<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');
		
	}

	// 01. Salesman Login
	public function login(){
		$obj = array();
		$username = $_POST['username'];
    $userPassword = $_POST['userPassword'];
    $user_record = $this->general_model->check_salesman_login($username,$userPassword);
    if($user_record == false){
			// throw invalid email id or password error
			$obj['status'] = 0;
      $obj['message'] = 'Invalid Login or Password';
		}else{
			$obj['userID'] = $user_record['salesmanID'];
			$obj['userFullName'] = $user_record['salesmanName'];
			$obj['status'] = 1;
      $obj['message'] = 'Success';
		}

		echo json_encode($obj);
	}

	// 02. Day Open
	public function dayOpen(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
    $transactionDate = strtotime($_POST['transactionDate']);

    $whereCheck = array(
    	'salesman'	=> $salesmanID,
    	'status'		=> 1
    );

    $checkCount = $this->general_model->getCount('trn_day_open_close', $whereCheck);
    if($checkCount > 0){
    	$openedDays = $this->general_model->get('trn_day_open_close', $whereCheck);
    	$obj['openedDate'] = $openedDays[0]['date'];
    	$obj['status'] = 0;
      $obj['message'] = 'Another day is already opened.';
    }else{
    	$where = array(
	    	'salesman'	=> $salesmanID,
	    	'date'			=> date('Y-m-d', $transactionDate)
	    );

	    $count = $this->general_model->getCount('trn_day_open_close', $where);

	    if($count > 0){
	    	$obj['status'] = 0;
	      $obj['message'] = 'Day is already opened';
	    }else{
	    	$data = array(
	    		'salesman'			=> $salesmanID,
	    		'date'					=> date('Y-m-d', $transactionDate),
	    		'dayOpenTime'		=> date('Y-m-d H:i:s'),
	    		'status'				=> 1
	    	);

	    	$this->general_model->insert('trn_day_open_close', $data);

				$obj['status'] = 1;
	      $obj['message'] = 'Day opened Successfully';    	
	    }
    }
    
    echo json_encode($obj);
	}

	// 03. Day Close
	public function dayClose(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
    $transactionDate = strtotime($_POST['transactionDate']);

    // Check Whether Day is Opened or Not
    $whereCheckOpen = array(
    	'salesman'	=> $salesmanID,
    	//'date'			=> date('Y-m-d', $transactionDate),
    	'status'		=> 1
    );
		$openCount = $this->general_model->getCount('trn_day_open_close', $whereCheckOpen);

    if($openCount > 0){
  		$data = array(
    		'dayCloseTime'	=> date('Y-m-d H:i:s'),
    		'status'				=> 2
    	);

    	$where = array(
    		'salesman'			=> $salesmanID,
    		'status'				=> 1
    	);

    	$this->general_model->update('trn_day_open_close', $data, $where);

			$obj['status'] = 1;
      $obj['message'] = 'Day closed Successfully';

	  }else{
    	$obj['status'] = 0;
      $obj['message'] = 'You should open the day first';
		}
    echo json_encode($obj);
	}

	// 04. Check Day Open/Close
	public function checkDayOpenClose(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
    $transactionDate = strtotime($_POST['transactionDate']);

    // Check Whether Day is Opened or Not
    $whereCheckOpen = array(
    	'salesman'	=> $salesmanID,
    	'date'			=> date('Y-m-d', $transactionDate),
    	'status'		=> 1
    );
		$openCount = $this->general_model->getCount('trn_day_open_close', $whereCheckOpen);

		if($openCount > 0){
    	// Check Whether Day is already closed or not
    	$whereCheckClose = array(
	    	'salesman'	=> $salesmanID,
	    	'date'			=> date('Y-m-d', $transactionDate),
	    	'status'		=> 2
	    );
			$closeCount = $this->general_model->getCount('trn_day_open_close', $whereCheckClose);

	    if($closeCount > 0){
	    	$obj['status'] = 0;
      	$obj['message'] = 'You cannot create new transaction as the day is already closed.';
	    }else{
				$obj['status'] = 1;
	      $obj['message'] = 'Sucess'; 
	    }
    }else{
    	$obj['status'] = 0;
      $obj['message'] = 'You cannot create new transaction as the day is not opened yet.';
		}

		echo json_encode($obj);
	}

	// 05. Customers List
	public function customers(){
		$obj = array();
		$where = array();
		$customers = $this->general_model->get('mst_customers',$where);

		if(is_array($customers)){
			$i=0;
			foreach($customers as $customer){
				$obj['results'][$i]['customerID'] = $customer['client_id'];
				$obj['results'][$i]['customerName'] = $customer['client_name'];
				$obj['results'][$i]['is_credit'] = $customer['is_credit'];
				$obj['results'][$i]['is_taxable'] = $customer['is_taxable'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No purchase orders";
    }
    echo json_encode($obj);
	}
	

	// 06. Customer Outstanding Amount
	public function customerOutstanding(){
		$obj = array();
		$client_id = $_POST['customerID'];
		$where = array(
			'client_id'		=> $client_id
		);
		$whereInvoiceAmount = array('status' => 5);
		$OutstandingAmount = $this->general_model->getSum('bill_os_amt','trn_customer_outstandings',$where);
		$OutstandingtotalAmount = $this->general_model->getSum('totalAmount','trn_sales_invoice',$whereInvoiceAmount);
		$outStandingBills = $this->general_model->getCount('trn_customer_outstandings',$where);

		$whereCustomer = array('client_id'	=> $client_id);
		$customerDetails = $this->general_model->get('mst_customers',$whereCustomer);

		if(is_array($OutstandingtotalAmount)){
			$obj['customerBalance'] = $OutstandingAmount[0]['bill_os_amt'] + $OutstandingtotalAmount[0]['totalAmount'];
		}else{
			$obj['customerBalance'] = $OutstandingAmount[0]['bill_os_amt'];
		}

		$whereOverDue = array(
			'client_id'	=> $client_id,
			'DATEDIFF(CURRENT_DATE(), bill_date) >'	=> $customerDetails[0]['creditPeriod']
		);
		$overDueAmount = $this->general_model->getSum('bill_os_amt','trn_customer_outstandings',$whereOverDue);
		$overDueBillCount = $this->general_model->getCount('trn_customer_outstandings',$whereOverDue);

		$obj['overdueamount'] = $overDueAmount[0]['bill_os_amt'];
		$obj['overDueBillCount'] = $overDueBillCount;
		$obj['outStandingBills'] = $outStandingBills;
		$obj['is_credit'] = $customerDetails[0]['is_credit'];
		$obj['creditLimit'] = $customerDetails[0]['creditLimit'];
		$obj['is_taxable'] = $customerDetails[0]['is_taxable'];
		$saleFlag = 1;
		if($customerDetails[0]['is_credit'] == 1){ // If Credit Sale Enabled
			if($customerDetails[0]['blockon_creditlimit'] == 1){ // If Block on Credit Limit
				if($overDueAmount[0]['bill_os_amt'] > $customerDetails[0]['creditLimit']){ // If Credit Limit over
					$saleFlag = 0;
				}

				if($obj['customerBalance'] > $customerDetails[0]['creditLimit']){
					$saleFlag = 0;
				}
			}

			if($customerDetails[0]['blockon_overdue'] == 1){ // If Block on Overdue
				if($overDueBillCount > 0){ // If overdue bills
					$saleFlag = 0;
				}
			}

		}else{
			if($customerDetails[0]['blockon_creditlimit'] == 1){ // If Block on Credit Limit
				if($overDueAmount[0]['bill_os_amt'] > $customerDetails[0]['creditLimit']){ // If Credit Limit over
					$saleFlag = 0;
				}

				if($obj['customerBalance'] > $customerDetails[0]['creditLimit']){
					$saleFlag = 0;
				}
			}

			if($customerDetails[0]['blockon_overdue'] == 1){ // If Block on Overdue
				if($overDueBillCount > 0){ // If overdue bills
					$saleFlag = 0;
				}
			}
		}

		if($saleFlag == 1){
			$obj['allowSale'] = 1;
		}else{
			$obj['allowSale'] = 0;
		}
		
		$obj['status'] = 1;
    $obj['message'] = "Sucess";
    echo json_encode($obj);
	}

	// 07. Item List For Sales Invoice
	public function products(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$customerID = $_POST['customerID'];
		$where = array('mst_godown.salesman' => $salesmanID, 'mst_item_details.is_saleable' => 1);
		$products = $this->general_model->get_sm_products_new($where);
		//print_r($products);exit;
		$whereCustomer = array('client_id'	=> $customerID);
		$clients = $this->general_model->get('mst_customers', $whereCustomer);
		$priceType = $clients[0]['priceType'];

		if(is_array($products)){
			$i=0;
			$obj['results'] = array();
			foreach($products as $product){
			    
			  // Check if product qty in (trn_godown_stock - unsync qty) > 0
			  $godownStock = $product['itemQty'];
			  $whereUnsyn = array(
			  	'trn_sales_invoice.isTallySync' => 0, 
			  	'trn_sales_invoice_details.item_code' => $product['item_code']
			  );

			  $unSyncQtyArray = $this->general_model->getSum_unsync_qty($whereUnsyn);
			  //echo $this->db->last_query();
			  $unSyncQty = $unSyncQtyArray[0]['unSyncQty'];
			  //$unSyncItemParentQty = $unSyncQty * $product['item_factor'];
			  $availableQty = ($godownStock - $unSyncQty) * $product['item_factor'];

			  //print_r($product);
			  //echo "<br/>Godown Stock:".$godownStock;
			  //echo "<br/>Unsync Child Stock:".$unSyncQty;
			  //echo "<br/>Unsync Parent Stock:".$unSyncQty;
			  //exit;
			  if($availableQty < 1){
			  	continue;
			  }

				$obj['results'][$i]['productID'] = $product['item_id'];
				$obj['results'][$i]['productBarCode'] = $product['item_barcode'];
				$obj['results'][$i]['productDetailsID'] = $product['item_details_id'];
				$obj['results'][$i]['productCode'] = $product['item_code'];
				$obj['results'][$i]['productName'] = $product['item_description'];
				$obj['results'][$i]['productTax'] = $product['productTax'];
				$obj['results'][$i]['rateInclVatFlag'] = $product['isRateInclVat'];
				$obj['results'][$i]['unit'] = $product['unitSymbol'];
				$obj['results'][$i]['availableQty'] = number_format((float)$availableQty, 2, '.', '');

				if($priceType != 0){
					if($priceType == 1){
						if($product['item_price1'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price1'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 2){
						if($product['item_price2'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price2'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = $product['item_price1'];
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 3){
						if($product['item_price3'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price3'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = $product['item_price1'];
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}
				}else{
					if($product['item_price1'] != "0.000"){
						$obj['results'][$i]['productPrice'] = $product['item_price1'];
						$obj['results'][$i]['productPriceFlag'] = 1;
					}else{
						$obj['results'][$i]['productPrice'] = '';
						$obj['results'][$i]['productPriceFlag'] = 1;
					}
				}
				$obj['results'][$i]['productMinPrice'] = $product['item_min_price'];
				$obj['results'][$i]['productMaxDiscountPer'] = $product['item_max_discount_per'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['results'] = array();
			$obj['status'] = 0;
      $obj['message'] = "No products";
    }
    echo json_encode($obj);
	}

	// 07A. Item List For Sales Order
	public function allproducts(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$customerID = $_POST['customerID'];
		$where = array();
		$products = $this->general_model->get_products($where);
		//print_r($products);exit;
		$whereCustomer = array('client_id'	=> $customerID);
		$clients = $this->general_model->get('mst_customers', $whereCustomer);
		$priceType = $clients[0]['priceType'];

		if(is_array($products)){
			$i=0;
			foreach($products as $product){
				$obj['results'][$i]['productID'] = $product['item_id'];
				$obj['results'][$i]['productBarCode'] = $product['item_barcode'];
				$obj['results'][$i]['productDetailsID'] = $product['item_details_id'];
				$obj['results'][$i]['productCode'] = $product['item_code'];
				$obj['results'][$i]['productName'] = $product['item_description'];
				$obj['results'][$i]['productTax'] = $product['productTax'];
				$obj['results'][$i]['rateInclVatFlag'] = $product['isRateInclVat'];
				$obj['results'][$i]['unit'] = $product['unitSymbol'];
				
				if($priceType != 0){
					if($priceType == 1){
						if($product['item_price1'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price1'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 2){
						if($product['item_price2'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price2'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 3){
						if($product['item_price3'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price3'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}
				}else{
					if($product['item_price1'] != "0.000"){
						$obj['results'][$i]['productPrice'] = $product['item_price1'];
						$obj['results'][$i]['productPriceFlag'] = 1;
					}else{
						$obj['results'][$i]['productPrice'] = '';
						$obj['results'][$i]['productPriceFlag'] = 1;
					}
				}
				
				$obj['results'][$i]['productMinPrice'] = $product['item_min_price'];
				$obj['results'][$i]['productMaxDiscountPer'] = $product['item_max_discount_per'];
				$i++;
			}
			$obj['status'] = 1;
    	    $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No products";
    }
    echo json_encode($obj);
	}

	// 08. Tax List
	public function tax(){
		$obj = array();
		$where = array();
		$taxes = $this->general_model->get('sys_tax',$where);

		if(is_array($taxes)){
			$i=0;
			foreach($taxes as $tax){
				$obj['results'][$i]['taxID'] = $tax['taxID'];
				$obj['results'][$i]['taxName'] = $tax['taxName'];
				$obj['results'][$i]['taxPercentage'] = $tax['taxPercentage'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No taxes";
    }
    echo json_encode($obj);
	}

	public function test(){
		$items[0]['itemDetailID'] = 1;
		$items[0]['itemPrice'] = 2.500;
		$items[0]['itemQty'] = 10;
		$items[0]['itemDiscountPer'] = 10.00;
		$items[0]['itemDiscountAmount'] = 2.500;
		$items[0]['itemTotalDiscountSplitAmount'] = 0.500;
		$items[0]['itemTax'] = 2;
		$items[0]['itemTaxAmount'] = 1.125;
		$items[0]['itemTotal'] = 23.625;
		$items[1]['itemDetailID'] = 2;
		$items[1]['itemPrice'] = 1.000;
		$items[1]['itemQty'] = 10;
		$items[1]['itemDiscountPer'] = 10.00;
		$items[1]['itemDiscountAmount'] = 1.000;
		$items[1]['itemTotalDiscountSplitAmount'] = 0.500;
		$items[1]['itemTax'] = 2;
		$items[1]['itemTaxAmount'] = 0.425;
		$items[1]['itemTotal'] = 8.925;

		$salesOrder['salesOrderDate'] = "2021-02-14";
		$salesOrder['customer'] = 1;
		$salesOrder['subTotal'] = 35.00;
		$salesOrder['taxAmount'] = 1.550;
		$salesOrder['discountAmout'] = 4.500;
		$salesOrder['totalAmount'] = 32.550;
		$salesOrder['salesman'] = 3;
		$salesOrder['paymentMode'] = 1;
		$salesOrder['cashAmountReceived'] = 35.000;
		$salesOrder['cashAmountBalance'] = 2.450;
		$salesOrder['cardNumber'] = '';
		$salesOrder['chequeNumber'] = '';
		$salesOrder['paymentStatus'] = 1;
		$salesOrder['items'] = json_encode($items);

		echo json_encode($salesOrder);
	}

	// 09. Create Sales Order
	public function createSalesOrder(){
		$obj = array();
		// $customer = $_POST['customer'];
		// $subTotal = $_POST['subTotal'];
		// $taxAmount = $_POST['taxAmount'];
		// $discountAmout = $_POST['discountAmout'];
		// $totalAmount = $_POST['totalAmount'];
		// $salesman = $_POST['salesman'];
		// $itemsJson = $_POST['items'];
		// $items = json_decode($itemsJson);

		//JSON Processing
		$salesOrderJson = $_POST['salesOrder'];
		$salesOrder = json_decode($salesOrderJson,true);
		$salesOrderDate = $salesOrder['salesOrderDate'];
		$customer = $salesOrder['customer'];
		$subTotal = $salesOrder['subTotal'];
		$taxAmount = $salesOrder['taxAmount'];
		$discountAmout = $salesOrder['discountAmout'];
		$totalAmount = $salesOrder['totalAmount'];
		$salesman = $salesOrder['salesman'];
		$itemsJson = $salesOrder['items'];
		$items = json_decode($itemsJson);


		$salesOrderNumber = $this->general_model->getmax('salesOrderNumber','trn_sales_orders');

		$data = array(
			'salesOrderNumber'	=> $salesOrderNumber,
			'salesOrderDate'		=> $salesOrderDate,
			'customer'					=> $customer,
			'subTotal'					=> $subTotal,
			'taxAmount'					=> $taxAmount,
			'discountAmout'			=> $discountAmout,
			'totalAmount'				=> $totalAmount,
			'salesman'					=> $salesman,
			'status'						=> 1,
		);

		$salesOrderID = $this->general_model->insert('trn_sales_orders', $data);

		if(isset($items) && is_array($items)){
			foreach($items as $item){
				$itemDetailID = $item->itemDetailID;
				$itemPrice = $item->itemPrice;
				$itemQty = $item->itemQty;
				$itemDiscountPer = $item->itemDiscountPer;
				$itemDiscountAmount = $item->itemDiscountAmount;
				//$itemTotalDiscountSplitAmount = $item->itemTotalDiscountSplitAmount;
				$itemTax = $item->itemTax;
				$itemTaxAmount = $item->itemTaxAmount;
				$itemTotal = $item->itemTotal;

				// Get Item code of Parent from Item Detail ID
				$whereParent = array('item_details_id' => $itemDetailID);
				$parentItem = $this->general_model->get('mst_item_details',$whereParent);
				$item_code = $parentItem[0]['item_code'];
				$item_barcode = $parentItem[0]['item_barcode'];

				$dataDetails = array(
					'salesOrder'										=> $salesOrderID,
					'item_code'											=> $item_code,
					'item_barcode'									=> $item_barcode,
					//'itemDetailID'									=> $itemDetailID,
					'itemPrice'											=> $itemPrice,
					'itemQty'												=> $itemQty,
					'itemDiscountPer'								=> $itemDiscountPer,
					'itemDiscountAmount'						=> $itemDiscountAmount,
					//'itemDiscountAmount'						=> $itemDiscountAmount,
					//'itemTotalDiscountSplitAmount'	=> $itemTotalDiscountSplitAmount,
					'itemTax'												=> $itemTax,
					'itemTaxAmount'									=> $itemTaxAmount,
					'itemTotal'											=> $itemTotal
				);

				$this->general_model->insert('trn_sales_order_details', $dataDetails);
			}

			$obj['salesOrderID'] = $salesOrderID;
			$obj['salesOrderNumber'] = $salesOrderNumber;
			$obj['subTotal'] = $subTotal;
			$obj['taxAmount'] = $taxAmount;
			$obj['discountAmout'] = $discountAmout;
			$obj['totalAmount'] = $totalAmount;
			$obj['status'] = 1;
	    $obj['message'] = "";

	    echo json_encode($obj);
		}
	}

	// 10. Create Sales Invoice
	public function createSalesInvoice(){
		$obj = array();

		//JSON Processing
		$salesOrderJson = $_POST['salesOrder'];
		$salesOrder = json_decode($salesOrderJson,true);
		$salesOrderDate = $salesOrder['salesOrderDate'];
		$customer = $salesOrder['customer'];
		$subTotal = $salesOrder['subTotal'];
		$taxAmount = $salesOrder['taxAmount'];
		$discountAmout = $salesOrder['discountAmout'];
		$totalAmount = $salesOrder['totalAmount'];
		$salesman = $salesOrder['salesman'];
		$paymentMode = $salesOrder['paymentMode'];
		$cashAmountReceived = $salesOrder['cashAmountReceived'];
		$cashAmountBalance = $salesOrder['cashAmountBalance'];
		$cardNumber = $salesOrder['cardNumber'];
		$chequeNumber = $salesOrder['chequeNumber'];
		$paymentStatus = $salesOrder['paymentStatus'];
		$roundOffType = $salesOrder['roundOffType'];
		$roundOffAmount = $salesOrder['roundOffAmount'];
		$itemsJson = $salesOrder['items'];
		$items = json_decode($itemsJson);


		$salesInvoiceNumer = $this->general_model->getmax('salesInvoiceNumber','trn_sales_invoice');

		$data = array(
			'salesInvoiceNumber'	=> $salesInvoiceNumer,
			'salesInvoiceDate'		=> $salesOrderDate,
			'customer'						=> $customer,
			'subTotal'						=> $subTotal,
			'taxAmount'						=> $taxAmount,
			'discountAmout'				=> $discountAmout,
			'totalAmount'					=> $totalAmount,
			'salesman'						=> $salesman,
			'paymentMode'					=> $paymentMode,
			'cashAmountReceived'	=> $cashAmountReceived,
			'cashAmountBalance'		=> $cashAmountBalance,
			'cardNumber'					=> $cardNumber,
			'chequeNumber'				=> $chequeNumber,
			'paymentStatus'				=> $paymentStatus,
			'roundOffType'				=> $roundOffType,
			'roundOffAmount'			=> $roundOffAmount,
			'status'							=> 1,
		);

		$salesInvoiceID = $this->general_model->insert('trn_sales_invoice', $data);

		$whereClient = array('client_id'	=> $customer);
		$customers = $this->general_model->get('mst_customers', $whereClient);

		$dataOS = array(
			'client_id'		=> $customer,
			'Client_name'	=> $customers[0]['client_name'],
			'bill_no'		=> $salesInvoiceNumer,
			'bill_date'		=> $salesOrderDate,
			'bill_amount'	=> $totalAmount,
			'bill_os_amt'	=> $cashAmountBalance
		);

		$this->general_model->insert('trn_customer_outstandings', $dataOS);

		$invoiceWiseDiscount = 0;
		if(isset($items) && is_array($items)){
			foreach($items as $item){
				$itemDetailID = $item->itemDetailID;
				$itemPrice = $item->itemPrice;
				$itemQty = $item->itemQty;
				$itemDiscountPer = $item->itemDiscountPer;
				$itemDiscountAmount = $item->itemDiscountAmount;
				$itemTotalDiscountSplitAmount = $item->itemTotalDiscountSplitAmount;
				$itemTax = $item->itemTax;
				$itemTaxAmount = $item->itemTaxAmount;
				$itemTotal = $item->itemTotal;

				$invoiceWiseDiscount = $invoiceWiseDiscount + $itemTotalDiscountSplitAmount;

				// Get Item code of Parent from Item Detail ID
				$whereParent = array('item_details_id' => $itemDetailID);
				$parentItem = $this->general_model->get('mst_item_details',$whereParent);
				$item_code = $parentItem[0]['item_code'];
				$item_barcode = $parentItem[0]['item_barcode'];
				$item_factor = $parentItem[0]['item_factor'];
				$actualQty = $itemQty / $item_factor;

				$dataDetails = array(
					'salesInvoice'									=> $salesInvoiceID,
					'item_code'											=> $item_code,
					'item_barcode'									=> $item_barcode,
					//'itemDetailID'									=> $itemDetailID,
					'itemPrice'											=> $itemPrice,
					'itemQty'												=> $itemQty,
					'itemDiscountPer'								=> $itemDiscountPer,
					'itemDiscountAmount'						=> $itemDiscountAmount,
					'itemTotalDiscountSplitAmount'	=> $itemTotalDiscountSplitAmount,
					'itemTax'												=> $itemTax,
					'itemTaxAmount'									=> $itemTaxAmount,
					'itemTotal'											=> $itemTotal,
					'actualQty'											=> $actualQty
				);

				$this->general_model->insert('trn_sales_invoice_details', $dataDetails);
			}

			$dataUpdate = array('invoiceWiseDiscount' => $invoiceWiseDiscount);
			$whereUpdate = array('salesInvoiceID' => $salesInvoiceID);
			$this->general_model->update('trn_sales_invoice', $dataUpdate, $whereUpdate);
		}

		$obj['salesInvoiceID'] = $salesInvoiceID;
		$obj['salesInvoiceNumer'] = $salesInvoiceNumer;
		$obj['subTotal'] = $subTotal;
		$obj['taxAmount'] = $taxAmount;
		$obj['discountAmout'] = $discountAmout;
		$obj['totalAmount'] = $totalAmount;
		$obj['status'] = 1;
    $obj['message'] = "";

    echo json_encode($obj);
	}

	// 11. Sales List
	public function salesList(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$where = array(
			'salesman'		=> $salesmanID
		);

		$invoices =  $this->general_model->get_invoices($where);
		if(is_array($invoices)){
			$i=0;
			foreach($invoices as $invoice){
				$obj['results'][$i]['salesInvoiceNumer'] = $invoice['salesInvoiceNumber'];
				$obj['results'][$i]['salesInvoiceDate'] = date('d/m/Y',strtotime($invoice['salesInvoiceDate']));
				$obj['results'][$i]['totalAmount'] = $invoice['totalAmount'];
				$obj['results'][$i]['customerName'] = $invoice['client_name'];
				$obj['results'][$i]['dueDays'] = $invoice['creditPeriod'];

				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No invoices found";
		}
		echo json_encode($obj);
	}

	// 12. Sale Report
	public function saleReport(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$where = array(
			'salesman'		=> $salesmanID
		);

		$invoices =  $this->general_model->get_invoices($where);
		if(is_array($invoices)){
			$i=0;
			foreach($invoices as $invoice){
				$obj['results'][$i]['salesInvoiceNumer'] = $invoice['salesInvoiceNumber'];
				$obj['results'][$i]['salesInvoiceDate'] = date('d/m/Y',strtotime($invoice['salesInvoiceDate']));
				$obj['results'][$i]['totalAmount'] = $invoice['totalAmount'];
				$obj['results'][$i]['customerName'] = $invoice['client_name'];
				$obj['results'][$i]['dueDays'] = $invoice['creditPeriod'];

				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No invoices found";
		}
		echo json_encode($obj);
	}

	// 12A. Sale Invoice Report
	public function saleInvoiceReport(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$customerID = $_POST['customerID'];
		$fromDate = str_replace('/','-',$_POST['fromDate']);
		$toDate = str_replace('/','-',$_POST['toDate']);
		$invoiceNumber = $_POST['invoiceNumber'];
		$page = $_POST['page'];
		$per_page = 15;
		$offset = ($page -1)*$per_page;
		
		//echo $fromDate; exit;
		//echo strtotime($fromDate); exit;

		$where = array(
			'salesman'		=> $salesmanID
		);

		// Filter By Customer
		if(isset($customerID) && $customerID > 0){
			$where['customer'] = $customerID;
		}

		// Filter By From Date
		if(isset($fromDate) && $fromDate > 0){
			$where['salesInvoiceDate >='] = date('Y-m-d',strtotime($fromDate));
		}

		// Filter By To Date
		if(isset($toDate) && $toDate > 0){
			$where['salesInvoiceDate <='] = date('Y-m-d',strtotime($toDate));
		}

		// Filter By Invoice Number
		if(isset($invoiceNumber) && $invoiceNumber > 0){
			$where['salesInvoiceNumber'] = $invoiceNumber;
		}

		$invoices =  $this->general_model->get_invoices($where,$per_page,$offset);
	    //echo $this->db->last_query();exit;
		if(is_array($invoices)){
			$i=0;
			foreach($invoices as $invoice){
				$obj['results'][$i]['salesInvoiceID'] = $invoice['salesInvoiceID'];
				$obj['results'][$i]['salesInvoiceNumer'] = $invoice['salesInvoiceNumber'];
				$obj['results'][$i]['salesInvoiceDate'] = date('d/m/Y',strtotime($invoice['salesInvoiceDate']));
				$obj['results'][$i]['totalAmount'] = $invoice['totalAmount'];
				$obj['results'][$i]['customerName'] = $invoice['client_name'];
				$obj['results'][$i]['dueDays'] = $invoice['creditPeriod'];

				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No invoices found";
		}
		echo json_encode($obj);
	}

	// 12B. Sale Order Report
	public function saleOrderReport(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$customerID = $_POST['customerID'];
		$fromDate = str_replace('/','-',$_POST['fromDate']);
		$toDate = str_replace('/','-',$_POST['toDate']);
		$invoiceNumber = $_POST['orderNumber'];
		$page = $_POST['page'];
		$per_page = 15;
		$offset = ($page -1)*$per_page;

		$where = array(
			'salesman'		=> $salesmanID
		);

		// Filter By Customer
		if(isset($customerID) && $customerID > 0){
			$where['customer'] = $customerID;
		}

		// Filter By From Date
		if(isset($fromDate) && $fromDate > 0){
			$where['salesOrderDate >='] = date('Y-m-d',strtotime($fromDate));
		}

		// Filter By To Date
		if(isset($toDate) && $toDate > 0){
			$where['salesOrderDate <='] = date('Y-m-d',strtotime($toDate));
		}

		// Filter By Order Number
		if(isset($invoiceNumber) && $invoiceNumber > 0){
			$where['salesOrderNumber'] = $invoiceNumber;
		}

		$orders =  $this->general_model->get_sales_orders($where,$per_page,$offset);
		if(is_array($orders)){
			$i=0;
			foreach($orders as $order){
				$obj['results'][$i]['salesOrderID'] = $order['salesOrderID'];
				$obj['results'][$i]['salesOrderNumber'] = $order['salesOrderNumber'];
				$obj['results'][$i]['salesOrderDate'] = date('d/m/Y',strtotime($order['salesOrderDate']));
				$obj['results'][$i]['totalAmount'] = $order['totalAmount'];
				$obj['results'][$i]['customerName'] = $order['client_name'];

				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No Orders found";
		}
		echo json_encode($obj);
	}

	// 13. App Settings
	public function appSettings(){
		$obj = array();
		$appID = HEX_APPLICATION_ID;

		// Get App Settngs
		$whereSettings = array('appID'	=> $appID);
		$appSettings = $this->general_model->get_app_settings('mst_applications', $whereSettings);
		$subscriptionExpiryDate = $appSettings[0]['subscriptionExpiryDate'];
		$isSalesOrder = $appSettings[0]['isSalesOrder'];
		$isSalesInvoice = $appSettings[0]['isSalesInvoice'];
		$isActive = $appSettings[0]['isActive'];
		$isOfflineDB = $appSettings[0]['isOfflineDB'];

		$subscriptionExpiryDate1 = strtotime($subscriptionExpiryDate);
		$today = strtotime("today");
		if($subscriptionExpiryDate1 > $today){
			$obj['activeSubscription'] = 1;
		}else{
			$obj['activeSubscription'] = 0;
		}
		
		if($isSalesOrder == 1){
			$obj['allowSalesOrder'] = 1;
		}else{
			$obj['allowSalesOrder'] = 0;
		}

		if($isSalesInvoice == 1){
			$obj['allowSalesInvoice'] = 1;
		}else{
			$obj['allowSalesInvoice'] = 0;
		}

		if($isActive == 1){
			$obj['appStatus'] = 1;
		}else{
			$obj['appStatus'] = 0;
		}

		if($isOfflineDB == 1){
			$obj['offlineDBFlag'] = 1;
		}else{
			$obj['offlineDBFlag'] = 0;
		}


		$salesmanID = $_POST['salesmanID'];
		//$salesmanID = 1;

		$whereCheck = array(
    	'salesman'	=> $salesmanID,
    	'status'		=> 1
    );

    $checkCount = $this->general_model->getCount('trn_day_open_close', $whereCheck);
    if($checkCount > 0){
    	$openedDays = $this->general_model->get('trn_day_open_close', $whereCheck);
    	$obj['openedDate'] = $openedDays[0]['date'];
    }


		$obj['status'] = 1;
    $obj['message'] = "Sucess";
    echo json_encode($obj);
	}

	// 14. Sales Order Details
	public function saleOrderDetails(){
		$obj = array();
		$salesOrderID = $_POST['salesOrderID'];
		
		$where = array('salesOrderID'		=> $salesOrderID);
		$orders =  $this->general_model->get_sales_orders($where);

		$whereDetails = array('salesOrder'	=> $salesOrderID);
		$orderDetails = $this->general_model->get_sales_order_details($whereDetails, null, null, 'salesOrderDetailsID', 'ASC');

		$obj['results']['logo'] = 'http://billogo.hexeam.org/assets/images/brand/logo.png';
		$obj['results']['companyName'] = 'Test Company';
		$obj['results']['companyAddress1'] = 'Address Line 1';
		$obj['results']['companyAddress2'] = 'Address Line 1';
		$obj['results']['TRN'] = '12345678';
		if(is_array($orders)){
			$obj['results']['salesOrderNumber'] = $orders[0]['salesOrderNumber'];
			$obj['results']['salesOrderDate'] = date('d/m/Y',strtotime($orders[0]['salesOrderDate']));
			$obj['results']['customerName'] = $orders[0]['client_name'];
			$obj['results']['customerAddress'] = $orders[0]['client_address'];
			$obj['results']['subTotal'] = $orders[0]['subTotal'];
			$obj['results']['taxAmount'] = $orders[0]['taxAmount'];
			$obj['results']['discountAmout'] = $orders[0]['discountAmout'];
			$obj['results']['totalAmount'] = $orders[0]['totalAmount'];

			if(is_array($orderDetails)){
				$i=0;
				foreach($orderDetails as $orderDetail){
					$obj['results']['orderDetails'][$i]['itemName'] = $orderDetail['item_description'];
					$obj['results']['orderDetails'][$i]['itemPrice'] = $orderDetail['itemPrice'];
					$obj['results']['orderDetails'][$i]['itemQty'] = $orderDetail['itemQty'];
					$obj['results']['orderDetails'][$i]['itemDiscountPer'] = $orderDetail['itemDiscountPer'];
					$obj['results']['orderDetails'][$i]['itemDiscountAmount'] = $orderDetail['itemDiscountAmount']+$orderDetail['itemTotalDiscountSplitAmount'];
					$obj['results']['orderDetails'][$i]['itemAmount'] = (($orderDetail['itemPrice']*$orderDetail['itemQty']) - $obj['results']['orderDetails'][$i]['itemDiscountAmount']);
					$obj['results']['orderDetails'][$i]['itemTaxPer'] = $orderDetail['itemTax'];
					$obj['results']['orderDetails'][$i]['itemTaxAmount'] = $orderDetail['itemTaxAmount'];
					$obj['results']['orderDetails'][$i]['itemTotal'] = $orderDetail['itemTotal'];

					$i++;
				}
			}else{
				$obj['results']['orderDetails'] = array();
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No Orders found";
		}
		echo json_encode($obj);
	}

	// 15. Sales Invoice Details
	public function saleInvoiceDetails(){
		$obj = array();
		$salesInvoiceID = $_POST['salesInvoiceID'];
		
		$where = array('salesInvoiceID'		=> $salesInvoiceID);
		$invoices =  $this->general_model->get_invoices($where);

		$whereDetails = array('salesInvoice'	=> $salesInvoiceID);
		$invoiceDetails = $this->general_model->get_sales_invoice_details($whereDetails, null, null, 'salesInvoiceDetailsID', 'ASC');
		$obj['results']['logo'] = 'http://billogo.hexeam.org/assets/images/brand/logo.png';
		$obj['results']['companyName'] = 'Test Company';
		$obj['results']['companyAddress1'] = 'Address Line 1';
		$obj['results']['companyAddress2'] = 'Address Line 1';
		$obj['results']['TRN'] = '12345678';
		if(is_array($invoices)){
			$obj['results']['salesInvoiceNumer'] = $invoices[0]['salesInvoiceNumber'];
			$obj['results']['salesInvoiceDate'] = date('d/m/Y',strtotime($invoices[0]['salesInvoiceDate']));
			$obj['results']['customerName'] = $invoices[0]['client_name'];
			$obj['results']['customerAddress'] = $invoices[0]['client_address'];
			$obj['results']['subTotal'] = $invoices[0]['subTotal'];
			$obj['results']['taxAmount'] = $invoices[0]['taxAmount'];
			$obj['results']['discountAmout'] = $invoices[0]['discountAmout'];
			$obj['results']['roundOffType'] = $invoices[0]['roundOffType'];
			$obj['results']['roundOffAmount'] = $invoices[0]['roundOffAmount'];
			$obj['results']['totalAmount'] = $invoices[0]['totalAmount'];

			if(is_array($invoiceDetails)){
				$i=0;
				foreach($invoiceDetails as $invoiceDetail){
					$obj['results']['invoiceDetails'][$i]['itemName'] = $invoiceDetail['item_description'];
					$obj['results']['invoiceDetails'][$i]['itemPrice'] = $invoiceDetail['itemPrice'];
					$obj['results']['invoiceDetails'][$i]['itemQty'] = $invoiceDetail['itemQty'];
					$obj['results']['invoiceDetails'][$i]['itemDiscountPer'] = $invoiceDetail['itemDiscountPer'];
					$obj['results']['invoiceDetails'][$i]['itemDiscountAmount'] = $invoiceDetail['itemDiscountAmount']+$invoiceDetail['itemTotalDiscountSplitAmount'];
					$obj['results']['invoiceDetails'][$i]['itemAmount'] = (($invoiceDetail['itemPrice']*$invoiceDetail['itemQty']) - $obj['results']['invoiceDetails'][$i]['itemDiscountAmount']);
					$obj['results']['invoiceDetails'][$i]['itemTaxAmount'] = $invoiceDetail['itemTaxAmount'];
					$obj['results']['invoiceDetails'][$i]['itemTaxPer'] = $invoiceDetail['itemTax'];
					$obj['results']['invoiceDetails'][$i]['itemTotal'] = $invoiceDetail['itemTotal'];

					$i++;
				}
			}else{
				$obj['results']['invoiceDetails'] = array();
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No Invoice found";
		}
		echo json_encode($obj);
	}
	

	


}