<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		//$this->load->library('encrypt');
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
            $this->session->set_flashdata('registerMessage','Please Login First',':old:');
            return redirect('index.php/welcome/login');
        }
		
	}

	public function index()
	{
		redirect(base_url().'index.php/dashboard/sales_dashboard');
	}

	public function sales_dashboard(){
		$data['currentMenu'] = 'dashboard';
		$data['pageType'] = 'Sales';
		$data['pageHeading'] = 'Dashboard';
		$data['pageTitle'] = "Dashboard | ".HEX_APPLICATION_NAME;
		echo $this->session->userdata('adminAccess');
		exit();
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		$this->load->view('templates/header',$data);
		$this->load->view('dashboard/sales_dashboard',$data);
		$this->load->view('templates/footer');
	}



	
}
