<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Items extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
        $this->session->set_flashdata('registerMessage','Please Login First',':old:');
        return redirect('index.php/welcome/login');
    }
		
	}
	
	public function index()
	{
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}

		$salesmanID = $this->session->userdata['userId'];
		//$where = array('mst_godown.salesman' => $salesmanID);
		$where = array();
		//$data['items'] = $this->general_model->get_products($where);
		$data['items'] = $this->general_model->get('mst_items',$where);
		
		$data['currentMenu'] = 'items';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Items';
		$data['pageTitle'] = "Items | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('masters/items/items',$data);
		$this->load->view('templates/footer');
	}

	

	public function edit($item_id=0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		
		$where = array();
		$whereEdit = array('item_id' => $item_id);

		$data['items'] = $this->general_model->get('mst_items',$where);
		$data['singleitems'] =$this->general_model->get('mst_items',$whereEdit);


		$data['loginRedirect']=base_url().'index.php/masters/items/update';
		
		$data['currentMenu'] = 'items';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Items';
		$data['pageTitle'] = "Items | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('masters/items/editItem',$data);
		$this->load->view('templates/footer');
	}

	public function update(){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('item_cost', 'Item Cost', 'required');
		$this->form_validation->set_rules('isRateInclVat', 'Rate Including Vat', 'required|numeric');
		$this->form_validation->set_rules('item_max_discount_per', 'Max Discount Percentage', 'required');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/masters/items');
		}else{

			if($this->input->post('isRateInclVat') == "1"){
				$isRateInclVat = 1;
			}else{
				$isRateInclVat = 0;
			}

			$data = array(
				'item_cost'		 					=>	$this->input->post('item_cost'),
				'isRateInclVat'   			=>  $isRateInclVat,
				'item_max_discount_per' =>  $this->input->post('item_max_discount_per'),
				'tax_rate'   						=>  $this->input->post('tax_rate')
			);
			$where = array(
				'item_id'					=> $this->input->post('item_id')
			);
			$this->general_model->update('mst_items',$data,$where);
			$this->session->set_flashdata('registerMessage','Item Updated Successfully',':old:');
			redirect(base_url().'index.php/masters/items');
		}
	}


	public function itemDetails($item_code=0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$where = array('item_code' => $item_code);
		$data['itemDetails'] = $this->general_model->get('mst_item_details',$where);

		$data['currentMenu'] = 'items';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Items';
		$data['pageTitle'] = "Items | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('masters/items/itemDetails',$data);
		$this->load->view('templates/footer');
	}

	public function editDetail($item_details_id=0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		
		$where = array();
		$whereEdit = array('item_details_id' => $item_details_id);

		$data['itemDetails'] = $this->general_model->get('mst_item_details',$where);
		$data['singleitemDetails'] =$this->general_model->get('mst_item_details',$whereEdit);
		$data['taxes'] = $this->general_model->get_list('taxID','taxPercentage','sys_tax', array(), array());

		$data['loginRedirect']=base_url().'index.php/masters/items/updateDetail';
		
		$data['currentMenu'] = 'items';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Item Details';
		$data['pageTitle'] = "Item Details | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('masters/items/editItemDetails',$data);
		$this->load->view('templates/footer');
	}

	public function updateDetail(){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('item_details_id', 'Item Details ID', 'required|numeric');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/masters/items');
		}else{

			$data = array(
				'item_price1'		 				=>	$this->input->post('item_price1'),
				'item_price2'   				=>  $this->input->post('item_price2'),
				'item_price3' 					=>  $this->input->post('item_price3'),
				'item_min_price'   			=>  $this->input->post('item_min_price'),
				'item_max_discount_per' =>  $this->input->post('item_max_discount_per'),
				'tax_rate'							=> 	$this->input->post('tax_rate')
			);
			$where = array(
				'item_details_id'					=> $this->input->post('item_details_id')
			);
			$this->general_model->update('mst_item_details',$data,$where);
			$this->session->set_flashdata('registerMessage','Item Details Updated Successfully',':old:');
			redirect(base_url().'index.php/masters/items/editDetail/'.$this->input->post("item_details_id"));
		}
	}
}
