<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xl-12">
        <div class="row">
            <div class="card">
                <div class="card-body">   
                    <div class="table-responsive">
                        <table id="saleslist" class="table table-striped table-bordered text-nowrap w-100">
                            <thead class="thead-light">
                                <tr>
                                    <th class="wd-15p">Customer Name</th>
                                    <th class="wd-15p">Order No</th>
                                    <th class="wd-20p">Order Date</th>
                                     <th class="wd-10p">Amount</th>
                                    <th class="wd-25p">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    if(is_array($orders)){
                                        foreach($orders as $order){
                                            echo '<tr>
                                                    <td>'.$order['client_name'].'</td>
                                                    <td>'.$order['salesOrderID'].'</td>
                                                    <td>'.date('d/m/Y',strtotime($order['salesOrderDate'])).'</td>
                                                    <td>'.$order['totalAmount'].'</td>
                                                    <td class="text-center"><a href="#" class="text-success"><i class="fa fa-print"></i></a></td> 
                                                 </tr>';
                                        }  
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>	
                </div>				 
            </div>				 
        </div>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function(){
 		checkWidth(); 
         $(function(e) {
            $('#saleslist').DataTable({
                "paging": true,
                "processing": false,
                "scrollCollapse": false,
                "ordering": false,
                "iDisplayLength": 15,
                "lengthMenu": [ [100, 150, 200, -1], [100, 150, 200, "All"] ],
                "info": false,
                fixedHeader: true
                 
            });
        });
	});
	var $window = $(window);
    function checkWidth() {
        var windowsize = $window.width();
        console.log(windowsize);
        if (windowsize < 1024) {
            $('.page-header').css({display : 'none !important'});	
            $('.app-sidebar').hide();
            $('.app-sidebar__toggle').hide();
            $('.app-sidebar__toggle close-toggle').hide();
            $('.nav-link').hide();
            $('.navbar-toggler').hide();
            $('#back-to-top').hide();
            $('#back-to-top').css({display : 'none !important'});
        }
    }
</script>