<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Client_reports extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}	

	public function index($page=1) {
		$this->users_model->permission("Customer", "View");
		$title['headerTitle']="Customer List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('Client_reports/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('new_client_master',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('new_client_master',
		array(),
		$config['per_page'],
		$offset,
		'client_id',
		'desc'
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header',$title);
		$this->load->view('reports/client_reports',$data);
		$this->load->view('templates/footer');
	}
	
	public function view_contact($Client_Id,$page=1) {
		$this->users_model->permission("Customer", "View");
		$title['headerTitle']="Customer Contact List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('Client_reports/view_contact/');
		$config['total_rows'] 	= $this->crud_model->get_count('client_contact',array('Client_Id'=> $Client_Id));

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('client_contact',
		array('Client_Id'=> $Client_Id),
		$config['per_page'],
		$offset,
		'Contact_Id',
		'desc'
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header',$title);
		$this->load->view('reports/view_contact',$data);
		$this->load->view('templates/footer');
	}

	function create() {
		$this->users_model->permission("Customer", "Add");
		$title['headerTitle']="Customer Create";
		$date=date("Y-m-d");
		$vat_applicable=$this->furniture_quotation_model->vat_applicable($date);
		$list = $this->crud_model->get_list2('id','Country','country_master',array(),array('status'=>1));
		$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Select Sales Man'),array(),'user_name','asc');
		$under_list = $this->crud_model->get_list2('acc_group_id','acc_group_name','account_group',array('isparent'=>'Customers'),array('acc_group_parent'=>17,'status'=>1));
		$datas   =   array("vat_applicable" => $vat_applicable,"country_master_list" => $list,'salesman_list'=>$list2,'under_list'=>$under_list);
		
		$this->load->view('templates/header',$title);
		$this->load->view('reports/add_client',$datas);
		$this->load->view('templates/footer');
	}
	function do_insert() {
		$this->users_model->permission("Customer", "Add");
		$title['headerTitle']="Customer Create";
		$this->form_validation->set_rules('client_name', 'Client Name', 'trim|required|max_length[100]|is_unique[new_client_master.client_name]');
		$this->form_validation->set_rules('client_address', 'Client Address', 'required|max_length[200]');
		$this->form_validation->set_rules('client_telephone1', 'Telephone 1', 'required|numeric|max_length[20]|is_unique[new_client_master.client_telephone1]|is_unique[new_client_master.client_telephone2]');
		$this->form_validation->set_rules('client_telephone2', 'Telephone 2', 'is_unique[new_client_master.client_telephone1]|is_unique[new_client_master.client_telephone2]');
		//$this->form_validation->set_rules('client_telephone2', 'Telephone 2', 'numeric|max_length[20]');
		//$this->form_validation->set_rules('client_fax', 'Fax', 'numeric|max_length[20]');
		$this->form_validation->set_rules('contact_person', 'Contact Person', 'required|max_length[100]');
		
		$client_id  	  = $this->input->post('client_id');
		$client_name  	  = trim($this->input->post('client_name'));
		$client_address   = trim($this->input->post('client_address'));
		$client_telephone1= $this->input->post('client_telephone1');
		$client_telephone2= $this->input->post('client_telephone2');
		$client_fax  	  = $this->input->post('client_fax');
		$client_email  	  = $this->input->post('client_email');
		$contact_person   = $this->input->post('contact_person');
		$tax_name  		  = $this->input->post('tax_name');
		$tax_no  		  = $this->input->post('tax_no');
		$country_id    	  = $this->input->post('country_id');
		$salesman_id  	  = $this->input->post('salesman_id');
		if(@$this->input->post('is_credit')==1){
			$is_credit = $this->input->post('is_credit');
		} else {
			$is_credit = 0;
		}

		if($this->input->post('acc_group_id')==='isparent'){
			$acc_group_id=17;
				
		} else {
			$acc_group_id =	$this->input->post('acc_group_id');
		}
		
		$credit_limit = $this->input->post('credit_limit');
		$credit_days  = $this->input->post('credit_days');
		$tax_perce    = $this->input->post('tax_perce');
		$opening_balance = $this->input->post('opening_balance');
		$cr_no  		   = $this->input->post('cr_no');
		$remarks  		= $this->input->post('remarks');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->create();
		} else {
			$str_arr = preg_split ("/\,/", $this->session->userdata('is_user_type'));
			if (in_array(3, $str_arr)  && $this->session->userdata('user_group_id') != 1) {
				$status=2;
			} else {
				$status=1;
			}
			$this->db->trans_begin();
			$data=array(
				'client_name' 	   => $client_name,
				'client_address'   => $client_address,
				'client_telephone1'=> $client_telephone1,
				'client_telephone2'=> $client_telephone2,
				'client_fax' 	   => $client_fax,
				'client_email' 	   => $client_email,
				'contact_person'   => $contact_person,
				'tax_name' 		   => $tax_name,
				'tax_no' 		   => $tax_no,
				'is_credit' 	   => $is_credit,
				'credit_limit' 	   => $credit_limit,
				'credit_days' 	   => $credit_days,
				'client_country'   => $country_id,
				'tax_perce' 	   => $tax_perce,
				'sales_man' 	   => $salesman_id,
				'cstatus' 		   => $status,
				'cr_no' 		   => $cr_no,
				'acc_group_id' 		=> $acc_group_id,
				'remarks' 		    => $remarks,
			);

			$records=$this->crud_model->insert('new_client_master',$data);
			$insert_id = $this->db->insert_id();

			$up_data=array(
				'client_code'  =>  'C'.sprintf("%'.04d",$insert_id),
			);
			$this->db->where('client_id', $insert_id);
			$this->db->update('new_client_master', $up_data);

			$user_id	=	$this->session->userdata('user_id');
			$Creation_date=date("Y-m-d");

			$contact_data=array(
				'Client_Id' 	=> $insert_id,
				'Contact_Name' 	=> $contact_person,
				'Contact_Tel' 	=> $client_telephone1,
				'Creation_date' => $Creation_date,
				'Created_UserId'=> $user_id,
			);

			$this->crud_model->insert('client_contact',$contact_data);

			$bank_account_number 	   = $this->input->post('bank_account_number');
			$bank_account_holder_name  = $this->input->post('bank_account_holder_name');
			$bank_iban   = $this->input->post('bank_iban');
			$bank_swift  = $this->input->post('bank_swift');
			$bank_name 	 = $this->input->post('bank_name');
			$bank_branch = $this->input->post('bank_branch');

			$data=array(
				'ledger_name' 		=> $client_name,
				'ledger_code' 		=> 'C'.sprintf("%'.04d",$insert_id),
				'acoount_group_id'  => 17,
				'tax_percentage' 	=> $tax_perce,
				'taxability' 		=> 'Taxable',
				'opening_balance' 	=> $opening_balance,
				'bank_account_number'=> $bank_account_number,
				'bank_account_holder_name' => $bank_account_holder_name,
				'bank_iban' 		=> $bank_iban,
				'bank_swift' 		=> $bank_swift,
				'bank_name' 		=> $bank_name,
				'country_id' 		=> $country_id,
				'bank_branch' 		=> $bank_branch
			);

			$records=$this->crud_model->insert('ledgers',$data);
			
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Customer',	
				'masters_id'=>'C'.sprintf("%'.04d",$insert_id),	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Sorry! Something went wrong .');
				redirect('client_reports');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success','Customer Details Added');
				if (in_array(3, $str_arr) && $this->session->userdata('user_group_id') != 1) {
					/* $html=$this->mailbody($insert_id,$this->session->userdata('user_name'));
					$this->db->select('*');
					$this->db->from('users');
					$this->db->where('user_status', 'Enabled');
					$this->db->where('user_email_id is not null');
					$this->db->where('user_email_id <>', '');
					$this->db->where('user_group_id in (7,10)');
					$query = $this->db->get();
					$ggg="";
					foreach($query->result_array() as $row) {
						$ggg.=$row['user_email_id'].",";
					}
					$kk	=	rtrim($ggg, ", "); 
					if($kk){
						$this->furniture_quotation_model->sendmail($from="ddd",$fromname="ddd","$kk",$subject="Create New Customer",$message="$html",$cc="",$bcc="");
					} */
					redirect('dashboard/sales_dashboard');
				} else {
					redirect('client_reports');
				}
			}		
		}
	}
	public function tttt() {
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where('user_status', 'Enabled');
		$this->db->where('user_email_id is not null');
		$this->db->where('user_email_id <>', '');
		$this->db->where('user_group_id in (7,10)');
		$query = $this->db->get();
		echo $this->db->last_query();
		$ggg="";
		foreach($query->result_array() as $row) {
			$ggg.=$row['user_email_id'].",";
		}
		echo $ggg;
	}
	public function mailbody($insert_id) {
		$this->db->select('*');
		$this->db->from('new_client_master');
		$this->db->where('client_id', $insert_id);
		$query = $this->db->get();
		$row = $query->row_array();
		$user_name=$this->session->userdata('user_name');
		$list='<table width="100%" bgcolor="#522a45" cellpadding="0" cellspacing="0" border="0">
			<tbody>
				<tr>
					<td width="100%">
						<table bgcolor="#522a45" width="100%" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
							<tbody>
								<tr>
									<td height="5" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
								</tr>
								<tr>
									<td>
										<table width="500" align="left" border="0" cellpadding="0" cellspacing="0" class="devicewidth">
											<tbody>
												<tr>
													<td width="500" height="60" align="center">
														<div class="imgpop"><span style="color:#FFF;font-size:25px;">Al Maraya Decor</span>';
														$list .= ' </div>
													</td>
												</tr>
											</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td height="" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</td>
				</tr>
			</tbody>
		</table>
		<table width="100%" bgcolor="#fff" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" style="border-bottom:2px solid #522a45;">
           <tbody>
              <tr>
                 <td>
                   	<table width="450" align="left" border="0" cellpadding="0" cellspacing="0" class="devicewidth">
						<tbody>
							<tr>
								 <td width="160" >&nbsp;</td>
								<td  height="20" colspan="2" ></td>
							</tr>
							<tr>
							 <td width="160" >&nbsp;</td>
								<td style="font-family: Helvetica, arial, sans-serif; font-size: 15px; color: #000; text-align:left;" colspan="2" >
									'.$user_name.' created a new Customer.
								</td>
							</tr>
							<tr>
							 <td width="160" >&nbsp;</td>
								<td  height="10"><b>Customer Name :</b> '.$row['client_name'].'</td>
							</tr>
							<tr>
							 <td width="160" >&nbsp;</td>
								<td  height="10"><b>Address :</b> '.nl2br($row['client_address']).'</td>
							</tr>
							<tr>
							 <td width="160" >&nbsp;</td>
								<td  height="10"><b>Telephone :</b> '.$row['client_telephone1'].'</td>
							</tr>
							<tr>
							 <td width="160" >&nbsp;</td>
								<td height="20" colspan="2"></td>
							</tr>
						</tbody>
					</table>
                 </td>
              </tr>
           </tbody>
        </table>';
		return $list;
	}

	public function search_client() {
		$like=array();
		$or_like=array();
		$or_where=array();
		if($this->input->post('client_name') != "") {
			$like=array('client_name'=> $this->input->post('client_name'));
		}
		$or_like=array('client_telephone1' =>  $this->input->post('client_name'),'client_telephone2' =>  $this->input->post('client_name'));
		
		$data['records'] = $this->crud_model->get('new_client_master', null, null, null, null, null, $like, $or_where,$or_like);
		$data['pagination'] = NULL;
		$this->load->view('templates/header');
		$this->load->view('reports/client_reports',$data);
		$this->load->view('templates/footer');
	}
	function update_Invoice($client_id){
		$where=array(
				'client_id' => $client_id
		);
		$records=$this->crud_model->get('new_client_master',$where);
		if($records != false){
			$client_name = $records[0]['client_name'];
			$where=array(
				'client_id'  => $client_id
			);
			$data=array(
				'client' 		=>	$client_name,
			);
			$records=$this->crud_model->update('furniture_invoice',$data,$where);
			$this->session->set_flashdata('success','Client Details Updated');
			redirect('client_reports');
		} else {
			$this->session->set_flashdata('response','Try Later>');
			redirect('client_reports');
		}
	}
	
	function edit($client_id) {
		$this->users_model->permission("Customer", "Edit");
		$title['headerTitle']="Customer Edit";
		$where=array(
				'client_id' => $client_id
		);
		$records=$this->crud_model->get('new_client_master',$where);
		if($records != false){
			//true section
			$data['client_id']		  = $records[0]['client_id'];
			$data['client_name']	  = $records[0]['client_name'];
			$data['client_address']	  = $records[0]['client_address'];
			$data['client_telephone1']= $records[0]['client_telephone1'];
			$data['client_telephone2']= $records[0]['client_telephone2'];
			$data['client_fax']		  = $records[0]['client_fax'];
			$data['client_email']	  = $records[0]['client_email'];
			$data['contact_person']	  = $records[0]['contact_person'];
			$data['tax_name']		  = $records[0]['tax_name'];
			$data['tax_no']		 	  = $records[0]['tax_no'];
			$data['tax_perce']		  = $records[0]['tax_perce'];
			$data['is_credit']		  = $records[0]['is_credit'];
			$data['credit_limit']	  = $records[0]['credit_limit'];
			$data['credit_days']	  = $records[0]['credit_days'];
			$data['client_code']	  = $records[0]['client_code'];
			$data['sales_man']		  = $records[0]['sales_man'];
			$data['client_country']	  = $records[0]['client_country'];
			$data['status']			  = $records[0]['cstatus'];
			$data['cr_no']	  		  = $records[0]['cr_no'];
			$data['acc_group_id']	  = $records[0]['acc_group_id'];
			$data['remarks']	      = $records[0]['remarks'];
			
			$where2=array(
				'ledger_code' => $records[0]['client_code']
			);
			$legder_records=$this->crud_model->get('ledgers',$where2);
			if($legder_records != false){
				$data['bank_account_number']	 = $legder_records[0]['bank_account_number'];
				$data['bank_account_holder_name']= $legder_records[0]['bank_account_holder_name'];
				$data['bank_iban']		 	     = $legder_records[0]['bank_iban'];
				$data['bank_swift']		 	     = $legder_records[0]['bank_swift'];
				$data['bank_name']		 	 	 = $legder_records[0]['bank_name'];
				$data['bank_branch']		 	 = $legder_records[0]['bank_branch'];
				$data['opening_balance']		 = $legder_records[0]['opening_balance'];
			} else {
				$data['bank_account_number']	 = NULL;
				$data['bank_account_holder_name']= NULL;
				$data['bank_iban']		 	     = NULL;
				$data['bank_swift']		 	     = NULL;
				$data['bank_name']		 	     = NULL;
				$data['bank_branch']		 	 = NULL;
				$data['opening_balance']		 = NULL;
			}				
			//$data['opening_balance']		 = $records[0]['opening_balance'];
			$date=date("Y-m-d");
			$data['vat_applicable']=$this->furniture_quotation_model->vat_applicable($date);
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
			
			$where3=array(
				'customer_code'=> $records[0]['client_code'],
				'trn_type' 	   => 'Opening',
			);
			$data['cust_bill_allocations_records']=$this->crud_model->get('cust_bill_allocations',$where3);

			$cd_query = $this->db->get('company_division');
			if ($cd_query->num_rows() > 1) {
				$list = $this->crud_model->get_list('division_id','division_name','company_division',array());
				$data['division_list'] = $list;
				$data['division_count'] = true;
			} else {
				$data['division_id'] = $cd_query->row()->division_id;
				$data['division_count'] = false;
			}

			$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Select Sales Man'),array(),'user_name','asc');
			$data['salesman_list'] = $list2;

			$list3 = $this->crud_model->get_list2('id','Country','country_master',array(),array('status'=>1));
			$data['country_master_list'] = $list3;
			$data['under_list'] = $this->crud_model->get_list2('acc_group_id','acc_group_name','account_group',array('isparent'=>'Customers'),array('acc_group_parent'=>17,'status'=>1));

			$data['user_status'] = array(2 => 'Draft',1 => 'Approve', 0 => 'Disabled');
			$this->load->view('templates/header',$title);
			$this->load->view('reports/edit_client',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('client_reports');
		}
	}

	function update_contact($Contact_Id,$Client_Id) {
		if($Contact_Id!='' && $Client_Id!=''){
			$client_Contact_Name  	   = $this->input->post('client_Contact_Name');
			$client_Contact_Tel  	   = $this->input->post('client_Contact_Tel');
			$client_Contact_designation= $this->input->post('client_Contact_designation');
			$client_Contact_Email  	   = $this->input->post('client_Contact_Email');
			$client_Contact_Address    = $this->input->post('client_Contact_Address');
			if($client_Contact_Name!==''){

				if($client_Contact_Tel!==''){
					$where=array(
						'Contact_Id'  => $Contact_Id
					);
					$data=array(
						'Contact_Name'   => $client_Contact_Name,
						'Contact_Tel' 	 =>	$client_Contact_Tel,
						'designation' 	 =>	$client_Contact_designation,
						'Contact_Email'  =>	$client_Contact_Email,
						'Contact_Address'=>	$client_Contact_Address
					);
					$records=$this->crud_model->update('client_contact',$data,$where);

					$data=array(
						'contact_num'   => $client_Contact_Name,
						'contact_num' 	 =>	$client_Contact_Tel,
					);
					$this->crud_model->update('job_card',$data,$where);


					$this->session->set_flashdata('success','Contact Details Updated');
					redirect('client_reports/view_contact/'.$Client_Id);
				} else {
					$this->session->set_flashdata('response','Contact Tel is required');
					redirect('client_reports/view_contact/'.$Client_Id);
				}
			} else {
				$this->session->set_flashdata('response','Contact Name is required');
				redirect('client_reports/view_contact/'.$Client_Id);
			}
		} else {
			$this->session->set_flashdata('response','error');
			redirect('client_reports');
		}
	}
	
	function do_update() {
		$this->users_model->permission("Customer", "Edit");
		$title['headerTitle']="Customer Edit";
		$client_id= $this->input->post('client_id');
		$where	  = array("client_id"=>$client_id);
		$records  =	$this->crud_model->get('new_client_master', $where);
		if($records != false){
			if(trim($records[0]['client_name']) != trim($this->input->post('client_name'))){
				$this->form_validation->set_rules('client_name', 'Client Name', 'required|max_length[100]|is_unique[new_client_master.client_name]');
			} else {
				$this->form_validation->set_rules('client_name', 'Client Name', 'required|max_length[100]');
			}

			if(trim($records[0]['client_telephone1']) != trim($this->input->post('client_telephone1'))){
				$this->form_validation->set_rules('client_telephone1', 'Telephone 1', 'required|numeric|max_length[20]|is_unique[new_client_master.client_telephone1]|is_unique[new_client_master.client_telephone2]');
			} else {
				$this->form_validation->set_rules('client_telephone2', 'Telephone 1', 'required|numeric|max_length[20]|is_unique[new_client_master.client_telephone2]');
			}
			if(trim($records[0]['client_telephone2']) != trim($this->input->post('client_telephone2'))){
				$this->form_validation->set_rules('client_telephone2', 'Telephone 2', 'numeric|max_length[20]|is_unique[new_client_master.client_telephone1]|is_unique[new_client_master.client_telephone2]');
			} else {
				$this->form_validation->set_rules('client_telephone2', 'Telephone 2', 'numeric|max_length[20]|is_unique[new_client_master.client_telephone1]');
			}
			
			$this->form_validation->set_rules('client_address', 'Client Address', 'required');
			$this->form_validation->set_rules('client_fax', 'Fax', 'numeric|max_length[20]');
			$this->form_validation->set_rules('contact_person', 'Contact Person', 'required|max_length[100]');
			
			
			$client_name  	  = trim($this->input->post('client_name'));
			$client_address   = trim($this->input->post('client_address'));
			$client_telephone1= $this->input->post('client_telephone1');
			$client_telephone2= $this->input->post('client_telephone2');
			$client_fax  	  = $this->input->post('client_fax');
			$client_email  	  = $this->input->post('client_email');
			$contact_person   = $this->input->post('contact_person');
			$tax_name  		  = $this->input->post('tax_name');
			$tax_no  		  = $this->input->post('tax_no');
			$salesman_id  	  = $this->input->post('salesman_id');
			$country_id  	  = $this->input->post('country_id');

			if(@$this->input->post('is_credit')==1){
				$is_credit=$this->input->post('is_credit');
			} else {
				$is_credit=0;
			}
			if($this->input->post('acc_group_id')==='isparent'){
				$acc_group_id=17;
					
			} else {
				$acc_group_id =	$this->input->post('acc_group_id');
			}
			$remarks  		= $this->input->post('remarks');
			
			$credit_limit= $this->input->post('credit_limit');
			$credit_days = $this->input->post('credit_days');
			$tax_perce   = $this->input->post('tax_perce');
			$cr_no   = $this->input->post('cr_no');

			if ($this->form_validation->run() == FALSE) {
				$data['client_id']		  = $records[0]['client_id'];
				$data['client_name']	  = $records[0]['client_name'];
				$data['client_address']	  = $records[0]['client_address'];
				$data['client_telephone1']= $records[0]['client_telephone1'];
				$data['client_telephone2']= $records[0]['client_telephone2'];
				$data['client_fax']		  = $records[0]['client_fax'];
				$data['client_email']	  = $records[0]['client_email'];
				$data['contact_person']	  = $records[0]['contact_person'];
				$data['tax_name']		  = $records[0]['tax_name'];
				$data['tax_no']		 	  = $records[0]['tax_no'];
				$data['tax_perce']		  = $records[0]['tax_perce'];
				$data['is_credit']		  = $records[0]['is_credit'];
				$data['credit_limit']	  = $records[0]['credit_limit'];
				$data['credit_days']	  = $records[0]['credit_days'];

				$data['client_code']	  = $records[0]['client_code'];
				$data['sales_man']		  = $records[0]['sales_man'];
				$data['client_country']	  = $records[0]['client_country'];
				$data['status']	  		  = $records[0]['cstatus'];
				$data['cr_no']	  		  = $records[0]['cr_no'];
				$data['acc_group_id']	  = $records[0]['acc_group_id'];
				$data['remarks']	  	  = $records[0]['remarks'];
				if($this->input->post('acc_group_id')==='isparent'){
					$acc_group_id=17;
						
				} else {
					$acc_group_id =	$this->input->post('acc_group_id');
				}
				$remarks  		= $this->input->post('remarks');

				$where2=array(
					'ledger_code' => $records[0]['client_code']
				);
				$legder_records=$this->crud_model->get('ledgers',$where2);
				if($legder_records != false){
					$data['bank_account_number']	  = $legder_records[0]['bank_account_number'];
					$data['bank_account_holder_name'] = $legder_records[0]['bank_account_holder_name'];
					$data['bank_iban']		 	      = $legder_records[0]['bank_iban'];
					$data['bank_swift']		 	      = $legder_records[0]['bank_swift'];
					$data['bank_name']		 	 	  = $legder_records[0]['bank_name'];
					$data['bank_branch']		 	  = $legder_records[0]['bank_branch'];
					$data['opening_balance']		  = $legder_records[0]['opening_balance'];
				} else {
					$data['bank_account_number']	  = NULL;
					$data['bank_account_holder_name'] = NULL;
					$data['bank_iban']		 	      = NULL;
					$data['bank_swift']		 	      = NULL;
					$data['bank_name']		 	      = NULL;
					$data['bank_branch']		 	  = NULL;
					$data['opening_balance']		  = NULL;
				}	

				$date=date("Y-m-d");
				$data['vat_applicable']=$this->furniture_quotation_model->vat_applicable($date);
				$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
				
				$where3=array(
					'customer_code' => $records[0]['client_code'],
					'trn_type' 		=> 'Opening',
				);
				$data['cust_bill_allocations_records']=$this->crud_model->get('cust_bill_allocations',$where3);

				$cd_query = $this->db->get('company_division');
				if ($cd_query->num_rows() > 1) {
					$list = $this->crud_model->get_list('division_id','division_name','company_division',array());
					$data['division_list'] = $list;
					$data['division_count'] = true;
				} else {
					$data['division_id'] = $cd_query->row()->division_id;
					$data['division_count'] = false;
				}

				$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Select Sales Man'),array(),'user_name','asc');
				$data['salesman_list'] = $list2;

				$list3 = $this->crud_model->get_list2('id','Country','country_master',array(),array('status'=>1));
				$data['country_master_list'] = $list3;
				$data['under_list'] = $this->crud_model->get_list2('acc_group_id','acc_group_name','account_group',array('isparent'=>'Customers'),array('acc_group_parent'=>17,'status'=>1));


				$data['user_status'] = array(2 => 'Draft',1 => 'Approve', 0 => 'Disabled');
				
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('reports/edit_client',$data);
				$this->load->view('templates/footer');
			} else {
				$str_arr = preg_split ("/\,/", $this->session->userdata('is_user_type'));
				if (in_array(3, $str_arr)  && $this->session->userdata('user_group_id') != 1) {
					$status=$this->input->post('status');
				} else {
					$status=1;
				}
				$status=$this->input->post('status');
				$this->db->trans_begin();
				$where=array(
					'client_id'  => $client_id
				);
				$data=array(
					'client_name' 		=> $client_name,
					'client_address' 	=> $client_address,
					'client_telephone1' => $client_telephone1,
					'client_telephone2' => $client_telephone2,
					'client_fax' 		=> $client_fax,
					'client_email' 		=> $client_email,
					'contact_person' 	=> $contact_person,
					'tax_name' 			=> $tax_name,
					'tax_no' 			=> $tax_no,
					'is_credit' 		=> $is_credit,
					'credit_limit' 		=> $credit_limit,
					'credit_days' 		=> $credit_days,
					'tax_perce' 		=> $tax_perce,
					'client_country' 	=> $country_id,
					'sales_man' 		=> $salesman_id,
					'cstatus' 			=> $status,
					'cr_no' 			=> 	$cr_no,
					'acc_group_id' 		=> $acc_group_id,
					'remarks' 		    => $remarks,
				);

				$records=$this->crud_model->update('new_client_master',$data,$where);
				$insid  = $this->input->post('client_code');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Customer',	
					'masters_id'=>$insid,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$bank_account_number 	   = $this->input->post('bank_account_number');
				$bank_account_holder_name  = $this->input->post('bank_account_holder_name');
				$bank_iban    = $this->input->post('bank_iban');
				$bank_swift    = $this->input->post('bank_swift');
				$bank_name = $this->input->post('bank_name');
				$bank_branch  = $this->input->post('bank_branch');
				$client_code  = $this->input->post('client_code');
				$opening_balance  = $this->input->post('opening_balance');
				
				$led_data=array(
					'ledger_code'  		=> $client_code,
					'ledger_name' 		=> $client_name,
					'tax_percentage' 	=> $tax_perce,
					'acoount_group_id'  => 17,
					'taxability' 		=> 'Taxable',
					'opening_balance' 	=> $opening_balance,
					'bank_account_number' => $bank_account_number,
					'bank_account_holder_name'=> $bank_account_holder_name,
					'bank_iban' 		=> $bank_iban,
					'bank_swift' 		=> $bank_swift,
					'bank_name' 		=> $bank_name,
					'country_id' 		=> $country_id,
					'bank_branch' 		=> $bank_branch,
				);

				$this->db->where('ledger_code', $client_code);
				$query = $this->db->get('ledgers');
				if ($query->num_rows() > 0) {
					$where2=array(
						'ledger_code'  => $client_code
					);
					$this->crud_model->update('ledgers',$led_data,$where2);
				} else {
					$this->crud_model->insert('ledgers',$led_data);
				}
				//$records=$this->crud_model->insert('ledgers',$data);
				$cus_bill_id  = $this->input->post('cus_bill_id');
				$bill_no	  = $this->input->post('bill_no');
				$bill_date	  = $this->input->post('bill_date');
				$bill_amount  = $this->input->post('bill_amount');
				$os_amount	  = $this->input->post('os_amount');
				$bill_type	  = $this->input->post('bill_type');
				$division_id  = $this->input->post('division_id');
				$det_salesman_id = $this->input->post('det_salesman_id');
				$opening_total= 0;
		
				$where3=array(
					'customer_code'=> $client_code,
					'trn_type' 	   => 'Opening',
				);

				$this->crud_model->delete('cust_bill_allocations',$where3);

				for($i=0; $i<count($bill_no); $i++){
					if($bill_no[$i]!=='' and $bill_date[$i]!=='' and $bill_amount[$i]!=='' and $os_amount[$i]!=='' and $bill_type[$i]!==''){
						$opening_total = $opening_total+$os_amount[$i];
						if($cus_bill_id[$i]!==''){
							$data_array = array(
								'id' 			=> $cus_bill_id[$i],
								'customer_code' => $client_code,
								'bill_id' 		=> 'OP'.$bill_no[$i],
								'trn_no' 		=> 'OP'.$bill_no[$i],
								'bill_date'		=> date("Y-m-d", strtotime($bill_date[$i])),
								'bill_amt' 		=> $bill_amount[$i],
								'bill_os_amount'=> $os_amount[$i],
								'bill_type' 	=> $bill_type[$i],
								'trn_type' 	  	=> 'Opening',
								'division_id' 	=> $division_id[$i],
								'sm_id' 		=> $det_salesman_id[$i],
								'status'        => 1
							);
							$this->db->insert('cust_bill_allocations', $data_array);
						} else {
							$data_array = array(
								'customer_code' => $client_code,
								'bill_id' 		=> 'OP'.$bill_no[$i],
								'trn_no' 		=> 'OP'.$bill_no[$i],
								'bill_date'		=> date("Y-m-d", strtotime($bill_date[$i])),
								'bill_amt' 		=> $bill_amount[$i],
								'bill_os_amount'=> $os_amount[$i],
								'bill_type' 	=> $bill_type[$i],
								'trn_type' 	  	=> 'Opening',
								'division_id' 	=> $division_id[$i],
								'sm_id' 		=> $det_salesman_id[$i],
								'status'        => 1
							);
							$this->db->insert('cust_bill_allocations', $data_array);
						}
	 		 		}
				}

				$op_data=array(
					'opening_balance' 	=> 	$opening_total
				);
				$this->crud_model->update('ledgers',$op_data,$where2);

				$where4=array(
					'ledger_code'=>  $client_code,
					'vch_no' 	=>  0,
					'vch_type'  => 'Opening',
				);
				$this->crud_model->delete('accounts',$where4);

				if($opening_total!=0 && $opening_total!=''){
					$books_beginning_date  = $this->furniture_quotation_model->books_beginning_date_config();
					$accounts_data = array(
						'vch_type' 	  => 'OPENING',
						'vch_no'  	  => 0,
						'vch_date'    => $books_beginning_date,
						'vch_ref'     => '',
						'ledger_code' => $client_code,
						'rev_ledger_code' => NULL,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> (float)$opening_total,
						'ledger_narration'=> 'Opening Balance',
						'vch_narration'=> 'Opening Balance',
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response','Sorry! Something went wrong .');
					redirect('client_reports/edit/'.$client_id);
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success','Client Details Updated');
					redirect('client_reports/edit/'.$client_id);
				}
			}
		} else {
			$this->session->set_flashdata('response','error');
			redirect('client_reports');
		}

	}
}
?>