<?php
class Emails extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
	}
	function index()	{

		$this->db->select('*');
		$this->db->from('emails');
		$query = $this->db->get();
		
		$data['records'] = $query->result_array();
		
		$data['records_count'] = $this->crud_model->get_count('emails',array());
		
		$this->load->view('templates/header');
		$this->load->view('admin/emails/list_emails',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->load->view('templates/header');
		$this->load->view('admin/emails/add_emails');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		
		$this->db->select('*');
		$this->db->from('emails');
		$this->db->where('id', $id); 
		$query = $this->db->get();
		$records=$query->result_array();
		
		if($records != false){
			$data['id']	                  = $records[0]['id'];
			$data['quote_confirmation']	  = $records[0]['quote_confirmation'];
			$data['quote_cc']		 	  = $records[0]['quote_cc'];
			$data['invoice']			  = $records[0]['invoice'];
			$data['invoice_cc']			  = $records[0]['invoice_cc'];
			$data['receipt']		      = $records[0]['receipt'];
			$data['receipt_cc']			  = $records[0]['receipt_cc'];
		
			$this->load->view('templates/header');
			$this->load->view('admin/emails/edit_emails',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">Error</div>');
			redirect('admin/emails');
		}
	}
	function do_insert() {
				$this->db->select('*');
				$this->db->from('emails');
				$up_data_new = $this->db->get();
				if($up_data_new->num_rows() == 1){
					$this->session->set_flashdata('response','<div class="alert alert-error">sorry...multiple entry not allowed</div>',':old:');
					$this->load->view('templates/header');
					$this->load->view('admin/emails/add_emails');
					$this->load->view('templates/footer');
				}else{
	
					$data=array('quote_confirmation' => $this->input->post('quote_email'),
								'quote_cc' => $this->input->post('quote_cc'),
								'invoice' => $this->input->post('invoice'),
								'invoice_cc' => $this->input->post('invoice_cc'),
								'receipt' => $this->input->post('receipt'),
								'receipt_cc' => $this->input->post('receipt_cc')
					);
	
					$rr=$this->crud_model->insert('emails',$data);
				
			if($rr == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Emails cannot be inserted</div>',':old:');
			} else {
				$this->session->set_flashdata('response','<div class="alert alert-success">Emails added successfully</div>');
			}
			redirect('admin/emails');
			}
	}

	function do_update() {

			$where=array(
				'id'  => $this->input->post('id')
			);
					$data=array('quote_confirmation' => $this->input->post('quote_email'),
								'quote_cc' => $this->input->post('quote_cc'),
								'invoice' => $this->input->post('invoice'),
								'invoice_cc' => $this->input->post('invoice_cc'),
								'receipt' => $this->input->post('receipt'),
								'receipt_cc' => $this->input->post('receipt_cc')
					);
			$records=$this->crud_model->update('emails',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Emails updated</div>');
			redirect('admin/emails');
			
	}
	function do_delete($id=0) {
	
			$where=array(
				'id'=> $id
			);
			$this->crud_model->delete('emails',$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Emails deleted</div>');
			redirect('admin/emails');
			
	}
}