<?php
class Quick_menu extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->config->load('arrays');
	}
	function index($page=1)
	{
		$this->users_model->permission("Users", "View");
		$title['headerTitle']="User List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('admin/users/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('users',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('users',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('admin/users/list',$data);
		$this->load->view('templates/footer');
	}
	function create($user_id,$group_id)
	{
		//$this->users_model->permission("Quick_menu", "Add");
		$title['headerTitle']="Quick Menu";
		$query= $this->db->query("SELECT user_id,user_name FROM `users` WHERE `user_id`='$user_id' ");
		$ListData	=	$query->result_array();
		$data['records']    = $query->result_array();
		$data['user_id']    = $ListData[0]['user_id'];
		$data['username']    = $ListData[0]['user_name'];
		$query2= $this->db->query("SELECT c.group_by as group_by,cg.name as group_name,c.sub_group,c.controller_name,c.full_option FROM `permission` p inner join controllers c on c.controller_name=p.controller inner join controller_group cg on cg.id=c.group_by WHERE p.`user_id` = '".$user_id."' and c.group_by = '".$group_id."' group by c.group_by order by c.group_by ");
		$data['fiels_list']	=$query2->result_array();
		//$this->load->view('header');
		//$this->load->view('sidebar');
		$query3= $this->db->query("SELECT * FROM `controller_sub_group` WHERE 1");
		$data['sub_group_records']	=$query3->result();
		$data['group_id']    = $group_id;
		$query4 = $this->db->query("SELECT * FROM `permission` WHERE  `is_quick_menu` = 1 AND `user_id`='$user_id' AND `group_id`= $group_id  ORDER BY `sort_by` ASC");
        $data['sortmenu'] = $query4->result_array();
		$data['controllersname'] = $this->getcontrollers();
		$this->load->view('templates/header',$title);
		$this->load->view('admin/users/quick_menu',$data);
		$this->load->view('templates/footer');
	}
	function edit($id = 0)
	{
		$this->users_model->permission("Users", "Edit");
		$title['headerTitle']="User Edit";
		$where=array(
				'user_id' => $id
		);
		$records=$this->crud_model->get('users',$where);
		$userwise_work_flow_datas = $this->crud_model->get('userwise_work_flow',null,null,null,null,null,null,null,null,'user_type');
		if($records != false){
			//true section
			$data['user_name']			     = $records[0]['user_name'];
			$data['name']			     	 = $records[0]['name'];
			$data['user_email_id']			 = $records[0]['user_email_id'];
			$data['user_status']			 = $records[0]['user_status'];
			$data['user_contact_number']	 = $records[0]['user_contact_number'];
			$data['user_direct_number']		 = $records[0]['user_direct_number'];
			$data['user_group_id']			 = $records[0]['user_group_id'];
			$data['user_id']			     = $records[0]['user_id'];
			$data['is_salesman']			 = $records[0]['is_salesman'];
			$data['is_user_type']			 = $records[0]['is_user_type'];
			$data['default_controller_name']			 = $records[0]['default_controller_name'];

			$records = $this->crud_model->get('user_groups');
			if($records!=false){

				$list = array(0 => ' - Select - ');
				foreach($records as $record){

					$list[$record['user_group_id']] = $record['user_group_name'];

				}

				$data['user_statuses'] = $this->config->item('user_status_array');
				$data['user_groups'] = $list;
				$data['userwise_work_flow_datas'] = $userwise_work_flow_datas;

				$this->load->view('templates/header',$title);
				$this->load->view('admin/users/edit',$data);
				$this->load->view('templates/footer');

			}
		}
		else{
			//false section
			$this->session->set_flashdata('response','error');
			redirect('admin/users');
		}

	}
	function location_permission($id = 0)
	{

		$title['headerTitle']="Permission";
		$where=array(
				'user_id' => $id
		);
		$records=$this->crud_model->get('users',$where);
		$userwise_work_flow_datas = $this->crud_model->get('userwise_work_flow',null,null,null,null,null,null,null,null,'user_type');
		if($records != false){
			//true section
			$data['user_name']			     = $records[0]['user_name'];
			$data['name']			     	 = $records[0]['name'];
			$data['user_email_id']			 = $records[0]['user_email_id'];
			$data['user_status']			 = $records[0]['user_status'];
			$data['user_contact_number']	 = $records[0]['user_contact_number'];
			$data['user_direct_number']		 = $records[0]['user_direct_number'];
			$data['user_group_id']			 = $records[0]['user_group_id'];
			$data['user_id']			     = $records[0]['user_id'];
			$data['is_salesman']			 = $records[0]['is_salesman'];
			$data['is_user_type']			 = $records[0]['is_user_type'];

			$records = $this->crud_model->get('user_groups');
			if($records!=false){



				$list2 = $this->crud_model->get('location_master',array('status'=>'1'));
				$data['location_list'] = $list2;
				$this->load->view('templates/header',$title);
				$this->load->view('admin/users/location_permission',$data);
				$this->load->view('templates/footer');

			}
		}
		else{
			//false section
			$this->session->set_flashdata('response','error');
			redirect('admin/users');
		}

	}
	function do_insert()
	{
		$this->users_model->permission("Users", "Add");
		$title['headerTitle']="User Create";
		$this->form_validation->set_rules('user_name', 'User Name', 'required|is_unique[users.user_name]');
		$this->form_validation->set_rules('full_name', 'Full Name', 'required');
		//$this->form_validation->set_rules('user_email_id', 'Email ID', 'required|valid_email|is_unique[users.user_email_id]');

		$this->form_validation->set_rules('new_password', 'New Password', 'required|min_length[6]|max_length[50]|matches[retype_password]');
		$this->form_validation->set_rules('retype_password', 'Retyped Password', 'required|min_length[6]|max_length[50]');
		$this->form_validation->set_rules('user_contact_number', 'Mobile Number', 'required|max_length[40]');
		$this->form_validation->set_rules('user_direct_number', 'Direct Number', 'required|max_length[20]');
		$this->form_validation->set_rules('user_status', 'Status', 'required');
		$this->form_validation->set_rules('user_group_id', 'Group', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('usertype[]', 'User Type', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->create();
		}
		else
		{	// true section



			//db validation
			$where = array('user_email_id'=>$this->input->post('user_email_id'));
			$user_exists = $this->crud_model->get('users',$where);
			if($user_exists != false){
				// user already exists in db
				// error section
				$this->session->set_flashdata('response','Email ID already exists',':old:');
				$this->create();
			}
			else{
				// user not exists in db
				// success section
				$user_name			= $this->input->post('user_name');
				$full_name			= $this->input->post('full_name');
				$user_email_id		= $this->input->post('user_email_id');
				$user_contact_number= $this->input->post('user_contact_number');
				$user_direct_number = $this->input->post('user_direct_number');
				$user_group_id		= $this->input->post('user_group_id');
				$usertype			= $this->input->post('usertype');
				$default_controller_name= $this->input->post('default_controller_name');
				$t='';
				for($i=0;$i<count($usertype);$i++){
					$t.=$usertype[$i].',';
				}

				$xxxuser=rtrim($t, ',');

				$hiddenProducts = explode(',', $xxxuser);

				if (in_array(3, $hiddenProducts)) {
					$issalesman		= 1;
				  } else {
					$issalesman		= 0;
				  }



				/*if($this->input->post('issalesman')==='1'){
					$issalesman		= 1;
				} else {
					$issalesman		= 0;
				}*/

				$data=array(
					'user_name' 			=> $full_name,
					'name' 					=> $user_name,
					'user_email_id' 		=> $user_email_id,
					'user_contact_number' 	=> $user_contact_number,
					'user_direct_number' 	=> $user_direct_number,
					'user_group_id' 		=> $user_group_id,
					'is_salesman' 			=> $issalesman,
					'is_user_type' 			=> $xxxuser,
					'default_controller_name'=> $default_controller_name,
					'user_password' 		=> md5($this->input->post('new_password'))
				);

				$rr = $this->crud_model->insert('users',$data);

				if($rr != false){
					// true section
					$this->session->set_flashdata('success','User added successfully');
					redirect('admin/users');
				}
				else
				{
					// false section
					$this->session->set_flashdata('response','Error creating user record',':old:');
					$this->create();
				}
			}

		}

	}

	function do_update()
	{
		$this->users_model->permission("Users", "Edit");
		$title['headerTitle']="User Edit";
		$this->form_validation->set_rules('user_name', 'User Name', 'required');
		$this->form_validation->set_rules('full_name', 'Full Name', 'required');
		$this->form_validation->set_rules('user_contact_number', 'Mobile Number', 'required|max_length[40]');
		$this->form_validation->set_rules('user_direct_number', 'Direct Number', 'required|max_length[20]');
		$this->form_validation->set_rules('new_password', 'New Password', 'min_length[6]|max_length[10]|matches[retype_password]');
		$this->form_validation->set_rules('retype_password', 'Retyped Password', 'min_length[6]|max_length[10]');
		$this->form_validation->set_rules('user_status', 'Status', 'required');
		$this->form_validation->set_rules('user_group_id', 'Group', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('usertype[]', 'User Type', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->edit($this->input->post('user_id'));

		}
		else
		{// true section


			$user_name				= $this->input->post('user_name');
			$full_name				= $this->input->post('full_name');
			$user_contact_number    = $this->input->post('user_contact_number');
			$user_direct_number     = $this->input->post('user_direct_number');
			$user_status		    = $this->input->post('user_status');
			$user_group_id		    = $this->input->post('user_group_id');
			$usertype				= $this->input->post('usertype');
			$user_email_id			= $this->input->post('user_email_id');
			$default_controller_name= $this->input->post('default_controller_name');
			$t='';
			for($i=0;$i<count($usertype);$i++){
				$t.=$usertype[$i].',';
			}

			$xxxuser=rtrim($t, ',');

			$hiddenProducts = explode(',', $xxxuser);

			if (in_array(3, $hiddenProducts)) {
				$issalesman		= 1;
			  } else {
				$issalesman		= 0;
			  }


			$data=array(
				'user_name' 			=> $full_name,
				'user_contact_number'   => $user_contact_number,
				'user_direct_number'    => $user_direct_number,
				'user_status'           => $user_status,
				'is_salesman' 			=> $issalesman,
				'is_user_type' 			=> $xxxuser,
				'user_email_id' 		=> $user_email_id,
				'user_group_id'         => $user_group_id,
				'default_controller_name'         => $default_controller_name
			);
			if($this->input->post('new_password') != ''){
				$data['user_password'] = md5($this->input->post('new_password'));
			}

			$where=array(
					'user_id'=> $this->input->post('user_id')
			);
			$records=$this->crud_model->update('users',$data,$where);

			$this->session->set_flashdata('success','User details updated');
			redirect('admin/users');

		}
	}

	function do_permission()
	{
		$title['headerTitle']="User Edit";
		$this->form_validation->set_rules('user_id', 'User Name', 'required');
		$this->form_validation->set_rules('usertype[]', 'Location', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->location_permission($this->input->post('user_id'));

		}
		else
		{// true section

			$user_id	= $this->input->post('user_id');
			$usertype	= $this->input->post('usertype');

			$where=array(
				'user_id'=> $user_id
			);

			$this->crud_model->delete('location_permission',$where);

			$t='';
			for($i=0;$i<count(@$usertype);$i++){
				$data=array(
					'loc_id' 			=> $usertype[$i],
					'user_id'   		=> $user_id,
					'permission_value'  => 'Allow'
				);
				$records=$this->crud_model->insert('location_permission',$data);
			}

			$this->session->set_flashdata('success','Permission updated');
			redirect('admin/users');
		}
	}

	function do_delete($id=0)
	{
		$this->users_model->permission("Users", "Delete");
		$where=array(
				'user_id'=> $id
		);

		$this->crud_model->delete('users',$where);

		$this->session->set_flashdata('response','User deleted');
		redirect('admin/users');
	}

	public function setPermission($user_id,$group_id){
		$title['headerTitle']="User Set Permission";
		$query= $this->db->query("SELECT user_id,user_name FROM `users` WHERE `user_id`='$user_id' ");
		$ListData	=	$query->result_array();
		$data['records']    = $query->result_array();
		$data['user_id']    = $ListData[0]['user_id'];
		$data['username']    = $ListData[0]['user_name'];
		$query2= $this->db->query("SELECT * FROM `controllers` where group_by='$group_id' order by group_by,sub_group asc ");
		$data['fiels_list']	=$query2->result_array();
		//$this->load->view('header');
		//$this->load->view('sidebar');
		$data['group_id']    = $group_id;
		$this->load->view('templates/header',$title);
		$this->load->view('admin/users/permission',$data);
		$this->load->view('templates/footer');
	}
	function save_permission($user_id,$group_id){
		$this->form_validation->set_rules('user', 'User', 'required');
		if ($this->form_validation->run() == FALSE){
			$title['headerTitle']="User Set Permission";
			$query= $this->db->query("SELECT user_id,user_name FROM `users` WHERE `user_id`='$user_id' ");
			$ListData	=	$query->result_array();
			$data['records']    = $query->result_array();
			$data['user_id']    = $ListData[0]['user_id'];
			$data['username']    = $ListData[0]['user_name'];
			$query2= $this->db->query("SELECT * FROM `controllers` where group_by='$group_id' order by group_by,sub_group asc ");
			$data['fiels_list']	=$query2->result_array();
			//$this->load->view('header');
			//$this->load->view('sidebar');
			$data['group_id']    = $group_id;
			$this->load->view('templates/header',$title);
			$this->load->view('admin/users/permission',$data);
			$this->load->view('templates/footer');
		}else{

			$this->db->where('user_id', $user_id);
			$this->db->where('group_id', $group_id);
            $this->db->delete('permission');

			for($i=0; $i<=$this->input->post('list_count') ; $i++){

			   if($this->input->post('view'.$i)=="yes"){
			   		$data=array(
						'user_id' 		=> $this->input->post('user'),
						'group_id' 		=> $group_id,
						'controller'    => $this->input->post('controller'.$i),
						'add'     		=> $this->input->post('add'.$i),
						'edit' 		    => $this->input->post('edit'.$i),
						'delete' 		=> $this->input->post('delete'.$i),
						'view' 	  		=> $this->input->post('view'.$i)
					);

					$this->db->insert('permission', $data);
				}
			}

			$this->session->set_flashdata('msg', 'Permission Added Successfully');
			if($group_id==1){
				redirect("admin/users/setPermission/".$user_id."/2");
			}else if($group_id==2){
				redirect("admin/users/setPermission/".$user_id."/3");
			} else {
				redirect("admin/users");
			}
		}
	}
	function permission_details(){
		$user_id = $this->input->post('user');
		$group_id = $this->input->post('group_id');
		$query = $this->db->query("SELECT * FROM `permission` WHERE `user_id`='$user_id' AND `group_id`='$group_id' ");
		$permission_list = $query->result_array();
		if($permission_list!=false){
			echo json_encode($permission_list);
		}
	}
	function controller_details(){
		$group_id = $this->input->post('group_id');
		$controller_count = $this->crud_model->get_count('controllers',array('group_by'=>$group_id));
		if($controller_count!=false){
			echo $controller_count;
		}
	}


	public function sortMenu(){
		$permission_id = $this->input->post('sort_data');
		$user_id = $this->input->post('user_id');
		$group_id = $this->input->post('group_id');
		$sortno = 1;
		$this->db->query("UPDATE `permission` SET `is_quick_menu` = 0 ,`sort_by` = 0  WHERE  `user_id` = '$user_id' AND `group_id` = '$group_id' AND `permission_id` != ''");
		foreach ($permission_id as $permission) {
			$updateqry = $this->db->query("UPDATE `permission` SET `is_quick_menu` = 1 ,`sort_by` ='$sortno'  WHERE  `permission_id` = '$permission'");
			$sortno++;
		}
		if($updateqry === TRUE){
			echo json_encode('success');
		}
		else
		{
			echo json_encode('error');
		}
	}

	public function getcontrollers(){
		$query = $this->db->query("SELECT * FROM `controllers`");
		return $query->result_array();
	}

}
