<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Furniture_payment_terms extends CI_Controller {

	public function __construct() {

		parent::__construct();

		if($this->session->userdata('user_logged_in') != true) {
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}

		/*if($this->session->userdata('furniture_quotation_id') == false) {
			$this->session->set_flashdata('response','<div class="alert alert-error">You are not authorized to edit this quotation.</div>');
			redirect('furniture/Furniture_quotations');
		}*/

		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('tw');
		$this->load->model('furniture_quotation_model');

		/*if($this->furniture_quotation_model->check_privilege($this->session->userdata('furniture_quotation_id')) == false) {
		if($this->session->userdata('staus_for_qoute') == false){
			$this->session->set_flashdata('response','<div class="alert alert-error">You are not authorized to edit this quotation.</div>');}
			else{
			$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Status Updated successfully.</div>');
			$this->session->unset_userdata('staus_for_qoute');
			}
			redirect('furniture/Furniture_quotations');

		}*/

	}

	function upload_it(){  
		if($this->input->post('title')!=='' && $_FILES["fileField"]["name"]!=='' ){
			$this->load->helper('form');
			$uniqueID = $this->input->post('quotation_number');
			if(!file_exists("uploads/".$uniqueID))
				mkdir("uploads/".$uniqueID);
				$config['upload_path'] = 'uploads/'.$uniqueID;
				$config['allowed_types'] = '*';
				$config['overwrite'] = FALSE;
				$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');
				$this->upload->do_upload("fileField");
				echo $this->upload->display_errors();
				$upload_data  =   $this->upload->data();
				$uploadImage = $upload_data['file_name'];
				$newdata = array(
					'title'=>$this->input->post('title'),
					'quotation_number'=>$this->input->post('quotation_number'),
					'division_id'=>$this->input->post('quotation_division'),
					'qutation_id'=>$this->input->post('quotation_id_redrct'),
					'user_id'=>$this->session->userdata('user_id'),
					'file_name'=>$uploadImage,
				);
				$add_file = $this->db->insert('upload_files_print', $newdata); 
				if($add_file){
					$this->session->set_flashdata('success','File Uploaded Successfully...');
				}else{
					$this->session->set_flashdata('response','Something Wrong.Try Again...');
				}
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again...');
		}
	    redirect('furniture/Furniture_payment_terms/index/'.$this->input->post('quotation_id_redrct').'');
	  	// exit;
	}

	function index($furniture_quotation_id) {
		$this->users_model->permission("Quotation", "Add");
		$title['headerTitle']="Quotation - Finalise";
		if(!($this->furniture_quotation_model->check_privilege($furniture_quotation_id))) {
			//exit();
			$this->session->set_flashdata('response','Sorry! You don\'t have the privilege to modify this quotation.');
			redirect('furniture/furniture_quotations');
		}
		$quotation_id=$furniture_quotation_id;



		$where=array(
			'quotation_id' => $quotation_id
		);

		$data['quotation_id'] = $quotation_id;

		$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');
		if(( QMS_GENERAL_QTN_DIV_ID == $quotation_details["division_id"]) or ( QMS_WORKSHOP_QTN_DIV_ID == $quotation_details["division_id"]) ) 		{
			$data['general_quotation'] = true;
		}

		$records = $this->crud_model->get('covering_letter_template');
		$list = $this->crud_model->get_list('cl_template_id','cl_template_name','covering_letter_template',array(0=>' - Select Covering Letter Template - '));
		$data['covering_letter_template'] = $list;
		
		$list_terms = $this->crud_model->get_list('terms_id','terms_name','terms_and_conditions',array(0=>' - Select Terms & Conditions - '));
		$data['terms_and_condition'] = $list_terms;

		$where2=array(
			'qutation_id' => $quotation_id
		);
		
		$data['upload_files_print'] = $this->crud_model->get('upload_files_print',$where2, null,null,null,null,null,null);

		$data['quotation_number_full'] = $quotation_details['quotation_number_full'];
		$data['quotation_number'] = $quotation_details['quotation_number'];
		$data['division_id'] = $quotation_details['division_id'];
		$data['quotation_date'] = $quotation_details['quotation_date'];
		$data['salesman_name'] 	= $quotation_details['salesman_name'];
		$data['quotation_total'] = $quotation_details['quotation_total'];
		$data['discount_percentage'] = $quotation_details['discount_percentage'];
		$data['quotation_discount_amount'] = $quotation_details['quotation_discount_amount'];
		$data['quotation_net_total'] = round($quotation_details['quotation_net_total'],3);
		$data['advance_percentage'] = $quotation_details['advance_percentage'];
		$data['advance_amount'] 	= $quotation_details['advance_amount'];
		$data['quotation_vat_percentage'] 	= $quotation_details['quotation_vat_percentage'];
		$data['contact_id'] = $quotation_details['contact_id'];
		$data['project_name'] = $quotation_details['project_name'];
		$data["qt_status"] = $quotation_details["status"];
		$data['rna_division'] = $quotation_details['division_id'];
		$data['rna_quotation_number'] = $quotation_details['quotation_number'];
		$data['covering_letter'] = $quotation_details['covering_letter'];
		$data['terms_and_conditions'] = $quotation_details['terms_and_conditions'];
		

		if($this->session->userdata('user_group_id') == 1) {
			//Loading Exstock Payment Terms and ByOrder Payement terms from master table
			$list = $this->crud_model->get_list('payment_id','payment_label','furniture_byorder_paymentterm',array());
			$data['byorder_label'] = $list;

			$list = $this->crud_model->get_list('payment_id','payment_text','furniture_byorder_paymentterm',array());
			$data['byorder_text'] = $list;

			$list = $this->crud_model->get_list('payment_id','payment_label','furniture_exstock_paymentterm',array());
			$data['exstock_label'] = $list;

			$list = $this->crud_model->get_list('payment_id','payment_text','furniture_exstock_paymentterm',array());
			$data['exstock_text'] = $list;

			$data['byorder_paymenttermid']=$quotation_details['byorder_paymenttermid'];
			$data['exstock_paymenttermid']=$quotation_details['exstock_paymenttermid'];


		} else {
			$data['byorder_label'] = $quotation_details['byorder_payment_label'];
			$data['byorder_text'] = $quotation_details['byorder_payment_text'];
			$data['exstock_label'] = $quotation_details['exstock_payment_label'];
			$data['exstock_text'] = $quotation_details['exstock_payment_text'];
		}

		if($quotation_details!=false){
			$data['is_enter_one_item'] = 1;
		} else {
			$data['is_enter_one_item'] = 0;
		}
		
		if($quotation_details["quotation_type"]!=3){
			$SQLxx = "SELECT quotation_id FROM furniture_items  where quotation_id='$quotation_id' And estimate_yes_or_no='No' ;";
			$psxx = $this->db->query($SQLxx);
			if($psxx->num_rows() > 0){
				$data['not_completed_bom']=1;
			}
			else{
				$data['not_completed_bom']=0;
			}
	    } else {
			$data['not_completed_bom']=0;
		}

		$list = $this->crud_model->get_list('logo_id','company_name','logos',array(""=>' - Select Logo - '));
		$data['logos_list'] = $list;
		
		$footer_list = $this->crud_model->get_list('footer_id','footer_name','footer',array('select'=>' - Select Footer - '));
		$data['footer_list'] = $footer_list;

		$data['quotation_logos'] = $quotation_details['quotation_logos'];
		$data['quotation_footer'] = $quotation_details['quotation_footer'];
		//$data['quotation_logos'] = '9';
		$data['covering_letter'] = $quotation_details['covering_letter'];
		
		$data['terms_and_conditions'] = $quotation_details['terms_and_conditions'];

		$data['quotation_status'] = $quotation_details['quotation_status'];

		$data['project_name'] = $quotation_details['project_name'];
		$data['project_location'] = $quotation_details['project_location'];

		$this->load->view('templates/header',$title);
		//$this->load->view('templates/header1');
		$this->load->view('furniture/quotations/payment_terms/payment_terms_view',$data);
		//$this->load->view('templates/footer');
		$this->load->view('templates/footer');

	}

	public function delete($id,$quotation_number,$division_id,$qutation_id){
		$this->db->where('id',$id);
		$this->db->delete('upload_files_print');
		$this->session->set_flashdata('response','File Deleted..');
		redirect('furniture/Furniture_payment_terms/index/'.$qutation_id.'');
	}
	



	public function do_update($quotation_id) {
		$this->users_model->permission("Quotation", "Edit");
		$this->form_validation->set_rules('quotation_status', 'Quotation.', 'required');
		//$this->form_validation->set_rules('covering_letter', 'Covering Letter', 'required');
		//$this->form_validation->set_rules('quotation_logos', 'Template Logo', 'required');
		

		if ($this->form_validation->run() == FALSE)	{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->index($quotation_id);
		} else {
			$where=array('id'	=> $quotation_id);

			$data_quo = array(
				'quotation_status'		=> $this->input->post('quotation_status'),
				'quotation_footer' => $this->input->post('footer_list'),
				'covering_letter' => str_replace('<p><br></p>', '', trim($this->input->post('covering_letter'))),
				'terms_and_conditions' => str_replace('<p><br></p>', '', trim($this->input->post('covering_letter2'))),
				'last_modified_by' => $this->session->userdata('user_id'),
				'last_modified_date' => date('Y-m-d h:m:s')
			);

			$rr_quo=$this->crud_model->update('furniture_quotation',$data_quo,$where);
			$this->session->set_flashdata('success','Quotation Status Updated successfully');
		
			
			$quote_res       = $this->db->query("SELECT * FROM `furniture_quotation` WHERE `id`='$quotation_id'");
			$quote_detls     = $quote_res->result_array();
			redirect('Manage_quotation/quotation/'.$quotation_id.'/'.$quote_detls[0]['quotation_divisionid'].'/'.$quote_detls[0]['quotation_number']);
		}
	}

	private function update_failed($quotation_id) {

		$quotation_id=$quotation_id;

		$where=array(
			'quotation_id' => $quotation_id
		);

		$data['quotation_id']=$quotation_id;

		$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');

		$data['quotation_number_full'] = $quotation_details['quotation_number_full'];
		$data['quotation_date'] = $quotation_details['quotation_date'];

		$data['salesman_name'] 	= $quotation_details['salesman_name'];

		$data['quotation_total'] = $quotation_details['quotation_total'];
		$data['discount_percentage'] = $quotation_details['discount_percentage'];

		$data['quotation_discount_amount'] = $quotation_details['quotation_discount_amount'];


		$data['quotation_net_total'] = $quotation_details['quotation_net_total'];
		$data['advance_percentage'] = $quotation_details['advance_percentage'];
		$data['advance_amount'] 	= $quotation_details['advance_amount'];

		if($this->session->userdata('user_group_id') == 1) {
			//Loading Exstock Payment Terms and ByOrder Payement terms from master table
			$list = $this->crud_model->get_list('payment_id','payment_label','furniture_byorder_paymentterm',array());
			$data['byorder_label'] = $list;

			$list = $this->crud_model->get_list('payment_id','payment_text','furniture_byorder_paymentterm',array());
			$data['byorder_text'] = $list;

			$list = $this->crud_model->get_list('payment_id','payment_label','furniture_exstock_paymentterm',array());
			$data['exstock_label'] = $list;

			$list = $this->crud_model->get_list('payment_id','payment_text','furniture_exstock_paymentterm',array());
			$data['exstock_text'] = $list;

		} else {
			$data['byorder_label'] = $quotation_details['byorder_payment_label'];
			$data['byorder_text'] = $quotation_details['byorder_payment_text'];
			$data['exstock_label'] = $quotation_details['exstock_payment_label'];
			$data['exstock_text'] = $quotation_details['exstock_payment_text'];
		}
			$data['project_name'] = $quotation_details['project_name'];
			
		$list = $this->crud_model->get_list('logo_id','company_name','logos',array(""=>' - Select Logo - '));
		$data['logos_list'] = $list;
		
		$list_footer = $this->crud_model->get_list('footer_id','footer_name','footer',array('select'=>' - Select Footer - '));
		$data['footer_list'] = $list_footer;
		
		$listnew = $this->crud_model->get_list('cl_template_id','cl_template_name','covering_letter_template',array(0=>' - Select - '));
		$data['covering_letter_template'] = $listnew;
		
		$list_terms = $this->crud_model->get_list('terms_id','terms_name','terms_and_conditions',array(0=>' - Select - '));
		$data['terms_and_condition'] = $list_terms;

		$data['quotation_status'] = $quotation_details['quotation_status'];


		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/payment_terms/payment_terms_view',$data);
		$this->load->view('templates/footer');

	}



	function do_update_quotation_status(){

		$this->form_validation->set_rules('esh_quotation_id', 'Quotation Id', 'required');
		$this->form_validation->set_rules('quotation_status', 'Quotation Status', 'required');

		/*if($this->input->post('quotation_status') == 'Closed'){
			$this->form_validation->set_rules('quotation_closed_reason', 'Reason for close', 'required');
		}*/
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response_status_update','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		} else {
			$esh_quotation_id=$this->input->post('esh_quotation_id');
			if($this->input->post('quotation_status') == 'Sales' || $this->input->post('quotation_status') == 'Estimator' || $this->input->post('quotation_status') == 'Approver'){
				$where = array('id'	=> $this->input->post('esh_quotation_id'));		
				$data_quo['status'] = $this->input->post('quotation_status');									
				$rr_quo = $this->crud_model->update('furniture_quotation',$data_quo,$where);
				redirect('furniture/furniture_quotations');
			} else if($this->input->post('quotation_status') == 'Confirmed'){

				// MAILING ....
				$client_contact_data = $this->db->query("SELECT * FROM `bom_h` BH WHERE BH.`quotation_id`='$esh_quotation_id'");
				
				//if(count($client_contact_data->result_array())>0){

				$res = $this->furniture_quotation_model->get_full_quotation_details($esh_quotation_id,'unique');
				$adv_required = $this->furniture_quotation_model->get_quotation_advance($esh_quotation_id);
				$this->db->select('*');
				$this->db->from('emails'); 
				$query = $this->db->get();
				$records=$query->result_array();
				if(@$records[0]['quote_confirmation']!=""){
				$quote_confirmation = $records[0]['quote_confirmation'];
				}else{
				$quote_confirmation = "";
				}

				$links =   site_url('manage_quotation/printQuotation/'.$res['quotation_id'].'/normal/without_image/0');
				/*	email notification start	*/
				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'Q-Pro Admin';
				$to 		= $quote_confirmation;
				$subject 	= 'Q-Pro - Furniture Quotation for '.$res['client_name'].'('.$res['quotation_number_full'].') is confirmed';
				if ($res['quotation_date']>'2019-07-01'){
					$html='<tr>
						<td>Vat Amount</td>
						<td>:</td>
						<td>'.$res['currency_code'].'. '.number_format( ($res['quotation_net_total']-$this->input->post('discount_bd'))*0.05,3).'</td>
					</tr>
					<tr>
						<td><b>Net Amount</b></td>
						<td>:</td>
						<td>'.$res['currency_code'].'. '.number_format( ($res['quotation_net_total']-$this->input->post('discount_bd'))+($res['quotation_net_total']-$this->input->post('discount_bd'))*0.05,3).'</td>
					</tr>';
				} else {
					$html='<tr>
						<td><b>Net Amount</b></td>
						<td>:</td>
						<td>'.$res['currency_code'].'. '.number_format( $res['quotation_net_total']-$this->input->post('discount_bd'),3).'</td>
					</tr>';
				}
				$message 	= '
				<table>
					<tr>
						<td>Quotation No.</td>
						<td>:</td>
						<td><a href='.$links.'>'.$res['quotation_number_full'].'</a></td>

					</tr>
					<tr>
						<td>Client</td>
						<td>:</td>
						<td>'.$res['client_name'].'</td>
					</tr>
					<tr>
						<td>Sales Person</td>
						<td>:</td>
						<td>'.$res['salesman_name'].'</td>
					</tr>
					<tr>
						<td>Quotation Total</td>
						<td>:</td>
						<td>'.$res['currency_code'].'. '.number_format( $res['quotation_total'],3).'</td>
					</tr>
					<tr>
						<td>Quotation Discount</td>
						<td>:</td>
						<td>'.$res['currency_code'].'. '.number_format( $res['quotation_discount_amount'],3).'</td>
					</tr>
					'.$html.'
					<tr>
						<td>Advance Amount</td>
						<td>:</td>
						<td>'.$res['currency_code'].'. '.number_format($res['advance_amount'],3).'</td>
					</tr>
				</table>';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);
				
				$this->tw_email->send($from,$fromname,$res['salesman_email_id'],$subject,$message);

				/*	email notification end		*/



				$data["quotation_cprid"] = 	$this->input->post('client_cpr_number');
				$data["quotation_status"] = $this->input->post('quotation_status');
				$data["quotation_confirmationdate"] = date('Y-m-d h:m:s');

			/*} else {
				$this->session->set_flashdata('response','<div class="alert alert-danger">Please Add BOM</div>');
								  redirect('manage_quotation/quotation/'.$esh_quotation_id.'/'.$this->input->post('quotation_divisionid').'/'.$this->input->post('quotation_number'));
                               
			}*/

			}else if(($this->input->post('quotation_status') == 'Draft') or ($this->input->post('quotation_status') == 'Open')){
				

				$where = array('id'	=> $esh_quotation_id);		/////<<<<<<<<<<<<<<<
				$data_quo['quotation_date'] = date('Y-m-d');									/////<<<<<<<<<<<<<<<
				$rr_quo = $this->crud_model->update('furniture_quotation',$data_quo,$where);	/////<<<<<<<<<<<<<<<

				$data["quotation_status"] = $this->input->post('quotation_status');
				$this->furniture_quotation_model->check_changes_cloned();


			}else if($this->input->post('quotation_status') == 'Closed'){

				$data["reason_forclose"] = 	$this->input->post('quotation_closed_reason');
				$data["quotation_status"] = $this->input->post('quotation_status');
			}


			$where=array('id'	=> $esh_quotation_id);

			$this->crud_model->update('furniture_quotation',$data,$where);

			$furniture_quotation_id=$esh_quotation_id;

			$this->session->unset_userdata('furniture_quotation_id');

			$qtn_dets =  $this->furniture_quotation_model->get_full_quotation_details($furniture_quotation_id,'unique');
			if($qtn_dets["division_id"] == QMS_GENERAL_QTN_DIV_ID) {
				$general_quotation = 1;
			}

			if($this->input->post('quotation_status') == 'Draft') {

                                if ($qtn_dets["division_id"] == QMS_GENERAL_QTN_DIV_ID)
                                {
                                  redirect('general/general_quotations/index');
                                }  elseif ($qtn_dets["division_id"] == QMS_WORKSHOP_QTN_DIV_ID) {
                                  redirect('workshop/workshop_quotations/index');
                                }
                                   else {
                                  redirect('furniture/furniture_quotations/index');
                                }

                                /*
                                if(isset($general_quotation)) {
					redirect('general/general_quotations/index');
				} else {
					redirect('furniture/furniture_quotations/index');
				} */
			} else {

				if ($qtn_dets["division_id"] == QMS_GENERAL_QTN_DIV_ID)
                                {
                                  redirect('general/general_quotations/index/1/1/'.$furniture_quotation_id);
                                }  elseif ($qtn_dets["division_id"] == QMS_WORKSHOP_QTN_DIV_ID) {
                                  redirect('workshop/workshop_quotations/index/1/1/'.$furniture_quotation_id);
                                }
                                   else {
								  //redirect('furniture/furniture_quotations/index/1/1/'.$furniture_quotation_id);
								  $this->session->unset_userdata('edit');
								  $this->session->set_flashdata('response','<div class="alert alert-success">Quotation Status Updated Successfully</div>');
								  redirect('manage_quotation/quotation/'.$furniture_quotation_id.'/'.$this->input->post('quotation_divisionid').'/'.$this->input->post('quotation_number'));
                                }
                                /*
                                if(isset($general_quotation)) {
					redirect('general/general_quotations/index/1/1/'.$furniture_quotation_id);
				} else {
					redirect('furniture/furniture_quotations/index/1/1/'.$furniture_quotation_id);
				} */
			}

		}

	}


	function discount_check($discount){
		if($discount < 0) {
			return false;
		}
		$rs = $this->crud_model->get('user_groups',array('user_group_id'=>$this->session->userdata('user_group_id')));
		if($rs != false){
			$discount_percentage_allowed = $rs[0]['discount_limit'];
			if($discount_percentage_allowed >= $discount){
				return TRUE;
			}
			else{
				$this->form_validation->set_message('discount_check', 'Allowed maximum discount percentage is '.$discount_percentage_allowed.'%%');
				return FALSE;
			}
		}
		else{
			return false;
		}
	}
	
	function do_close() {
		$this->session->unset_userdata('furniture_quotation_id');
		redirect('furniture/furniture_quotations/index');
	}
} 
?>