<?php
//require 'vendor2/autoload.php';
class Item_excel extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}

	function index($textfield2='NIL',$stock_group_id='NIL',$brand_id='NIL',$item_name='NIL',$page=1)	{
		$title['headerTitle']="Item List";
		$where=array();
		$like=array();
	
		if (@$this->input->post('textfield2')) {
			$textfield2 =   $this->input->post("textfield2");
		}elseif ($textfield2 != "NIL") {
			$textfield2	=	$textfield2;
		} else {
			$textfield2	= "NIL";
		}
		if (@$this->input->post('stock_group_id')) {
			$stock_group_id =   $this->input->post("stock_group_id");
		}elseif ($stock_group_id != "NIL") {
			$stock_group_id	=	$stock_group_id;
		} else {
			$stock_group_id	= "NIL";
		}
		if (@$this->input->post('brand_id')) {
			$brand_id =   $this->input->post("brand_id");
		}elseif ($brand_id != "NIL") {
			$brand_id	=	$brand_id;
		} else {
			$brand_id	= "NIL";
		}
		if (@$this->input->post('item_name')) {
			$item_name =   $this->input->post("item_name");
		}elseif ($item_name != "NIL") {
			$item_name	=	$item_name;
		} else {
			$item_name	= "NIL";
		}
		if($textfield2 != "NIL") {
			$where += array('main_category' => $textfield2);
		}
		if($stock_group_id != "NIL") {
			$where += array('stock_group_id' => $stock_group_id);
		}
		if($brand_id != "NIL") {
			$where += array('brand_id' => $brand_id);
		}
		if($item_name != "NIL") {
			$like = array('item_name'=>$item_name);
		}
		$config['base_url'] 	= site_url('masters/item/index/');
		if(isset($_POST["ttttt"])) {
			$config["total_rows"] = 10000000;
			$config["per_page"]   = 10000000000000;
		} else {
			$config['per_page']	  = 200;
			$config['total_rows'] = $this->crud_model->get_count('items',$where);
		}

		$offset = ($page-1) * $config['per_page'];
		$data['records'] = $this->crud_model->get('items',$where,$config['per_page'],$offset,'id','desc',$like);
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->load->view('templates/header',$title);
		$this->load->view('masters/item/list_item',$data);
		$this->load->view('templates/footer');
	}
	

	function validate_excel_file($excelFile) {
		if ($_FILES['excel_file']['error'] == 4) {
			$this->form_validation->set_message('validate_excel_file', 'Please select an Excel file.');
			return false;
		}
		return true;
	}


	function create() {
		$this->users_model->permission("ItemExcelImport", "Add");
		$title['headerTitle']="Item Excel Import";
		$list = $this->crud_model->get('main_category',array('status'=>'1'));
		$data['category_list'] = $list;

		$list2 = $this->crud_model->get('stock_group',array('status'=>'1'));
		$data['stock_group_list'] = $list2;

		$list3 = $this->crud_model->get('furniture_brands',array('status'=>'1'));
		$data['brand_list'] = $list3;

		$date=date("Y-m-d");
		$this->form_validation->set_rules('textfield2', 'Stock Category', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('stock_group_id', 'Vendor', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('brand_id', 'Catelog', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('unit_name', 'Unit', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('unit_id', 'Unit', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('vat_perc', 'Vat', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('excel_file', 'Excel File', 'callback_validate_excel_file');
		if ($this->form_validation->run() == FALSE) {
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item/item_excel',$data);
			$this->load->view('templates/footer');
		} else {
			$upload_status =  $this->uploadDoc();
			if($upload_status!=false)
			{
				require_once APPPATH . "/third_party/PHPExcel.php";
				$inputFileName = 'uploads/imports/'.$upload_status;
				/* $inputTileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($inputFileName);
				$reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputTileType);
				$spreadsheet = $reader->load($inputFileName);
				$sheet = $spreadsheet->getSheet(0); */

				$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
                    $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                    $objPHPExcel = $objReader->load($inputFileName);
                    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);

				$count_Rows = 0;
				$firstRow = true;
				foreach ($allDataInSheet as $value) {
					if ($firstRow) {
						$firstRow = false;
						continue; // Skip the first row
					}
					$item_name = $value['A'];
					$item_size = $value['B'];
					$item_packing = $value['C'];
					$cost_price = $value['D'];
					$selling_price = $value['E'];
					$reorder_level = $value['F'];
					/* $inserdata[$i]['first_name'] = $value['A'];
					$inserdata[$i]['last_name'] = $value['B'];
					$inserdata[$i]['email'] = $value['C'];
					$inserdata[$i]['contact_no'] = $value['D']; */


					if($this->input->post('is_purchase')==='1'){
						$is_purchase=1;
					} else {
						$is_purchase=0;
					}
					if($this->input->post('is_sales')==='1'){
						$is_sales=1;
					} else {
						$is_sales=0;
					}
					if($this->input->post('item_type')==='1'){
						$item_type=1;
					} else {
						$item_type=0;
					}
					if($item_name!=''){
						$result = $this->db->query("SELECT COUNT(item_name) AS items_count FROM items");
						$val = $result->result_array();
						$items_count = "IT00".($val[0]['items_count']+1);
						//$items_count = "IT0055";
						$data=array(
							'main_category' => $this->input->post('textfield2'),
							'sub_category' 	=> @$this->input->post('textfield3'),
							'item_name' 	=> $item_name,
							'item_size' 	=> $item_size,
							'stock_group_id'=> $this->input->post('stock_group_id'),
							'brand_id' 		=> $this->input->post('brand_id'),
							'item_code' 	=> $items_count,
							'description' 	=> '',
							'cost_price' 	=> $cost_price,
							'selling_price' => $selling_price,
							'vat_percentage'=> $this->input->post('vat_perc'),
							'unit_id' 		=> $this->input->post('unit_id'),
							'unit' 			=> $this->input->post('unit_name'),
							'item_packing' 	=> $item_packing,
							'reorder_level' => $reorder_level,
							'item_file_name'=> '',
							'is_purchase' 	=> $is_purchase,
							'is_sales' 		=> $is_sales,
							'item_type' 	=> $item_type
						);
						$rr=$this->crud_model->insert('items',$data);
					}
					$count_Rows++;
				}
				$this->session->set_flashdata('success','Successfully Data Imported');
				redirect('masters/Item_excel/create');
			}
			else
			{
				$this->session->set_flashdata('error','File is not uploaded');
				//redirect('masters/Item_excel/create');
			}
		}
	}

	/* 
	function create() {
		require_once APPPATH . "/third_party/PHPExcel.php";
		$title['headerTitle']="Item Excel Import";
		$list = $this->crud_model->get('main_category',array('status'=>'1'));
		$data['category_list'] = $list;

		$list2 = $this->crud_model->get('stock_group',array('status'=>'1'));
		$data['stock_group_list'] = $list2;

		$list3 = $this->crud_model->get('furniture_brands',array('status'=>'1'));
		$data['brand_list'] = $list3;

		$date=date("Y-m-d");
		$this->form_validation->set_rules('textfield2', 'Stock Category', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('stock_group_id', 'Vendor', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('brand_id', 'Catelog', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('unit_name', 'Unit', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('unit_id', 'Unit', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('vat_perc', 'Vat', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('excel_file', 'Excel File', 'callback_validate_excel_file');
		if ($this->form_validation->run() == FALSE) {
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item/item_excel',$data);
			$this->load->view('templates/footer');
		} else {
			$upload_status =  $this->uploadDoc();
			if($upload_status!=false)
			{
				$inputFileName = 'uploads/imports/'.$upload_status;
				$inputTileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($inputFileName);
				$reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputTileType);
				$spreadsheet = $reader->load($inputFileName);
				$sheet = $spreadsheet->getSheet(0);
				$count_Rows = 0;
				$firstRow = true;
				foreach($sheet->getRowIterator() as $row)
				{
					if ($firstRow) {
						$firstRow = false;
						continue; // Skip the first row
					}
					$item_name = $spreadsheet->getActiveSheet()->getCell('A'.$row->getRowIndex());
					$item_size = $spreadsheet->getActiveSheet()->getCell('B'.$row->getRowIndex());
					$item_packing = $spreadsheet->getActiveSheet()->getCell('C'.$row->getRowIndex());
					$cost_price = $spreadsheet->getActiveSheet()->getCell('D'.$row->getRowIndex());
					$selling_price = $spreadsheet->getActiveSheet()->getCell('E'.$row->getRowIndex());
					$reorder_level = $spreadsheet->getActiveSheet()->getCell('F'.$row->getRowIndex());


					if($this->input->post('is_purchase')==='1'){
						$is_purchase=1;
					} else {
						$is_purchase=0;
					}
					if($this->input->post('is_sales')==='1'){
						$is_sales=1;
					} else {
						$is_sales=0;
					}
					if($this->input->post('item_type')==='1'){
						$item_type=1;
					} else {
						$item_type=0;
					}
					if($item_name!=''){
						$result = $this->db->query("SELECT COUNT(item_name) AS items_count FROM items");
						$val = $result->result_array();
						$items_count = "IT00".$val[0]['items_count'];
						//$items_count = "IT0055";
						$data=array(
							'main_category' => $this->input->post('textfield2'),
							'sub_category' 	=> @$this->input->post('textfield3'),
							'item_name' 	=> $item_name,
							'item_size' 	=> $item_size,
							'stock_group_id'=> $this->input->post('stock_group_id'),
							'brand_id' 		=> $this->input->post('brand_id'),
							'item_code' 	=> $items_count,
							'description' 	=> '',
							'cost_price' 	=> $cost_price,
							'selling_price' => $selling_price,
							'vat_percentage'=> $this->input->post('vat_perc'),
							'unit_id' 		=> $this->input->post('unit_id'),
							'unit' 			=> $this->input->post('unit_name'),
							'item_packing' 	=> $item_packing,
							'reorder_level' => $reorder_level,
							'item_file_name'=> '',
							'is_purchase' 	=> $is_purchase,
							'is_sales' 		=> $is_sales,
							'item_type' 	=> $item_type
						);
						$rr=$this->crud_model->insert('items',$data);
					}
					$count_Rows++;
				}
				$this->session->set_flashdata('success','Successfully Data Imported');
				redirect('masters/Item_excel/create');
			}
			else
			{
				$this->session->set_flashdata('error','File is not uploaded');
				redirect('masters/Item_excel/create');
			}
		}
	} */


	function uploadDoc()
	{
		$uploadPath = 'uploads/imports/';

		$files = glob($uploadPath . '*'); // Get all file paths in the folder
		foreach ($files as $file) {
			if (is_file($file)) {
				unlink($file); // Delete the file
			}
		}

		if(!is_dir($uploadPath))
		{
			mkdir($uploadPath,0777,TRUE); 
		}

		$config['upload_path']=$uploadPath;
		$config['allowed_types'] = 'csv|xlsx|xls';
		$config['max_size'] = 1000000;
		$this->load->library('upload',$config);
		$this->upload->initialize($config);
		if($this->upload->do_upload('excel_file'))
		{
			$fileData = $this->upload->data();
			return $fileData['file_name'];
		}
		else
		{
			return false;
		}
	}

	public function search_main_category() {
		$main_category	=	$this->input->post('main_category');
		$today	=	date("Y-m-d");
		$html	='';
		$main_category_data = $this->db->query("SELECT * FROM `main_category` where status='1' and  `category_name` like '%$main_category%' order by category_name");
		$n=1;
		$html='<li style="color:red;" class="no_result_button" ><a target="_blank" href='.site_url('masters/Category/create').'>Add a New Stock Category</a></li>';
		if(count($main_category_data->result_array())>0){
			foreach ($main_category_data->result_array() as $main_category_datas){
				$html.='<li value="' .$main_category_datas['id'].'" class="main_category_button" tabindex="'.$n++.'" ><input type="hidden" class="category_name" value="'.$main_category_datas['category_name'].'" />'.$main_category_datas['category_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_stock_group() {
		$stock_group_name	=	$this->input->post('stock_group_name');
		$today	=	date("Y-m-d");
		$html	='';
		$stock_group_data = $this->db->query("SELECT * FROM `stock_group` where status='1' and  `stock_group_name` like '%$stock_group_name%' order by stock_group_name");
		$n=1;
		$html='<li style="color:red;" class="no_result_button" ><a target="_blank" href='.site_url('masters/Group/create').'>Add a New Stock Group</a></li>';
		if(count($stock_group_data->result_array())>0){
			foreach ($stock_group_data->result_array() as $stock_group_datas){
				$html.='<li value="' .$stock_group_datas['id'].'" class="stock_group_name_button" tabindex="'.$n++.'" ><input type="hidden" class="stock_group_name" value="'.$stock_group_datas['stock_group_name'].'" />'.$stock_group_datas['stock_group_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_brand() {
		$brand_name	=	$this->input->post('brand_name');
		$today	=	date("Y-m-d");
		$html	='';
		$brand_data = $this->db->query("SELECT * FROM `furniture_brands` where status='1' and `brand_name` like '%$brand_name%' order by brand_name");
		$n=1;
		$html='<li style="color:red;" class="no_result_button" ><a target="_blank" href='.site_url('masters/Brand/create').'>Add a New Brand</a></li>';
		if(count($brand_data->result_array())>0){
			foreach ($brand_data->result_array() as $brand_datas){
				$html.='<li value="' .$brand_datas['brand_id'].'" class="brand_button" tabindex="'.$n++.'" ><input type="hidden" class="brand_name" value="'.$brand_datas['brand_name'].'" />'.$brand_datas['brand_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_unit() {
		$unit_name	=	$this->input->post('unit_name');
		$today	=	date("Y-m-d");
		$html	='';
		$unit_data = $this->db->query("SELECT * FROM `unit_master` where status='1' and `unit_name` like '%$unit_name%' order by unit_name");
		$n=1;
		if(count($unit_data->result_array())>0){
			$html='';
			foreach ($unit_data->result_array() as $unit_datas){
				$html.='<li value="' .$unit_datas['unit_id'].'" class="unit_button" tabindex="'.$n++.'" ><input type="hidden" class="unit_name" value="'.$unit_datas['unit_name'].'" />'.$unit_datas['unit_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}
	
	function edit($id) {
		$title['headerTitle']="Item Edit";
		$where=array(
				'id' => $id
		);
		$records=$this->crud_model->get('items',$where);
		if($records != false){
			//true section
			$data['item_id']			= $records[0]['id'];
			$data['main_category']		= $records[0]['main_category'];
			$data['stock_group_id']		= $records[0]['stock_group_id'];
			$data['brand_id']			= $records[0]['brand_id'];
			$data['vat_percentage']		= $records[0]['vat_percentage'];
			$data['item_packing']		= $records[0]['item_packing'];
			$data['sub_category']		= $records[0]['sub_category'];
			$data['item_name']			= $records[0]['item_name'];
			$data['item_code']			= $records[0]['item_code'];
			$data['description']		= html_entity_decode(stripslashes($records[0]['description']));
			$data['cost_price']			= $records[0]['cost_price'];
			$data['selling_price']		= $records[0]['selling_price'];
			$data['unit']				= $records[0]['unit'];
			$data['unit_id']			= $records[0]['unit_id'];
			$data['item_file_name']		= $records[0]['item_file_name'];
			$data['is_purchase']		= $records[0]['is_purchase'];
			$data['is_sales']			= $records[0]['is_sales'];
			$data['item_type']			= $records[0]['item_type'];
			$data['reorder_level']		= $records[0]['reorder_level'];
			$data['status']				= $records[0]['status'];
			
			$list = $this->crud_model->get('main_category',array('status'=>'1'));
			$data['category_list'] = $list;

			$list2 = $this->crud_model->get('stock_group',array('status'=>'1'));
			$data['stock_group_list'] = $list2;

			$list3 = $this->crud_model->get('furniture_brands',array('status'=>'1'));
			$data['brand_list'] = $list3;
			
			$date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);

			$data['user_status'] = $this->config->item('user_status_array');

			$this->db->select('*');
			$this->db->from('item_specifications');
			$this->db->where('item_id', $id); 
			$up_data = $this->db->get();
			if($up_data->num_rows() > 0){
				$data['rec_file'] = $up_data->result_array();
			}
			else{
				$data['rec_file'] = array();
			}

			$where2=array(
				'status' => 1
			);
			$nb=$this->crud_model->get('location_master',$where2);
			$data['location_list'] = $nb;

			$unit_list = $this->crud_model->get_list('unit_id','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;
		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item/edit_item',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/item');
		}
	}
	function do_insert() {
		$title['headerTitle']="Item Create";
		//$currency_code = ascii_to_entities($this->input->post('currency_code'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('item_name', 'Item Name', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('item_code', 'Item Code', 'required');
		//$this->form_validation->set_rules('selling_price', 'Selling Price', 'required');
		$this->form_validation->set_rules('unit_id', 'Unit', 'required');
		
		$result = $this->db->query("SELECT COUNT(item_name) AS items_count FROM items");
		$val = $result->result_array();
		$data['items_count'] = "IT00".($val[0]['items_count']+1);
		//$this->form_validation->set_rules('currency_code', 'Currency Code', 'required|max_length[10]');
		if($_FILES["logo_image"]["name"]!=""){
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			} /*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/items";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		$this->load->library('upload', $config);
	
		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = @$up_data["upload_data"]["file_name"];
		}

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$list = $this->crud_model->get('main_category',array('status'=>'1'));
			$data['category_list'] = $list;

			$list2 = $this->crud_model->get('stock_group',array('status'=>'1'));
			$data['stock_group_list'] = $list2;

			$list3 = $this->crud_model->get('furniture_brands',array('status'=>'1'));
			$data['brand_list'] = $list3;

			$date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item/create_item',$data);
			$this->load->view('templates/footer');
		}elseif($file_error) {
			$this->session->set_flashdata('response',"Allowed File Types : jpeg, jpg, png, gif",':old:');
			$list = $this->crud_model->get('main_category',array('status'=>'1'));
			$data['category_list'] = $list;
			
			$list2 = $this->crud_model->get('stock_group',array('status'=>'1'));
			$data['stock_group_list'] = $list2;
			
			$list3 = $this->crud_model->get('furniture_brands',array('status'=>'1'));
			$data['brand_list'] = $list3;

			$date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item/create_item',$data);
			$this->load->view('templates/footer');			
			
		} else {	// true section
			if($this->input->post('is_purchase')==='1'){
				$is_purchase=1;
			} else {
				$is_purchase=0;
			}
			if($this->input->post('is_sales')==='1'){
				$is_sales=1;
			} else {
				$is_sales=0;
			}
			if($this->input->post('item_type')==='1'){
				$item_type=1;
			} else {
				$item_type=0;
			}

			$data=array(
				'main_category' => $this->input->post('textfield2'),
				'sub_category' 	=> @$this->input->post('textfield3'),
				'item_name' 	=> $this->input->post('item_name'),
				'stock_group_id'=> $this->input->post('stock_group_id'),
				'brand_id' 		=> $this->input->post('brand_id'),
				'item_code' 	=> $this->input->post('item_code'),
				'description' 	=> $this->input->post('description'),
				'cost_price' 	=> $this->input->post('cost_price'),
				'selling_price' => $this->input->post('selling_price'),
				'vat_percentage'=> $this->input->post('vat_perc'),
				'unit_id' 		=> $this->input->post('unit_id'),
				'unit' 			=> $this->input->post('unit_name'),
				'item_packing' 	=> $this->input->post('item_packing'),
				'reorder_level' => $this->input->post('reorder_level'),
				'item_file_name'=> $filename,
				'is_purchase' 	=> $is_purchase,
				'is_sales' 		=> $is_sales,
				'item_type' 	=> $item_type
			);

			$rr=$this->crud_model->insert('items',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Excel',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			
			$count_location=$this->input->post('count_location');
			$user_id=$this->session->userdata('user_id');
			for($i=0;$i<$count_location;$i++){
				if( $this->input->post('loc_id'.$i)!='' &&  $this->input->post('location_qty'.$i)!='' &&  $this->input->post('location_rate'.$i)!=''){
					$loc_data=array(
						'trans_no' 	   => 0,
						'trans_date'   => date("Y-m-d"),
						'trans_type'   => 0,
						'item_id'      => $insert_id,
						'loc_id'       => $this->input->post('loc_id'.$i),
						'item_qty' 	   => $this->input->post('location_qty'.$i),
						'item_rate'    => $this->input->post('location_rate'.$i),
						'item_amount'  => $this->input->post('location_qty'.$i)*$this->input->post('location_rate'.$i),
						'created_date' => date("Y-m-d"),
						'user_id'      => $user_id
					);
					$this->crud_model->insert('item_trans',$loc_data);
				}
			}
			
			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Item cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/item');
				$this->load->view('templates/footer');
			} else {
				// redirect
				if($_REQUEST["xcount"]>0){
					$this->load->helper('form');
					$query = $this->db->query("SELECT MAX(`id`) AS `MAXID` FROM `items`");
					$row = $query->row();
					$uniqueID = $row->MAXID;
					if(!file_exists("item_specifications/".$uniqueID))
						mkdir("item_specifications/".$uniqueID);
						$config['upload_path'] = 'item_specifications/'.$uniqueID;
						$config['allowed_types'] = '*';
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
						$this->upload->set_allowed_types('*');
						for($j=1; $j <= $_REQUEST["xcount"]; $j++) { 
							if($_FILES["fileField".$j]["name"]){
								$this->upload->do_upload("fileField".$j);
								$newdata = array('item_id'=>$row->MAXID,'specification'=>str_replace(" ","_",$_FILES["fileField".$j]["name"]));
								$add_file = $this->db->insert('item_specifications', $newdata); 
							}
						}
				}
				$this->session->set_flashdata('success','Item added successfully');
				redirect('masters/item');
			}
		}
	}

	function do_update() {
		
		$title['headerTitle']="Item Edit";
		//$currency_code = ascii_to_entities($this->input->post('currency_code'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('item_name', 'Item Name', 'required|max_length[100]');
		$this->form_validation->set_rules('item_code', 'Item Code', 'required');
		//$this->form_validation->set_rules('selling_price', 'Selling Price', 'required');
		$this->form_validation->set_rules('unit_id', 'Unit', 'required');
		
		if($_FILES["logo_image"]["name"]!=""){
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			}/*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/items";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		$this->load->library('upload', $config);
		
		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = $up_data["upload_data"]["file_name"];
		}else{
			$filename = $this->input->post('image_item');
		}

		if ($this->form_validation->run() == FALSE) {
			// false section
			$item_id = $this->input->post('item_id');
			$where=array("id"=>$item_id);
					
			$records=$this->crud_model->get('items', $where);
			if($records != false){
				//true section
				$data['item_id']			= $records[0]['id'];
				$data['main_category']		= $records[0]['main_category'];
				$data['stock_group_id']		= $records[0]['stock_group_id'];
				$data['brand_id']			= $records[0]['brand_id'];
				$data['vat_percentage']		= $records[0]['vat_percentage'];
				$data['item_packing']		= $records[0]['item_packing'];
				$data['sub_category']		= $records[0]['sub_category'];
				$data['item_name']			= $records[0]['item_name'];
				$data['item_code']			= $records[0]['item_code'];
				$data['description']		= html_entity_decode(stripslashes($records[0]['description']));
				$data['cost_price']			= $records[0]['cost_price'];
				$data['selling_price']		= $records[0]['selling_price'];
				$data['unit']				= $records[0]['unit_name'];
				$data['unit_id']			= $records[0]['unit_id'];
				$data['item_file_name']		= $records[0]['item_file_name'];
				$data['is_purchase']		= $records[0]['is_purchase'];
				$data['is_sales']			= $records[0]['is_sales'];
				$data['item_type']			= $records[0]['item_type'];
				$data['reorder_level']		= $records[0]['reorder_level'];
				$data['status']				= $records[0]['status'];
				
				$list = $this->crud_model->get('main_category',array('status'=>'1'));
				$data['category_list'] = $list;

				$list2 = $this->crud_model->get('stock_group',array('status'=>'1'));
				$data['stock_group_list'] = $list2;

				$list3 = $this->crud_model->get('furniture_brands',array('status'=>'1'));
				$data['brand_list'] = $list3;
				
				$date=date("Y-m-d");
				$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);

				$data['user_status'] = $this->config->item('user_status_array');
				
				$this->db->select('*');
				$this->db->from('item_specifications');
				$this->db->where('item_id', $this->input->post('item_id')); 
				$up_data = $this->db->get();
				if($up_data->num_rows() > 0){
					$data['rec_file'] = $up_data->result_array();
				}
				else{
					$data['rec_file'] = array();
				}
				$where2=array(
					'status' => 1
				);
				$nb=$this->crud_model->get('location_master',$where2);
				$data['location_list'] = $nb;
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/item/edit_item',$data);
				$this->load->view('templates/footer');

			} else {
				//false section
				$this->session->set_flashdata('response','error');
				redirect('masters/item');
			}
		} else { // true section

			$where=array(
				'id'  => $this->input->post('item_id')
			);
			if($this->input->post('is_purchase')==='1'){
				$is_purchase=1;
			} else {
				$is_purchase=0;
			}
			if($this->input->post('is_sales')==='1'){
				$is_sales=1;
			} else {
				$is_sales=0;
			}
			if($this->input->post('item_type')==='1'){
				$item_type=1;
			} else {
				$item_type=0;
			}

			$data=array(
				'main_category' => $this->input->post('textfield2'),
				'sub_category' 	=> @$this->input->post('textfield3'),
				'item_name' 	=> $this->input->post('item_name'),
				'stock_group_id'=> $this->input->post('stock_group_id'),
				'brand_id' 		=> $this->input->post('brand_id'),
				'description' 	=> $this->input->post('description'),
				'cost_price' 	=> $this->input->post('cost_price'),
				'selling_price' => $this->input->post('selling_price'),
				'vat_percentage'=> $this->input->post('vat_perc'),
				'unit_id' 		=> $this->input->post('unit_id'),
				'unit' 			=> $this->input->post('unit_name'),
				'item_packing' 	=> $this->input->post('item_packing'),
				'reorder_level' => $this->input->post('reorder_level'),
				'status' 		=> $this->input->post('status'),
				'item_file_name'=> $filename,
				'is_purchase' 	=> $is_purchase,
				'is_sales' 		=> $is_sales,
				'item_type' 	=> $item_type
			);

				$records=$this->crud_model->update('items',$data,$where);
				$insert_id = $this->input->post('item_id');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Inventory Item',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);



				$count_location=$this->input->post('count_location');
				$user_id=$this->session->userdata('user_id');
				for($i=0;$i<$count_location;$i++){
					if( $this->input->post('loc_id'.$i)!='' &&  $this->input->post('location_qty'.$i)!='' &&  $this->input->post('location_rate'.$i)!=''){
						if($this->input->post('item_trans_id'.$i)!=''){
							$loc_data=array(
								'item_qty' => $this->input->post('location_qty'.$i),
								'item_rate' => $this->input->post('location_rate'.$i),
								'item_amount' => $this->input->post('location_qty'.$i)*$this->input->post('location_rate'.$i)
							);
							$where3=array(
								'item_id'  => $this->input->post('item_id'),
								'loc_id'  => $this->input->post('loc_id'.$i)
							);
							$this->crud_model->update('item_trans',$loc_data,$where3);
						} else {
							$loc_data=array(
								'trans_no' => 0,
								'trans_date'   => date("Y-m-d"),
								'trans_type'   => 0,
								'item_id'      => $insert_id,
								'loc_id'       => $this->input->post('loc_id'.$i),
								'item_qty'     => $this->input->post('location_qty'.$i),
								'item_rate'    => $this->input->post('location_rate'.$i),
								'item_amount'  => $this->input->post('location_qty'.$i)*$this->input->post('location_rate'.$i),
								'created_date' => date("Y-m-d"),
								'user_id'      => $user_id
							);
							$this->crud_model->insert('item_trans',$loc_data);
						}
					}
				}
			
			if($_REQUEST["xcount"]>0){
					$this->load->helper('form');
					$query = $this->db->query("SELECT MAX(`id`) AS `MAXID` FROM `items`");
					$row = $query->row();
					$uniqueID = $this->input->post('item_id');
					if(!file_exists("item_specifications/".$uniqueID))
						mkdir("item_specifications/".$uniqueID);
						$config['upload_path'] = 'item_specifications/'.$uniqueID;
						$config['allowed_types'] = '*';
						$this->load->library('upload', $config);
						$this->upload->initialize($config);
						$this->upload->set_allowed_types('*');
						for($j=1; $j <= $_REQUEST["xcount"]; $j++) { 
							if($_FILES["fileField".$j]["name"]){
								$this->upload->do_upload("fileField".$j);
								$newdata = array('item_id'=>$uniqueID,'specification'=>str_replace(" ","_",$_FILES["fileField".$j]["name"]));
								$add_file = $this->db->insert('item_specifications', $newdata); 
							}
						}
				}

			$this->session->set_flashdata('success','Item updated');
			redirect('masters/item');

		}
	}
	function do_delete($id=0) {

		$where2=array(
			'item_id'=> $id
		);
		
		$records=$this->crud_model->get('furniture_items', $where2);
		
		if(!$records) {
			$where=array(
				'id'=> $id
			);
			$records=$this->crud_model->get('items',$where);
			$filename = $records[0]["item_file_name"];
			if($filename!=""){
			unlink(FCPATH."images/items/".$filename);
			}
			$this->crud_model->delete('items',$where);
			$this->session->set_flashdata('response','Item deleted');
			redirect('masters/item');
		} else {
			$this->session->set_flashdata('response','Sorry. You cannot delete a Item that is used in the existing quotations.');
			redirect('masters/item');
		}
	}
	function sub_category() {
		$sub_category_name =  $this->input->post('sub_category');
		$list = $this->crud_model->get_list('sub_id','sub_category_name','sub_category',array('select'=>' - Select - '),array('main_category'=>$sub_category_name));
		$js = 'id="textfield3", class="form-control" style="height: 42px;"';
		$output = form_dropdown('textfield3', $list,'',$js);
    	echo $output;
	}
	function delete_item_specification($id=0,$item_id=0) {
		$where=array(
			'id'=> $id
		);
		$records=$this->crud_model->get('item_specifications',$where);
		$filename = $records[0]["specification"];
		$fileid   = $records[0]["item_id"];
		unlink(FCPATH."item_specifications/".$fileid."/".$filename);
		$success = $this->crud_model->delete('item_specifications',$where);
			
		$where_item=array(
			'id' => $item_id
		);
		$records=$this->crud_model->get('items',$where_item);
		if($records != false){
			//true section
			$data['item_id']		= $records[0]['id'];
			$data['main_category']	= $records[0]['main_category'];
			$data['sub_category']	= $records[0]['sub_category'];
			$data['item_name']		= $records[0]['item_name'];
			$data['item_code']		= $records[0]['item_code'];
			$data['description']	= $records[0]['description'];
			$data['cost_price']		= $records[0]['cost_price'];
			$data['selling_price']	= $records[0]['selling_price'];
			$data['unit']			= $records[0]['unit'];
			$data['item_file_name']	= $records[0]['item_file_name'];
			
			$list = $this->crud_model->get_list('id','category_name','main_category',array('select'=>' - Select - '));
			$data['category_list'] = $list;
			
			$sub_list = $this->crud_model->get_list('sub_id','sub_category_name','sub_category',array('select'=>' - Select - '),array('main_category'=>$data['main_category']));
			$data['sub_category_list'] = $sub_list;
			
			
			$this->db->select('*');
			$this->db->from('item_specifications');
			$this->db->where('item_id', $id); 
			$up_data = $this->db->get();
			if($up_data->num_rows() > 0) {
				$data['rec_file'] = $up_data->result_array();
			} else {
				$data['rec_file'] = array();
			}
			 
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Excel',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('response','Item Specification deleted');
			redirect('masters/item/edit/'.$item_id);
		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/item');
		}
		/*} else {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry. You cannot delete a division that is used in the existing quotations.</div>');
			redirect('masters/company_division');
		}*/
	}
	public function search_item($page=1) {
			$where=array();
			$or_like=array();
			if($this->input->post('filter_division') != "-1") {
			$where=array('main_category'=> $this->input->post('filter_division'));
			}
			if($this->input->post('filter_division1') != "-1") {
			$where=array('sub_category'=> $this->input->post('filter_division1'));
			}
			if($this->input->post('filter_value') != "") {
			$or_like = array('item_name'=>$this->input->post('filter_value'),
							'item_code'=>$this->input->post('filter_value'));
			}
			$config['per_page']		= 25;
			$config['base_url'] 	= site_url('masters/item/index/');
			$config['total_rows'] 	= $this->crud_model->get_count('items',array());
	
			$offset = ($page-1) * $config['per_page'];
			$data['records'] = $this->crud_model->get('items', $where,$config['per_page'],$offset, null, null, null, null, $or_like);
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			
			$list = $this->crud_model->get_list('id','category_name','main_category',array('-1'=>' - Main Categories - '));
			$data['main_category_list'] = $list;
			$list = $this->crud_model->get_list('sub_id','sub_category_name','sub_category',array('-1'=>' - Sub Categories - '));
			$data['sub_category_list'] = $list;
		    $this->load->view('templates/header');
			$this->load->view('masters/item/list_item',$data);
			$this->load->view('templates/footer');
	}
}