<?php
class Make extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("Make", "View");
		$title['headerTitle']="Vehicle Make";
		$data['make']  = $this->Vehicle->getMake();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/vehicle_make',$data);
		$this->load->view('templates/footer');

	}
	public function create(){
		$this->users_model->permission("Make", "Add");
		$this->form_validation->set_rules('title', 'Title', 'required');
		if ($this->form_validation->run() == FALSE) {
			return $this->index();
		}
		else{
			$data = array(
				'code' => $this->input->post('title'),
				'title' => $this->input->post('title'),
				'type' => 1
			);
			$res = $this->Vehicle->save($data);
			if($res){
				$insert_id = $this->db->insert_id();
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'Make',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'create',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Make Added Successfully');
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
			}
			
			redirect('masters/make');
		}
	}
	public function edit(){		
		$this->users_model->permission("Make", "Edit");
		$this->form_validation->set_rules('updatetitle', 'Title', 'required');
		if ($this->form_validation->run() == FALSE) {
			redirect('masters/make');
		}
		else{
			$data = array(
				'code'  => $this->input->post('updatetitle'),
				'title' => $this->input->post('updatetitle'),
				'type'  => 1
			);
			$res = $this->Vehicle->Updatemake($data);
			if($res){
				    $insert_id = $this->input->post('updatetitle');
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'Make',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'update',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Make Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/make');
		}
	}
}