<?php
class Vocher_ledger extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}

	function mapping() {
		$this->users_model->permission("Vocher_ledger", "View");
		$title['headerTitle']="Voucher Ledger Mapping";
		$this->form_validation->set_rules('name[]', 'Name', 'required');
		if ($this->form_validation->run() == FALSE) {
			// false section
			//$where=array("emp_category_id"=>$emp_category_id);
			$data['records']=$this->crud_model->get('voucher_ledger_mapping');
				//true section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/voucher_ledger/edit',$data);
			$this->load->view('templates/footer');
		} else {// true section
			$name=$this->input->post('name');
			
			for($i=0;$i<count($name);$i++){
				$allt	=	$name[$i];
				$array_of_words =	explode(':nb:',$allt);

				$id	=	$array_of_words[0];
				$ledger_code	=	$array_of_words[1];

				$where = array('id' => $id);
				$udata = array('ledger_code' =>  $ledger_code);
				$invupdate = $this->crud_model->update('voucher_ledger_mapping',$udata,$where);
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Voucher Lledger Mapping',	
					'masters_id'=>$id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);

				//echo $complaint_master_id.','.$complaint_master_name.'<br>';
			}
			/*$where=array(
				'emp_category_id'  => $emp_category_id
			);
			$data=array(
				'emp_category_name' => $name,
				'status' => $status
			);
			$records=$this->crud_model->update('emp_category',$data,$where);
			$this->session->set_flashdata('success','Employee Category updated');
			redirect('masters/EmpCategory');*/
		}
	}

	function index($page=1)	{
		$title['headerTitle']	= "Employee Category List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/EmpCategory/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('emp_category',array());
		$offset = ($page-1) * $config['per_page'];
		$data['records'] = $this->crud_model->get('emp_category',array(),$config['per_page'],$offset);
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/emp_category/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$title['headerTitle']="Employee Category Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/emp_category/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$title['headerTitle']="Employee Category Edit";
		$where=array(
			'emp_category_id' => $id
		);
		$records=$this->crud_model->get('emp_category',$where);
		if($records != false){
			//true section
			$data['emp_category_name']	= $records[0]['emp_category_name'];
			$data['emp_category_id']	= $records[0]['emp_category_id'];
			$data['status']				= $records[0]['status'];
			$data['user_status'] 		= $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/emp_category/edit',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/EmpCategory');
		}
	}
	
	function do_insert() {
		$title['headerTitle']="Employee Category Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/emp_category/create');
			$this->load->view('templates/footer');
		} else {	// true section
			$name=$this->input->post('name');
			$data=array(
				'emp_category_name' => $name
			);
			$rr=$this->crud_model->insert('emp_category',$data);

			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Employee Category cannot be inserted',':old:');
				$redirect('masters/EmpCategory');
			} else {
				// redirect
				$this->session->set_flashdata('success','Employee Category added successfully');
				redirect('masters/EmpCategory');
			}
		}
	}

	function do_update() {
		$title['headerTitle']="Employee Category Edit";
		$emp_category_id = ascii_to_entities($this->input->post('emp_category_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("emp_category_id"=>$emp_category_id);
			$records=$this->crud_model->get('department_master', $where);
			if($records != false){
				//true section
				$data['emp_category_name']	= $records[0]['emp_category_name'];
				$data['emp_category_id']	= $records[0]['emp_category_id'];
				$data['status']				= $records[0]['status'];
				$data['user_status'] 		= $this->config->item('user_status_array');

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/emp_category/edit',$data);
				$this->load->view('templates/footer');
			} 
		} else {// true section
			$name=$this->input->post('name');
			$where=array(
				'emp_category_id'  => $emp_category_id
			);
			$data=array(
				'emp_category_name' => $name,
				'status' => $status
			);
			$records=$this->crud_model->update('emp_category',$data,$where);
			$this->session->set_flashdata('success','Employee Category updated');
			redirect('masters/EmpCategory');
		}
	}
	function do_delete($department_id=0) {

		$where=array(
			'emp_category_id'  => $emp_category_id
		);
		$data=array('status' => 0);
		$records=$this->crud_model->update('emp_category',$data,$where);

		$this->session->set_flashdata('success','Employee Category deleted');
		redirect('masters/EmpCategory');
	}
}