<?php
class Quotation_Model extends CI_Model {

	function __construct()
	{
		// Call the Model constructor
		parent::__construct();
	}

	function set_quotation_id()
	{
		$quotation_number = $this->get_new_quotation_number();
		$da=array(
				'quotation_date' =>date('Y-m-d h:m:s'),
				'salesman_id'    =>$this->session->userdata('user_id'),
				'quotation_number' => $quotation_number
		);
		$quotation_id = $this->crud_model->insert('quotations',$da);
		$this->session->set_userdata('quotation_id',$quotation_id);
	}
	
	
	function get_quotation_kitchen_list($where = array()){
		$rs = $this->db->get_where('view_quotation_kitchen_with_kitchen_brands_and_kitchen_areas',$where);
		$init_list = array(0 => '-- Select Kitchen --');
		if($rs->num_rows() > 0)
		{
			$rows = $rs->result_array();
			$i=1;
			foreach($rows as $row){
				$init_list[$row['quotation_kitchen_id']] = $row['kitchen_area_name'] .' / '. $row['drawing_number'];//'Kitchen/Pantry #'.$i;
				$i++;
			}
			return $init_list;
		}
		else{
			return $init_list;
		}
	}
	
	function get_full_quotation_details($quotation_id = 0,$revisions = 'unique'){

		$data['quotation_id']  = $quotation_id;
		$where=array(
			'quotation_id' => $quotation_id
		);
		
		
		//Quotation Details
		if($revisions == 'unique'){
			$rs=$this->crud_model->get('view_quotations_client_project_users',$where);
		}
		else{
			$rs=$this->crud_model->get('view_quotations_client_project_users_all',$where);
		}
		if($rs!=false)
		{
			$data=$rs[0];
			$data['quotation_total'] = 0;
			
			
			$wh=array(
				'user_id' => $data['salesman_id']
			);
			$records=$this->crud_model->get('users',$wh);
			if($records != false){
			//true section
				$data['salesman_name']= $records[0]['user_name'];
			} 

			//Kitchen Details
			$data['kitchens'] = array();
			$rs_kitchens = $this->crud_model->get('view_qkitchen_with_kbrands_kareas_quotation',$where);
			if($rs_kitchens != false)
			{
				foreach($rs_kitchens as $row)
				{
					$kitchen_total = 0;
					$data['kitchens'][$row['quotation_kitchen_id']] = $row;

					$kitchen_total += $row['kitchen_quantity'] * $row['kitchen_price'];

					//Worktop Details of kitchen
					$where2 = array(
								'quotation_kitchen_id' 	=> $row['quotation_kitchen_id'],
								'quotation_id'			=> $quotation_id
					);
					$rs_worktops_of_kitchen 	= $this->crud_model->get('view_qworktop_qkitchen_kbrands_wbrands_wfinish_wmodel_wept',$where2);

					if($rs_worktops_of_kitchen != false)
					{
						foreach($rs_worktops_of_kitchen as $row2)
						{
							$data['kitchens'][$row['quotation_kitchen_id']]['worktops_of_kitchen'][] = $row2;
							$kitchen_total += (($row2['worktop_lm']*$row2['worktop_price_per_lm']*$row2['worktop_quantity']) + ($row2['worktop_lm']*$row2['worktop_ep_price']*$row2['worktop_quantity']));
						}
					}
					else {
						$data['kitchens'][$row['quotation_kitchen_id']]['worktops_of_kitchen'] = array();
					}

					//Appliance Details of kitchen
					$where4 = array(
								'quotation_kitchen_id' 	=> $row['quotation_kitchen_id'],
								'quotation_id'			=> $quotation_id
					);
					$rs_appliances_of_kitchen 	= $this->crud_model->get('view_quotation_qappliance',$where4);

					if($rs_appliances_of_kitchen != false)
					{
						foreach($rs_appliances_of_kitchen as $row4)
						{
							$data['kitchens'][$row['quotation_kitchen_id']]['appliances_of_kitchen'][] = $row4;
							$kitchen_total += $row4['reference_quote_amount'];
						}
					}
					else {
						$data['kitchens'][$row['quotation_kitchen_id']]['appliances_of_kitchen'] = array();
					}
					$data['kitchens'][$row['quotation_kitchen_id']]['kitchen_total'] = $kitchen_total;
					
					$data['quotation_total'] += $kitchen_total;
				}
			}
			else
			{
				//$data['kitchens'][$row['quotation_kitchen_id']] = array();
			}



			//Worktops
			$where3 = array(
						'quotation_kitchen_id' 	=> 0,
						'quotation_id'			=> $quotation_id
			);
			$rs_worktops 	= $this->crud_model->get('view_qworktop_qkitchen_kbrands_wbrands_wfinish_wmodel_wept',$where3);

			if($rs_worktops != false)
			{
				foreach($rs_worktops as $row3)
				{

					$data['worktops'][] = $row3;
					
					$data['quotation_total'] += (($row3['worktop_lm']*$row3['worktop_price_per_lm']*$row3['worktop_quantity']) + ($row3['worktop_lm']*$row3['worktop_ep_price']*$row3['worktop_quantity']));
				}
			}
			else {
				$data['worktops'] = array();
			}


			//Appliances
			$where5 = array(
						'quotation_kitchen_id' 	=> 0,
						'quotation_id'			=> $quotation_id
			);
			$rs_appliances 	= $this->crud_model->get('view_quotation_qappliance',$where5);

			if($rs_appliances != false)
			{
				foreach($rs_appliances as $row5)
				{

					$data['appliances'][] = $row5;
					
					$data['quotation_total'] += $row5['reference_quote_amount'];
				}
			}
			else {
				$data['appliances'] = array();
			}
			
			
			
			
			
			
			$data['quotation_total'] 			= round($data['quotation_total'],2);
			$data['quotation_discount_amount'] 	= round($data['quotation_total'] * ($data['discount_percentage'] / 100),2);
			$data['quotation_net_total']		= round($data['quotation_total'] - $data['quotation_discount_amount'],2);
			
			
			
			
			
			

		}
		
		return $data;


	}
	
	function get_new_quotation_number(){
		
		$SQL = "
		SELECT MAX(quotation_number)+1 as `new_quotation_number` FROM quotations;
		";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		if($data[0]['new_quotation_number'] != NULL and $data[0]['new_quotation_number'] != ""){
			return $data[0]['new_quotation_number'];
		}
		else{
			return 10001;
		}
	}
	
	function check_changes_cloned(){
		if($this->session->userdata('quotation_mode') == 'edit'){
			log_message('INFO','Before cloning, Quotation ID: '.$this->session->userdata('quotation_id'));
			$new_quotation_id = $this->clone_quotation($this->session->userdata('quotation_id'));
			$this->session->set_userdata('quotation_id',$new_quotation_id);
			$this->session->set_userdata('quotation_mode','edit_cloned');
			log_message('INFO','After cloning, Quotation ID: '.$this->session->userdata('quotation_id'));
		}
	}
	
	
	function clone_quotation($quotation_id=0){
		
		$rs = $this->crud_model->get('quotations',array('quotation_id'=>$quotation_id));
		if($rs != false){
			$row = $rs[0];
			$salesman_id=$row['salesman_id'];
			
			// Getting Max Revision Number //
			$records = $this->db->query("SELECT MAX(quotation_revision_number) as `max_rev_number` FROM quotations WHERE quotation_number = ".$this->db->escape($row['quotation_number']));
			$ds = $records->result_array();
			//print_r($ds);exit;
			$max_rev_number = ($ds[0]['max_rev_number']) + 1;
			// -- -- -- //
			
			$data = array(
				'quotation_date' => $row['quotation_date'],
				'salesman_id' => $salesman_id,
				'client_id' => $row['client_id'],
				'project_id' => $row['project_id'],
				'cl_template_id' => $row['cl_template_id'],
				'cl_content' => $row['cl_content'],
				'kitchen_total' => $row['kitchen_total'],
				'worktop_total' => $row['worktop_total'],
				'appliance_total' => $row['appliance_total'],
				'discount_percentage' => 0,
				'discount_value' => 0,
				'net_total' => $row['net_total'],
				'agreement_content' => $row['agreement_content'],
				'quotation_status' => "Draft",
				'quotation_number' => $row['quotation_number'],
				'quotation_revision_number' => $max_rev_number,
				'quotation_closed_reason' => $row['quotation_closed_reason'],
				'client_cpr_number' => $row['client_cpr_number'],
				'client_cpr_file_name' => $row['client_cpr_file_name'],
				'last_modified_by' => $this->session->userdata('user_id'),
				'last_modified_date' => date('Y-m-d'),
				'status' => $row['status']
			);
			$this->crud_model->insert('quotations',$data);
			
			$new_quotation_id = $this->db->insert_id();
				
		}
		
		$quotation_kitchen_map = array();
		
		// inserting kitchens
		$rs = $this->crud_model->get('quotation_kitchen',array('quotation_id'=>$quotation_id));
		if($rs != false){
			
			foreach($rs as $row){
				
				$data = array(
					'kitchen_brand_id' => $row['kitchen_brand_id'],
					'drawing_number' => $row['drawing_number'],
					'kitchen_area_id' => $row['kitchen_area_id'],
					'kitchen_price' => $row['kitchen_price'],
					'kitchen_front_name' => $row['kitchen_front_name'],
					'kitchen_front_code' => $row['kitchen_front_code'],
					'kitchen_handle' => $row['kitchen_handle'],
					'kitchen_plinth' => $row['kitchen_plinth'],
					'kitchen_more_details' => $row['kitchen_more_details'],
					'kitchen_quantity' => $row['kitchen_quantity'],
					'quotation_id' => $new_quotation_id
				);
				$this->crud_model->insert('quotation_kitchen',$data);
				//$this->db->query($SQL_Clone_Quotation_Kitchen);
				$new_quotation_kitchen_id = $this->db->insert_id();
				$quotation_kitchen_map[$row['quotation_kitchen_id']] = $new_quotation_kitchen_id;
				
			}
			
		}
		// inserting worktops
		$rs = $this->crud_model->get('quotation_worktop',array('quotation_id'=>$quotation_id));
		if($rs != false){
				
			foreach($rs as $row){
		
				$data = array(
					'worktop_brand_id' => $row['worktop_brand_id'],
					'worktop_brand_name' => $row['worktop_brand_name'],
					'worktop_finish_id' => $row['worktop_finish_id'],
					'worktop_finish_name' => $row['worktop_finish_name'],
					'worktop_model_id' => $row['worktop_model_id'],
					'worktop_model_name' => $row['worktop_model_name'],
					'worktop_ept_id' => $row['worktop_ept_id'],
					'worktop_ept_name' => $row['worktop_ept_name'],
					'worktop_ep_id' => $row['worktop_ep_id'],
					'worktop_ep_name' => $row['worktop_ep_name'],
					'worktop_ep_price' => $row['worktop_ep_price'],
					'worktop_name' => $row['worktop_name'],
					'worktop_lm' => $row['worktop_lm'],
					'worktop_price_per_lm' => $row['worktop_price_per_lm'],
					'worktop_quantity' => $row['worktop_quantity'],
					'quotation_kitchen_id' => ($row['quotation_kitchen_id']>0 ? $quotation_kitchen_map[$row['quotation_kitchen_id']] : 0),
					'quotation_id' => $new_quotation_id
				);
				$this->crud_model->insert('quotation_worktop',$data);
			}
		}
		
		// inserting appliances
		$rs = $this->crud_model->get('quotation_appliance',array('quotation_id'=>$quotation_id));
		if($rs != false){
		
			foreach($rs as $row){
		
				$data = array(
					'reference_quote_number' => $row['reference_quote_number'],
					'reference_quote_date' => $row['reference_quote_date'],
					'reference_quote_amount' => $row['reference_quote_amount'],
					'quotation_kitchen_id' => ($row['quotation_kitchen_id']>0 ? $quotation_kitchen_map[$row['quotation_kitchen_id']] : 0),
					'quotation_id' => $new_quotation_id
				);
				$this->crud_model->insert('quotation_appliance',$data);
			}
		}
		
		
		return $new_quotation_id;
		
		
	}
	
	
	
	

}