<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ledger_reports extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}		
	public function blist($fromDate="NIL",$client_id="NIL",$user_id="NIL",$division="NIL",$client_code="NIL") {
		$this->users_model->permission("Ledger_reports", "View");
		
		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date( "Y-m-d", strtotime($date2));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
			//$fromDate	= '2020-05-28';
		}
		
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}

		if (@$this->input->post('client_code')) {
			$client_code =   $this->input->post("client_code");
		}elseif ($client_code != "NIL") {
			$client_code	=	$client_code;
		} else {
			$client_code	= "NIL";
		}

		if (@$this->input->post('user_id')) {
			$user_id =   $this->input->post("user_id");
		}elseif ($user_id != "NIL") {
			$user_id	=	$user_id;
		} else {
			$user_id	= "NIL";
		}
		if (@$this->input->post('division')) {
			$division =   $this->input->post("division");
		}elseif ($division != "NIL") {
			$division	=	$division;
		} else {
			$division	= "NIL";
		}
		
		
		$config["base_url"] = base_url() . "index.php/mobile/mobile_invoice/list_invoice/".$fromDate."/".$client_id."/".$user_id."/".$user_id;
        $config["total_rows"] = 100000000;
        $config['num_links'] = 10;
        $config["per_page"] = 1000000000000;
		$config['uri_segment'] = 8;
        $this->pagination->initialize($config);
        if ($this->uri->segment(8)) {
            $page = $this->uri->segment(8)*1000000000000-1000000000000;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
        //pagging end
        $list='';
		$totalquote_amount=0;
		$totalinvoice_amount=0;
		$totalpaid_amount=0;
		$totaldiscount=0;
		$totalcreditnoteamount=0;
		$totalUnInvoiced_amount=0;
		$totalbalance=0;
		$mxc=0;
		$header ='';
		$client_name ='';
		$forexcelheader ='';
		$opening=0;
		$count=1;
		$debit_opening_amount=0;
		$credit_opening_amount=0;
		if(!empty($_POST)){
			$books_beginning_date  = $this->furniture_quotation_model->books_beginning_date_config();
			$dd='';
			$sql="";
			$opening_date='';
			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$opening_date=$this->input->post("fromDate");
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('accounts.vch_date >=', $fromDate);
				$this->db->where('accounts.vch_date <=', $toDate);
				if($fromDate==$books_beginning_date){
					$sql.=" and accounts.vch_date <= '$fromDate' and accounts.vch_type='OPENING' ";
				} else {
					$sql.=" and accounts.vch_date < '$fromDate' ";
				}
				$dd = date("d-m-Y", strtotime($date2)).' to '.date("d-m-Y", strtotime($date3));
			} else if($fromDate!='' and $toDate==''){
				$opening_date=$this->input->post("fromDate");
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('accounts.vch_date >=', $fromDate);
				$sql.=" and accounts.vch_date < '$fromDate' ";
				$dd = date("d-m-Y", strtotime($date2));
			} else if($fromDate=='' and $toDate!=''){
				$opening_date=$this->input->post("toDate");
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('accounts.vch_date <=', $toDate);
				$sql.=" and accounts.vch_date < '$toDate' ";
				$dd = date("d-m-Y", strtotime($date3));
			}
			
			$client_code	=$this->input->post('client_code');
			$query2= $this->db->query("select sum(accounts.ledger_amount) as opening from accounts where status='1' and accounts.ledger_code='$client_code' ".$sql." limit 1");
			$client_name =$this->input->post('client');
			$header =' <br> '.$dd;
			$forexcelheader =$this->input->post('client').' \n '.$dd;
			/* $query3= $this->db->query("select ledgers.opening_balance as opening_balance_from_ledger from ledgers where ledgers.ledger_code='$client_code' ");
			if($query3->num_rows()>0){
				$opening=round($query2->row()->opening+$query3->row()->opening_balance_from_ledger,3);
			} else { */
				$opening=round($query2->row()->opening,3);
			//}
			
			$this->db->query("SET SQL_BIG_SELECTS=1");

			$this->db->where('accounts.ledger_code',$this->input->post('client_code'));
			$this->db->where('accounts.vch_type!=','OPENING');
			$this->db->select('accounts.vch_type,accounts.vch_no,accounts.vch_date,accounts.vch_ref,accounts.ledger_amount,accounts.vch_narration,ledgers.ledger_name AS reverse_ledger_name' );
			$this->db->from('accounts');
			$this->db->join('ledgers','accounts.rev_ledger_code = ledgers.ledger_code','left');
			$this->db->where('accounts.status', 1);
			//$this->db->limit(200);
			
			$this->db->order_by("vch_date","asc");
			$rs = $this->db->get();
			$total_debit=0;
			$total_credit=0;
			$list.= '<tr class="nbop-filter" >
						<td>'.$count++.'</td>
						<td>'.$opening_date.'</td>
						<td>Opening Balance</td>
						<td></td>
						<td></td>
						<td></td>';
						if($opening>=0){
							$debit_opening_amount=$opening;
							$credit_opening_amount=0;
							$list.= '<td style="text-align:right !important;" >'.$opening.'</td>
							<td style="text-align:right !important;" ></td>';
						} else {
							$credit_opening_amount=($opening*-1);
							$debit_opening_amount=0;
							$list.= '<td style="text-align:right !important;" ></td>
								<td style="text-align:right !important;" >'.($opening*-1).'</td>';
							
						}
						$list.= '<td></td>
					</tr>';
			foreach ($rs->result_array() as $row) {
				if($row['ledger_amount']>=0){
					$total_debit=$total_debit+$row['ledger_amount'];
					$cd='<td style="text-align:right !important;" class="tddr" > '.number_format($row['ledger_amount'],3).' </td><td></td>';
					
				} else {
					$total_credit=$total_credit+($row['ledger_amount']*-1);
					$cd='<td></td><td style="text-align:right !important;" class="tdcr" > '.number_format($row['ledger_amount']*-1,3).' </td>';
				}
				$list.= '<tr >
							<td>'.$count++.'</td>
							<td> '.date("d-M-Y", strtotime($row['vch_date'])).' </td>
							<td>'.$row['vch_type'].'</td>
							<td> '.$row['vch_no'].' </td>
							<td> '.$row['vch_ref'].' </td>
							<td> '.$row['reverse_ledger_name'].' </td>
							'.$cd.'
							<td> '.$row['vch_narration'].' </td>
						</tr>';
			}
			$dr=0;
			$cr=0;
			$list.='<tr class="nbfooter-filter ">
					<td><p style="display:none;">'.$count++.'</p></td>
					<td> &nbsp; </td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td style="text-align:right !important;" class="nb_total_debit" > '.number_format((float)$total_debit+$debit_opening_amount, 3, '.', '').' </td>
					<td style="text-align:right !important;"> '.number_format((float)$total_credit+$credit_opening_amount, 3, '.', '').' </td>
					<td>&nbsp;</td>
				</tr>';
				$total_debit=$total_debit+$debit_opening_amount;
				$total_credit=$total_credit+$credit_opening_amount;
				if($total_debit>$total_credit){
					$dr=$total_debit-$total_credit;
					$list.= '<tr class="nbfooter-filter" >
					<td><p style="display:none;">'.$count++.'</p></td>
						<td> &nbsp; </td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>Closing Balance</td>
						<td style="text-align:right !important;">'.number_format((float)($total_debit-$total_credit), 3, '.', '').'</td>
						<td> &nbsp;  </td>
						<td>&nbsp;</td>
					</tr>';
				} else {
					$cr=$total_credit-$total_debit;
					$list.= '<tr class="nbfooter-filter">
					<td><p style="display:none;">'.$count++.'</p></td>
						<td> &nbsp; </td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>Closing Balance</td>
						<td > &nbsp; </td>
						<td style="text-align:right !important;">'.number_format((float)($total_credit-$total_debit), 3, '.', '').'</td>
						<td>&nbsp;</td>
					</tr>';
				}
			/* $list.= '<tr class="nbfooter-filter" >
				<td><p style="display:none;">'.$count++.'</p></td>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
				<td style="text-align:right !important;"> '.number_format((float)$total_debit+$cr, 3, '.', '').' </td>
				<td style="text-align:right !important;"> '.number_format((float)$total_credit+$dr, 3, '.', '').' </td>
				<td>&nbsp;</td>
			</tr>'; */
		}
		$usr = $this->crud_model->get('users');
		$usrlist = array(0 => ' - Select Sales Man- ');
		foreach($usr as $usrs){
			$usrlist[$usrs['user_id']] = $usrs['user_name'];
		}
		
		$company_division = $this->crud_model->get('company_division');
		if(count($company_division)!=1){
			$company_divisionslist = array(0 => ' - Select Division - ');
		}
		foreach($company_division as $company_divisions){
			$company_divisionslist[$company_divisions['division_id']] = $company_divisions['division_name'];
		}
		
		$datas   =   array("data" => $list,"users"=>$usrlist,"nbuser_id"=>$user_id,"company_division"=>$company_divisionslist,"nbcompany_divisionslist"=>$division,"client_name"=>$client_name,"header"=>$header,"forexcelheader"=>$forexcelheader,"opening"=>$opening,"debit_opening_amount"=>$debit_opening_amount,"credit_opening_amount"=>$credit_opening_amount);
		
		$this->load->view('templates/header');
		$this->load->view('reports/ledger_reports',$datas);
		$this->load->view('templates/footer');		
	}

	public function search_ledger() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and ledger_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where status='1' and `ledger_name` like '$client%'  union (SELECT * FROM `ledgers` where status='1' and `ledger_id` not in (SELECT `ledger_id` FROM `ledgers` where status='1' and  `ledger_name` like '$client%' ) ".$sql." order by ledger_name) limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['ledger_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}
}
?>