<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Quotation_register extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}	
	
	
	public function index($status='') {
		$this->users_model->permission("Quotation_register", "View");
		if($status == "result" ) {
			$this->form_validation->set_rules('report_date_from', 'Date', 'callback_date_check');
			$this->form_validation->set_rules('report_date_to', 'Date', 'callback_date_check');
			
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				//Furniture Quotations...
				$data['quotation_type'] = "furniture";
				$where = array();
				if($this->input->post('user_id') != 0 ) {
					$where['salesman_id'] = $this->input->post('user_id');
				}
				if($this->input->post('quotation_status')) {
					$where['quotation_status'] = $this->input->post('quotation_status');
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['quotation_divisionid'] = $this->input->post('division');
					$div_total_flag = 1;
				}
				$order_by='quotation_id';
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to').' + 1 day'));

					if($this->input->post('quotation_status') == 'Confirmed'){
						if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
							$where['quotation_confirmationdate >='] = $date_fmt;
							$where['quotation_confirmationdate <='] = $date_to;
						} else if ($this->input->post('report_date_from') != '') {
							$where['quotation_confirmationdate >='] = $date_fmt;
						} else if ($this->input->post('report_date_to')!=''){
							$where['quotation_confirmationdate <='] = $date_to;
						}
					} else {
						if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
							$where['quotation_date >='] = $date_fmt;
							$where['quotation_date <='] = $date_to;
						} else if ($this->input->post('report_date_from') != '') {
							$where['quotation_date >='] = $date_fmt;
						} else if ($this->input->post('report_date_to')!=''){
							$where['quotation_date <='] = $date_to;
						}
					}
				}
				if($this->input->post('quotation_status') == 'Confirmed'){
					$order_by='quotation_confirmationdate';
				}
				$data['records']=$this->crud_model->get('view_furniture_quotations_client_project_users', $where,null,null,$order_by,'desc');

				if($this->input->post('user_id') != 0 ) {
					if($data['records']!=false){
						$recordnb=$data['records'];
						$data['sales_man'] = $recordnb[0]['user_name'];
					}
				}
				$data['logo_filename']=NULL;
				//echo $this->db->last_query().'<br>';
				$data['submitted_division_id'] = $this->input->post('division');
				if(isset($div_total_flag) and $data['records']) {
					$furniture_division_total = 0;
					foreach($data['records'] as $record) {
						$furniture_division_total += ($record["quotation_amount_with_vat"]);
					}
					$data["furniture_division_total"] = $furniture_division_total;
					$where2['division_id'] = $this->input->post('division');
					$companydata=$this->crud_model->get('company_division', $where2);
					$data['logo_filename']=$companydata[0]['logo_filename'];
				}
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}			
				
		
		
		
		$records = $this->crud_model->get('users');
		if($records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array());
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();
			
			$data=$data;
			
			$this->load->view('templates/header');
			$this->load->view('reports/quotation_register',$data);
			$this->load->view('templates/footer');
		}
	}
	
	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		if($given_date <= $today_date) {
			return true;
		}else{
			$this->form_validation->set_message('date_check', 'Date cannot be Future date');
			return FALSE;
		}
	}
}

?>