<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Receipt extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}


	public function list_receipt($fromDate="NIL",$toDate="NIL",$division_id="NIL",$receipt_no="NIL",$client_id="NIL") {
		$this->users_model->permission("Receipt", "View");
		$title['headerTitle']="Receipt List";
		$this->load->library('pagination');

		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}

		if (@$this->input->post('division_id')) {
			$division_id =   $this->input->post("division_id");
		}elseif ($division_id != "NIL") {
			$division_id	=	$division_id;
		} else {
			$division_id	= "NIL";
		}
		
		
		if (@$this->input->post('receipt_no')) {
			$receipt_no =   $this->input->post("receipt_no");
		}elseif ($receipt_no != "NIL") {
			$receipt_no	=	$receipt_no;
		} else {
			$receipt_no	= "NIL";
		}

		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}

		$config["base_url"] = base_url() . "index.php/receipt/list_receipt/".$fromDate."/".$toDate."/".$division_id."/".$receipt_no."/".$client_id;
        $config["total_rows"] = $this->furniture_quotation_model->rnbrecord_count($fromDate,$toDate,$division_id,$receipt_no,$client_id);
        $config['num_links'] = 10;
        $config["per_page"] = 100;
		$config['uri_segment'] =8;
        $this->pagination->initialize($config);
        if ($this->uri->segment(8)) {
            $page = $this->uri->segment(8)*100-100;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
		$data['receipts'] = $this->furniture_quotation_model->nbget_all_receipts($config["per_page"], $page,$fromDate,$toDate,$division_id,$receipt_no,$client_id);
		$data['pagination'] = $this->pagination->create_links();

		if($data['receipts']!=false && $client_id!='NIL'){
			$customer_name =	$data['receipts'][0]['client_name'];
		} else {
			$customer_name = '';
		}
		

		$data['receipt_no'] = $receipt_no;
		$data['toDate']	   = $toDate;
		$data['fromDate']   = $fromDate;
		$data['client_id']   = $client_id;
		$data['customer_name']   = $customer_name;
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header',$title);
		$this->load->view('manage/list_receipt',$data);
		$this->load->view('templates/footer');
	}

	public function index($quotation_id=0) {
		$this->data['receipts'] = $this->furniture_quotation_model->get_all_receipts();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header');
		$this->load->view('manage/receipts',$this->data);
		$this->load->view('templates/footer');
	}
	
	public function create_receipt(){
		$this->users_model->permission("Receipt", "Add");
		$title['headerTitle']="New Receipt";
		/* $this->db->select('new_client_master.client_id,new_client_master.client_name,new_client_master.client_code,new_client_master.client_address,new_client_master.client_country,new_client_master.client_telephone1,new_client_master.client_telephone2,new_client_master.client_fax,new_client_master.client_email');
		$this->db->from('new_client_master');
		$rs = $this->db->get();
		$html='';
		if($rs->num_rows() > 0){
			$records['client_list'] = $rs->result_array();
			if($records['client_list'] == false ){
				$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
			} else {
				foreach($records['client_list'] as $index=>$client_entry) {
					$html.='<li  tabindex="-1"  value="' .$client_entry['client_id'] .'" data-client_code="' .$client_entry['client_code'] .'" data-client_name="' .$client_entry['client_name'] .'" class="client_buttonxxxxx" >'. $client_entry['client_name'] . '</li>';
			
				}
			}
		}
		$data['clientList'] = $html; */
		$data['cash_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
		$data['bank_ledgers'] 	= $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
		$data['records'] 		= $this->crud_model->get('voucher_ledger_mapping');
		$this->load->view('templates/header',$title);
		$this->load->view('manage/createReceipt',$data);
		$this->load->view('templates/footer');
	}
	
	function search_client_for_receipt() {
		$search_name = trim($this->input->post('filter_division'));
		$search_mob = trim($this->input->post('search_name'));
		
		$or_where=array();
		$like=null;
		if($search_mob !='' && $search_name!='') {
			$where=array('furniture_invoice.quotation_divisionid'=>$search_name);
			$like=array('furniture_invoice.client'=>$search_mob);
		
		}else{
			$where=array('furniture_invoice.quotation_divisionid'=>$search_name);
			$like=array();
		}
		$this->db->distinct();
		$this->db->select('new_client_master.client_id,new_client_master.client_code,new_client_master.client_name,new_client_master.client_address,new_client_master.client_country,new_client_master.client_telephone1,new_client_master.client_telephone2,new_client_master.client_fax,new_client_master.client_email,furniture_invoice.quotation_divisionid');
		$this->db->from('furniture_invoice');
		$this->db->join('new_client_master', 'new_client_master.client_id = furniture_invoice.client_id','inner');
		$this->db->where($where);
		$this->db->where('furniture_invoice.invoice_status', '0'); 
		$this->db->like($like);
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			$records['client_list'] = $rs->result_array();
			if($records['client_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('manage/search_clients', $records);
			//$this->load->view('manage/search_result_receipt', $records);
		}
		}
		
		//$records['client_list']=$this->crud_model->get('new_client_master',array(), null,null,null,null,$like, $or_where);
		
	
		
		
	}
	
	function search_client_for_receiptxx() {
		$html='';
		$filter_division = trim($this->input->post('filter_division'));
		$client_name = trim($this->input->post('search_name'));
		
		$like=array('client_name'=>$client_name);
		$where=array('cstatus'=>1);
		$rs=$this->crud_model->get('new_client_master',$where,25,0,null,null,$like,null,null);
		
		if($rs == false ){
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
			echo $html;
		} else {
			foreach($rs as $index=>$client_entry) {
				$html.='<li  tabindex="-1"  value="' .$client_entry['client_id'] .'" ref="' .$filter_division .'" data-client_code="' .$client_entry['client_code'] .'" data-client_name="' .$client_entry['client_name'] .'" class="client_buttonxxxxx" >'. $client_entry['client_name'] . '</li>';
			}
			echo $html;
		}
		
	}

	function search_client() {
		$html='';
		$client_name = trim($this->input->post('client'));
		
		$like=array('client_name'=>$client_name);
		$where=array('cstatus'=>1);
		$rs=$this->crud_model->get('new_client_master',$where,25,0,null,null,$like,null,null);
		
		if($rs == false ){
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
			echo $html;
		} else {
			foreach($rs as $index=>$client_entry) {
				$html.='<li  tabindex="-1"  value="' .$client_entry['client_id'] .'" data-client_code="' .$client_entry['client_code'] .'" data-client_name="' .$client_entry['client_name'] .'" class="client_button" >'. $client_entry['client_name'] . '</li>';
			}
			echo $html;
		}
		
	}

	/* function search_client_for_receiptxx() {
		$html='';
		$search_name = trim($this->input->post('filter_division'));
		$search_mob = trim($this->input->post('search_name'));
		$or_where=array();
		$like=null;
		if($search_mob !='' && $search_name!='') {
			$where=array();
			//$where=array('furniture_quotation.quotation_divisionid'=>$search_name);
			$like=array('new_client_master.client_name'=>$search_mob);
		
		}else{
			$where=array();
			//$where=array('furniture_quotation.quotation_divisionid'=>$search_name);
			$like=array();
		}
		
		
		//$this->db->distinct();
		$this->db->select('new_client_master.client_id,new_client_master.client_name,new_client_master.client_code,new_client_master.client_address,new_client_master.client_country,new_client_master.client_telephone1,new_client_master.client_telephone2,new_client_master.client_fax,new_client_master.client_email');
		$this->db->from('new_client_master');
		//$this->db->where('invoice_amount','1');
		$this->db->like($like);
		$this->db->limit(25);
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			$records['client_list'] = $rs->result_array();
			if($records['client_list'] == false ){
				$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
				echo $html;
			} else {
				foreach($records['client_list'] as $index=>$client_entry) {
					$html.='<li  tabindex="-1"  value="' .$client_entry['client_id'] .'" ref="' .$search_name .'" data-client_code="' .$client_entry['client_code'] .'" data-client_name="' .$client_entry['client_name'] .'" class="client_buttonxxxxx" >'. $client_entry['client_name'] . '</li>';
			
				}
				echo $html;
			}
		}
	} */

	

	function get_outstanding_invoices(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$invoices=$this->furniture_quotation_model->get_outstanding_invoices_new2($client_id,$ref_division);
		if ($invoices != false){
				foreach($invoices as $index =>$invoice){
				//$quotation_id = $invoice['quotation_id'];
				//$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
				$amount_paid = $invoice['paid_amount'];
				$invoices[$index]['amount_paid'] =$amount_paid;
				$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
			}
        }
		
		$records['invoices'] = $invoices;
		//$records['Confirmed_quotations'] = $this->crud_model->get_list4('quotation_number_full','quotation_number_full','view_furniture_quotations_client_project_users',array(''=>' - Select Quotation - '),array('client_code'=>$client_id,'quotation_status'=>"Confirmed"));

		//if($records['invoices'] == false ){
		//	echo '<label style="color:red; font-size:14.5px;">No Invoice List Available..!</label>';
		//} else {
			$records=html_escape($records);
			$this->load->view('manage/search_result_receipt', $records);
		//}
	}

	function get_confirmed_quotations(){
		$client_id = $this->input->post('client_id');
		//$invoices = $this->furniture_quotation_model->get_outstanding_invoices($client_id);
		$invoices = $this->furniture_quotation_model->get_confirmed_quotes ($client_id);
              /*
                $not_included_quotations = array();
                if ($invoices != false ) {
                foreach($invoices as $index =>$invoice){
			if($invoice['invoice_number']){
				array_push($not_included_quotations,$invoice['invoice_id']);
			}
		}
                }
                */
		$confirmed_quotations = $this->furniture_quotation_model->get_confirmed_quotations($client_id,$not_included_quotations);
		if(is_array($confirmed_quotations)){
		foreach($confirmed_quotations as $index =>$invoice){
			$quotation_id = $invoice['id'];
			$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
			$confirmed_quotations[$index]['amount_paid'] =$amount_paid;
			$confirmed_quotations[$index]['balance_amount'] =$invoice['quotation_total']- $amount_paid;
		}
		}
		$records['confirmed_quotations'] = $confirmed_quotations;
		//var_dump($records['invoices']); exit;
		if($records['confirmed_quotations'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('manage/receipts_confirmed_quotations', $records);
			
		}
		
	}
	
	public function save_receipt_new_temp(){
		$no_of_invoices = $this->input->post('no_of_invoices');		
		$SQL = "SELECT MAX(receipt_number)+1 as `new_receipt_number` FROM furniture_receipts where quotation_divisionid='".$this->input->post('ref_div_id')."';";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		
		if($data[0]['new_receipt_number'] != NULL and $data[0]['new_receipt_number'] != ""){
			$receipt_no = $data[0]['new_receipt_number'];
		} else{
			$receipt_no = 101;
		}
				
		$receipt['receipt_number'] = $receipt_no;
		$receipt['quotation_divisionid'] = $this->input->post("ref_div_id");
		$receipt['receipt_date'] = date("Y-m-d h:m:s");
		$receiptd['receipt_mode'] = $this->input->post("payment_modes");
		$receipt['receipt_amount'] = ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt'));
		$receipt['receipt_reference'] = $this->input->post("ref_number");
		$receipt['receipt_bankname'] = $this->input->post("bank_name");
		$receipt['receipt_id'] = $this->input->post("remarks");
		$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
		$receiptdts['invoice_id'] = 0;
		//$this->furniture_quotation_model->set_receipt_id($quotation_id);
		//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
		//$where= array('receipt_id'=>$generated_receipt_id);
		$rcpt = $this->crud_model->insert('furniture_receipts',$receipt);
		//$receipt_no = $this->furniture_quotation_model->get_new_receipt_number();
		//$amount = $this->input->post($current_amount_invoice);
		$receipt_id = $this->db->insert_id();
			for($i=1;$i<=$no_of_invoices;$i++)
			{
				$current_amount_invoice ="current_amount_invoice_".$i;
				$amount = $this->input->post($current_amount_invoice);
				$nbbbamount = $this->input->post($current_amount_invoice)+(float)$this->input->post("receipt_discount_".$i);
				$new_current_bal_amount_invoice ="current_bal_amount_invoice_".$i;
				$bal_amount = $this->input->post($new_current_bal_amount_invoice);
				$invoice_id ="invoice_id_".$i;
				$invid = $this->input->post($invoice_id);
				$new_receipt_tick ="new_receipt_tick_".$i;
				$new_receipt_tick = $this->input->post($new_receipt_tick);
				if($amount!="" && $amount!="0"){
						//$receipt['quotation_id'] = $quotation_id;
						$receiptdts['receipt_amount'] = $amount;
						$receiptdts['receipt_discount'] = $this->input->post("receipt_discount_".$i);
						$receiptdts['balance_amount'] = $bal_amount;
						$receiptdts['receipt_id'] = $receipt_id;
						$receiptdts['invoice_id'] = $invid;
						//$this->furniture_quotation_model->set_receipt_id($quotation_id);
						//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						//$where= array('receipt_id'=>$generated_receipt_id);
						$inv = $this->crud_model->insert('receipts_details',$receiptdts);
						//$this->furniture_quotation_model->set_receipt_id($quotation_id);
						//$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						//$where= array('receipt_id'=>$generated_receipt_id);
						if($inv){
							$paid_amount = $this->furniture_quotation_model->get_paid_amount_for_invoice($invid);
							$receipt_discount = $this->furniture_quotation_model->get_receipt_discount_for_invoice($invid);
							$creceipt_discount=$this->input->post("receipt_discount_".$i);
							$invoiceWhere = array('invoice_id' => $invid);
							$invoiceData = array('paid_amount' =>  (float)$paid_amount+ (float)$amount,'receipt_discount' =>  (float)$receipt_discount+ (float)$creceipt_discount);
							$invupdate = $this->crud_model->update('furniture_invoice',$invoiceData,$invoiceWhere);

							$division_id=$this->input->post('ref_div_id');
							$div_data = $this->db->query("SELECT * FROM `company_division` WHERE division_id='$division_id' ");
							$division_code=$div_data->row()->division_code;  

							$cust_bill_allocations_data = array(
								'customer_code' => $this->input->post('clientIdHidden'),
								'bill_id'         => $invid,
								'trn_no'       => $division_code.'-'.$receipt_no,
								'bill_date'         => date("Y-m-d h:m:s"),
								'bill_amt'       => -((float)$nbbbamount),
								'bill_os_amount'     => -((float)$nbbbamount),
								'bill_type'       => 'Receipt',
								'trn_type'               =>  'Receipt'
							);
								
							$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);
						}
				}
					
			}
			if($receipt_id){
			
				if($this->input->post('cash')!==''){
					$paidData = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cash'),
						'name' 				=> 'Paid Amount',
						'payment_mode' 		=> 'Paid Amount'
					);
					$this->db->insert('receipt_payment_details', $paidData);
					
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> ((float)$this->input->post('i_total'))-((float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
						'name' 				=> 'Cash',
						'payment_mode' 		=> 'Cash'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
				if($this->input->post('c_card')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('c_card'),
						'authorized' 		=> $this->input->post('authorized'),
						'name' 				=> $this->input->post('c_type'),
						'payment_mode' 		=> 'Credit Card'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
				if($this->input->post('cheque_amt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cheque_amt'),
						'authorized' 		=> $this->input->post('cheque_no'),
						'name' 				=> $this->input->post('cheque_bank'),
						'payment_mode' 		=> 'Cheque'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
				if($this->input->post('wallet_amnt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('wallet_amnt'),
						'authorized' 		=> $this->input->post('wallet_authorized'),
						'name' 				=> $this->input->post('wallet_type'),
						'payment_mode' 		=> 'Wallet'
					);
					$this->db->insert('receipt_payment_details', $data);
					
				}
		}
		if($inv){
		$SQLRECEIPT = "SELECT MAX(receipt_id) as `receipt_id` FROM furniture_receipts;";
		$receipt_result = $this->db->query($SQLRECEIPT);
		$receipt_details = $receipt_result->result_array();
		$receipt_id = $receipt_details[0]['receipt_id'];
		
		// MAILING ....

				/* mail recpt nbas close start $INVOICESQL = "SELECT company_division.division_code AS division_name,company_division.currency_code AS currency_name,furniture_invoice.client AS client,furniture_receipts.receipt_number,furniture_receipts.receipt_amount,furniture_receipts.quotation_divisionid FROM furniture_receipts JOIN furniture_invoice ON furniture_invoice.invoice_id=furniture_receipts.invoice_id JOIN company_division ON company_division.division_id=furniture_invoice.quotation_divisionid WHERE furniture_receipts.receipt_id=".$receipt_id;
				$invoice_result = $this->db->query($INVOICESQL);
				$invoice_details = $invoice_result->result_array();
				$this->db->select('*');
				$this->db->from('emails'); 
				$query_email = $this->db->get();
				$records_email=$query_email->result_array();

				$links =   site_url('furniture/furniture_receipt/view1/'.$receipt_id.'/'.$invoice_details[0]['receipt_number'].'/'.$invoice_details[0]['quotation_divisionid'].'/normal');
				
				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'Q-Pro Admin';
				$to 		= @$records_email[0]['receipt'];
				$subject 	= 'Q-Pro - Receipt for '.$invoice_details[0]['client'].'('.$invoice_details[0]['division_name'].' - '.$invoice_details[0]['receipt_number'].') is created';
				$message 	= '
				<table>
					<tr>
						<td>Receipt No.</td>
						<td>:</td>
						<td><a href='.$links.'>'.$invoice_details[0]['division_name'].' - '.$invoice_details[0]['receipt_number'].'</a></td>

					</tr>
					<tr>
						<td>Client</td>
						<td>:</td>
						<td>'.$invoice_details[0]['client'].'</td>
					</tr>
					<tr>
						<td>Receipt Amount</td>
						<td>:</td>
						<td>'.$invoice_details[0]['currency_name'].'. '.number_format( $invoice_details[0]['receipt_amount'],2).'</td>
					</tr>
				</table>';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);
			mail recpt nbas close close
				/*	email notification end		*/
		
		$this->session->set_flashdata('response', 'New Receipt Created...');	
		redirect('Receipt/list_receipt');}else{
		$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
		redirect('Receipt/list_receipt');
		}
	}

	public function validate_amount($amount) {
		$net_amount = (float)$this->input->post('bank_amt') + (float)$this->input->post('cash') + (float)$this->input->post('c_card') + (float)$this->input->post('cheque_amt') + (float)$this->input->post('wallet_amnt');
		$total_paying_amount = 0;
		$no_of_invoices = $this->input->post('no_of_invoices');	
		$no_of_adv_receipts = $this->input->post('no_of_adv_receipts');	

		for($z=1;$z<=$no_of_adv_receipts;$z++) {
			$total_paying_amount = $total_paying_amount - (float)$this->input->post("adv_current_amount_invoice_" . $z);
		}
		for ($i = 1; $i <= $no_of_invoices; $i++) {
			$total_paying_amount = $total_paying_amount + (float)$this->input->post("current_amount_invoice_" . $i);
		}
		$total_paying_amount=$total_paying_amount+(float)$this->input->post('advance_payment');

		if ((float)$net_amount == (float)$total_paying_amount) {
			return true;
		} else {
			$this->form_validation->set_message('validate_amount', 'The total amount does not match the total paying amount.');
			return false;
		}
	}

	public function save_receipt_new(){
		$this->users_model->permission("Receipt", "Add");
		$this->form_validation->set_rules('receipt_date','Date', 'required');
		$this->form_validation->set_rules('i_total','Amount', 'required|max_length[100]');
		$this->form_validation->set_rules('clientIdHidden','Client', 'required');
		$this->form_validation->set_rules('client_code','Client', 'required');
		if($this->input->post('bank_check')==1){
			$this->form_validation->set_rules('bank_ledgers','Bank Ledger', 'required');
		} else {
			$this->form_validation->set_rules('bank_ledger_code','Bank Ledger', 'required');
		}
		if($this->input->post('cash_check')==1){
			$this->form_validation->set_rules('cash_ledgers','Cash Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cash_ledger_code','Cash Ledger', 'required');
		}
		if($this->input->post('c_card_check')==1){
			$this->form_validation->set_rules('c_card_ledgers','C Card Ledgers', 'required');
		} else {
			$this->form_validation->set_rules('c_card_ledger_code','C Card Ledger', 'required');
		}
		if($this->input->post('wallet_check')==1){
			$this->form_validation->set_rules('wallet_ledgers','Wallet Ledger', 'required');
		} else {
			$this->form_validation->set_rules('wallet_ledger_code','Wallet Ledger', 'required');
		}
		if($this->input->post('cheque_check')==1){
			$this->form_validation->set_rules('cheque_ledgers','Cheque Ledger', 'required');
		} else {
			$this->form_validation->set_rules('cheque_ledger_code','Cheque Ledger', 'required');
		}
		
		$this->form_validation->set_rules('i_total', 'Amount', 'callback_validate_amount');

		if ($this->form_validation->run() == FALSE) {
			$data['cash_ledgers'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>22,'status'=>1),'ledger_name','asc');
			$data['bank_ledgers'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'Select'),array('acoount_group_id'=>23,'status'=>1),'ledger_name','asc');
			$data['records'] 	  = $this->crud_model->get('voucher_ledger_mapping');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('manage/createReceipt',$data);
			$this->load->view('templates/footer');
		} else {
			$largest=max((float)$this->input->post('c_card'),(float)$this->input->post('cheque_amt'),(float)$this->input->post('wallet_amnt'),(float)$this->input->post('cash'),(float)$this->input->post('bank_amt'));
			if((float)$this->input->post('cash')==$largest) {
				if($this->input->post('cash_check')==1){
					$rev_ledger_code=$this->input->post('cash_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cash_ledger_code');
				}
			} else if((float)$this->input->post('bank_amt')==$largest){
				if($this->input->post('bank_check')==1){
					$rev_ledger_code=$this->input->post('bank_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('bank_ledger_code');
				}	
			} else if((float)$this->input->post('c_card')==$largest){
				if($this->input->post('c_card_check')==1){
					$rev_ledger_code=$this->input->post('c_card_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('c_card_ledger_code');
				}	
			}  else if((float)$this->input->post('wallet_amnt')==$largest) {
				if($this->input->post('wallet_check')==1){
					$rev_ledger_code=$this->input->post('wallet_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('wallet_ledger_code');
				}
			} else if((float)$this->input->post('cheque_amt')==$largest) {
				if($this->input->post('cheque_check')==1){
					$rev_ledger_code=$this->input->post('cheque_ledgers');
				} else {
					$rev_ledger_code=$this->input->post('cheque_ledger_code');
				}
			}
			$this->db->trans_begin();
			$no_of_invoices = $this->input->post('no_of_invoices');	
			$no_of_adv_receipts = $this->input->post('no_of_adv_receipts');	
			
			//echo $no_of_invoices;
			//exit();

			$SQL = "SELECT MAX(receipt_number)+1 as `new_receipt_number` FROM furniture_receipts where quotation_divisionid='".$this->input->post('ref_div_id')."';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			
			if($data[0]['new_receipt_number'] != NULL and $data[0]['new_receipt_number'] != ""){
				$receipt_no = $data[0]['new_receipt_number'];
			} else{
				$receipt_no = 1;
			}

			$ref_div_id	=	$this->input->post('ref_div_id');

			$receipt_code	=	$this->furniture_quotation_model->get_receipt_code($ref_div_id,$receipt_no);
			$receipt_date = strtotime( $this->input->post('receipt_date') );
			$mysqldate = date( 'Y-m-d h:m:s', $receipt_date);

			if($this->input->post('cheque_date')!=''){
				$cheque_date2 = strtotime( $this->input->post('cheque_date') );
				$cheque_date = date( 'Y-m-d', $cheque_date2);
			} else {
				$cheque_date = NULL;
			}
			

			$receipt['receipt_number'] 	= $receipt_no;
			$receipt['receipt_code']   	= $receipt_code;
			$receipt['client_id'] 		= $this->input->post('clientIdHidden');
			$receipt['quotation_divisionid'] = $this->input->post("ref_div_id");
			$receipt['receipt_date'] 	= $mysqldate;
			$receiptd['receipt_mode'] 	= $this->input->post("payment_modes");
			$receipt['receipt_amount'] 	= ((float)$this->input->post('i_total'));
			$receipt['receipt_reference'] = $this->input->post("ref_number");
			$receipt['receipt_bankname']= $this->input->post("cheque_bank");
			$receipt['cheque_date'] 	= $cheque_date;
			$receipt['receipt_remarks'] = $this->input->post("remarks");
			$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
			$receiptdts['invoice_id'] 	= 0;
			$rcpt 		= $this->db->insert('furniture_receipts',$receipt);
			$receipt_id = $this->db->insert_id();

			$xxreceipt_discount=0;

			$xxreceipt_amount=0;

			$total_paying_amount=0;


			for($z=1;$z<=$no_of_adv_receipts;$z++) {
				$total_paying_amount=$total_paying_amount-(float)$this->input->post("adv_current_amount_invoice_".$z);
				$adv_current_amount_invoice ="adv_current_amount_invoice_".$z;
				$adv_amount = $this->input->post($adv_current_amount_invoice);
				$adv_nbbbamount = $this->input->post($adv_current_amount_invoice);
				$adv_invoice_id ="adv_invoice_id_".$z;
				$advinvid = $this->input->post($adv_invoice_id);
				$sm_idxx =$this->input->post("r_sm_id_".$z);
				if($adv_amount!="" && $adv_amount!="0"){
					$adv_receiptdts['receipt_amount'] = $adv_amount;
					$adv_receiptdts['receipt_discount'] = 0;
					$adv_receiptdts['balance_amount'] = 0;
					$adv_receiptdts['receipt_id'] = $receipt_id;
					$adv_receiptdts['invoice_id'] = $advinvid;
					$inv = $this->crud_model->insert('receipts_details',$adv_receiptdts);
					if($inv){
						$cust_bill_allocations_data = array(
							'customer_code' => $this->input->post('client_code'),
							'bill_id'       => $advinvid,
							'trn_no'        => $receipt_code,
							'bill_date'     => $mysqldate,
							'bill_amt'      => ((float)$adv_nbbbamount),
							'bill_os_amount'=> ((float)$adv_nbbbamount),
							'bill_type'     => 'Receipt',
							'division_id'   => $this->input->post('ref_div_id'),
							'sm_id'   		=> $sm_idxx,
							'trn_type'      => 'Receipt'
						);			
						$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);
					}
				}		
			}

			$division_id=$this->input->post('ref_div_id');
			for($i=1;$i<=$no_of_invoices;$i++) {
				$total_paying_amount=$total_paying_amount+(float)$this->input->post("current_amount_invoice_".$i);
				$current_amount_invoice ="current_amount_invoice_".$i;
				$amount = $this->input->post($current_amount_invoice);
				$nbbbamount = $this->input->post($current_amount_invoice)+(float)$this->input->post("receipt_discount_".$i);
				$new_current_bal_amount_invoice ="current_bal_amount_invoice_".$i;
				$bal_amount = $this->input->post($new_current_bal_amount_invoice);
				$invoice_id ="invoice_id_".$i;
				$invid = $this->input->post($invoice_id);
				$new_receipt_tick ="new_receipt_tick_".$i;
				$new_receipt_tick = $this->input->post($new_receipt_tick);
				$sm_id_i =$this->input->post("sm_id_".$i);
				if($amount!="" && $amount!="0"){
						$receiptdts['receipt_amount'] = $amount;
						$receiptdts['receipt_discount'] = $this->input->post("receipt_discount_".$i);
						$receiptdts['balance_amount'] = $bal_amount;
						$receiptdts['receipt_id'] = $receipt_id;
						$receiptdts['invoice_id'] = $invid;
						$inv = $this->crud_model->insert('receipts_details',$receiptdts);
						if($inv){
							$paid_amount = $this->furniture_quotation_model->get_paid_amount_for_invoice($invid);
							$receipt_discount = $this->furniture_quotation_model->get_receipt_discount_for_invoice($invid);
							$creceipt_discount=$this->input->post("receipt_discount_".$i);
							$xxreceipt_discount=$xxreceipt_discount+(float)$this->input->post("receipt_discount_".$i);
							$invoiceWhere = array('invoice_id' => $invid);
							$invoiceData = array('paid_amount' =>  (float)$paid_amount+ (float)$amount,'receipt_discount' =>  (float)$receipt_discount+ (float)$creceipt_discount);
							$invupdate = $this->crud_model->update('furniture_invoice',$invoiceData,$invoiceWhere);

							
							$div_data = $this->db->query("SELECT * FROM `company_division` WHERE division_id='$division_id' ");
							$division_code=$div_data->row()->division_code;  

							$cust_bill_allocations_data = array(
								'customer_code' => $this->input->post('client_code'),
								'bill_id'       => $invid,
								'trn_no'        => $receipt_code,
								'bill_date'     => $mysqldate,
								'bill_amt'      => -((float)$nbbbamount),
								'bill_os_amount'=> -((float)$nbbbamount),
								'bill_type'     => 'Receipt',
								'division_id'   => $division_id,
								'sm_id'   		=> $sm_id_i,
								'trn_type'      => 'Receipt'
							);
								
							$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);

						}
				}
					
			}

			/* $cc_amount=(float)$this->input->post('cash')+(float)$this->input->post('bank_amt')+(float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt');
			$xxreceipt_amount	=	$total_paying_amount+(float)$this->input->post('advance_payment');

			if($cc_amount!=$xxreceipt_amount){
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Please check the receipt amount...');	
				redirect('Receipt/list_receipt');
			} */
			
			if($receipt_id){
				
				if($this->input->post('advance_payment')!='' && $this->input->post('advance_payment')!='0' && $this->input->post('advance_payment')!='0.000' ){
					/* if($this->input->post('confirmed_quotation')!=''){
						$receipt_c=$this->input->post('confirmed_quotation');
					} else {
						$receipt_c=$receipt_code;
					} */
					$cust_bill_allocations_data = array(
						'customer_code' => $this->input->post('client_code'),
						'bill_id'       => $receipt_code,
						'trn_no'        => $receipt_code,
						'bill_date'     => $mysqldate,
						'bill_amt'      => -((float)$this->input->post('advance_payment')),
						'bill_os_amount'=> -((float)$this->input->post('advance_payment')),
						'bill_type'     => 'Receipt',
						'sm_id'   		=> $this->session->userdata("user_id"),
						'division_id'   => $division_id,
						'trn_type'      => 'Receipt'
					);
						
					$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);
				}

				if($this->input->post('client_code')!=''){
					if($xxreceipt_discount>0){
						$xxreceipt_amount	=	$total_paying_amount+(float)$xxreceipt_discount+(float)$this->input->post('advance_payment');
					} else {
						$xxreceipt_amount	=	$total_paying_amount+(float)$this->input->post('advance_payment');
					}
					
					$this->db->where("vch_no",$receipt_code);
					$this->db->where("vch_type",'RECEIPT');
					$this->db->delete('accounts');
					$accounts_data[] = array(
						'vch_type' 	  => 'RECEIPT',
						'vch_no'  	  => $receipt_code,
						'vch_date'    => $mysqldate,
						'vch_ref'     => '',
						'ledger_code' => $this->input->post('client_code'),
						'rev_ledger_code' => $rev_ledger_code,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> -(float)$xxreceipt_amount,
						'ledger_narration'=> $this->input->post('remarks'),
						'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					//$this->db->insert('accounts', $accounts_data);
				}

				if($xxreceipt_discount>0){
					$accounts_data[] = array(
						'vch_type' 	  => 'RECEIPT',
						'vch_no'  	  => $receipt_code,
						'vch_date'    => $mysqldate,
						'vch_ref'     => '',
						'ledger_code' => 'D0002',
						'rev_ledger_code' => $this->input->post('client_code'),
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> $xxreceipt_discount,
						'ledger_narration'=> $this->input->post('remarks'),
						'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					//$this->db->insert('accounts', $accounts_data);
				}

				if($this->input->post('cash')!==''){
					$paidData = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cash'),
						'name' 				=> 'Paid Amount',
						'payment_mode' 		=> 'Paid Amount'
					);
					$this->db->insert('receipt_payment_details', $paidData);
					
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> ((float)$this->input->post('i_total'))-((float)$this->input->post('bank_amt')+(float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
						'name' 				=> 'Cash',
						'payment_mode' 		=> 'Cash'
					);
					$this->db->insert('receipt_payment_details', $data);
					if($this->input->post('cash_check')==1){
						$cash_ledger_code=$this->input->post('cash_ledgers');
					} else {
						$cash_ledger_code=$this->input->post('cash_ledger_code');
					}
					if($cash_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Cash',
							'ledger_code' => $cash_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'  => ((float)$this->input->post('i_total'))-((float)$this->input->post('bank_amt')+(float)$this->input->post('c_card')+(float)$this->input->post('cheque_amt')+(float)$this->input->post('wallet_amnt')),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}
				}
				if($this->input->post('bank_amt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('bank_amt'),
						'authorized' 		=> NULL,
						'name' 				=> $this->input->post('bank_name'),
						'payment_mode' 		=> 'Bank Transfer'
					);
					$this->db->insert('receipt_payment_details', $data);
					if($this->input->post('bank_check')==1){
						$bank_ledger_code	=	$this->input->post('bank_ledgers');
					} else {
						$bank_ledger_code	=	$this->input->post('bank_ledger_code');
					}
					if($bank_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Bank Transfer',
							'ledger_code' => $bank_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('bank_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}	
				}

				if($this->input->post('c_card')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('c_card'),
						'authorized' 		=> $this->input->post('authorized'),
						'name' 				=> $this->input->post('c_type'),
						'payment_mode' 		=> 'Credit Card'
					);
					$this->db->insert('receipt_payment_details', $data);
					if($this->input->post('c_card_check')==1){
						$c_card_ledger_code	=	$this->input->post('c_card_ledgers');
					} else {
						$c_card_ledger_code	=	$this->input->post('c_card_ledger_code');
					}
					if($c_card_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Credit Card',
							'ledger_code' => $c_card_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('c_card'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}	
				}
				if($this->input->post('cheque_amt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('cheque_amt'),
						'authorized' 		=> $this->input->post('cheque_no'),
						'name' 				=> $this->input->post('cheque_bank'),
						'payment_mode' 		=> 'Cheque'
					);
					$this->db->insert('receipt_payment_details', $data);
					if($this->input->post('cheque_check')==1){
						$cheque_ledger_code	=	$this->input->post('cheque_ledgers');
					} else {
						$cheque_ledger_code	=	$this->input->post('cheque_ledger_code');
					}
					if($cheque_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Cheque',
							'ledger_code' => $cheque_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('cheque_amt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						//$this->db->insert('accounts', $accounts_data);
					}
					
				}
				if($this->input->post('wallet_amnt')!=''){
					$data = array(
						'receipt_id' 		=> $receipt_id,
						'amount' 			=> $this->input->post('wallet_amnt'),
						'authorized' 		=> $this->input->post('wallet_authorized'),
						'name' 				=> $this->input->post('wallet_type'),
						'payment_mode' 		=> 'Wallet'
					);
					$this->db->insert('receipt_payment_details', $data);
					if($this->input->post('wallet_check')==1){
						$wallet_ledger_code	=	$this->input->post('wallet_ledgers');
					} else {
						$wallet_ledger_code	=	$this->input->post('wallet_ledger_code');
					}
					if($wallet_ledger_code!=''){
						$accounts_data[] = array(
							'vch_type' 	  => 'RECEIPT',
							'vch_no'  	  => $receipt_code,
							'vch_date'    => $mysqldate,
							'vch_ref'     => 'Wallet',
							'ledger_code' => $wallet_ledger_code,
							'rev_ledger_code' => $this->input->post('client_code'),
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> $this->input->post('wallet_amnt'),
							'ledger_narration'=> $this->input->post('remarks'),
							'vch_narration'=> 'Auto entry from Receipt No '.$receipt_code,
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						
					}
					
				}
				$this->db->insert_batch('accounts', $accounts_data);
			}
			
			$log_data=array(
				'trans_no'  	=>  $receipt_code,
				'trans_type'  	=>  'Receipt',
				'trans_op'  	=>  'Create',
				'trans_user_id' =>  $this->session->userdata('user_id')
	
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$account_result =$this->furniture_quotation_model->validate_debit_or_credit($receipt_code,'RECEIPT');
			if($account_result===false){
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Debit amount and Credit amount are not equal...');	
				redirect('Receipt/list_receipt');
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
				redirect('Receipt/list_receipt');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'New Receipt Created...');	
				redirect('Receipt/list_receipt');
		 	}
		}
	}

	public function save_receipt(){
		
		$no_of_invoices = $this->input->post('no_of_invoices');
		$no_of_confirmed_quotations = $this->input->post('no_of_confirmed_quotations');
		
		$this->form_validation->set_message('amount_check','Amount is invalid or greater than balance');
		$this->form_validation->set_rules('remarks', 'Remarks', 'max_length[48]');
		
		if($this->input->post("payment_modes") != "Cash"){
			$this->form_validation->set_rules('ref_number', 'Reference Number', 'max_length[20]');
			$this->form_validation->set_rules('bank_name', 'Bank Name', 'required|max_length[100]');
		}
		
		if ($this->form_validation->run() == TRUE){
			$receipt_no = $this->furniture_quotation_model->get_new_receipt_number();
		
			for($i=1;$i<=$no_of_invoices;$i++)
			{
				$quotation_id_name = "quotation_id_invoices_".$i;
				$new_receipt_tick ="new_receipt_tick_".$i;
				$quotation_id = $this->input->post($quotation_id_name);
				$receipt_chk = $this->input->post($new_receipt_tick);
				
				if($receipt_chk){
					$current_amount_invoice ="current_amount_invoice_".$i;
					$amount = $this->input->post($current_amount_invoice);
					$this->form_validation->set_rules($current_amount_invoice,'Receipt Amount','required|max_length[20]|numeric|callback_amount_check['.$amount.','.$quotation_id.']');
					if ($this->form_validation->run() == TRUE){
						$receipt['quotation_id'] = $quotation_id;
						$receipt['receipt_number'] = $receipt_no;
						$receipt['receipt_date'] = date("Y-m-d h:m:s");
						$receipt['receipt_mode'] = $this->input->post("payment_modes");
						$receipt['receipt_amount'] = $current_amount_invoice;
						$receipt['receipt_reference'] = $this->input->post("ref_number");
						$receipt['receipt_bankname'] = $this->input->post("bank_name");
						$receipt['receipt_remarks'] = $this->input->post("remarks");
						$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
						
						$this->furniture_quotation_model->set_receipt_id($quotation_id);
						$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						$where= array('receipt_id'=>$generated_receipt_id);
						$this->crud_model->insert('furniture_receipts',$receipt);
					}else{
						echo "Validation Error2";
					}		
				}
				$paid_amount = $this->furniture_quotation_model->get_paid_amount_for_quotation($quotation_id);
				$invoiceWhere = array('quotation_id' => $quotation_id);
				$invoiceData = array('paid_amount' => $paid_amount + $current_amount_invoice);
				$this->crud_model->update('furniture_invoice',$invoiceData,$invoiceWhere);
				
			}
			echo "fgdf".$no_of_confirmed_quotations;
			for($i=1;$i<=$no_of_confirmed_quotations;$i++){
				$quotation_id_name = "quotation_id_quote_".$i;
				$new_receipt_tick ="new_receipt_tick_quote_".$i;
				$quotation_id = $this->input->post($quotation_id_name);
				$receipt_chk = $this->input->post($new_receipt_tick);
				
				if($receipt_chk){
					$current_amount_invoice ="current_amount_confirmed_quote_".$i;
					$amount = $this->input->post($current_amount_invoice);
					$this->form_validation->set_rules($current_amount_invoice,'Receipt Amount','required|max_length[20]|numeric|callback_amount_check['.$amount.','.$quotation_id.']');
					if ($this->form_validation->run() == TRUE){
						$receipt['quotation_id'] = $quotation_id;
						$receipt['receipt_number'] = $receipt_no;
						$receipt['receipt_date'] = date('Y-m-d h:m:s');
						$receipt['receipt_mode'] = $this->input->post("payment_modes");
						$receipt['receipt_amount'] = $this->input->post($current_amount_invoice);
						$receipt['receipt_reference'] = $this->input->post("ref_number");
						$receipt['receipt_bankname'] = $this->input->post("bank_name");
						$receipt['receipt_remarks'] = $this->input->post("remarks");
						$receipt['receipt_generatedby'] = $this->session->userdata("user_id");
						
						$this->furniture_quotation_model->set_receipt_id($quotation_id);
						$generated_receipt_id = $this->session->userdata("furniture_receipt_id");
						$where= array('receipt_id'=>$generated_receipt_id);
						$this->crud_model->insert('furniture_receipts',$receipt);
					}else{
						echo "Validation Error2";
					}
				}
			}
		}else{
			echo "Validation Error1";
		}
		
		redirect('Receipt/list_receipt');
	}
	
	function amount_check($amount,$quotation_id){
		//$quotation_id =$this->session->userdata('receipt_quotation_id');
		$where1= array('quotation_id'=>$quotation_id);
		$data['records'] = $this->crud_model->get('furniture_receipts',$where1);
		$receipt_total = 0;
			if($data['records'] != false) {
				foreach ($data['records'] as $recrd){
					if($recrd['receipt_status'] != 0){
						$receipt_total += $recrd['receipt_amount'];
					}
				}
			}
		$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
		
		$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
		
		if($data['balance']< $amount){
			return false;
		} else{
			if($this->input->post('receipt_amount')<=0){
				return false;
			} else{
				return true;
			}
		}
	}
	
	function filter_receipts(){
	
	}
	
	
	public function cancel_receipt($receipt_number,$quotation_divisionid,$receipt_id,$receipt_code){
		$this->users_model->permission("Receipt", "Delete");
		$this->db->where('receipt_number',$receipt_number);
		$this->db->where('quotation_divisionid',$quotation_divisionid);
				$data = array(
				'receipt_status' => 0,
				'receipt_cancelledby' => $this->session->userdata('user_name'),
				'receipt_cancelled_date' => date('Y-m-d h:m:s')
			);
		$receipt_cancel	= $this->db->update('furniture_receipts', $data);

		$this->db->where('trn_no',$receipt_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('cust_bill_allocations', $data1);

		$this->db->where('vch_no',$receipt_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('accounts', $data1);
				
		$this->db->select('receipt_amount,invoice_id,receipt_discount');
		$this->db->from('furniture_receipts');
		$this->db->where('furniture_receipts.receipt_number', $receipt_number);
		$this->db->where('furniture_receipts.quotation_divisionid', $quotation_divisionid); 
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$paid_amount 			 = $this->furniture_quotation_model->get_paid_amount_for_invoice($row->invoice_id);
				$receipt_discount_amount = $this->furniture_quotation_model->get_receipt_discount_for_invoice($row->invoice_id);
			 	$this->db->where('invoice_id',$row->invoice_id);
				$invdata = array(
					'paid_amount' 		=> $paid_amount-($row->receipt_amount),
					'receipt_discount'  => $receipt_discount_amount-($row->receipt_discount)
				);
				$this->db->update('furniture_invoice', $invdata);
			}
		}

		$log_data=array(
			'trans_no'  	=>  $receipt_code,
			'trans_type'  	=>  'Receipt',
			'trans_op'  	=>  'Delete',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

		if($receipt_cancel){
			$this->session->set_flashdata('response', 'Receipt Cancelled...');
		}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('Receipt/list_receipt');
	}
}

?>