<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');

 class Furniture_Receipt extends CI_Controller {

	public function __construct() {

			parent::__construct();

			if($this->session->userdata('user_logged_in') != true) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
				redirect('login');
			}

			$this->load->library('form_validation');
			$this->load->model('furniture_quotation_model');
			$this->load->helper('cookie');
			$this->load->helper('num_words');

		}

		function index($quotation_id) {
			if(!(isset($quotation_id))){
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>',':old:');
				redirect('furniture/furniture_quotations');
			}
			$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);

			if($quotation_details == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
			}
			if($quotation_details['quotation_status'] != "Confirmed") {
				$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Receipts can be generated only for confirmed quotations.</div>');
				redirect('furniture/furniture_quotations');
			}



			$data['quotation_id'] = $quotation_id;
			$data['quotation_number'] = $quotation_details['quotation_number'];
			$data['revision_number'] = $quotation_details['quotation_revisionnumber'];
			$data['division_code'] = $quotation_details['division_code'];
			$data['currency_code'] = $quotation_details['currency_code'];
			$data['salesman_name'] 	= $quotation_details['salesman_name'];
			$data['project_name'] = $quotation_details['project_name'];
			$data['client_name'] = $quotation_details['client_name'];

			$data['quotation_net_total'] = $quotation_details['quotation_net_total'];

			//$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
                        $data['advance'] = $quotation_details['advance_amount'];
			$where= array('quotation_id'=>$quotation_id);

			$data['records'] = $this->crud_model->get('furniture_receipts',$where,NULL,NULL,'receipt_id','desc');

			$receipt_total = 0;
			if($data['records'] != false) {
				foreach ($data['records'] as $recrd){
					if($recrd['receipt_status'] != 0){
						$receipt_total += $recrd['receipt_amount'];
					}
				}
			}
			$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
			$data['amount_paid']  = $receipt_total;
			


			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/furniture_receipt/furniture_receipt',$data);
			$this->load->view('templates/footer');

		}

		function create($quotation_id,$receipt_mode){
			if($receipt_mode =="new"){
				$data['error_flag'] ="false";
			} else{
				$data['error_flag'] ="true";
			}
			$this->form_validation->set_message('amount_check','Amount is invalid or greater than balance');
			$this->form_validation->set_rules('receipt_amount', 'Receipt Amount', 'required|max_length[20]|numeric|callback_amount_check');
			$this->form_validation->set_rules('remarks', 'Remarks', 'max_length[48]');
			
			if($this->input->post("payment_modes") != "Cash"){
				$this->form_validation->set_rules('ref_number', 'Reference Number', 'max_length[20]');
				$this->form_validation->set_rules('bank_name', 'Bank Name', 'required|max_length[100]');
			}
			
			if ($this->form_validation->run() == FALSE){
				// false section
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);

				$data['quotation_id'] = $quotation_id;
				$data['quotation_number'] = $quotation_details['quotation_number'];
				$data['division_code'] = $quotation_details['division_code'];
				$data['revision_number'] = $quotation_details['quotation_revisionnumber'];
				$data['currency_code'] = $quotation_details['currency_code'];
				$data['salesman_name'] 	= $quotation_details['salesman_name'];
				$data['project_name'] = $quotation_details['project_name'];
				$data['client_name'] = $quotation_details['client_name'];
			
				$data['quotation_net_total'] = $quotation_details['quotation_net_total'];
				$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
				
				$where1= array('quotation_id'=>$quotation_id);
				$data['records'] = $this->crud_model->get('furniture_receipts',$where1);
			
				$receipt_total = 0;
				if($data['records'] != false) {
					foreach ($data['records'] as $recrd){
						if($recrd['receipt_status'] != 0){
							$receipt_total += $recrd['receipt_amount'];
						}
					}
				}
				$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
				$data['amount_paid']  = $receipt_total;				
				
				$this->load->view('templates/header');
				$this->load->view('furniture/quotations/furniture_receipt/create_furniture_receipt',$data);
				$this->load->view('templates/footer');
			} else {	// true
				
				$receipt['receipt_mode'] = $this->input->post("payment_modes");
				$receipt['receipt_amount'] = $this->input->post("receipt_amount");
				$receipt['receipt_reference'] = $this->input->post("ref_number");
				$receipt['receipt_bankname'] = $this->input->post("bank_name");
				$receipt['receipt_remarks'] = $this->input->post("remarks");
				$receipt['receipt_generatedby'] = $this->session->userdata('user_id');
				
				$this->furniture_quotation_model->set_receipt_id($quotation_id);
				$generated_receipt_id = $this->session->userdata('furniture_receipt_id');
				$where= array('receipt_id'=>$generated_receipt_id);
				$this->crud_model->update('furniture_receipts',$receipt,$where);		
				
				
				
				// MAILING ....	
				$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
				$links = site_url().'/furniture/furniture_quotations/view/'.$quotation_id;
				
				$where= array('receipt_id'=>$generated_receipt_id);
				$receipts = $this->crud_model->get('furniture_receipts',$where);
				
				$temp = $receipts[0]['receipt_generatedby'];
				$where= array('user_id'=>$temp);
				$receipts1 = $this->crud_model->get('users',$where);
				
				
				/*	email notification start	*/
				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'QMS Admin';
				$to 		= RECEIPT_NOTIFICATION_EMAIL;
				$subject 	= 'QMS - Furniture Quotation Receipt for '.$quotation_details['client_name'].'('.$quotation_details['division_code'].'-'.$quotation_details['quotation_number'].'-'.$quotation_details['quotation_revisionnumber'].')';
				$message 	= '
				<h2>Receipt Generated</h2><br /><br />
				<h3>Quotation Details</h3>
				<table>
					<tr>
						<td>Quotation No.</td>
						<td>:</td>
						<td><a href='.$links.'>'.$quotation_details['division_code'].'-'.$quotation_details['quotation_number'].'-'.$quotation_details['quotation_revisionnumber'].'</a></td>														
					</tr>
					<tr>
						<td>Client</td>
						<td>:</td>
						<td>'.$quotation_details['client_name'].'</td>
					</tr>
					<tr>
						<td>Salesperson</td>
						<td>:</td>
						<td>'.$quotation_details['salesman_name'].'</td>
					</tr>
					<tr>
						<td>Project Name</td>
						<td>:</td>
						<td>'.$quotation_details['project_name'].'</td>
					</tr>
				</table><br /><br />
				<h3>Receipt Details</h3>
				<table>
					<tr>
						<td>Receipt Number</td>
						<td>:</td>
						<td>'.$quotation_details['division_code'].'-'.$receipts[0]['receipt_number'].'</td>												
					</tr>
					<tr>
						<td>Receipt Date</td>
						<td>:</td>
						<td>'.date('F d, Y',strtotime($receipts[0]['receipt_date'])).'</td>
					</tr>
					<tr>
						<td>Receipt Mode</td>
						<td>:</td>
						<td>'.$receipts[0]['receipt_mode'].'</td>
					</tr>';
				if($receipts[0]['receipt_mode']=="Credit Card")	{
					$message .= '<tr>
							<td>Card Type</td>
							<td>:</td>
							<td>'.$receipts[0]['receipt_bankname'].'</td>
						</tr>';
				}
				if($receipts[0]['receipt_mode']=="Bank" or $receipts[0]['receipt_mode']=="Cheque") {
					$message .= '<tr>
							<td>Reference Number</td>
							<td>:</td>
							<td>'.$receipts[0]['receipt_reference'].'</td>
						</tr>
						<tr>
							<td>Bank Name</td>
							<td>:</td>
							<td>'.$receipts[0]['receipt_bankname'].'</td>
						</tr>';
				}
				$message 	.='<tr>
						<td>Receipt Amount</td>
						<td>:</td>
						<td>'.number_format($receipts[0]['receipt_amount'],3).'</td>
					</tr>
					<tr>
						<td>Generated By</td>
						<td>:</td>
						<td>'.$receipts1[0]['user_name'].'</td>
					</tr>
					<tr>
						<td>Receipt Remarks</td>
						<td>:</td>
						<td>'.$receipts[0]['receipt_remarks'].'</td>
					</tr>					
				</table>
				';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);

				/*	email notification end		*/				
				
				$this->session->set_flashdata('response','<div class="alert alert-success">Receipt Generated Successfully</div>',':old:');
				redirect('furniture/furniture_receipt/index/'.$quotation_id);		
				
			}
			
		} // Ending of Create Function
		
		function view($quotation_id,$receipt_id){

			$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id,'unique');
			$currency_code = $records['currency_code'];

			$where= array('receipt_id'=>$receipt_id);
			$data['records'] = $this->crud_model->get('furniture_receipts',$where);

			$data['base_url'] = base_url();

                        $data['logos_url'] = array();
			$logos_id = explode(",",$records['quotation_logos']);
			foreach($logos_id as $key=>$logo_id) {
				$where = array('logo_id' => $logo_id);
				$logo = $this->crud_model->get('logos',$where);
				if($logo[0]['logo_filename']){
					array_push($data['logos_url'], $logo[0]['logo_filename']);
				}
			}

			$where = array('quotation_id'=>$quotation_id);
			$generated_receipts = $this->crud_model->get('furniture_receipts',$where);
			
			
			if($data['records'][0]['receipt_status']) {
				$receipt_total = 0;
				if($generated_receipts != false) {
					foreach ($generated_receipts as $receipt){
						if($receipt['receipt_status'] != 0 and $receipt['receipt_id'] <= $data['records'][0]['receipt_id']){
							$receipt_total += $receipt['receipt_amount'];
						}
					}
				}
				$data['balance'] = $records['quotation_net_total'] - $receipt_total;
				$data['amount_paid']  = $receipt_total;
			} else {
				$data['cancel_flag'] = 1;
			}


			$data['receipt_number'] = $data['records'][0]['receipt_number'];
			$data['receipt_date'] = $data['records'][0]['receipt_date'];
			$data['receipt_mode'] = $data['records'][0]['receipt_mode'];
			$data['receipt_amount'] = $data['records'][0]['receipt_amount'];
			$data['receipt_remarks'] = $data['records'][0]['receipt_remarks'];
			$data['receipt_bankname'] = $data['records'][0]['receipt_bankname'];
			
			$data['quotation_number'] = $records['division_code'].'-'.$records['quotation_number'].'-'.$records['quotation_revisionnumber'];
			$data['quotation_net_total'] = $records['quotation_net_total'];

		
			
			$temp = $data['records'][0]['receipt_generatedby'];
			$where= array('user_id'=>$temp);
			$generated_by_user = $this->crud_model->get('users',$where);
			$data["generated_by"] = $generated_by_user[0]['user_name'];

			
			$data["received_from"] = $records['client_name'];
			$data["receipt_code"] = $records["division_code"];
			$data["currency_code"] = $currency_code;
	
			$data['receipt_amount'] = $data['records'][0]["receipt_amount"];
			
			$data['currency_name'] = $records['currency_name'];
			
			
	
			$this->load->view('furniture/quotations/furniture_receipt/view_receipt', $data);
		} // End of receipt view
		
		
		function view1($quotation_id,$receipt_no,$quotation_divisionid,$type){

			$where= array('receipt_number'=>$receipt_no);
			$data['records'] = $this->furniture_quotation_model->get_receipt_details($receipt_no,$quotation_id,$quotation_divisionid);
			$data['receipt_inv'] = $this->furniture_quotation_model->get_all_receipts_invdetails($receipt_no,$quotation_id,$quotation_divisionid);
			$data['receipt_pay'] = $this->furniture_quotation_model->get_all_receipts_paydetails($receipt_no,$quotation_id,$quotation_divisionid);
			$data['base_url'] = base_url();

            $data['logos_url'] = array();

			$this->db->select('user_email_id,client_email,quotation_logos');    
			$this->db->from('furniture_receipts');
			$this->db->join('receipts_details', 'furniture_receipts.receipt_id = receipts_details.receipt_id');
			$this->db->join('furniture_invoice', 'furniture_receipts.invoice_id = receipts_details.invoice_id');
			$this->db->join('furniture_quotation', 'furniture_invoice.quotation_id = furniture_quotation.id');
			$this->db->join('new_client_master', 'furniture_quotation.client_id = new_client_master.client_id');
			$this->db->join('users', 'furniture_quotation.salesman_id = users.user_id');
			$this->db->where('furniture_receipts.receipt_id',$quotation_id);
			$query_val = $this->db->get(); 
						
						
						foreach ($query_val->result() as $row){
							$user_email_id =  $row->user_email_id;
							$client_email =  $row->client_email;
							$quotation_logos =  $row->quotation_logos;
						}
						if(isset($quotation_logos)){
							$logos_id = explode(",",$quotation_logos);
						}
						/*foreach($logos_id as $key=>$logo_id) {
							$where = array('logo_id' => $logo_id);
							$logo = $this->crud_model->get('logos',$where);
							if($logo==true){
								array_push($data['logos_url'], $logo[0]['logo_filename']);
							}else{
								array_push($data['logos_url'], $data['records'][0]['logo_filename']);
						}
			}*/
			array_push($data['logos_url'], $data['records'][0]['logo_filename']);
			
			//$where = array('quotation_id'=>$quotation_id);
			$generated_receipts = $this->furniture_quotation_model->get_generated_receipts($quotation_id);
			$data['amount_paid'] = $generated_receipts[0]['rcpt_amount'] ;

			$data['receipt_id'] = $data['records'][0]['receipt_id'];
			$data['receipt_code'] = $data['records'][0]['receipt_code'];
			$data['receipt_number'] = $data['records'][0]['receipt_number'];
			$data['division_code'] = $data['records'][0]['division_code'];
			$data['currency_code'] = $data['records'][0]['currency_code'];
			$data['receipt_date'] = $data['records'][0]['receipt_date'];
			$data['receipt_mode'] = $data['records'][0]['receipt_mode'];
			$data['receipt_amount'] = $data['records'][0]['receipt_amount'];
			$data['receipt_discount'] = $data['records'][0]['receipt_discount'];
			$data['receipt_remarks'] = $data['records'][0]['receipt_remarks'];
			$data['receipt_bankname'] = $data['records'][0]['receipt_bankname'];
			$data['receipt_reference'] = $data['records'][0]['receipt_reference'];
			$data['currency_name1'] = $data['records'][0]['currency_name'];
			$data['receipt_status'] = $data['records'][0]['receipt_status'];
			$data['division_id'] = $data['records'][0]['division_id'];
			$data['division_code'] = $data['records'][0]['division_code'];
			$data['logo_filename'] = $data['records'][0]['logo_filename'];
			$data['client_code'] = $data['records'][0]['client_code'];
			$data['cheque_date'] = $data['records'][0]['cheque_date'];

			$temp = $data['records'][0]['receipt_generatedby'];
			$where= array('user_id'=>$temp);
			$generated_by_user = $this->crud_model->get('users',$where);
			$data["generated_by"] = $generated_by_user[0]['user_name'];


			$data["received_from"] = $data['records'][0]['client_name'];

			$data['receipt_amount'] = $data['records'][0]["receipt_amount"];

			$data['quotation_id'] = $quotation_id;
			
			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row();
			foreach ($query->result() as $row){
				$company_email_name =  $row->company_name;
			}
			
			if($type=="pdf"){
				$records['print_type'] = "pdf_print_type";
				//$this->load->helper(array('dompdf', 'file'));
				$mpdf = new \Mpdf\Mpdf();
				$html = $this->load->view('furniture/quotations/furniture_receipt/view_receipt1', $data, true);
				//echo $html;
				$mpdf->WriteHTML($html);
				$file_name	=	'Receipt Voucher - '.$data['records'][0]['receipt_code'].'.pdf';
       			$mpdf->Output($file_name, 'I');
			}else if($type=="normal"){
				$records['print_type'] = "normal_print_type";
				$this->load->view('furniture/quotations/furniture_receipt/view_receipt', $data);
				$this->load->view('furniture/quotations/furniture_receipt/test_print');
				$this->load->view('furniture/quotations/furniture_receipt/view_receipt', $data);
			}else if($type=="email"){
			
				$this->db->select('*');
				$this->db->from('emails'); 
				$query_email = $this->db->get();
				$records_email=$query_email->result_array();
			
				$records['print_type'] = "email_print_type";
				$this->load->helper(array('dompdf', 'file'));
				$html = $this->load->view('furniture/quotations/furniture_receipt/view_receipt1', $data, true);
				pdf_create($html, 'Receipt_No_'.$quotation_id,$stream=FALSE);
						
						
						$from 		= $user_email_id;
						$fromname 	= $company_email_name;
						$to 		= $client_email;
						$cc 		= @$records_email[0]['receipt_cc'];
						$subject 	= 'Receipt';
						$message 	= 'Please find attached receipt';
						$this->load->library('receipt_email');
						$send = $this->receipt_email->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$quotation_id);
						if($send){
							$this->session->set_flashdata('response','<div class="alert alert-success">Email Send Successfully</div>');
						}else{
							$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
						}
						redirect('receipt');
			}
		
		} // End of receipt view1

		function cancel($receipt_id, $confirm_cancel, $quotation_id){
			if($confirm_cancel == "0"){
				$data['receipt_id'] = $receipt_id;
				$data['quotation_id'] = $quotation_id;
				
				
				$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
				$data['quotation_number'] = $quotation_details['quotation_number'];
				$data['revision_number'] = $quotation_details['quotation_revisionnumber'];
				$data['division_code'] = $quotation_details['division_code'];
				$data['currency_code'] = $quotation_details['currency_code'];
				$data['salesman_name'] 	= $quotation_details['salesman_name'];
				$data['project_name'] = $quotation_details['project_name'];
				$data['client_name'] = $quotation_details['client_name'];
				$where1= array('quotation_id'=>$quotation_id);
				$data['records'] = $this->crud_model->get('furniture_receipts',$where1);
			
				$receipt_total = 0;
				if($data['records'] != false) {
					foreach ($data['records'] as $recrd){
						if($recrd['receipt_status'] != 0){
							$receipt_total += $recrd['receipt_amount'];
						}
					}
				}
				$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
				$data['amount_paid']  = $receipt_total;
		
				$data['quotation_net_total'] = $quotation_details['quotation_net_total'];
			
				$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
				
				
				$where= array('receipt_id'=>$receipt_id);
				$receipts = $this->crud_model->get('furniture_receipts',$where);
				$data['quotation_id'] = $receipts[0]['quotation_id'];
				$data['receipt_number'] = $receipts[0]['receipt_number'];
				$data['receipt_date'] = $receipts[0]['receipt_date'];
				$data['receipt_status'] = $receipts[0]['receipt_status'];
				$data['receipt_mode'] = $receipts[0]['receipt_mode'];
				$data['receipt_amount'] = $receipts[0]['receipt_amount'];
				$data['receipt_reference'] = $receipts[0]['receipt_reference'];
				$data['receipt_bankname'] = $receipts[0]['receipt_bankname'];
				$data['receipt_remarks'] = $receipts[0]['receipt_remarks'];
				$data['receipt_generatedby'] = $receipts[0]['receipt_generatedby'];
				$data['receipt_cancelledby'] = $receipts[0]['receipt_cancelledby'];
				$where= array('user_id'=>$data['receipt_generatedby']);
				$receipts1 = $this->crud_model->get('users',$where);
				$data['generated_user'] = $receipts1[0]['user_name'];
				$where= array('user_id'=>$data['receipt_cancelledby']);
				$receipts1 = $this->crud_model->get('users',$where);
				$data['cancelled_user'] = $receipts1[0]['user_name'];
				$data['flag'] = "cancel";
				$this->load->view('templates/header');
				$this->load->view('furniture/quotations/furniture_receipt/receipt_details',$data);
				$this->load->view('templates/footer');
			} else {
				$data['receipt_status'] ="0";
				$data['receipt_cancelledby'] =$this->session->userdata('user_id');
				$data['receipt_cancelled_date'] =date('Y-m-d h:m:s');
				$where= array('receipt_id'=>$receipt_id);
				$this->crud_model->update('furniture_receipts',$data,$where);

				
				// MAILING ....	
				$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
				$links = site_url().'/furniture/furniture_quotations/view/'.$quotation_id;
				
				$where= array('receipt_id'=>$receipt_id);
				$receipts = $this->crud_model->get('furniture_receipts',$where);
				
				$temp = $receipts[0]['receipt_generatedby'];
				$where= array('user_id'=>$temp);
				$receipts1 = $this->crud_model->get('users',$where);
				
				$temp = $receipts[0]['receipt_cancelledby'];
				$where= array('user_id'=>$temp);
				$receipts2 = $this->crud_model->get('users',$where);
				
				
				/*	email notification start	*/
				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'QMS Admin';
				$to 		= RECEIPT_NOTIFICATION_EMAIL;
				$subject 	= 'QMS - Furniture Quotation Receipt for '.$quotation_details['client_name'].'('.$quotation_details['division_code'].'-'.$quotation_details['quotation_number'].'-'.$quotation_details['quotation_revisionnumber'].')';
				$message 	= '
				<h2>Receipt Cancelled.</h2><br /><br />
				<h3>Quotation Details</h3>
				<table>
					<tr>
						<td>Quotation No.</td>
						<td>:</td>
						<td><a href='.$links.'>'.$quotation_details['division_code'].'-'.$quotation_details['quotation_number'].'-'.$quotation_details['quotation_revisionnumber'].'</a></td>														
					</tr>
					<tr>
						<td>Client</td>
						<td>:</td>
						<td>'.$quotation_details['client_name'].'</td>
					</tr>
					<tr>
						<td>Salesperson</td>
						<td>:</td>
						<td>'.$quotation_details['salesman_name'].'</td>
					</tr>
					<tr>
						<td>Project Name</td>
						<td>:</td>
						<td>'.$quotation_details['project_name'].'</td>
					</tr>
				</table><br /><br />
				<h3>Receipt Details</h3>
				<table>
					<tr>
						<td>Receipt Number</td>
						<td>:</td>
						<td>'.$quotation_details['division_code'].'-'.$receipts[0]['receipt_number'].'</td>														
					</tr>
					<tr>
						<td>Receipt Date</td>
						<td>:</td>
						<td>'.date('F d, Y',strtotime($receipts[0]['receipt_date'])).'</td>
					</tr>
					<tr>
						<td>Receipt Mode</td>
						<td>:</td>
						<td>'.$receipts[0]['receipt_mode'].'</td>
					</tr>';
				if($receipts[0]['receipt_mode']=="Credit Card")	{
					$message .= '<tr>
							<td>Card Type</td>
							<td>:</td>
							<td>'.$receipts[0]['receipt_bankname'].'</td>
						</tr>';
				}
				if($receipts[0]['receipt_mode']=="Bank" or $receipts[0]['receipt_mode']=="Cheque") {
					$message .= '<tr>
							<td>Reference Number</td>
							<td>:</td>
							<td>'.$receipts[0]['receipt_reference'].'</td>
						</tr>
						<tr>
							<td>Bank Name</td>
							<td>:</td>
							<td>'.$receipts[0]['receipt_bankname'].'</td>
						</tr>';
				}
				$message 	.='<tr>
						<td>Receipt Amount</td>
						<td>:</td>
						<td>'.number_format($receipts[0]['receipt_amount'],3).'</td>
					</tr>
					<tr>
						<td>Generated By</td>
						<td>:</td>
						<td>'.$receipts1[0]['user_name'].'</td>
					</tr>
					<tr>
						<td>Receipt Remarks</td>
						<td>:</td>
						<td>'.$receipts[0]['receipt_remarks'].'</td>
					</tr>
					<tr>
						<td>Cancelled By</td>
						<td>:</td>
						<td>'.$receipts2[0]['user_name'].'</td>
					</tr>					
				</table>
				';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);

				/*	email notification end		*/
				
				$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
				
				$data['quotation_id'] = $quotation_id;
				$data['quotation_number'] = $quotation_details['quotation_number'];
				$data['division_code'] = $quotation_details['division_code'];
				$data['revision_number'] = $quotation_details['quotation_revisionnumber'];				
				$data['salesman_name'] 	= $quotation_details['salesman_name'];
				$data['project_name'] = $quotation_details['project_name'];
				$data['client_name'] = $quotation_details['client_name'];
			
				$data['quotation_net_total'] = $quotation_details['quotation_net_total'];
				$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
				
				$where= array('quotation_id'=>$quotation_id);
				
				$data['records'] = $this->crud_model->get('furniture_receipts',$where);
				
				redirect('furniture/furniture_receipt/index/'.$quotation_id);
			}
				
		} // Ending of the Function Cancel
		
		function details($receipt_id,$status,$quotation_id){
		
			$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
			$data['quotation_number'] = $quotation_details['quotation_number'];
			$data['division_code'] = $quotation_details['division_code'];
			$data['revision_number'] = $quotation_details['quotation_revisionnumber'];
			$data['currency_code'] = $quotation_details['currency_code'];
			$data['salesman_name'] 	= $quotation_details['salesman_name'];
			$data['project_name'] = $quotation_details['project_name'];
			$data['client_name'] = $quotation_details['client_name'];
			$where1= array('quotation_id'=>$quotation_id);
			$data['records'] = $this->crud_model->get('furniture_receipts',$where1);
			$receipt_total = 0;
				if($data['records'] != false) {
					foreach ($data['records'] as $recrd){
						if($recrd['receipt_status'] != 0){
							$receipt_total += $recrd['receipt_amount'];
						}
					}
				}
			$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
			$data['amount_paid']  = $receipt_total;
			$data['quotation_net_total'] = $quotation_details['quotation_net_total'];
			$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
			
			$where= array('receipt_id'=>$receipt_id);
			$receipts = $this->crud_model->get('furniture_receipts',$where);
			$data['quotation_id'] = $receipts[0]['quotation_id'];
			$data['receipt_number'] = $receipts[0]['receipt_number'];
			$data['receipt_date'] = $receipts[0]['receipt_date'];
			$data['receipt_status'] = $receipts[0]['receipt_status'];
			$data['receipt_mode'] = $receipts[0]['receipt_mode'];
			$data['receipt_amount'] = $receipts[0]['receipt_amount'];
			$data['receipt_reference'] = $receipts[0]['receipt_reference'];
			$data['receipt_bankname'] = $receipts[0]['receipt_bankname'];
			$data['receipt_remarks'] = $receipts[0]['receipt_remarks'];
			$data['receipt_generatedby'] = $receipts[0]['receipt_generatedby'];
			$data['receipt_cancelledby'] = $receipts[0]['receipt_cancelledby'];
			$where= array('user_id'=>$data['receipt_generatedby']);
			$receipts1 = $this->crud_model->get('users',$where);
			$data['generated_user'] = $receipts1[0]['user_name'];
			$where= array('user_id'=>$data['receipt_cancelledby']);
			$receipts1 = $this->crud_model->get('users',$where);
			$data['cancelled_user'] = $receipts1[0]['user_name'];
			$data['flag'] = "details";
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/furniture_receipt/receipt_details',$data);
			$this->load->view('templates/footer');
			
		} // Ending of the function Details.
		
		function amount_check($quotation_id){
			$quotation_id =$this->session->userdata('receipt_quotation_id');
			$where1= array('quotation_id'=>$quotation_id);
			$data['records'] = $this->crud_model->get('furniture_receipts',$where1);
			$receipt_total = 0;
				if($data['records'] != false) {
					foreach ($data['records'] as $recrd){
						if($recrd['receipt_status'] != 0){
							$receipt_total += $recrd['receipt_amount'];
						}
					}
				}
			$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
			
			$data['balance'] = $quotation_details['quotation_net_total'] - $receipt_total;
			
			if($data['balance']< $this->input->post('receipt_amount')){
				return false;
			} else{
				if($this->input->post('receipt_amount')<=0){
					return false;
				} else{
					return true;
				}
			}
		}
	}
	
?>