<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Furniture_quotations_order_form extends CI_Controller {

	function Furniture_quotations_order_form()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->model('furniture_quotation_model');
		$this->load->library('pagination');
	}
	
	function index($quotation_id=0, $search=0) {
	
		// Handling direct URL ( without quotation id )
		if(!$quotation_id) { 
			$this->session->set_flashdata('response','<div class="alert alert-error">Please select a quotation first.</div>',':old:');
			redirect('furniture/furniture_quotations');
		}
		
		$quotation_details = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
		if($quotation_details == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		
		if($quotation_details['quotation_status'] != "Confirmed") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Order form is available only for confirmed quotations.</div>');
			redirect('furniture/furniture_quotations');
		}		
		
		$where=array (
			'quotation_id'=>$quotation_id
		);
		$records=$this->crud_model->get('view_furniture_items_with_brand', $where);
		
		// var_dump($records);
		
		$type_list = array();
		$brand_list = array();
		if($records) {
			foreach($records as $furniture_item) {
				if(!in_array($furniture_item["furniture_brand_name"],$brand_list)) {
					$index = $furniture_item["furniture_brand_id"];
					$brand_list[$index] = $furniture_item["furniture_brand_name"];
					
				}
				$index = $furniture_item["furniture_type"];
				if($index == 1) {
					$type = "Ex-Stock";
				} else {
					$type = "By-Order";
				}
				
				if(!in_array($index, $type_list)) {
					$type_list[$index]=$type;
				}
			}
		}
		// To get the quotation number.
		
		$where=array (
			'quotation_id'=>$quotation_id
		);			
		$records=$this->crud_model->get('view_furniture_quotations_client_project_users_all', $where);
		$data["quotation_number"] = $records[0]["division_code"]."-".$records[0]["quotation_number"]."-".$records[0]["quotation_revisionnumber"];
		$data["quotation_id"] = $quotation_id;
		
		$data["type_list"] = $type_list;
		$data["brand_list"] = $brand_list;
		
		$user_id = $this->session->userdata('user_id');
		$where=array ('user_id' => $user_id);	
		$records=$this->crud_model->get('users', $where);
		
		
		
			
		if($search == 1) { //  Search results page ....
		
			$furniture_type = $this->input->post('furniture_type');
			$brand = $this->input->post('brand_list');
			
			$data["results_page"] = 1;
			$data["furniture_type"] = $furniture_type;
			$data["furniture_brand"] = $brand;
			
			
			$where=array (
				'quotation_id' => $quotation_id,
				'furniture_type'=>$furniture_type,
				'furniture_brand_id'=>$brand
			);	

			$records=$this->crud_model->get('view_furniture_items_with_brand', $where);
			if($records) {
				$data["found"] = 1;
				$data["results"] = $records; 
			}					
		} 	
		if($search == 2) {  // Send EMail...
			
			$where=array (
				'quotation_id' => $quotation_id,
				'furniture_type' => $this->input->post("furniture_type"),
				'furniture_brand_id' => $this->input->post("brand_list")
			);	

			$records=$this->crud_model->get('view_furniture_items_with_brand', $where);
			if($records) {
				 $where=array (
					'quotation_id' => $quotation_id,
				);
				$details=$this->crud_model->get('view_furniture_quotations_client_project_users', $where);
				if($this->input->post("furniture_type") == 1){
					$furniture_type = "Ex Stock";
				}else{
					$furniture_type = "By Order";
				}	
				$brand_name = $records[0]['furniture_brand_name'];
				$client_name = $details[0]['client_name'];
				$quotation_details = 	'<table border="1" style="width:700px;" > 
											<tr>
												<td><b>Type</b></td>
												<td>' .$furniture_type .'</td>
												<td><b>Quotation Number</b></td>
												<td>'.$data["quotation_number"].'</td>
											</tr>
											<tr>
												<td><b>Brand</b></td>
												<td>'. $brand_name .'</td>
												<td><b>Client Name</b></td>
												<td>'.$client_name.'</td>
											</tr>
										</table><br />'; 
				 
				$table_html = $quotation_details;
				$table_html .= '<table border="1" style="width:800px;">
								<tbody><tr><th align="left">#</th>
                        <th align="left">Reference</th>
                        <th align="left">Model</th>
                        <th align="left">Description</th>
                        <th align="left">Upholstery</th>
                        <th align="right">Quantity</th></tr>';
				$i=0; 
				
				$records=html_escape($records);
				foreach($records as $furniture_items) { 
					$i++; 					
					$table_html .= '<tr><td>'.$i.'</td><td>'.$furniture_items['furniture_reference'].'</td><td>'.$furniture_items['furniture_model'].'</td><td>'.$furniture_items['furniture_description'].'</td><td>'.$furniture_items['furniture_upholstery'].'</td><td align="right">'.$furniture_items['furniture_quantity'].'</td></tr>';
				} 
				$table_html .= '</tbody></table>'; 
				
				/*	email notification start	*/

				$this->load->library('tw_email');
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'QMS Admin';
				$to 		= $this->session->userdata('user_email_id');
				$subject 	= "Order Form for Quotation : ".$data["quotation_number"];
				$message	= $table_html;

				$ret = $this->tw_email->send($from,$fromname,$to,$subject,$message);
				
				if($ret) {
					echo "1";
				}

				/*	email notification end		*/
				return;			
						
			}
		} else {
			$this->load->view('furniture/quotations/furniture_quotations_order_form/furniture_quotations_order_form',$data);
						
		}		
	}	
}

?>