<?php
class AccountsGroup extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}

	function test() {
		$title['headerTitle']="Group Create";
		$data['list']='';
		$group_datas = $this->db->query("SELECT * FROM `account_group` WHERE status='1' group by `acc_group_primary` ");
		foreach($group_datas->result_array() as $group_data){
			if($group_data['acc_group_primary']=='1'){
				$acc_group_primary='Liability';
			} else if($group_data['acc_group_primary']=='2'){
				$acc_group_primary='Asset';
			} else if($group_data['acc_group_primary']=='3'){
				$acc_group_primary='Income';
			} else if($group_data['acc_group_primary']=='4'){
				$acc_group_primary='Expence';
			} else {
				$acc_group_primary='';
			} 
			$data['list'].='<tr>
				<td><b>' .$acc_group_primary.'</b></td>
				<td></td>
			</tr>';
			$acc_group_primary_id=$group_data['acc_group_primary'];
			$sub_datas = $this->db->query("SELECT * FROM `account_group` WHERE status='1' and acc_group_parent='0' and acc_group_primary='$acc_group_primary_id' ");
			foreach($sub_datas->result_array() as $sub_data){
				$acc_group_id	=	$sub_data['acc_group_id'];
				$data['list'].='<tr>
					<td>&nbsp;&nbsp;&nbsp;&nbsp;' .$sub_data['acc_group_name'].'</td>
					<td>&nbsp;&nbsp;&nbsp;&nbsp;' .$sub_data['sort_option'].'</td>
					<td></td>
				</tr>';

				
				$data['list'].=$this->loop_function($acc_group_id,$acc_group_primary_id);

				/*

				*/
			}
		}
		$this->load->view('templates/header',$title);
		$this->load->view('masters/accounts_group/test',$data);
		$this->load->view('templates/footer');
	}

	function loop_function($acc_group_id,$acc_group_primary_id){
		$list='';
		$sub_sub_datas = $this->db->query("SELECT * FROM `account_group` WHERE status='1' and acc_group_parent='$acc_group_id' and acc_group_primary='$acc_group_primary_id' ");
		foreach($sub_sub_datas->result_array() as $sub_sub_data){
			$list.='<tr>
				<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' .$sub_sub_data['acc_group_name'].' ,' .$acc_group_id.', ' .$sub_sub_data['acc_group_parent'].'</td>
				<td></td>
			</tr>';
			$sub_sub_data['acc_group_parent'];
			if($acc_group_id!=$sub_sub_data['acc_group_parent']){
				$data['list'].=$this->loop_function($acc_group_id,$acc_group_primary_id);
			}
		}
		return $list;
	}

	function index($page=1)	{
		$this->users_model->permission("AccountsGroup","View");
		$title['headerTitle']="Group List";
		$config['per_page']		= 50;
		$config['base_url'] 	= site_url('masters/AccountsGroup/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('account_group',array('status'=>1));

		$offset = ($page-1) * $config['per_page'];

		$this->db->select('AG.acc_group_id,AG.acc_group_code,AG.acc_group_name,AG.acc_group_parent,AG.acc_group_primary,AG.is_revenue,AG.sort_option,AG.affects_gross_profit,AG.status,AG2.acc_group_name as parent_acc_group_name');
		$this->db->from('account_group as AG');
		$this->db->join('account_group AS AG2','AG.acc_group_parent = AG2.acc_group_id','left');
		$this->db->where('AG.status', 1);
		$this->db->limit($config['per_page'], $offset);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$data['records'] = $rs->result_array();
		}else{
			$data['records'] = false;
		}
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/accounts_group/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("AccountsGroup","Add");
		$title['headerTitle']="Accounts Group Create";
	//	$data['under_list'] = $this->crud_model->get_list3('acc_group_id','acc_group_primary','is_revenue','affects_gross_profit','acc_group_name','account_group',array('isparent'=>'Primary'),array('acc_group_parent'=>0,'status'=>1));
		$data['under_list'] = $this->crud_model->get_list3('acc_group_id','acc_group_primary','is_revenue','affects_gross_profit','acc_group_name','account_group',array('isparent'=>'Primary'),array('acc_group_parent'=>0 ,'status'=>1),array( 'acc_group_id' => 17));

		$this->load->view('templates/header',$title);
		$this->load->view('masters/accounts_group/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("AccountsGroup","Edit");
		$title['headerTitle']="Accounts Group Edit";
		$where=array(
				'acc_group_id' => $id
		);
		$records=$this->crud_model->get('account_group',$where);

		$this->form_validation->set_rules('acc_group_name', 'Group Name', 'required');
		$this->form_validation->set_rules('acc_group_primary', 'Under', 'required');
		$this->form_validation->set_rules('acc_group_parent', 'Primary Group', 'required');

		if ($this->form_validation->run() == FALSE) {
			if($records != false){
				//true section
				$data['acc_group_id']	  = $records[0]['acc_group_id'];
				$data['acc_group_code']	  = $records[0]['acc_group_code'];
				$data['acc_group_name']	  = $records[0]['acc_group_name'];
				$data['acc_group_parent'] = $records[0]['acc_group_parent'];
				$data['acc_group_primary']= $records[0]['acc_group_primary'];
				$data['is_revenue']		  = $records[0]['is_revenue'];
				$data['sort_option']	  = $records[0]['sort_option'];
				$data['affects_gross_profit']= $records[0]['affects_gross_profit'];
				$data['status']			  = $records[0]['status'];
				$data['comments']			  = $records[0]['comments'];

				$data['under_list'] = $this->crud_model->get_list3('acc_group_id','acc_group_primary','is_revenue','affects_gross_profit','acc_group_name','account_group',array('isparent'=>'Primary'),array('acc_group_parent'=>0,'status'=>1),array( 'acc_group_id' => 17));				
				$this->load->view('templates/header',$title);
				$this->load->view('masters/accounts_group/edit',$data);
				$this->load->view('templates/footer');

			} else {
				//false section
				$this->session->set_flashdata('response','Something went wrong please try later');
				redirect('masters/AccountsGroup');
			}
		} else {

			$acc_group_name=$this->input->post('acc_group_name');
			
			if($this->input->post('acc_group_parent2')==='isparent'){
				$acc_group_parent=0;
				$acc_group_primary=$this->input->post('acc_group_primary');
			} else {
				$array_of_words =	explode(':nb:',$this->input->post('acc_group_parent2'));
				$acc_group_parent	=	$array_of_words[0];
				$acc_group_primary	=	$array_of_words[1];
			}
			
			$sort_option=$this->input->post('sort_option');
			$is_revenue=$this->input->post('is_revenue');
			$affects_gross_profit=$this->input->post('affects_gross_profit');
			
			$data=array(
				'acc_group_name' => $acc_group_name,
				'acc_group_parent' => $acc_group_parent,
				'acc_group_primary' => $acc_group_primary,
				'sort_option' => $sort_option,
				'is_revenue' => $is_revenue,
				'affects_gross_profit' => $affects_gross_profit,
				'comments' => $comments,
			);
			$rr=$this->crud_model->update('account_group',$data,$where);
			 
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Accounts Group',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Accounts Group cannot be updated',':old:');
				redirect('masters/AccountsGroup');
			} else {
				// redirect
				$this->session->set_flashdata('success','Accounts Group updated');
				redirect('masters/AccountsGroup');
			}
		} 
	}
	function do_insert() {
		$this->users_model->permission("AccountsGroup","Add");
		$title['headerTitle']="Accounts Group Create";
		$this->form_validation->set_rules('acc_group_name', 'Group Name', 'required');
		$this->form_validation->set_rules('acc_group_primary', 'Under', 'required');
		$this->form_validation->set_rules('acc_group_parent', 'Primary Group', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$data['under_list'] = $this->crud_model->get_list3('acc_group_id','acc_group_primary','is_revenue','affects_gross_profit','acc_group_name','account_group',array('isparent'=>'Primary'),array('acc_group_parent'=>0,'status'=>1),array( 'acc_group_id' => 17));
			$this->load->view('templates/header',$title);
			$this->load->view('masters/accounts_group/create',$data);
			$this->load->view('templates/footer');
		} else {	// true section

			$acc_group_name=$this->input->post('acc_group_name');
			
			if($this->input->post('acc_group_parent2')==='isparent'){
				$acc_group_parent=0;
				$acc_group_primary=$this->input->post('acc_group_primary');
			} else {
				$array_of_words =	explode(':nb:',$this->input->post('acc_group_parent2'));
				$acc_group_parent	=	$array_of_words[0];
				$acc_group_primary	=	$array_of_words[1];
			}
			
			$sort_option=$this->input->post('sort_option');
			$is_revenue=$this->input->post('is_revenue');
			$affects_gross_profit=$this->input->post('affects_gross_profit');
			$comments=$this->input->post('comments');
			
			$data=array(
				'acc_group_name' => $acc_group_name,
				'acc_group_parent' => $acc_group_parent,
				'acc_group_primary' => $acc_group_primary,
				'sort_option' => $sort_option,
				'is_revenue' => $is_revenue,
				'affects_gross_profit' => $affects_gross_profit,
				'comments' => $comments,
			);

			$rr=$this->crud_model->insert('account_group',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Accounts Group',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Accounts Group cannot be inserted',':old:');
				redirect('masters/AccountsGroup');
			} else {
				// redirect
				$this->session->set_flashdata('success','Accounts Group added successfully');
				redirect('masters/AccountsGroup');
			}
		}

	}

	
	function do_delete($unit_id=0) {
		$this->users_model->permission("AccountsGroup","Delete");
		$where=array(
			'unit_id'  => $unit_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('unit_master',$data,$where);

		$this->session->set_flashdata('response','Unit deleted');
		redirect('masters/Unit');
	}
}