<?php
class EmployeeGroup extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("EmployeeGroup", "View");
		$title['headerTitle']	= "Employee Group List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/EmployeeGroup/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('employee_group',array());
		$offset = ($page-1) * $config['per_page'];
		$data['records'] = $this->crud_model->get('employee_group',array(),$config['per_page'],$offset);
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/employee_group/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("EmployeeGroup", "Add");
		$title['headerTitle']="Employee Group Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/employee_group/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("EmployeeGroup", "Edit");
		$title['headerTitle']="Employee Group Edit";
		$where=array(
			'employee_group_id' => $id
		);
		$records=$this->crud_model->get('employee_group',$where);
		if($records != false){
			//true section
			$data['group_name']		  = $records[0]['group_name'];
			$data['employee_group_id']= $records[0]['employee_group_id'];
			$data['status']			  = $records[0]['status'];
			$data['user_status'] 	  = $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/employee_group/edit',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/EmployeeGroup');
		}
	}
	
	function do_insert() {
		$this->users_model->permission("EmployeeGroup", "Add");
		$title['headerTitle']="Employee Group Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/employee_group/create');
			$this->load->view('templates/footer');
		} else {	// true section
			$name=$this->input->post('name');
			$data=array(
				'group_name' => $name,
				'created_id' => $this->session->userdata('user_id'),
				'status' => 1
			);
			$rr=$this->crud_model->insert('employee_group',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Group',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Employee Group cannot be inserted',':old:');
				redirect('masters/EmployeeGroup');
			} else {
				// redirect
				$this->session->set_flashdata('success','Employee Group added successfully');
				redirect('masters/EmployeeGroup');
			}
		}
	}

	function do_update() {
		$this->users_model->permission("EmployeeGroup", "Edit");
		$title['headerTitle']="Employee Category Edit";
		$employee_group_id = ascii_to_entities($this->input->post('employee_group_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("employee_group_id"=>$employee_group_id);
			$records=$this->crud_model->get('employee_group', $where);
			if($records != false){
				//true section
				$data['group_name']		  = $records[0]['group_name'];
				$data['employee_group_id']= $records[0]['employee_group_id'];
				$data['status']			  = $records[0]['status'];
				$data['user_status'] 	  = $this->config->item('user_status_array');

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/employee_group/edit',$data);
				$this->load->view('templates/footer');
			} 
		} else {// true section
			$name=$this->input->post('name');
			$where=array(
				'employee_group_id'  => $employee_group_id
			);
			$data=array(
				'group_name' => $name,
				'created_id' => $this->session->userdata('user_id'),
				'status' => $status
			);
			$records=$this->crud_model->update('employee_group',$data,$where);

			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Group',	
				'masters_id'=>$employee_group_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Employee Group updated');
			redirect('masters/EmployeeGroup');
		}
	}
	function do_delete($department_id=0) {
		$this->users_model->permission("EmployeeGroup", "Delete");
		$where=array(
			'employee_group_id'  => $employee_group_id
		);
		$data=array('status' => 0);
		$records=$this->crud_model->update('emp_category',$data,$where);

		$this->session->set_flashdata('success','Employee Group deleted');
		redirect('masters/EmployeeGroup');
	}
}