<?php
class Item_description_template extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$title['headerTitle']="Item Description Template List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/Item_description_template/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('item_description_template',array());
		$offset = ($page-1) * $config['per_page'];

		$this->db->select('*' );
		$this->db->from('item_description_template');
		$this->db->limit($config['per_page'], $offset);
		$rs = $this->db->get();
		$data['records'] =	$rs->result_array();
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/item_description_template/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$title['headerTitle']="Item Description Template Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/item_description_template/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$title['headerTitle']="Item Description Template  Edit";
		$this->db->select('*' );
		$this->db->from('item_description_template');
		$this->db->where('template_id', $id);
		$rs = $this->db->get();
		$records=$rs->result_array();
		if($records != false){
			//true section
			$data['group_name']	= $records[0]['group_name'];
			$data['template_id']	= $records[0]['template_id'];
			$data['status']	    = $records[0]['status'];
			$data['name']	= $records[0]['name'];

			$data['user_status'] = $this->config->item('user_status_array');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item_description_template/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Item_description_template');
		}
	}
	function do_insert() {
		$title['headerTitle']="Item Description Template  Create";
		$this->form_validation->set_rules('group', 'Group', 'required');
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/item_description_template/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			$group=$this->input->post('group');
			
			$data=array(
				'name'=> $name,
				'group_name' 	=> $group
			);

			$rr=$this->crud_model->insert('item_description_template',$data);

			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Item Description Template cannot be inserted',':old:');
				redirect('masters/Item_description_template');
			} else {
				// redirect
				$this->session->set_flashdata('success','Added successfully');
				redirect('masters/Item_description_template');
			}
		}

	}

	function do_update() {
		$title['headerTitle']="Item Description Template  Edit";
		$this->form_validation->set_rules('group', 'Group', 'required');
		$this->form_validation->set_rules('name', 'Name', 'required');
		$template_id = ascii_to_entities($this->input->post('template_id'));
		
		$status = ascii_to_entities($this->input->post('status'));

		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->db->select('*' );
			$this->db->from('item_description_template');
			$this->db->where('template_id', $template_id);
			$rs = $this->db->get();
			$records=$rs->result_array();

			if($records != false){
				//true section
				$data['group_name']	= $records[0]['group_name'];
				$data['template_id']	= $records[0]['template_id'];
				$data['status']	    = $records[0]['status'];
				$data['name']	= $records[0]['name'];

				$data['user_status'] = $this->config->item('user_status_array');

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/item_description_template/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			$group = ascii_to_entities($this->input->post('group'));

			$where=array(
				'template_id'  => $template_id
			);
			$data=array(
				'name' => $name,
				'group_name' => $group,
				'status' => $status
			);

			$records=$this->crud_model->update('item_description_template',$data,$where);

			$this->session->set_flashdata('success','Updated successfully...');
			redirect('masters/Item_description_template');
		}
	}
	function do_delete($unit_id=0) {

		$where=array(
			'unit_id'  => $unit_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('unit_master',$data,$where);

		$this->session->set_flashdata('response','Unit deleted');
		redirect('masters/Unit');
	}
}