<?php
class VehicleInventoryChecklist extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("VehicleInventoryChecklist", "View");
		$title['headerTitle']="Vehicle Inventory Checklist";
		$data['vinventoryChecklist']  = $this->Vehicle->v_InventoryChecklist();		
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/VehicleInventoryChecklist',$data);
		$this->load->view('templates/footer');
	}
	public function create_VehicleInventoryChecklist(){
		$this->users_model->permission("VehicleInventoryChecklist", "Add");
		$title['headerTitle']="Vehicle Inventory Checklist";
		$this->load->view('templates/header',$title);
 		$this->load->view('masters/vehicle/create_vehicleInventoryChecklist');
		$this->load->view('templates/footer');
	}
	public function create( ) {
		$this->users_model->permission("VehicleInventoryChecklist", "Add");
		$this->db->trans_begin();
		$this->form_validation->set_rules('title', 'Title', 'required');
		$title['headerTitle']="Vehicle Inventory Check List";
		$config = array(		 
			array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please enter document %s.'
                    )
            ),);
			$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){ 
			$data['title']   =  set_value('title');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/create_vehicleInventoryChecklist',$data);
			$this->load->view('templates/footer'); 
		} else{
				
			$this->load->library('upload');
			$files = $_FILES;
			$file_upload = $this->input->post('image');
			$file_upload2 = $this->input->post('image2');
			$config['upload_path'] = './images/vehicle_inventory/';
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$config['allowed_types'] = 'gif|jpg|png|jpeg';
			$config['max_size']= '0';
			$config['overwrite'] = TRUE;
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
 			if($_FILES["image"]['name']!=''){
				if ($this->upload->do_upload('image')) {
					$ext = end(explode(".", $_FILES["image"]['name']));
					$datanew = array(
						'item_name'=> $this->input->post('title'),
						'image'  => $config['file_name'].'.'.$ext
					);
					$this->db->insert('vehicle_inventory_checklist',$datanew);
				} else {
				 	$this->session->set_flashdata('response', $this->upload->display_errors());
					redirect("masters/VehicleInventoryChecklist/create_VehicleInventoryChecklist");
				}
			}
			else{
				$datanew = array(
					'item_name'=> $this->input->post('title'),
					'image'  => NULL
 				);
				$this->db->insert('vehicle_inventory_checklist',$datanew);
			}
			
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', $this->upload->display_errors());
				redirect("masters/VehicleInventoryChecklist");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Checklist Item Added Successfully');
				redirect("masters/VehicleInventoryChecklist");
			}
		}		   
	}
	public function edit_inventory_checklist($id) {
		
		$this->users_model->permission("VehicleInventoryChecklist", "Edit");	
		$this->db->trans_begin();
		$data['invitem']= $this->Vehicle->datainventorychkRowdocument($id);		
 		$this->form_validation->set_rules('title', 'Title', 'required');
		$title['headerTitle']="Vehicle Inventory Check List";
		$config = array(		 
			array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please enter document %s.'
                    )
            ),);
			$this->form_validation->set_rules($config);
			
		if ($this->form_validation->run() == FALSE){ 
 			$data['title']   =  set_value('title');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/edit_vehicleInventoryChecklist',$data);
			$this->load->view('templates/footer'); 
		} else{
			$datanew = array(
				'item_name'=> $this->input->post('title')
			);
			$where = array('id' => $id);
			$this->crud_model->update('vehicle_inventory_checklist',$datanew,$where);
					
			$this->load->library('upload');
			$files = $_FILES;
			$file_upload = $this->input->post('image');
			$file_upload2 = $this->input->post('image2');
			$config['upload_path'] = './images/vehicle_inventory/';
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$config['allowed_types'] = '*';
			$config['max_size']= '0';
			$config['overwrite'] = TRUE;
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			if(!empty($_FILES) || $_FILES["image"]['name'] != '')
			{
				$img1 = $this->input->post('old_image');
				$existing_img = $existing_img = $config['upload_path'].$img1; 
				if (file_exists($existing_img)) {
					unlink($existing_img);
				}
				if ($this->upload->do_upload('image')) {
					$ext = end(explode(".", $_FILES["image"]['name']));
					$file_name  =$config['file_name'].'.'.$ext ;
					$datanew = array(
						'image'    => $file_name
				   );
				   $where = array('id' => $id);
				   $this->crud_model->update('vehicle_inventory_checklist',$datanew,$where);
				}

			}else{
				    $this->db->trans_rollback();
 					$this->session->set_flashdata('response', $this->upload->display_errors());
					redirect("masters/VehicleInventoryChecklist/edit_inventory_checklist/".$id."/");
			}						
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', $this->upload->display_errors());
				redirect("masters/VehicleInventoryChecklist/edit_inventory_checklist/".$id."/");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Checklist Item Updated Successfully');
				redirect("masters/VehicleInventoryChecklist");
			}
		}		   
	}

	public function Update_inventorystatus(){
		$this->users_model->permission("VehicleInventoryChecklist", "Edit");	
		$this->db->trans_begin();
		$id =  $this->input->post('id');
		$status =  $this->input->post('status');
		$where = array('id' => $id);
		$data = array(
			'status'    => $status
	   );
		$this->crud_model->update('vehicle_inventory_checklist',$data,$where);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			echo 'error';
		} else {
			$this->db->trans_commit();
			echo 'success';
		}
	}
}