<?php
class Quotation_appliance extends CI_Controller {
	function Quotation_appliance()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('transactions/quotation_appliance/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('quotation_appliance',array('quotation_id'=>$this->session->userdata('quotation_id')));

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('quotation_appliance',
		array('quotation_id'=>$this->session->userdata('quotation_id')),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$list = $this->quotation_model->get_quotation_kitchen_list(array('quotation_id' => $this->session->userdata('quotation_id')));
		$data['quotation_kitchens'] = $list;

		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_appliance/create',$data);
		$this->load->view('templates/footer');

	}
	function do_insert()
	{
		$this->form_validation->set_rules('quotation_kitchen_id', 'Kitchen', 'required');
		$this->form_validation->set_rules('reference_quote_number', 'Reference Quote Number', 'required');
		$this->form_validation->set_rules('reference_quote_date', 'Reference Quote Date', 'required|callback_date_check');
		$this->form_validation->set_rules('reference_quote_amount', 'Reference Quote Total', 'required|numeric');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
		}
		else
		{	// true section

			$data=array(
					'quotation_id'              => $this->session->userdata('quotation_id'),
					'quotation_kitchen_id'		=> $this->input->post('quotation_kitchen_id'),
					'reference_quote_number'    => $this->input->post('reference_quote_number'),
					'reference_quote_date'      => date('Y-m-d',strtotime($this->input->post('reference_quote_date'))),
					'reference_quote_amount'    => $this->input->post('reference_quote_amount')
			);
			$rr=$this->crud_model->insert('quotation_appliance',$data);

			if($rr == false)
			{
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Appliance cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('quotations/quotation_appliance');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Quotation Appliance Details added successfully</div>');
				redirect('quotations/quotation_appliance');

			}
		}

	}

	function date_check($data)
	{
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		/* echo date('Y-m-d',$given_date);
		echo date('Y-m-d',$today_date);
		exit ; */
		if($given_date <= $today_date){
			//true
			return true;
		}
		else{
			//false
			$this->form_validation->set_message('date_check', 'Date cannot be future date');
			return FALSE;
		}
		
	}
	function do_delete($id=0)
	{
		$where=array(
				'quotation_appliance_id'=> $id
		);
		$this->crud_model->delete('quotation_appliance',$where);
		$this->session->set_flashdata('response','<div class="alert alert-success">Appliance deleted</div>');
		redirect('quotations/quotation_appliance');
	}
}