<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends CI_Controller {

	function Reports() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}

	public function index() {
		//echo "Reports";
		
		
		$this->load->view('templates/header');
		$this->load->view('reports/view_reports');
		$this->load->view('templates/footer');
		
		
	}
	
	
	
	public function view_reports() {
		//echo "Reports";
		
		
		$this->load->view('templates/header');
		$this->load->view('reports/view_reports',$this->data);
		$this->load->view('templates/footer');
		
		
	}
	
	
	
	public function customer_ledger(){
		
		$this->load->view('templates/header');
		$this->load->view('general_reports/customer_ledger');
		$this->load->view('templates/footer');
	}
	
	public function filter_customer_ledger(){
		$client_name = $this->input->post('client_name');
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		echo $client_name."==".$from_date."==".$to_date;
	}
	
	public function outstanding_invoices(){
		
		$this->load->view('templates/header');
		$this->load->view('general_reports/outstanding_invoices');
		$this->load->view('templates/footer');
	}
	
	
	
	

	
		
}

?>