<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Account_posting extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
		$this->load->model('Hr_model');
	}
	public function list(){
		$this->users_model->permission("Account_posting","View");
		$title['headerTitle']="Account Posting";
		$data['payheads'] = $this->crud_model->get('pay_head');
		$data['payroll_account_debit'] = $this->Hr_model->get_payroll_account_debit();
		$data['payroll_account_credit'] = $this->Hr_model->get_payroll_account_credit();
		
		if($this->input->post('year')!='') {
			$data['selectedyear'] = $this->input->post('year');
		} else {
			$data['selectedyear'] = date('Y');
		}
		if($this->input->post('month')!='') {
			$data['selectedmonth'] = $this->input->post('month');
		} else {
			$data['selectedmonth'] = date('m');
		}
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/account_posting',$data);
		$this->load->view('templates/footer');
	}
	public function save(){
		$this->users_model->permission("Account_posting","View");
		$this->db->trans_begin();
		$payroll_account_debit = $this->Hr_model->get_payroll_account_debit();
		$payroll_account_credit = $this->Hr_model->get_payroll_account_credit();
		$accounts_data=array();
		$total_debit_amount=0;
		$total_credit_amount=0;
		if($payroll_account_debit!=false){
			foreach ($payroll_account_debit as $value) {
				$accounts_data[] = array(
					'vch_type' 	  => 'Payroll',
					'vch_no'  	  => $value['processing_month'].'-'.$value['processing_year'],
					'vch_date'    => $value['processed_date'],
					'vch_ref'     => '',
					'ledger_code' => $value['accounts_ledger'],
					'rev_ledger_code' => '',
					'cc_code' 	  => 1,
					'div_code' 	  => 1,
					'ledger_amount'=> $value['ledger_amount'],
					'vch_narration'=> 'Auto entry from Payroll account ',
					'user_id' 	  => $this->session->userdata('user_id'),
					'status'      => 1
				);
				$total_debit_amount+=$value['ledger_amount'];
			}
		}
		if($payroll_account_credit!=false){
			foreach ($payroll_account_credit as $value) {
				$accounts_data[] = array(
					'vch_type' 	  => 'Payroll',
					'vch_no'  	  => $value['processing_month'].'-'.$value['processing_year'],
					'vch_date'    => $value['processed_date'],
					'vch_ref'     => '',
					'ledger_code' => $value['accounts_ledger'],
					'rev_ledger_code' => '',
					'cc_code' 	  => 1,
					'div_code' 	  => 1,
					'ledger_amount'=> $value['ledger_amount'],
					'vch_narration'=> 'Auto entry from Payroll account ',
					'user_id' 	  => $this->session->userdata('user_id'),
					'status'      => 1
				);
				$total_credit_amount+=$value['ledger_amount'];
			}
		}
		if(number_format($total_debit_amount,3,'.','')!=number_format($total_credit_amount*-1,3,'.','')){
			$this->db->trans_rollback();
			$this->session->set_flashdata('response','Debit and Credit amount should not be same');
			redirect('transactions/Account_posting/list');
		} else {
			$this->db->insert_batch('accounts', $accounts_data);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Cannot be done, try again.');
				redirect('transactions/Account_posting/list');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success','Data saved successfully');
				redirect('transactions/Account_posting/list');
		 	}
		}
		
	}
}

?>