<?php
class Vehicle extends CI_Model {

	function __construct()
	{
		// Call the Model constructor
		parent::__construct();
	}

	public function save($data){
		$this->db->trans_begin();
        $this->db->insert('make', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
			//return $this->db->insert_id();
	   }
	}
	public function getMake(){		
		$this->db->select('id,title,status');
		$this->db->from('make');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	

	public function Updatemake($data){
		$id  = $this->input->post('make_id');
		$this->db->trans_begin();
		$this->db->where('id', $id);
		$this->db->update('make', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}
	
	public function getModel(){
		$this->db->select('id,make_id,title');
		$this->db->from('model');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function saveModel($data){
		$this->db->trans_begin();
        $this->db->insert('model', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
	   }
	}
	public function Updatemodel($data){
		$id  = $this->input->post('make_id');
		$this->db->trans_begin();
		$this->db->where('id', $id);
		$this->db->update('model', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}
	public function insertregistration($data){
		$this->db->trans_begin();
        $this->db->insert('reg_no_table', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
			//return $this->db->insert_id();
	   }
	}
		
	public function  getRegistration(){
		$client_id      = $this->input->post('search_client_id');
		$search_reg_no  = $this->input->post('search_reg_no');
		$sql = "" ;
		if($client_id != ''){
			//$where = "client_id = $client_id";
			$sql =	$this->db->where('client_id',$client_id);
		}

		if($search_reg_no != ''){
			$sql =	$this->db->where('reg_no',$search_reg_no);
		}

		$this->db->select('*');
		$this->db->from('reg_no_table');
		$sql;
		$this->db->order_by('reg_no_id' ,'DESC');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getUpdateRegi($reg_no_id){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no_id', $reg_no_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
			
	}
	public function  getCustomer(){
		$this->db->select('*');
		$this->db->from('new_client_master');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function  getnewCustomer(){
		$this->db->select('*');
		$this->db->from('new_client_master');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getregisterModel($make_id){
		$this->db->select('*');
		$this->db->from('model');
		$this->db->where('make_id', $make_id);
		$rs = $this->db->get();
	 
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function Updateregistration($data){
		$id  = $this->input->post('reg_no_id');
		$this->db->trans_begin();
		$this->db->where('reg_no_id', $id);
		$this->db->update('reg_no_table', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}
	public function Updatenameregistration($data){
		$id  = $this->input->post('reg_no');
		$this->db->trans_begin();
		$this->db->where('reg_no', $id);
		$this->db->update('reg_no_table', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	/*public function UpdateVRegistrationInJobcard($jobcarddata){
		$client  = $this->input->post('client_id');
		$reg_no  = $this->input->post('reg_no');
		$this->db->select('*');
		$this->db->where('client_id',$client);
		$this->db->where('reg_no',$reg_no);
		$this->db->from('job_card');
		$rs = $this->db->get();
 
		if($rs->num_rows() > 0){

			$this->db->trans_begin();
			$this->db->where('client_id', $client);
			$this->db->where('reg_no', $reg_no);
			$this->db->update('job_card', $jobcarddata);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			}
			else{
				$this->db->trans_commit();
			}
		}
	}*/

	public function make(){
        $query= $this->db->query("SELECT * FROM `make` WHERE status='1' ");
		return $query->result();
    }
	public function model($make_id){
        $query= $this->db->query("SELECT * FROM `model` where `make_id`='$make_id' ");
	return $query->result();
    }
	public function dataRow($id){
        $query= $this->db->query("SELECT 
									RNT.`reg_no_id`,
									RNT.`reg_no`,
									RNT.`make_id`,
									RNT.`model_id`,
									RNT.`client_id`,
									RNT.`car_year`,
									RNT.`car_color`,
									RNT.`chassi_number`,
									RNT.`radio_code`,
									RNT.`key_number`,
									MK.`title` AS v_make,
									MD.`title` AS v_model,
									CM.`client_name`,
									CM.`client_telephone1`,
									CM.`client_address` FROM `reg_no_table` RNT 
									INNER JOIN `make` MK ON MK.id=RNT.`make_id` 
									INNER JOIN `model` MD ON MD.id=RNT.`model_id` 
									LEFT JOIN `new_client_master` CM ON CM.`client_id`= RNT.`client_id` WHERE RNT.`reg_no_id`='$id'");
									 
	return $query->row();
    }
	public function getdivision(){	
		$this->db->select('*');
		$this->db->from('company_division');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getsection(){	
		$this->db->select('*');
		$this->db->from('section_master');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getstaffdetail(){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function insertStaff($data){
		$this->db->trans_begin();
        $this->db->insert('staff_master', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
			  $this->db->insert_id();
	   }
	}

	public function getstaffdata($id){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('status', 1);
		$this->db->where('staff_id', $id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function updatetStaff($data){
		$id  = $this->input->post('staff_id');
		$this->db->trans_begin();
		$this->db->where('staff_id', $id);
		$this->db->update('staff_master', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	public function getServiceStaff(){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('type', 2);
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getAdvisorStaff(){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('type', 1);
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}



	public function insertjobcard($data){
		$this->db->trans_begin();
		$this->db->insert('job_card', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return $this->db->insert_id();
		}
	}


	public function insertjobcarddetail($data){
		$this->db->trans_begin();
        $this->db->insert('job_card_details', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			 return true;
	   }
	}

	public function insertfurnitureItem($data){
		$this->db->trans_begin();
        $this->db->insert('furniture_items', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			 return true;
	   }
	}
    
	public function getMVjobcard(){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->order_by('job_card_number','DESC');
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}


	public function getVjobcard($status){
		$jbno       = $this->input->post('jbno');
		$reg_number = $this->input->post('reg_number');
		$client_id  = $this->input->post('client_id');
		$user_id    = $this->session->userdata('user_id');
		$job_card_status = $this->input->post('job_card_status');
		$vehichle_status = $this->input->post('vehichle_status');
		//$report_date_from = $this->input->post('report_date_from');
		//$report_date_to = $this->input->post('report_date_to');
		$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
		$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

		$sql = $limit = "" ;
		if(!empty($status) ){
			if($status == 'Draft'){
				$sql = $this->db->where('job_card_status', 'Draft');
			}
			else if($status == 'Cancelled'){
				$sql = $this->db->where('job_card_status', 'Cancelled');
			}
			else if($status == 'Completed'){
				$sql = $this->db->where('job_card_status', 'Completed');
			}
			else if($status == 'Requested'){
				//$sql = $this->db->where('disc_req_to', 0);				 
				$sql = $this->db->where('disc_req_to', $user_id);				 
			}			
		}
		
		
		if(!empty($jbno)){
			$sql = $this->db->like('job_card_number', $jbno, 'before');
		}		
		if(!empty($reg_number)){
			$sql = $this->db->where('reg_no', $reg_number);
		}
		if(!empty($client_id)){
			$sql = $this->db->where('client_id', $client_id);
		}
		
	 
		// if(!empty($job_card_status)){
		// 	$sql = $this->db->where('job_card_status', $job_card_status);
		// }
		if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
			$sql = $this->db->where('date(job_card_date) >=', $date_fmt);
			$sql = $this->db->where('date(job_card_date) <=', $date_to);
 		} else if ($this->input->post('report_date_from') != '') {
			$sql = $this->db->where('date(job_card_date) >=', $date_fmt);
		} else if ($this->input->post('report_date_to')!=''){
			$sql = $this->db->where('date(job_card_date) <=', $date_to);
		}

		if(!empty($job_card_status) ){
			if(!empty($job_card_status) && $job_card_status != 'NIL'){
				if($job_card_status == 'Draft' || $job_card_status == 'Cancelled' || $job_card_status == 'Completed' ){
					$sql = $this->db->where('job_card_status', $job_card_status);
				}
				else{
					$sql = $this->db->where('job_c_status', $job_card_status);
				}
				if($status == 'Requested'){
 					$sql = $this->db->where('disc_req_to', $user_id);				 
				}
			}					 			
		}

		if(!empty($vehichle_status) && $vehichle_status != 'NIL'){
 			$sql = $this->db->where('vehicle_status', $vehichle_status);
		}

		if(!empty($sql)){
			$limit = "";
		}
		else{
			$limit = $this->db->limit(500);
		}
		
		//$this->db->select('id,job_card_number,job_card_confirmationdate,job_card_date,client_id,reg_no,make,model,km_in,customer_complaints,job_card_amount_with_vat,grand_cost,job_card_status,disc_req_to,dis_req_status');
		$this->db->select('*');
		$this->db->from('view_furniture_job_card');
		$this->db->order_by('job_card_number','DESC');
		$sql;
		$limit;
		$rs = $this->db->get();
		//echo $this->db->last_query(); exit();
  		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcardcountarea(){
		$this->db->select('id,job_card_status,disc_req_to,dis_req_status');
		$this->db->from('job_card');
		$this->db->order_by('job_card_number','DESC');
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcarddesc(){		
		$this->db->select('job_card_id,furniture_model');
		$this->db->from('job_card_details');
		//$this->db->where('job_card_id', $jobid);
		$this->db->where('jb_type', 1);
		$this->db->order_by('job_card_details_id','ASC');
		$this->db->group_by('job_card_id');
		//$this->db->limit(1);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			//return $rs->row();
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcard_detail($id){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('id', $id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}	
	
	public function getVjobcard_desc($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function Chkjobtype_spare($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('jb_type',2);
		$this->db->where('job_card_id',$id);
		$this->db->group_by('jb_type'); 
	 
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function Chkjobtype_labour($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('jb_type',1);
		$this->db->where('job_card_id',$id);
		$this->db->group_by('jb_type'); 
		
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	/*INSERT INTO `job_card_details`(
		`job_card_details_id`,
		`job_card_id`,
		`sl_no`,
		`item_id`,
		`furniture_model`,
		`furniture_description`,
		`furniture_unitprice`,
		`furniture_quantity`,
		`furniture_amount`,
		`vat_perce`,
		`vat_amount`,
		`item_discount`,
		`net_amount`,
		`jb_type`,
		`section_id`,
		`technician_id`,
		`body_id`,
		`part_type`
	)
	VALUES(
		'571',
		'52',
		'1',
		'8029',
		'Test Stock',
		'',
		'2.590',
		'2.000 ',
		'5.180 ',
		'0.000',
		'4.000',
		'',
		'5.180',
		'2',
		'1',
		'12' '273',
		'Purchase Invoice'
	)*/

	public function UpdateJobdetails($dataValues){
		$job_card_id =  $dataValues['job_card_id'];
		$sl_no =  $dataValues['sl_no'];
		$job_card_details_id =  $dataValues['job_card_details_id'];
		$item_id =  $dataValues['item_id'];
		$furniture_model = $dataValues['furniture_model'];
		$furniture_description  = $dataValues['furniture_description'];
		$furniture_unitprice = $dataValues['furniture_unitprice'];
		$furniture_quantity = $dataValues['furniture_quantity'];
		$furniture_amount = $dataValues['furniture_amount'];
		$vat_perce = $dataValues['vat_perce'];
		$vat_amount  = $dataValues['vat_amount'];
		$item_discount  = $dataValues['item_discount'];
		$net_amount  = $dataValues['net_amount'];
		$jb_type  = $dataValues['jb_type'];
		$section_id  = $dataValues['section_id'];
		$technician_id  = $dataValues['technician_id'];
		$body_id  = $dataValues['body_id'];
		$part_type  = $dataValues['part_type'];
		$uom  = $dataValues['uom'];
		$uom_id  = $dataValues['uom_id'];
		$item_disc_perc  =  $dataValues['item_disc_perc'];
		$Item_cost  =  $dataValues['Item_cost'];

		$is_request_id  = $this->input->post('is_request_id');
		if(!empty($is_request_id) && ($is_request_id == $this->session->userdata('user_id')) ){
			$data = array(
				'dis_req_status' => 1,
			);
			$this->db->where('id', $job_card_id);
			$this->db->update('job_card', $data);
		}
		
		if(!empty($job_card_details_id)){
	 				$this->db->query("INSERT INTO `job_card_details`( 
					`job_card_details_id`,
					`job_card_id`,
					`sl_no`,
					`item_id`,
					`furniture_model`,
					`furniture_description`,
					`Item_cost`,
					`furniture_unitprice`,
					`furniture_quantity`,
					`furniture_amount`,
					`uom`,
					`uom_id`,
					`vat_perce`,
					`vat_amount`,
					`item_disc_perc`,
					`item_discount`,
					`net_amount`,
					`jb_type`,
					`section_id`,
					`technician_id`,
					`body_id`,
					`part_type`
					) values(
						'$job_card_details_id',
						'$job_card_id',
						'$sl_no',
						'$item_id',
						'$furniture_model',
						'$furniture_description',
						'$Item_cost',
						'$furniture_unitprice',
						'$furniture_quantity ',
						'$furniture_amount ',
						'$uom',
						'$uom_id',
						'$vat_perce',
						'$vat_amount',
						'$item_disc_perc',
						'$item_discount',
						'$net_amount',
						'$jb_type',
						'$section_id',
						'$technician_id',
						'$body_id',
						'$part_type'
					)");
		}
		else{
			
			$this->db->query("INSERT INTO `job_card_details`( 
											`job_card_id`,
											`sl_no`,
											`item_id`,
											`furniture_model`,
											`furniture_description`,
											`Item_cost`,
											`furniture_unitprice`,
											`furniture_quantity`,
											`furniture_amount`,
											`uom`,
											`uom_id`,
											`vat_perce`,
											`vat_amount`,
											`item_disc_perc`,
											`item_discount`,
											`net_amount`,
											`jb_type`,
											`section_id`,
											`technician_id`,
											`body_id`,
											`part_type`
											) values(
												'$job_card_id',
												'$sl_no',
												'$item_id',
												'$furniture_model',
												'$furniture_description',
												'$Item_cost',
												'$furniture_unitprice',
												'$furniture_quantity ',
												'$furniture_amount ',
												'$uom',
												'$uom_id',
												'$vat_perce',
												'$vat_amount',
												'$item_disc_perc',
												'$item_discount',
												'$net_amount',
												'$jb_type',
												'$section_id',
												'$technician_id',
												'$body_id',
												'$part_type'
											) ");
		}

 		return true;
	}
	public function getInsurer($insurer_id){
		$this->db->select('*');
		$this->db->from('insurer_master');
		$this->db->where('insurer_id', $insurer_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function jobCardRow($id){
        $query= $this->db->query("SELECT J.id,
										 J.job_card_number,
										 J.job_card_date,
										 J.divisionid,
										 J.client_id,
										 J.salesman_id,
										 J.project_name,
										 J.contact_id,
										 J.contact_name,
										 J.contact_num,
										 J.status,
										 J.reg_no,
										 J.make,
										 J.model,
										 J.chassi_number,
										 J.contact_name,
										 J.contact_num,
										 J.is_insurance,
										 J.insurer_id,
										 NCM.tax_perce FROM `job_card` J 
										 INNER JOIN `new_client_master` NCM ON NCM.client_id=J.client_id  
										 WHERE J.`id` ='$id'");
									return $query->row();
    }
	public function getVjobcard_division($id){
		
		$query= $this->db->query("SELECT divisionid FROM `job_card` WHERE `id` ='$id'" );
		return $query->row()->divisionid;
	}


	public function getPurchaseMaterial_job($id,$division_id){
		$query= $this->db->query("SELECT PH.*,
										 PB.item_h_id,
										 PB.item_name_purchase,
										 PB.item_qty,
										 PB.uom,
										 PB.uom_id,
										 PB.b_uom,
										 PB.item_rate,
										 PB.item_amt,
										 PB.tcost,
										 PB.fx_amount,
										 PB.item_vat_per,
										 PB.item_vat_amt,
										 PB.item_net_amt,
										 PB.pur_det_id,
										 IP.cost,
										 IP.sel_price,
										 IP.uom_id AS ip_uom
										 FROM `purchase_h` PH 
										 LEFT JOIN `purchase_b` PB ON PB.pur_h_id = PH.id  
										 LEFT JOIN `item_price` IP ON (IP.item_id = PB.item_h_id) AND (IP.division_id = PH.division_id) AND (IP.uom_id = PB.uom_id)
										 WHERE PB.`job_id` ='$id' AND PB.`inventory_type` ='Job' AND PH.status= 'Confirmed' "); // AND PH.status= 'Confirmed'										 				
									return $query->result_array();
 	}

	public function getMaterialIssue_job($id,$division_id){
		$query= $this->db->query("SELECT MH.*,
										 MB.item_details_id,
										 MB.item_description,
										 MB.item_qty,
										 MB.item_rate,
										 MB.item_fx_rate,
										 MB.item_disc,
										 MB.item_amount,
										 MB.item_vat_per,
										 MB.item_vat,
										 MB.net_amount,
										 MB.mi_b_id,
										 MB.uom,
										 MB.uom_id,
										 IP.cost,
										 IP.sel_price,
										 IT.vat_percentage as item_vat_per
										 FROM `material_issue_h` MH 
										 LEFT JOIN `material_issue_b` MB ON MB.mi_id=MH.mi_id  
										 LEFT JOIN `item_price` IP ON (IP.item_id =  MB.item_details_id) AND (IP.division_id = MH.division_id) AND (IP.uom_id = MB.uom_id)
										 LEFT JOIN `items` AS IT ON (IT.id =  MB.item_details_id)
 										 WHERE MH.`job_id` ='$id' AND MH.status = 1");
									return $query->result_array();
	}

	public function get_ContactDetails($Client_Id,$contact_name){
		$html ='';
		$this->db->select('*');
		$this->db->from('client_contact');
		$this->db->where('Client_Id',$Client_Id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			if(count($rs->result_array())>0){
				$html ='<option value="" > - Select Contact Person- </option>';
				foreach ($rs->result_array() as $client_contact_datas){
					$selected =  $contact_name == $client_contact_datas['Contact_Name'] ? 'selected ="selected"' : '';
					$html.='<option  '.$selected.'  data-cnt-id="'.$client_contact_datas['Contact_Id'].'"  value="'.$client_contact_datas['Contact_Name'].'">'.$client_contact_datas['Contact_Name'].'</option>';			
				}
			} else {
				$html.='<option value="" > - Select Contact Persons- </option>';
			}

			return $html;
		}
		else{
			return false;
		}
	}

	public function get_ContactDetails_only($Client_Id){
		$this->db->select('*');
		$this->db->from('client_contact');
		$this->db->where('Client_Id',$Client_Id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function get_ContactDetails_only_new($Client_Id){
		$this->db->select('*');
		$this->db->from('client_contact');
		$this->db->where('Client_Id',$Client_Id);
		$this->db->order_by('Contact_Id', 'DESC');
		$this->db->limit(1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getJBCModel($model_id){
		$this->db->select('*');
		$this->db->from('model');
		$this->db->where('id', $model_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function dataRowdocument($job_no,$division_id){
        $query= $this->db->query("SELECT * FROM `job_card` WHERE  id='$job_no' AND divisionid='$division_id' ");
		return $query->row();
    }

	public function jobDataRow($id,$division_id){
        $query= $this->db->query("SELECT JC.*,
		MK.`title` AS v_make,
		MD.`title` AS v_model,
		CM.`client_code`,
		CM.`client_name`,
		CM.`client_telephone1`,
		CM.`tax_name`,
		RNT.`reg_no_id`,
		RNT.`car_year`,
		RNT.`car_color`,
		RNT.`chassi_number`,
		RNT.`client_mobile_no` FROM `job_card` JC 
		INNER JOIN `make` MK ON MK.id=JC.`make` 
		INNER JOIN `model` MD ON MD.id=JC.`model` 
		LEFT JOIN `new_client_master` CM ON JC.`customer_id`=CM.`client_id` 
		Left join `reg_no_table` RNT ON JC.`reg_no`=RNT.`reg_no` 
		WHERE JC.`id`='$id' AND JC.`divisionid`='$division_id' ");
		return $query->row();
    }

	public function vir_files($job_no,$division_id){
        $query= $this->db->query("SELECT * FROM `vir_files` where `job_no`='$job_no' and `division_id`='$division_id'");
		return $query->result();
    }

	public function get_job_images($job_no){
		$this->db->select('*');
		$this->db->from('job_images');
		$this->db->where('job_id',$job_no);		
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getvehicledetails($chassi_number){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('chassi_number',$chassi_number);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function checkPOdata($job_id){
		// $this->db->select('*');
		// $this->db->from('po_h');
		// $this->db->where('job_id',$job_id);
		// $this->db->where('status != ','Cancel');
		// $rs = $this->db->get();		 		 
		// if($rs->num_rows() > 0){
		// 	$this->db->select('*');
		// 	$this->db->from('purchase_h');
		// 	$this->db->where('po_h_id',$rs->row()->po_id);
		// 	$this->db->where('status != ','Cancel');
		// 	$rs1 = $this->db->get();			 			 
		// 	if($rs1->num_rows() > 0){
		// 		return false;
		// 	}
		// 	else{
		// 		return $rs->row()->po_code;
		// 	}				  
		// }
		// else{
		// 	return false;			
		// }

		// $this->db->query("CALL checkPOdata(?, @po_code)", array($job_id));
		// $po_code = $this->db->query("SELECT @po_code AS po_code")->row()->po_code;
		// return $po_code;

		$this->db->query("CALL checkPOdata($job_id, @po_code)");
		$po_code = $this->db->query("SELECT @po_code AS po_code")->row()->po_code;
 		return $po_code;
	}


	public function get_check_pulled_pur_data($job_id)
	{
		$this->db->query("CALL get_check_pulled_pur_data(?, @pu_data, @status)", [$job_id]);
		$query = $this->db->query("SELECT @pu_data AS pu_data, @status AS status_out");
		$result = $query->result_array();
		$this->db->close();
		$this->db->initialize();
		return $result;
	}


	// public function get_check_pulled_pur_data($job_id){
	// 	// $query = $this->db->query("CALL get_check_pulled_pur_data($job_id)");
	// 	// $result = $query->result_array();
	// 	// return $result;
	// 	$this->db->query("CALL get_check_pulled_pur_data($job_id, @pu_data, @status)");
	// 	$query = $this->db->query("SELECT @pu_data AS pu_data , @status AS status_out");
 	// 	$result = $query->result_array();
	// 	return $result;
	// 	// $returnArray = array('pu_data' => '', 'status' => '');
	// 	// $this->db->select('*');
	// 	// $this->db->from('purchase_h');
	// 	// $this->db->where('status != ','Cancel');
	// 	// $this->db->where('job_id= ',$job_id);
	// 	// $rs = $this->db->get();		
 	// 	// if($rs->num_rows() > 0){
	// 	// 	foreach($rs->result_array() as $records){
	// 	// 		$this->db->select('*');
	// 	// 		$this->db->from('purchase_b');
	// 	// 		$this->db->where('pur_h_id',$records['id']);
	// 	// 		$this->db->where('status ',1);
	// 	// 		$rs1 = $this->db->get();
 	// 	// 		if($rs1->num_rows() > 0){
	// 	// 			$this->db->select('*');
	// 	// 			$this->db->from('job_card_details');
	// 	// 			$this->db->where('body_id',$rs1->row()->pur_det_id);
	// 	// 			$this->db->where('job_card_id',$job_id);
	// 	// 			$this->db->where('part_type','Purchase Invoice');
 	// 	// 			$rs2 = $this->db->get();	
 	// 	// 			if($rs2->num_rows() > 0){
	// 	// 				$returnArray['status'] =  false;						
	// 	// 			}
	// 	// 			else{
	// 	// 				$returnArray['status'] =  TRUE;	
	// 	// 				$returnArray['pu_data'] =  $records['purchase_invoice_code'];	
	// 	// 			}
	// 	// 		}
	// 	// 		else{
	// 	// 			$returnArray['status'] =  false;
	// 	// 		}	
	// 	// 	}
	// 	// }
	// 	// else{
	// 	// 	$returnArray['status'] =  false;	
	// 	// }
	// 	// return $returnArray;
	// }

	public function get_check_pulled_material_data($job_id){
		$this->db->query("CALL get_check_pulled_material_data($job_id, @mi_data, @status)");
		$query = $this->db->query("SELECT @mi_data AS mi_data, @status AS status_out");
		$result = $query->result_array();
		return $result;
	}

	public function get_check_rate_Job($job_id){
		$this->db->select_sum('net_amount');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id ',$job_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->net_amount;
		}
		else{
			return false;
		}
	}

	public function get_check_rate_quo($job_id){
		$this->db->select_sum('net_amount');
		$this->db->from('furniture_quotation AS FQ');
		$this->db->join('furniture_items AS FI','FI.quotation_id = FQ.id','left');
		$this->db->where('job_card_id ',$job_id);
		$this->db->where('quotation_status !=','Closed');
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row()->net_amount;
		}
		else{
			return false;
		}
	}

	public function UpdateJObcardStatus($job_id,$data){
		$this->db->trans_begin();
		$this->db->where('id', $job_id);
		$this->db->update('job_card', $data);
		
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	public function getInvoiceTempNum($divisionid){
		$this->db->select_max('invoice_number') ;
		$this->db->from('furniture_invoice');
		$this->db->where('quotation_divisionid',$divisionid);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$inv  = $rs->row()->invoice_number ;
			return $inv;
		}
		else{
			return false;
		}
	}

	public function getUnitmasterdata(){
		$this->db->select('*');
		$this->db->from('unit_master');
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	// public function getLabourDiscountAdvisor(){
	// 	$user_id   = $this->session->userdata('user_id');
	// 	$disc_limt = $this->crud_model->user_wise_section_discount_limit()->is_labour_disc;
	// 	$this->db->select('SM.staff_id,SM.staff_name,U.is_labour_disc');
	// 	$this->db->from('staff_master AS SM');
	// 	$this->db->join('users as U','U.advisor_id = SM.staff_id','left');
	// 	$this->db->where('SM.staff_id !=',$user_id);
	// 	$this->db->where('U.is_labour_disc > ',$disc_limt);
	// 	$rs = $this->db->get();
	// 	if($rs->num_rows()>0){
	// 		return $rs->result_array();
	// 	}
	// 	else{
	// 		return false;
	// 	}
	// }

	public function getLabourDiscountAdvisor(){
		$user_id   = $this->session->userdata('user_id');
		$disc_limt = $this->crud_model->user_wise_section_discount_limit()->is_labour_disc;
		$this->db->select('user_id,user_name,is_labour_disc');
		$this->db->from('users');		 
		$this->db->where('user_id !=',$user_id);
		$this->db->where('is_labour_disc > ',$disc_limt);
		$this->db->order_by('is_labour_disc','DESC');
		$rs = $this->db->get();
		if($rs->num_rows()>0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function sendDicsRequest(){		
		$job_id 	 = $this->input->post('job_card_id_req');  
		$data = array(
			'disc_req_to'  => $this->input->post('request_to_adv'),
			'disc_req_from' => $this->session->userdata('user_id'),
			'dis_req_narration'  => $this->input->post('narration'),
			'dis_req_status' => 0
		);
		$this->db->trans_begin();
		$this->db->where('id', $job_id);
		$this->db->update('job_card', $data);		
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	public function getJobhistory($reg_no){

		    $where  = $limit ='' ;
	    	$reg_post = $this->input->post('reg_no');
	    	$from_date = $this->input->post('report_date_from');
	    	$to_date = $this->input->post('report_date_to');
			if(!empty($reg_post)){
				$where = $this->db->where( 'JC.reg_no',$reg_post);
			}
			else{
				if(!empty($reg_no)){
					$where = $this->db->where( 'JC.reg_no',$reg_no);
					$limit = $this->db->limit('5');
				} 
			}
			if(!empty($from_date)){
				$where = $this->db->where( 'FINV.invoice_date >=',date('Y-m-d',strtotime($from_date)));
			}
			if(!empty($to_date)){
				$where = $this->db->where( 'FINV.invoice_date <=',date('Y-m-d',strtotime($to_date)));
			}
		
		$this->db->select('FINV.*,JC.id,JC.job_card_number,JC.km_in,JC.next_km');
		$this->db->from('furniture_invoice AS FINV');
 		$this->db->join('job_card AS JC','JC.id = FINV.job_card_id','left');
		$where;
		$this->db->order_by('invoice_date','DESC');
		$limit;
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getInvoiceDetails($invoice_id){
		$this->db->select('*');
		$this->db->from('furniture_invoice_details');
		$this->db->where( 'invoice_id',$invoice_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function get_vehicle_job_details($job_id){
		$this->db->Select('*');
		$this->db->From('job_card');
		$this->db->Where('id',$job_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	 
	public function getcompany_details(){
		$this->db->select('*');
		$this->db->from('company_details');
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getcompany_division($division_id){
 		$this->db->select('*');
		$this->db->from('company_division');
		$this->db->where('division_id',$division_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function checkInvoice($jb_id){
		$this->db->select('job_card_id');
		$this->db->from('furniture_invoice');
		$this->db->where('job_card_id',$jb_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function datainventorychkRowdocument($id){
		$this->db->select('*');
		$this->db->from('vehicle_inventory_checklist');
		$this->db->where('id',$id);
  		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function v_InventoryChecklist(){
		$this->db->select('*');
		$this->db->from('vehicle_inventory_checklist');
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	// public function is_v_type_valid($reg_no, $v_type)
	// {
	// 	$this->db->select('v_type');
	// 	$this->db->from('reg_no_table');
	// 	$this->db->where('reg_no', $reg_no);
	// 	$this->db->where('v_type', $v_type);
	// 	$query = $this->db->get();
 	// 	if ($query->num_rows() > 0) {
	// 		return true;  
	// 	} else {
	// 		return false;  
	// 	}
	// }

	public function is_v_type_valid($reg_no)
	{
		$v_type = $this->input->post('v_type');  
		$this->db->select('reg_no');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no', $reg_no);
		$this->db->where('v_type', $v_type);
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_v_type', '%s is Already Exists with this Vehicle Type '.$v_type.'.');
			return false;  
		} else {
			return true;  
		}
	}
	public function is_edit_v_type_valid($reg_no)
	{
		$v_type = $this->input->post('v_type');  
		//$id  = $this->input->post('reg_no_id');
		if(!empty($this->input->post('reg_no_id'))){
			$id  = $this->input->post('reg_no_id');
		}
		else{
			$id  = $this->input->post('regnoid');			
		}
		$this->db->select('reg_no');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no', $reg_no);
		//$this->db->where("reg_no LIKE '%$reg_no%'");

		$this->db->where('v_type', $v_type);
		$this->db->where('reg_no_id  !=', $id);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_edit_v_type', '%s is Already Exists with selected Vehicle Type.');
			return false;  
		} else {
			return true;  
		}
	}


	public function is_chassi_number_valid($v_type)
	{
  		$chassi_number  = $this->input->post('chassi_number');
		$this->db->select('chassi_number');
		$this->db->from('reg_no_table');
 		$this->db->where('v_type', $v_type);
		$this->db->where('chassi_number', $chassi_number);
 		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_chassi_number', '%s is Already Exists.');
			return false;  
		} else {
			return true;  
		}
	}

	public function is_edit_chassi_number_valid($v_type, $id)
	{
  		$chassi_number  = $this->input->post('chassi_number');
		$this->db->select('chassi_number');
		$this->db->from('reg_no_table');
 		$this->db->where('v_type', $v_type);
		$this->db->where('chassi_number', $chassi_number);
		$this->db->where('reg_no_id  !=', $id);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_edit_chassi_number', '%s is Already Exists.');
			return false;  
		} else {
			return true;  
		}
	}

	public function getVehicleCategory(){
		$this->db->select('*');
		$this->db->from('vehicle_category');
		//$this->db->where('type_status', 0);
		$this->db->order_by('type_status','ASC');
		$rs = $this->db->get();
		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getv_category(){
		$this->db->select('*');
		$this->db->from('vehicle_category');
		$this->db->order_by('type','ASC');
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getUpdateRegistration($reg){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no_id', $reg);
 		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	}

	public function getQutatioJBDetail($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id', $id);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}
	public function getJobCost(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('report_date_from')!="" && $this->input->post('report_date_to')!=""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('report_date_from')));
				$toDate=date('Y-m-d',strtotime($this->input->post('report_date_to')));
				$this->db->where('date(jc.job_card_date) >=',$fromDate);
				$this->db->where('date(jc.job_card_date) <=',$toDate);
			} else if($this->input->post('report_date_from')!="" && $this->input->post('report_date_to')==""){
				$fromDate=date('Y-m-d',strtotime($this->input->post('report_date_from')));
				$this->db->where('date(jc.job_card_date) >=',$fromDate);
			} else if($this->input->post('report_date_from')=="" && $this->input->post('report_date_to')!=""){
				$toDate=date('Y-m-d',strtotime($this->input->post('report_date_to')));
				$this->db->where('date(jc.job_card_date) <=',$toDate);
			}
			if($this->input->post('reg_no')!=""){
				$this->db->where('jc.reg_no',$this->input->post('reg_no'));
			}
			if($this->input->post('client_id')!=""){
				$this->db->where('jc.client_id',$this->input->post('client_id'));
			}
			$this->db->select('jc.id,jc.job_card_number,jc.job_card_date,jc.client_id,jc.reg_no,jc.make,jc.model,
			SUM(jd.furniture_quantity*jd.Item_cost) AS cost_price, 
			SUM(CASE WHEN jd.jb_type = 1 THEN jd.furniture_quantity*jd.Item_cost ELSE 0 END) AS labour_charge_cost, 
			SUM(CASE WHEN jd.jb_type = 2 THEN jd.furniture_quantity*jd.Item_cost ELSE 0 END) AS spare_parts_cost, 
			SUM(CASE WHEN jd.jb_type = 1 THEN jd.furniture_quantity*jd.furniture_unitprice ELSE 0 END) AS labour_charge_total, 
			SUM(CASE WHEN jd.jb_type = 2 THEN jd.furniture_quantity*jd.furniture_unitprice ELSE 0 END) AS spare_parts_total');
			$this->db->from('job_card AS jc');
			$this->db->join('job_card_details AS jd','jd.job_card_id = jc.id', 'left');
			$this->db->where('jc.job_card_status !=', 'Cancelled');
			$this->db->group_by('jc.id');
			$rs = $this->db->get();
			if ($rs->num_rows() > 0){
				return $rs->result_array();
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	public function CheckJobcardStatus($reg_no_id,$vtype){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('reg_no',$reg_no_id);
		$this->db->where('vtype_id',$vtype);
		$this->db->order_by('id', 'DESC');
		$this->db->limit(1);
 		$rs = $this->db->get();  
		//echo $this->db->last_query(); exit();
  		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	}
	// public function update_Jobstatus(){
		// 	$job_id 	 = $this->input->post('job_id');  
		// 	$jobstatus	 = $this->input->post('newStatus');  

		// 	$this->db->trans_begin();
		// 	$data = array(
		// 		'job_c_status'  => $jobstatus,
		// 	);
		// 	$this->db->where('id', $job_id);
		// 	$this->db->update('job_card', $data);		
		// 	if ($this->db->trans_status() === FALSE) {
		// 		$this->db->trans_rollback();
		// 		return false;
		// 	}
		// 	else{
		// 		$this->db->trans_commit();
		// 		return true;
		// 	}
	// }
}
