<?php 
	$this->load->helper('num_words');

	$flat_rows = [];
	if ($invoice_items !== false) {
		foreach ($invoice_items as $products) {
			// Group header
			if ($products['group_name'] !== "0") {
				if ($products['group_name'] === 'Labour') {
					$label = 'Labour Charges';
				} elseif ($products['group_name'] === 'Spare Parts') {
					$label = 'Spare Parts / Consumables';
				} else {
					$label = $products['group_name'];
				}
				$flat_rows[] = [
					'type' => 'group',
					'label' => $label,
					'group_id' => $products['group_id']
				];
			}

			// Fetch subgroups
			$this->db->select('*');
			$this->db->where([
				'invoice_id' => $products['invoice_id'],
				'group_id' => $products['group_id']
			]);
			$this->db->from('furniture_invoice_details');
			$this->db->order_by("sub_group_id", "ASC");
			$this->db->group_by("sub_group_name");
			$rs = $this->db->get();
			$sub_groups = $rs->result_array();

			foreach ($sub_groups as $sub_group) {
				$flat_rows[] = [
					'type' => 'subgroup',
					'label' => $sub_group['sub_group_name'],
					'group_id' => $products['group_id'],
					'sub_group_id' => $sub_group['sub_group_id']
				];

				// Fetch items under this subgroup
				$this->db->select('*');
				$this->db->where([
					'invoice_id' => $products['invoice_id'],
					'group_id' => $products['group_id'],
					'sub_group_id' => $sub_group['sub_group_id']
				]);
				$this->db->from('furniture_invoice_details');
				$this->db->order_by("item_order", "ASC");
				$this->db->order_by("id", "ASC");
				$items = $this->db->get()->result_array();

				foreach ($items as $item) {
					$flat_rows[] = [
						'type' => 'item',
						'data' => $item,
						'group_id' => $products['group_id'],
						'sub_group_id' => $sub_group['sub_group_id']
					];
				}
			}
		}
		function printLogoHeader() {
			echo '<div class="print-header">
					<img src="'.base_url().'images/awadhilogo.png" style="height:110px; width:700px;" alt="Print Logo" />
				  </div>';
		}
	}
	$first_page_limit  = 14;
	$other_pages_limit = 20;
	
	$item_counter   = 0;
	$page_index     = 0;
	$current_limit  = $first_page_limit;  
	
	$total_discount = 0.0;
	$total_amount   = 0.0;
	$total_vat_amt  = 0.0;
	$total_net_amnt = 0.0;
	
	// Pre‑compute totals (unchanged)
	foreach ($flat_rows as $row) {
		if ($row['type'] === 'item') {
			$item = $row['data'];
			$total_discount += floatval($item['item_discount']);
			$total_amount   += floatval($item['amount']);
			$total_vat_amt  += floatval($item['vat_amount']);
			$total_net_amnt += floatval($item['net_amount']);
		}
	}
?>

<html>
<head>
<title><?php echo $invoice_number.'-'.date('dmY',strtotime($invoice_date)).'-'.date('dmY'); ?></title>
  <meta content="text/html; charset=UTF-8" http-equiv="content-type">
  <link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
  <style type="text/css">
  
  	*{
		 
		font-family: 'Open Sans', sans-serif;
	}
  	.outer_wrapper{
		width:700px;
		margin:0 auto;
		min-height:900px;
		/*border:solid 1px blue;*/
		/* position: relative; */
	}
	
	.mainTable{
		width:100%;	
	}
	
  	.quotationTitle{
		/*height:150px;*/
		width:100%;
		background-color:#7f7f7f;
		float:left;
	}
	
	.quotationTitle h2{
		/*background-color:#7f7f7f;*/
    	margin: 0;
    	text-align: center;	
		font-family: 'Open Sans', sans-serif;
		color:#fff;
		line-height:42px;
		/*text-transform:uppercase;*/
		float:left;
		width:100%;
	}
	
	.leftSpan{
		width:60%;
		vertical-align: top;
	}
	
	.rightSpan{
		width:40%;
		vertical-align: top;
	}
	
	.halfSpan > span {
		float: left;
		width: 100%;
	}
	
	.halfSpan > span label{
		width:50%;
		color:#7f7f7f;
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		float:left;
	}
	
	.halfSpan h3{
		color: #000000;
    	font-family: 'Open Sans', sans-serif;
    	font-weight: bold;
    	margin: 0;
		padding:0px;
	}
	
	.halfSpan h4{
		color: #000000;
    	font-family: 'Open Sans', sans-serif;
    	font-weight: normal;
   		margin-bottom: 0;
    	margin-top: 3px;
		padding:0px;
	}
	
	.halfspan p{
		color: #000000;
    	font-family: 'Open Sans', sans-serif;
    	font-weight: normal;
   		margin-bottom: 0;
    	margin-top: 3px;
		padding:0px;	
	}
	
	.halfspan p.boldText{
		font-weight:bold;
		font-size:11px;	
	}
	.details{
		font-size:11px;	
		font-family: 'Open Sans', sans-serif;
	}
	
	.quotationIntro{
		margin-top:20px;
		float:left;
		width:100%;
		font-family: 'Open Sans', sans-serif;
		color:#000000;
		font-size:15px;
		
	}
	
	.quotationIntro h3{
		text-transform:uppercase;	
	}
	
	.quotationIntro b{
		font-weight:bold;	
	}
	
	.FeesTitle h3{
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		color:#000;
		margin:5px;
	}
	
	.quotationTables{
		margin-top:10px;
		float:left;
		width:100%;
	}
	
	.quotationTables b{
		font-weight:bold;	
	}
	
	.quotationTables table{
		width:100%;	
		/* border:solid 1px #d4d4d4; */
		border:none;
		/*background-color:#f4f4f4;*/
		border-spacing:0px;
	}
	
	.quotationTables table thead th{
		background-color:#7a7a7a;
		color:#fff;
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		text-align:left;	
		padding:5px;
	}
	
	.quotationTables table tbody th{
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		text-align:left;	
		padding:5px;
		color:#000;
		font-size:14px;
	}
	
	.quotationTables table th, .quotationTables table td{
		border-bottom: 1px solid #aaaaaa !important;
    	/* border-right: 1px solid #aaaaaa !important; */
		padding:4px;
	}
	
	.quotationTables table td .swDesc{
		opacity: 0.35;
	}
	

	.footer_content p{
		margin:5px 0px;	
	}
	
	.footer_content h3{
		text-transform:none;
		font-weight:bold;
	}
	
	.quotationTables td:last-child {
		border-right: medium none !important;
	}
	
	.quotationTables td.swdescription:last-child {
		border-right: 1px solid #aaaaaa !important;
		font-size:10px;
	}
	
	.quotationTables tr:last-child td {
		border-bottom: medium none !important;
	}
	
	
	.quotationTables th:last-child {
		border-right: medium none !important;
	}
	
	.quotationTables .swGroup{
		background-color: #7a7a7a;
		color: #fff;
		font-family: 'Open Sans', sans-serif;
		font-weight: bold;
		padding: 5px;
		text-align: center;
		font-size:11px;
		color:#000000;
	}
	
	.log_left {
		float: right;
	}
	
	
	
	#watermark {
    color: #FF0000;
    font-size: 100pt;
    -webkit-transform: rotate(-25deg);
    -moz-transform: rotate(-45deg);
    position: absolute;
    width: auto;
    height: auto;
    margin: 0;
    z-index: 9999;
    text-align: center;
    top: 100px;
    right: 100px;
    opacity: 0.2;
    display: block;
    margin: auto;
    left: 35px;
}
	/* #watermark{
	  color: #FF0000;
	  font-size: 100pt;
	  -webkit-transform: rotate(-25deg);
	  -moz-transform: rotate(-45deg);
	  position: absolute;
	  width: 100%;
	  height: 100%;
	  margin: 0;
	  z-index: -1;
	  text-align:center;
	  top:50px;
	  left:100px;
	  opacity:0.2;
	} */

	a.no_print1 {
		color: #2d6ca2;
		text-decoration: none !important;
		font-size: 0.9rem;
		margin-left: 14px;
		background: #a4a4a433;
		padding: 10px;
		margin-top: 10px;
		display: block;
		width: 100px;
		border-radius: 5px;
		text-align: center;
		position: fixed;
		top: 10px;
		font-weight: 600;
		letter-spacing: normal;
	}

	a.no_print1:hover {
		text-decoration: underline;
	}

	
	.header-title{
		text-align: center;
		font-size: 21px;
		font-weight: bolder;
		margin-bottom: 0px;
		margin-top: 0px;
	}
	.jb_detail{
	table-layout: fixed;
 	 width: 100%;
 	 border-collapse: collapse;
	}

	
	.jb_detail td{
 		height: 18px;
 	}

	.jb_detail  tr {   
		white-space: nowrap;
		line-height: 16px;
	}
	.vat-top-right{
		text-align: right;
		font-size: 14px;
		font-weight: 600;
		margin-bottom: 0;
	}
	.print-body-area{
		/* height: 620px; */
		min-height: 620px;
	}
	.system-info-gen{
		display: block;
		margin: auto;
		float: left;
		font-size: 11px;
		color: #dd2c2c;
		text-align: center;
		width: 100%;
		margin-bottom: 2px;
		font-weight: 600;
	}
	.subject-class {
		font-size: 11px;
		padding: 5px 0 0 0px;
		margin-bottom: 0;
		font-weight: 600;
	}

	.pagination-page-break{
		display: none !important;
	}


	@media print {
		.rightSpan h3 {
			margin: 0px;
		}

		.rightSpan h4 {
			margin: 0px;
		}

		.no_print {
			display: none;
		}

		.no_print1 {
			display: none !important;
		}
		header, footer {
        	display: none; /* Hide header and footer */
		}
		body {
			-webkit-print-color-adjust: exact; /* Ensures colors are printed as seen on screen */
			print-color-adjust: exact; /* For non-WebKit browsers */
			margin-bottom: 100px;
		}
		.print-footer-area {
			position: fixed;
			bottom: 0;
			left: 0;
			right: 0;
			width: 100%;
			font-size: 12px;
			page-break-inside: avoid;
			/* z-index: 9999; */
		}
		.print-footer-area img {
			max-width: 100%;
			height: auto;
			display: block;
			position: relative;
			z-index: 99999;
			top: 0;
			bottom: 0;
		}
 
		table { 
			page-break-inside: auto;
		}
		/* tr { page-break-inside: avoid; page-break-after: auto; } */
		thead { 
			display: table-header-group; 
		}
		tfoot { 
			display: table-footer-group; 
		}
		.page-break { 
			page-break-after: always; 
		}
		.print-only{
			display: table-header-group !important;
		}
		thead {
			display: table-header-group;
		}
		tfoot {
			display: table-footer-group;
		}
		table.invoice {
			page-break-inside: auto;
		}

		tr{
			page-break-inside: avoid;
		}
		.page-break {
			page-break-after: always; /* break page after each div */
			break-after: page;
		}
	}
	@media screen {
		.print-only, .pagination-header, .print-header,.page-break{
			display: none !important;
		}
		/* .page-break {
			page-break-after: auto;
			break-after: auto;
		} */

		.screen-logo {
			display: block;
			text-align: center;
			margin-bottom: 20px;
		}
		.page-break {
			display: none;
		}
	}

	@media print {
    thead {
        display: table-header-group;
    }
    tfoot {
        display: table-footer-group;
    }
    .page-break-print {
        page-break-after: always;
        break-after: page;
    }

	.print-header {
        display: block !important;
        text-align: center;
        margin-bottom: 10px;
    }
    .screen-logo {
        display: none !important;
    }
}
@media screen {
    .page-break-print {
        display: none;
    }
	.print-header {
        display: none !important;
    }
    .screen-logo {
        display: block;
    }
	.new_table{
		border-top: 0px !important;
		margin-top: 0px !important;
 	}
}
  </style>
</head>
<body>
<span class='icon-print no_print'></span><a class='no_print1' href='javascript:window.print();'> <i class="fa fa-print" aria-hidden="true"></i> Print</a><br />

<?php if($invoice_status==1) { ?>
<div id="watermark">cancelled</div>
<?php } ?><?php if($invoice_status==2) { ?>
<!-- <div id="watermark">Draft</div> -->
<?php } ?>
	
	<div class="outer_wrapper">
	    <div class="print-header-area">
			<div class="screen-logo">
				<div class="header-logo" style="display:block;margin:auto; width:700px; padding-bottom:0px;">
					<img src="<?=base_url()."images/awadhilogo.png"?>" alt="" style="height:110px;width:700px; padding:0px;"/>
					<!--<img src="<?php echo base_url()."images/company_logo/".$logo_filename; ?>" alt=""  style="height:150px;width:600px; padding:0px;"  class="logo"/>-->
				</div>
			</div>
			<?php  printLogoHeader(); ?>
		</div>
		<div class="header-title">TAX INVOICE</div>
		<div class="vat-top-right">VAT No.:	<?php if(isset($company_details->tax_no)){ if($company_details->tax_no!=""){  echo $company_details->tax_no; } }  ?></div>
		<div class="print-body-area">
			<table class="mainTable " style="border: 1px  inset #666;border-collapse: collapse; ">
				<tbody>
					<tr>
						<td valign="top" style="width: 60%; border-right: 1px  solid #666;">
							<table border="0px" class="jb_detail" >
								<tr>
									<td valign="middle" colspan="4" style="border-collapse: collapse; font-size:12px; font-weight: 500;white-space: nowrap;">Customer : </td>
								</tr>
								<tr>
									<td valign="middle" style="padding-left: 10px;"><span class="details" style="font-weight: bold;white-space: nowrap;"><?php echo $client_name;?></span></td>
								</tr>
								<tr>
									<td valign="middle" style="padding-left: 10px;white-space: nowrap;"><span class="details"><?php echo $client_address;?></span></td>
								</tr>
								
								<?php /* if($tax_name){*/?>
								<!-- <tr> 
									<td valign="middle" width="15%"  style="border-collapse: collapse; font-weight: 600; padding-left: 10px;"> <span class="details">Vat Name</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 500;"><span class="details"> <?php echo $tax_name;?></span></td>
								</tr> -->
								<?php /* }*/ ?>
								<?php /*if($tax_no){*/?>
								<tr>                      	 									
									<td valign="middle" width="35%"   style=" font-size:11px; border-collapse: collapse; font-weight: 600; padding-left: 10px;">Vat No.&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;&nbsp;</span> <?php echo $tax_no;?></td>
								</tr>
								<?php /* } */?>
							</table>
						</td>
						<td valign="top" style="width: 40%;">
							<table border="0px" class="jb_detail" >
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">Invoice No</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600;"><span class="details"> <?php echo $invoice_number;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">Invoice Date</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo date('M d, Y',strtotime($invoice_date));?></span></td>
								</tr>
								<?php if($quotation_number!="") { ?>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">Quotation No</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo $quotation_number_full;?></span></td>
								</tr>
								<?php } ?>
								<?php /* if($is_insurance != 0) { ?>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">LPO No</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo $lpono;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">LPO Date</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo date('d-m-Y', strtotime($lpo_date));?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">Claim No</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo $claim_no;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">Claim Amount</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo number_format($claim_amount,3,'.','');?></span></td>
								</tr>
								<?php } */ ?>
							</table>	
						</td>
					</tr>
				</tbody>	
			</table>
			<table class="mainTable " style="border: 1px  inset #666; margin-top:10px ;border-collapse: collapse;">
				<tbody>
					<tr>					
						<td valign="top" style="width: 33%; border-right: 1px  solid #666; border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" >
								<tr style="border-bottom: 1px  inset #666;">
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> <span class="details">Reg No</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600; border-bottom: 1px  inset #666;padding:2px;"><span class="details"> <?php echo $reg_no;?> ( <?=$vtype_name;?> )</span></td>
								</tr>
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Year</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?php echo $car_year;?></span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 33%; border-right: 1px  solid #666;border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" >
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> <span class="details">KM.IN</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600; border-bottom: 1px  inset #666;padding:2px;"><span class="details"> <?php echo $Km_in;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Chaiss No</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?php echo $chassi_number;?></span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 33%;padding:0px;">
							<table  class="jb_detail" style="padding:5px;">
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> <span class="details">Make</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600; border-bottom: 1px  inset #666;padding:2px;"><span class="details"> <?php echo $vname;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Color</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?php echo $car_color;?></span></td>
								</tr>
							</table>	
						</td>
					</tr>
				</tbody>	
			</table>

			<?php if($is_insurance == 1) {?>
			<table class="mainTable " style="border: 1px  inset #666; margin-top:10px ;border-collapse: collapse;">
				<tbody>
					<tr>					
						<td valign="top" style="width: 28%; border-right: 1px  solid #666; border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" >
								<tr style="border-bottom: 0px  inset #666;">
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> <span class="details">LPO No</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> : </td>
									<td valign="middle" style="border-collapse: collapse; font-weight: 600; border-bottom: 0px  inset #666;padding:2px;"><span class="details"> <?php echo $lpono;?> </span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 21%; border-right: 1px  solid #666;border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" >
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500; border-bottom:0px  inset #666;padding:2px;"> <span class="details">LPO Date</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> : </td>
									<td valign="middle" style="border-collapse: collapse; font-weight: 600; border-bottom: 0px  inset #666;padding:2px;"><span class="details"> <?php echo date('d-m-Y', strtotime($lpo_date));?></span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 28%;padding:0px;border-right: 1px  solid #666;border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" style="padding:5px;">
								<tr>
									<td valign="middle" width="30%" style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> <span class="details">Claim No</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> : </td>
									<td valign="middle" style="border-collapse: collapse; font-weight: 600; border-bottom: 0px  inset #666;padding:2px;"><span class="details"> <?php echo $claim_no;?></span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 23%;padding:0px;">
							<table  class="jb_detail" style="padding:5px;">
								<tr>
									<td valign="middle" width="45%" style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> <span class="details">Claim Amount</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 0px  inset #666;padding:2px;"> : </td>
									<td valign="middle" style="border-collapse: collapse; font-weight: 600; border-bottom: 0px  inset #666;padding:2px;"><span class="details">   <?php echo $currency_code.' '. number_format($claim_amount,3,'.','');?></span></td>
								</tr>
							</table>	
						</td>
					</tr>
				</tbody>	
			</table>
			<?php } ?>
			<div class="subject-class">Subject &nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;&nbsp;
				<?php
				    $searchString = "LABOUR CHARGE";
					$vdesc        = str_replace($searchString, '', $subject);
					echo $vdesc;
				?>			
			</div>
			<table class="invoice first_table" style="border-top:none; border: 1px inset #666; width: 100%; border-collapse: collapse;margin-top:10px;line-height:16px;width:100%">
				<thead>  
					<tr>
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="40%">ITEM</th>
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="5%">QTY</th>
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="5%">Unit</th>
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: normal; text-align:center;line-height:10px;" width="10%">&nbsp;Rate <br/>&nbsp;&nbsp;<?php echo ' ('.$currency_code.')' ?>&nbsp;&nbsp;</th>
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">Discount %<br />
							<small style="font-size: 9px; color: #666; font-style: italic;">(Discount)</small></th>
						<!-- <th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="5%">Dis.Amt</th> -->
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: normal; text-align:center;line-height:10px;" width="10%">Amount<br/><?php echo ' ('.$currency_code.')' ?>&nbsp;&nbsp;</th>
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">Vat%<br/>
							<small style="font-size: 9px; color: #666; font-style: italic;">(Vat Amount)</small>
						</th>
						<!-- <th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="5%">Vat.Amt</th> -->
						<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">&nbsp;&nbsp;Net Amount</th>
				</tr>
				</thead>
				<tbody style="border-top:1px inset #666;border-collapse: collapse;">
					<?php
					foreach ($flat_rows as $row) {
						if ($row['type'] === 'group') {
							echo '<tr><td colspan="10" class="details" style="border-top:1px inset #666;font-weight:600;border-bottom:0px inset #666;border-collapse: collapse;padding:1.px;text-align:left">' . 
								htmlspecialchars($row['label']) . '</td></tr>';
						}
						elseif ($row['type'] === 'subgroup') {
							echo '<tr><td colspan="10" class="details" style="border-top:1px inset #666;font-weight:600;border-bottom:0px inset #666;border-collapse: collapse;padding:1.px;text-align:left">' . 
								htmlspecialchars($row['label']) . '</td></tr>';
						}
						elseif ($row['type'] === 'item') {
							$item = $row['data'];
							// Compute rate and discount percent
							$rate = 0.0;
							if ($item['quantity'] != 0) {
								$rate = ($item['amount'] + $item['item_discount']) / $item['quantity'];
							}
							$disc_pct = 0.0;
							if ($rate != 0) {
								$disc_pct = ($item['item_discount'] / ($rate * $item['quantity'])) * 100;
							}
							echo '<tr style="line-height:3px;">
										<td class="details" width="40%" style="line-height: 11px;font-size:10px;text-transform:capitalize;border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0px 3px 0 3px; white-space: pre-wrap;">'.$item['item_name'].' </td>
										<td class="details" width="5%" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap; text-align:center;">'.number_format($item['quantity'],0,'.','').'</td>
										<td class="details" width="5%" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap; text-align:center;">'.$item['uom'].'</td>
										<td class="details" width="10%" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format(($item['amount']+ $item['item_discount'])/$item['quantity'],3,'.','').'</td>
										<td class="details" width="10%" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:8px 3px 0 3px; white-space: nowrap;text-align:right;">
												<div >&nbsp;</div>
												'.number_format($disc_pct,0,'.','').'%
												<!--<div style="font-size:9px; color:#666;">Disc</div>-->
												<div style="padding-top:8px;margin-bottom: 6.7px;">'.number_format($item['item_discount'], 3, '.', '').'</div>
										</td>
										<!--<td class="details" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($item['item_discount'], 3,'.','').'</td>-->
										<td class="details" width="10%" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($item['amount'],3,'.','').' </td>
										<td class="details" width="10%" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:8px 3px 0 3px; white-space: nowrap;text-align:right;">
											<div >&nbsp;</div>
											'.number_format($item['vat_perce'],0,'.','').'%
											<div style="padding-top:8px;margin-bottom: 6.7px;">'.number_format($item['vat_amount'], 3, '.', '').'</div>
										</td>
										<!--<td class="details" style="border-top: none;border-right:0px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($item['vat_amount'],3,'.','').'</td>-->
										<td class="details" width="10%" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($item['net_amount'],3,'.','').'</td>
									</tr>';
						}
						$item_counter++;
						if ($item_counter >= $current_limit) {
							echo '</tbody></table>';         //End current table
							echo '<div class="page-break-print"></div>';
								//echo '<tr class="page-break-print" style="border-bottom:1px inset #666;"><td colspan="8">&nbsp;</td></tr>';
								printLogoHeader();
								// reset counters for next page
								$item_counter  = 0;
								$page_index++;
								$current_limit = ($page_index === 0 ? $first_page_limit : $other_pages_limit);
								//$current_limit = $other_pages_limit;
							   // New table start
								   echo '<table class="invoice new_table" style=" border: 1px inset #666; width: 100%; border-collapse: collapse;margin-top:10px;line-height:16px;width:100%">
								   <thead class="print-only">  
										<tr>
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="40%">ITEM</th>
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="5%">QTY</th>
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="5%">Unit</th>
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: normal; text-align:center;line-height:10px;" width="10%">&nbsp;Rate <br/>&nbsp;&nbsp;'.'('.$currency_code.')'.'&nbsp;&nbsp;</th>
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">Discount %<br />
												<small style="font-size: 9px; color: #666; font-style: italic;">(Discount)</small></th>
											<!-- <th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="5%">Dis.Amt</th> -->
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: normal; text-align:center;line-height:10px;" width="10%">Amount<br/>'.'('.$currency_code.')'.'&nbsp;&nbsp;</th>
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">Vat%<br/>
												<small style="font-size: 9px; color: #666; font-style: italic;">(Vat Amount)</small>
											</th>
											<!-- <th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="5%">Vat.Amt</th> -->
											<th style="border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">&nbsp;&nbsp;Net Amount</th>
									</tr>
									</thead>
								 <tbody style="border-top:1px inset #666;border-collapse: collapse;">';
						}
					}
					?>
				</tbody>
				<tfoot>
					<tr>
						<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap; text-align:right;font-weight:600;border-right:0px !important;">Total</td>
						<td class="details" style="border-bottom:1px inset #666;border-top:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;border-right:0px !important"></td>
						<td class="details" style="border-bottom:1px inset #666;border-top:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;border-right:0px !important"></td>
						<td class="details" style="border-bottom:1px inset #666;border-top:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;border-right:0px !important"></td>
						<!-- <td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;"></td> -->
						<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_discount,3,'.','');?></td>
						<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_amount,3,'.','');?></td>
						<!-- <td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;"></td> -->
						<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_vat_amt,3,'.','');?></td>
						<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:3.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_net_amnt,3,'.','');?></td>
					</tr>
					<tr>
						<td valign="top" colspan="4" style="width: 100%; border-right: 1px  solid #666;">
							<table border="0px" class="jb_detail" >
								<tr>
									<td valign="middle"  style="padding-left: 5px;border-collapse: collapse; font-size:11px; font-weight: 600;white-space: normal;padding-bottom:5px">Amount &nbsp;&nbsp;:&nbsp;&nbsp; 
										<?php
											//$inv_amnt = round($invoice_percentage_amount-$invoice_discount,3);
											if($round_off > 0){
												if($sign == '-'){
													$inv_total = $total_net_amnt - $round_off ;
												}
												else{
													$inv_total =   $total_net_amnt + $round_off ;
												}												
											}
											else{
												$inv_total =   $total_net_amnt;
											}
											$inv_amnt =  round($inv_total,3);
											$intpart=(int) $inv_amnt;
											$floatpart=(round($inv_amnt,3)*pow(10,3)-($intpart*pow(10,3)));
											if($floatpart !=0) { 
												echo ucwords($currency_name).'&nbsp'.num_words($intpart) . '&nbsp;&amp;&nbsp;Fils &nbsp;' .num_words($floatpart). " Only";
											} else {
												echo ucwords($currency_name).'&nbsp'.num_words($intpart)." Only";
											}
										?>
									</td>
								</tr>
								<tr>
									<td valign="middle"  style="padding-left: 5px;"><span class="details" style="font-size:11px; font-weight: 600;white-space: normal;">VAT Amount &nbsp;&nbsp;:&nbsp;&nbsp; 
										<?php
											$vat_amt_wrd = round($total_vat_amt,3);
											$intpart=(int) $vat_amt_wrd;
											$floatpart=(round($vat_amt_wrd,3)*pow(10,3)-($intpart*pow(10,3)));
											//$floatpart= $vat_amt_wrd - floor($vat_amt_wrd);
											if($floatpart !=0) { 
												echo ucwords($currency_name).'&nbsp'.num_words($intpart) . '&nbsp;&amp;&nbsp;Fils &nbsp;' .num_words($floatpart). " Only";
											} else {
												echo ucwords($currency_name).'&nbsp'.num_words($intpart)." Only";
											}
										?>
									</td>
								</tr>						
							</table>
						</td>
						<td valign="top" colspan="4" style="width: 100%; text-align:right;">
							<table border="0px" class="jb_detail"  style="width: 100%; text-align:right;" >
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Amount Excl.VAT</span></td>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td colspan="2" valign="middle" width="35%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?= $currency_code .'&nbsp'. number_format($total_amount,3,'.','');?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">VAT</span></td>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td colspan="2" valign="middle" width="35%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?= $currency_code .'&nbsp'. number_format($total_vat_amt,3,'.','');?></span></td>
								</tr>
								<?php  if($round_off > 0){
										echo '<tr>
											<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Round Off</span></td>
											<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
											<td colspan="2" valign="middle" width="35%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"> '.$currency_code .'&nbsp'. number_format($round_off,3,'.','').'</span></td>
										</tr>';
									}
								?>			
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Net.Amount</span></td>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td colspan="2" valign="middle" width="35%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?= $currency_code .'&nbsp'. number_format($inv_total,3,'.','');?></span></td>
								</tr>
								<!-- <tr>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> </td>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Advance.Amt</span></td>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle" width="35%" style="text-align:left; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?= $currency_code .'&nbsp'. number_format($total_vat_amt,3,'.','');?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> </td>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Balance.Amt</span></td>
									<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle" width="35%" style="text-align:left; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?= $currency_code .'&nbsp'. number_format($total_net_amnt,3,'.','');?></span></td>
								</tr>-->
							</table>	
						</td>
					</tr>
				</tfoot>
			</table>
		</div>
 
		<div class="print-footer-area">
			<span class="quotationIntro footer_content">
				<table width="100%">
					<tr>
						<td class="details">
							<p></p><br/>
							<p>Customer Name and Signature</p>
						</td>
						<td align="right" class="details">
							<p></p><br/><br/>
							<p>For <?php if(isset($company_details->company_name)){ echo $company_details->company_name;} ?></p>
						</td>
					</tr>
				</table>
			</span>													
			<div class="system-info-gen">
				This is a computer generated document. Signature is not mandatory.
			</div>
			<table class="table" width="100%" border="0">
				<tr>
				<td width="15%" class="table-cell" style="text-align:center; text-transform: uppercase !important; border:none;">								
						<img src="<?= base_url()."images/trio_plus_pdf_footer1.png" ?>" alt="" style="height:auto;width:700px;" /> 
					</td>
				</tr>
			</table>
		</div>
	</div>
</body>
</html>