
	<style>
		div.dt-buttons {
			float: right;
			padding-left: 15px;
			padding-right: 15px;
		}
		.dataTables_length {
			position: absolute;
		}
		.client_result {
			border: 1px solid #d2d6de;
			position: absolute;
			width: 347px;
			height: auto;
			background-color: #fff;
			z-index: 100;
			margin-top: 0px;
			border-radius: 3px;
			display: none;
		}
		.clientList {
			margin:0px;
		}
		.clientList li {
			color: #000000;
			padding: 0;
			padding-left: 8px;
			height: 30px;
			padding-top: 4px;
			cursor:pointer;
			font-weight:600;
			list-style-type: none;
		}
		.clientList li:hover {
			background:#CCCCCC;
		}
		.nbactive{
			background-color:#D6D6D6;
		}
	</style>
    <!--app-content open-->
	<div class="app-content main-content">
		<div class="side-app">
			<div class="main-container">
				<!-- PAGE-HEADER -->
				<div class="page-header">
					<div class="col-xl-5 col-lg-6 col-md-5 col-sm-6">
						<h1 class="page-title">Receipt List</h1>
                    </div>
					<div class="col-xl-7 col-lg-6 col-md-7 col-sm-6">
                        <div class="float-sm-end float-none my-1">
							<?php if($this->users_model->check_permission("Receipt","Add")!=false){ ?>
							<a id="add__new__list" type="button" class="btn btn-md btn-primary " data-bs-target=".bd-example-modal-lg" href="<?php echo site_url('Receipt/create_receipt');?>"><i class="fa fa-plus"></i> Add a new Receipt</a>
							<?php } ?>
						</div>
                    </div>
				</div>
			</div>
			<!-- PAGE-HEADER END -->
			<!-- ROW-1 -->
			<div class="row">
				<div class="col-md-12 col-lg-12">
					<div class="card">
						<div class="card-body">
							<h3 class="card-title">Receipt List</h3>
						</div>
						<?php
							if($this->session->flashdata("response")!='') {
								echo '<div class="alert alert-danger">' . $this->session->flashdata("response") . '</div>';
								$this->session->unset_userdata('response');
							}
						?>
						<?php
							if($this->session->flashdata("success")!='') {
								echo '<div class="alert alert-success">' . $this->session->flashdata("success") . '</div>';
								$this->session->unset_userdata('success');
							}
						?>
						<form id="data-form" class="form-search" method="post" enctype="multipart/form-data" action="<?php echo site_url('Receipt/list_receipt');?>">
							<div class="form-row">
								<div class="form-group col-md-2 mb-0">
									<div class="form-group">
										<input type="text" class="form-control fromDate" id="fromDate" name="fromDate" placeholder="From Date" value="<?php if ($this->input->post('fromDate')){  echo $this->input->post('fromDate'); } elseif($fromDate!=='NIL'){ echo date( "d-m-Y", strtotime($fromDate)); }?>"  autocomplete="off"  >
									</div>
								</div>
								<div class="form-group col-md-2 mb-0">
									<div class="form-group">
										<input type="text" class="form-control  toDate" id="toDate" name="toDate" placeholder="To Date" value="<?php if ($this->input->post('toDate')){  echo $this->input->post('toDate'); } elseif($toDate!=='NIL'){ echo date( "d-m-Y", strtotime($toDate)); }?>"  autocomplete="off" >
									</div>
								</div>
								<div class="form-group col-md-2 mb-0">
									<div class="form-group">
										<input type="text" class="form-control" id="receipt_no" name="receipt_no" placeholder="Receipt No" value="<?php if ($this->input->post('receipt_no')){  echo $this->input->post('receipt_no'); } elseif($receipt_no!=='NIL'){ echo $receipt_no; }?>"  autocomplete="off" >
										<input type="hidden" class="form-control" id="nbx" name="nbx" value="1" placeholder="Qtn No">
									</div>
								</div>
								<div class="form-group col-md-3 mb-0">
									<div class="form-group">
										<input type="text" class="form-control client" name="client" id="client" placeholder="Customer" autocomplete="off" value="<?php if ($this->input->post('client')){  echo $this->input->post('client'); } elseif($customer_name!=='NIL'){ echo $customer_name; }?>"   autocomplete="off" >
										<input type="hidden" id="client_id" class="form-control client_id" name="client_id" value="<?php if ($this->input->post('client_id')){  echo $this->input->post('client_id'); } elseif($client_id!=='NIL'){ echo $client_id; } ?>"   autocomplete="off"   />
										<div class="client_result">
											<ul class="clientList unstyled" >
											</ul>
										</div>
									</div>
								</div>
								<div class="col-md-1 mb-0">
									<div class="form-group">
										<button class="btn btn-primary" type="submit" name="ttttt" ><i class="fe fe-search"></i></button>
									</div>
								</div>
							</div>
						</form>
						<div class="table-responsive">
							<table id="receipt_data" class="table card-table ">
								<thead class="thead-light"  >
									<tr>
										<th>Receipt Number</th>
										<th>Client</th>
										<th>Receipt Date</th>
										<th>Receipt Amount</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$DeleteReceiptPermission=$this->users_model->check_permission("Receipt","Delete");
									$EditReceiptPermission=$this->users_model->check_permission("Receipt","Edit");
										if($receipts != false) {
											foreach($receipts as $receipts) {
												$style='';
			
												if($receipts['receipt_status']=='0'){
													$style= 'style="background: #f5d2d2;color:#6b1110;"';
												} else {
													$style='';
												}
									?>
									<tr <?php  echo $style;?> >
										<td>
											<?php echo $receipts['receipt_code'];?>
										</td>
										<td><?php echo $receipts['client_name'];?></td>
										<td><?php echo date('M d,Y',strtotime ($receipts['receipt_date']));?></td>
										<td><?php echo number_format($receipts['receipt_amount'],3);?></td>
										<td style="width:100px;">
											<div class="btn-group">
												<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
												Action <span class="caret"></span>
												</button>
												<ul class="dropdown-menu" role="menu">
													<li><a class="click2" target="_blank" href="<?php echo site_url('furniture/Furniture_receipt/view1/'.$receipts["receipt_id"].'/'.$receipts['receipt_number'].'/'.$receipts['quotation_divisionid'].'/pdf'); ?>"  ><i class="fa fa-print"></i> Print</a></li>
													<?php if($DeleteReceiptPermission){ ?>
														<li><a class="click2" href="javascript:ConfirmDelete('<?php echo $receipts['receipt_number'];?>','<?php echo $receipts['quotation_divisionid'];?>','<?php echo $receipts['receipt_id'];?>','<?php echo $receipts['receipt_code'];?>')"  ><i class="fa fa-mail-forward"></i> Cancel</a></li>
													<?php } ?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } } ?>
								</tbody>
							</table>
						</div>
						<?php echo $pagination; ?>
						<!-- table-responsive -->
					</div>
				</div>
			</div>
			<!-- ROW-1 CLOSED -->
		</div>
	</div>
						</div>
						<!-- ROW-4 CLOSED -->
					</div>
				</div>
				<!-- CONTAINER CLOSED -->
			</div>

	<script type="text/javascript">
		$(function(e) {
			$('#receipt_data').DataTable({
				"paging": true,
				"processing": true,
				"scrollCollapse": true,
				"order": [[0, 'desc']],
				"iDisplayLength": 100,
				"lengthMenu": [ [100, 150, 200, -1], [100, 150, 200, "All"] ],
				"info": true,
				dom: 'lBfrtip',
				buttons: [
					{ extend: 'copyHtml5',title: '',text: 'Copy',header: false, text:'<i class="fa fa-copy"></i>',titleAttr: 'Copy', className: 'btn-primary' },
					{ extend: 'excelHtml5',title: 'Receipt Data',filename: function(){ var today = new Date();var n = today.getTime();return 'ReceiptExcelExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Excel', text:'<i class="fa fa-file-excel-o"></i>',titleAttr: 'Excel', className: 'btn-success' },
					{ extend: 'print',title: 'Receipt Data',filename: function(){ var today = new Date();var n = today.getTime();return 'ReceiptPrintExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Print', text:'<i class="fa fa-print"></i>',titleAttr: 'Print', className: 'btn-warning' },
					
				]
			});
			//
			// Select2 { extend: 'csvHtml5',text: 'CSV',header: false, text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'CSV', className: 'btn-warning' },
			//{ extend: 'colvis',title: '',filename: 'fileName',text: 'Pdf', text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'Pdf', className: 'btn-warning' },
		} );
		function ConfirmDelete(receipt_number,quotation_divisionid,receipt_id,receipt_code){
			$('body').removeClass('timer-alert');
			swal({
					title: "Alert",
					text: "Are you sure you want to Cancel this Receipt ??",
					type: "warning",
					showCancelButton: true,
					confirmButtonText: 'Yes',
					cancelButtonText: 'Cancel'
				},
				function(isConfirm){
				if (isConfirm) {
					document.location.href="<?php echo site_url('Receipt/cancel_receipt'); ?>/"+receipt_number+"/"+quotation_divisionid+"/"+receipt_id+"/"+receipt_code;
					//window.location = "Receipt/cancel_receipt/"+receipt_number+"/"+quotation_divisionid+"/"+receipt_id;
				} else {
					swal("Cancelled", "Something went wrong :)", "error");
				}
			});
		}
		$("html").on("keyup",".client",function(){
			
			var client	=	$(this).val();
			$('.client_id').val('');
			$('.client_address').val('');
			$("#prospect_name").val('');
			$('#prospect_name').attr('readonly', false);
			$(".client_id").val('');
			$("#phone").val('');
			$("#email").val('');
			$(".cname").html('');
			$(".cphone").html('');
			$(".cemail").html('');
			$(".caddress").html('');
			$(".cperson").html('');
			$(".tax_name").html('');
			$(".tax_no").html('');
			if (client==''){
				$(".client_result").css('display','none');
				$(this).val("");
				return false;
			} else {
				$.ajax({
					url:"<?php echo site_url("receipt/search_client")?>" , 
					type: "POST" ,
					data: {client	: client} ,
					success: function(data){
						$(".client_result").css('display','block');
						$(".clientList").html(data);
						client_button();
						$('.client').keydown(function (ex) {
							if (ex.keyCode == 40) {
								$('.clientList').on('focus', 'li', function() {
									$this = $(this);
									$this.addClass('nbactive').siblings().removeClass();
									$this.closest('.clientList').scrollTop($this.index() * $this.outerHeight());
								}).on('keydown', 'li', function(e) {
									$this = $(this);
									if (e.keyCode == 40) {        
										$this.next().focus();
										return false;
									} else if (e.keyCode == 38) {        
										$this.prev().focus();
										return false;
									}
								}).find('li').first().focus();
							}
						});
						$(".clientList li").keypress(function (e) {
							if (e.keyCode == 13) {
								$(".client_result").css('display','none');
								var client_id	=	($(this).attr('value'));
								var client_name = ($(this).attr('data-client_name'));
								$(".client").val(client_name);
								$(".client_id").val(client_id);
							}
						});
					},
					error: function(){
							$("#errorMsg").html('Connection Error......');
							$("#errorMsg").stop(true, true, true).slideDown(500);
					}
				});
			}
		});
		function client_button() {
			$(".client_button").click(function() {
				$(".client_result").css('display','none');
				var client_id	=	($(this).attr('value'));
				var client_name = ($(this).attr('data-client_name'));
				$(".client").val(client_name);
				$(".client_id").val(client_id);
			});
			$(".no_result_button").click(function() {
				$("#category_result").css('display','none');
				$(".client").val('');
				$(".client_id").val('');
			});
		}
	</script>
<script src="<?php echo base_url(); ?>/admincss/plugins/date-picker/jquery-ui.js"></script>	