$.fn.extend({
    treed: function (o) {
      
      var openedClass = 'fe fe-folder-minus';
      var closedClass = 'fe fe-folder-plus';
      
      if (typeof o != 'undefined'){
        if (typeof o.openedClass != 'undefined'){
        openedClass = o.openedClass;
        }
        if (typeof o.closedClass != 'undefined'){
        closedClass = o.closedClass;
        }
      };
      
        //initialize each of the top levels
        var tree = $(this);
        tree.addClass("tree");
        tree.find('li').has("ul").each(function () {
            var branch = $(this); //li with children ul
            branch.prepend("<i class='si " + closedClass + "'></i>");
            branch.addClass('branch');
            branch.on('click', function (e) {
                if (this == e.target) {
                    var icon = $(this).children('i:first');
                    icon.toggleClass(openedClass + " " + closedClass);
                    $(this).children().children().toggle();
                }
            })
            branch.children().children().toggle();
        });
		tree.find('.branch i').each(function () {
            $(this).on('click', function (e) {
                $(this).closest('li').click();
                e.preventDefault();
            });
        });
        //fire event from the dynamically added icon
      tree.find('.branch .indicator').each(function(){
        $(this).on('click', function () {
            $(this).closest('li').click();
        });
      });
        //fire event to open branch if the li contains an anchor instead of text
        tree.find('.branch>a').each(function () {
            $(this).on('click', function (e) {
                $(this).closest('li').click();
                e.preventDefault();
            });
        });
        //fire event to open branch if the li contains a button instead of text
        tree.find('.branch>button').each(function () {
            $(this).on('click', function (e) {
                $(this).closest('li').click();
                e.preventDefault();
            });
        });
    }
});

//Initialization of treeviews

$('#treeview1').treed();

$('#treeview2').treed();

$('#treeview3').treed();

$('#tree1').treed();

$('#tree2').treed({openedClass:'fe fe-file-minus', closedClass:'fe fe-file-plus'});

$('#tree3').treed({openedClass:'fe fe-minus', closedClass:'fe fe-plus'});

$('#tree4').treed({openedClass:'fe fe-minus', closedClass:'fe fe-plus'});

$('#tree5').treed({openedClass:'fe fe-minus', closedClass:'fe fe-plus'});
