<?php
class My_account extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->library('form_validation');
		}
	function index()
	{
		$title['headerTitle']="My Account";
		$this->load->model('users_model');
		
		$where=array('user_id' => $this->session->userdata('user_id'));
		$rs=$this->users_model->get_full_details($where);
		
		if($rs != false){
			//true section
			$data['user_name']			 = $rs[0]['user_name'];
			$data['user_contact_number'] = $rs[0]['user_contact_number'];
			$data['user_direct_number']	 = $rs[0]['user_direct_number'];
			$data['user_email_id'] 	 	 = $rs[0]['user_email_id'];
			$data['user_group_name'] 	 = $rs[0]['user_group_name'];
			
			$this->load->view('templates/header',$title);
			$this->load->view('login/my_account',$data);
			$this->load->view('templates/footer');
		}
		else{
			//false section
			$this->session->set_flashdata('response','Some errors occured. Please login again.');
			redirect('login');
		}
	}
	function do_update_account()
	{

		$this->form_validation->set_rules('user_name', 'Full Name', 'required|max_length[20]');
		$this->form_validation->set_rules('user_contact_number', 'Mobile Number', 'required|max_length[40]');
		$this->form_validation->set_rules('user_direct_number', 'Direct Number', 'required|max_length[20]');
		if ($this->form_validation->run() == FALSE)
		{	// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');

			$this->index();
		}
		else
		{
		
			$user_name= $this->input->post('user_name');
			$user_contact_number= $this->input->post('user_contact_number');
			$user_direct_number= $this->input->post('user_direct_number');
			$data=array('user_name' => $user_name,
				'user_contact_number' => $user_contact_number,
				'user_direct_number' => $user_direct_number
			);
			
			$where= array('user_id' => $this->session->userdata('user_id'));
			
			$rr=$this->crud_model->update('users',$data,$where);
			
			$this->session->set_flashdata('success','Account information updated');
			redirect('my_account');
		}
	}
	function do_change_password()
	{

		$this->form_validation->set_rules('current_password', 'Current Password', 'required|max_length[20]');
		$this->form_validation->set_rules('new_password', 'New Password', 'required|min_length[6]|max_length[15]|matches[retype_password]');
		$this->form_validation->set_rules('retype_password', 'Retyped Password', 'required|max_length[15]');
		if ($this->form_validation->run() == FALSE)
		{// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->index();
		}
		else
		{// true section
			
			$where = array(
				'user_id' => $this->session->userdata('user_id'),
				'user_password' => md5($this->input->post('current_password'))
			);
			
			$records = $this->crud_model->get('users',$where);
			if($records != false){
				// true section
				$data = array('user_password' => md5($this->input->post('new_password')));
				
				// update new password
				$this->crud_model->update('users',$data,$where);
				
				$this->session->set_flashdata('success','Password updated.');
				redirect('my_account');
			}
			else{
				//false section
				$this->session->set_flashdata('response','Invalid current password entered.',':old:');
				$this->index();
			}
		}

	}
}

