<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Trial_balance extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
	}	
	
	
	public function index($status='') {
		if($status == "result" ) {
			$this->form_validation->set_rules('report_date_from', 'Date', 'callback_date_check');
			$this->form_validation->set_rules('report_date_to', 'Date', 'callback_date_check');
			
			$error_flag = false;
			$error_msg = '';
			$quotation_type = "furniture";
			
			if ($this->form_validation->run() == FALSE || $error_flag) {
				// false section
				$this->session->set_flashdata('response',''.validation_errors().$error_msg.'',':old:');
				$data['records'] = false;
			} else {
				$data['records']=false;
				//Furniture Quotations...
				$data['quotation_type'] = "furniture";
				$where = array();
				//$where['acc.status'] = 1;
				//$where['ag.acc_group_parent'] = 0;
				/* if($this->input->post('user_id') != 0 ) {
					$where['salesman_id'] = $this->input->post('user_id');
				}
				if($this->input->post('quotation_status')) {
					$where['quotation_status'] = $this->input->post('quotation_status');
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$where['quotation_divisionid'] = $this->input->post('division');
					$div_total_flag = 1;
				}*/
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {
					
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='' and (($this->input->post('quotation_status')) == 'Confirmed' )) {
						$where['vch_date >='] = $date_fmt;
						$where['vch_date <='] = $date_to;
					} else if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$where['vch_date >='] = $date_fmt;
						$where['vch_date <='] = $date_to;
					} else if ($this->input->post('report_date_from') != '') {
						$where['vch_date >='] = $date_fmt;
					} else if ($this->input->post('report_date_to')!=''){
						$where['vch_date <='] = $date_to;
					}
				} 

				/* $this->db->select('Round(sum(acc.ledger_amount),3) as Amount, ag.acc_group_parent,ag.acc_group_name,ag.acc_group_id' );
				$this->db->from('accounts as acc');
				$this->db->join('ledgers as led','led.ledger_code = acc.ledger_code ','inner');
				$this->db->join('account_group as ag','led.acoount_group_id = ag.acc_group_id ','inner');
				$this->db->group_by("ag.acc_group_id"); */

				/* $this->db->select('Round(sum(acc.ledger_amount),3) as Amount,ag.acc_group_name,ag2.acc_group_id,ag2.acc_group_name');
				$this->db->from('accounts as acc');
				$this->db->join('ledgers as led','led.ledger_code = acc.ledger_code ','inner');
				$this->db->join('account_group as ag','led.acoount_group_id = ag.acc_group_id ','inner');
				$this->db->join('account_group as ag2','ag.acc_group_primary = ag2.acc_group_id ','inner');
				$this->db->or_where('ag.acc_group_primary', 1); 
				$this->db->or_where('ag.acc_group_primary', 2);
				$this->db->or_where('ag.acc_group_primary', 3); 
				$this->db->or_where('ag.acc_group_primary', 4);
				$this->db->group_by("ag.acc_group_primary");
				$this->db->order_by("ag.acc_group_id", "DESC"); */

				$this->db->select(' *,Round(sum(ledger_amount),3) as Amount');
				$this->db->group_by("parent_group_name");
				$this->db->from('view_for_accounts');
				$this->db->order_by("acc_group_parent", "ASC");
				$this->db->order_by("acc_group_primary", "ASC");
				$this->db->order_by("sort_option", "DESC");
				//$this->db->limit(100);

				$this->db->where($where);
				$rs = $this->db->get();
				//echo $this->db->last_query().'<br>';
				$data['records']=$rs->result_array();
			}
		} else {
			$data['logo_filename']= NULL;
			$data['sales_man'] = NULL;
			$data['records'] = "";
			$data['quotation_type'] = "furniture";
		}			
				
		
		
		
		$records = $this->crud_model->get('users');
		if($records!=false){
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select Division - '));
			$data['division_list'] = $division_list;

			$list = array(0 => ' - Select Salesman - ');
			foreach($records as $record){
				$list[$record['user_id']] = $record['user_name'];
			}
			$data['users'] = $list;
			$data['quotation_status'] = $this->config->item('quotation_status_array');

			$query = $this->db->get('company_details');  
			$data['company_details'] = $query->row_array();
			
			$data=$data;
			
			$this->load->view('templates/header');
			$this->load->view('reports/trial_balance',$data);
			$this->load->view('templates/footer');
		}
	}
	
	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		if($given_date <= $today_date) {
			return true;
		}else{
			$this->form_validation->set_message('date_check', 'Date cannot be Future date');
			return FALSE;
		}
	}
}

?>