<?php
class CustomerUpdate extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
	}

	function create() {
		$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'-- Select Sales Person --'),array('is_salesman'=>1),'user_name','asc');
		$data['salesman_list'] = $list2;
		$this->load->view('templates/header');
		$this->load->view('admin/customer/customer_update',$data);
		$this->load->view('templates/footer');
	}

	public function get_quotation() {
		$search_quotation	=	$this->input->post('search_quotation');
		$html	='';
		$client_contact_data = $this->db->query("SELECT * FROM `view_furniture_quotations_client_project_users` where `quotation_number_full` like '%$search_quotation%' limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['quotation_id'].'" class="quotation_button" tabindex="'.$n++.'" ><input type="hidden" class="quotation_number_full" value="'.$client_contact_datas['quotation_number_full'].'" /><input type="hidden" class="client_id" value="'.$client_contact_datas['client_id'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" /><input type="hidden" class="contact_id" value="'.$client_contact_datas['contact_id'].'" /><input type="hidden" class="Contact_Name" value="'.$client_contact_datas['Contact_Name'].'" /><input type="hidden" class="salesman_id" value="'.$client_contact_datas['salesman_id'].'" />'.$client_contact_datas['quotation_number_full'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function get_contact_person() {
		$client_id	=	$this->input->post('client_id');
		$html	='';
		$client_contact_data = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id' limit 25");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='<option value="" > - Select Contact Person- </option>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<option value="'.$client_contact_datas['Contact_Id'].'">'.$client_contact_datas['Contact_Name'].'</option>';
			}
		} else {
			$html.='<option value="" > - Select Contact Person- </option>';
		}
		print $html;
	}

	function updateSalesman() {
		$this->form_validation->set_rules('sa_quotation_id', 'Quotation', 'required');
		$this->form_validation->set_rules('salesman_id', 'Salesman', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'-- Select Sales Person --'),array('is_salesman'=>1),'user_name','asc');
			$data['salesman_list'] = $list2;
			$this->load->view('templates/header');
			$this->load->view('admin/customer/customer_update',$data);
			$this->load->view('templates/footer');
		} else {
			$quotation_id = $this->input->post('sa_quotation_id');
			$salesman_id = $this->input->post('salesman_id');
			$this->db->query(" UPDATE `enquiry` inner join `furniture_quotation` on furniture_quotation.enquiry_id = enquiry.id SET enquiry.`salesman_id`='$salesman_id' WHERE furniture_quotation.`id`='$quotation_id'");
			$this->db->update('furniture_quotation',array('salesman_id'=> $salesman_id),array('id'  => $quotation_id));	
			$this->db->update('job_card',array('salesman_id'=> $salesman_id),array('quotation_id'  => $quotation_id));
			//$job_card_affected_rows = $this->db->affected_rows();
			//echo $job_card_affected_rows;
			$this->db->update('log_for_quotation',array('trans_user_id'=> $salesman_id),array('trans_id'  => $quotation_id,'group_by' => 1));
			redirect('admin/CustomerUpdate/create');
		}
	}

	function update() {
		$this->users_model->permission("CustomerUpdate", "View");
		$this->form_validation->set_rules('quotation_id', 'Quotation', 'required');
		$this->form_validation->set_rules('client_name', 'Client Name', 'required');
		$this->form_validation->set_rules('client_id', 'Client ID', 'required');
		$this->form_validation->set_rules('client_code', 'Client Code', 'required');
		$this->form_validation->set_rules('pre_client_code', 'Client Code', 'required');
		$this->form_validation->set_rules('Contact_Id', 'Contact Person', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			$list2 = $this->crud_model->get_list2('user_id','user_name','users',array(''=>'Sales Person Assigned'),array('is_salesman'=>1),'user_name','asc');
			$data['salesman_list'] = $list2;
			$this->load->view('templates/header');
			$this->load->view('admin/customer/customer_update',$data);
			$this->load->view('templates/footer');
		} else {

			$quotation_id = $this->input->post('quotation_id');
			$client_name  = $this->db->escape_str($this->input->post('client_name'));
			$client_id 	  = $this->input->post('client_id');
			$client_code  = $this->input->post('client_code');
			$pre_client_code  = $this->input->post('pre_client_code');
			$Contact_Id  = $this->input->post('Contact_Id');
			
			//$this->db->trans_begin();


			/* $this->db->join('furniture_quotation', 'furniture_quotation.enquiry_id = enquiry.id', 'inner');
			$this->db->set('enquiry.client_id', $client_id);
			$this->db->where('furniture_quotation.id', $quotation_id);
			$this->db->update('enquiry'); */
			$this->db->query(" UPDATE `enquiry` inner join `furniture_quotation` on furniture_quotation.enquiry_id = enquiry.id SET enquiry.`client_id`='$client_id',enquiry.`prospect_name`='$client_name',enquiry.`contact_id`='$Contact_Id' WHERE furniture_quotation.`id`='$quotation_id'");
					

			$this->db->update('furniture_quotation',array('client_id'=> $client_id,'contact_id'=> $Contact_Id),array('id'  => $quotation_id));
			$this->db->update('job_card',array('client_id'=> $client_id),array('quotation_id'  => $quotation_id));
			$this->db->update('proforma',array('client_id'=> $client_id,'client'=> $client_name),array('quotation_id'  => $quotation_id));
			$this->db->update('furniture_invoice',array('client_id'=> $client_id,'client'=> $client_name),array('quotation_id'  => $quotation_id));
			//$this->db->update('furniture_receipts',array('client_id'=> $client_id),array('quotation_id'  => $quotation_id));

			$this->db->select('*');
			$this->db->from('furniture_invoice');
			$this->db->where('quotation_id', $quotation_id);
			$query = $this->db->get();
			$result = $query->result_array();
			if($result!=false){
				foreach($result as $row){
					$invoice_id	=$row['invoice_id'];
					$invoice_number	=$row['invoice_number'];
					//echo $invoice_id;
					$this->db->query(" UPDATE `furniture_receipts` inner join `receipts_details` on receipts_details.receipt_id = furniture_receipts.receipt_id SET furniture_receipts.`client_id`='$client_id' WHERE receipts_details.`invoice_id`='$invoice_id'");
					$this->db->update('cust_bill_allocations',array('customer_code'=> $client_code),array('bill_id'  => $invoice_id));
					$this->db->update('accounts',array('ledger_code'=> $client_code),array('vch_no'  => $invoice_number,'ledger_code'  => $pre_client_code));

					$this->db->select('*');
					$this->db->from('furniture_receipts');
					$this->db->join('receipts_details','furniture_receipts.receipt_id = receipts_details.receipt_id',"inner");
					$this->db->where('receipts_details.invoice_id', $invoice_id);
					$query2 = $this->db->get();
					$result2 = $query2->result_array();
					if($result2!=false){
						foreach($result2 as $row2){
							$receipt_code	=$row2['receipt_code'];
							$this->db->update('accounts',array('ledger_code'=> $client_code),array('vch_no'  => $receipt_code,'ledger_code'  => $pre_client_code));
						}
					}
				}
				/* $this->db->set('furniture_receipts.client_id', $client_id);
				$this->db->where('receipts_details.invoice_id', $invoice_id);
				$this->db->update('furniture_receipts');
				$this->db->join('receipts_details','furniture_receipts.receipt_id = receipts_details.receipt_id',"inner"); */
				//$this->db->update('furniture_invoice',array('client_id'=> $client_id,'client'=> $client_name),array('quotation_id'  => $quotation_id));
			}
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Customer Update',	
				'masters_id'=>$quotation_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			/* if($this->db->trans_status() === FALSE){
				$this->session->set_flassdata('error','Something went wrong. Please try again.');
				redirect('admin/CustomerUpdate/create');
				$this->db->trans_rollback();
			} else {
				$this->session->set_flashdata('success','Updated Successfully</div>');*/
				redirect('admin/CustomerUpdate/create');
				/* $this->db->trans_commit();
			}  */
		}		
	}
}