<?php
class Group_permissions extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->config->load('arrays');
	}
	function index($page=1)
	{
		$title['headerTitle']	="Group Permissions";
		$config['per_page']		= 20;
		$config['base_url'] 	= site_url('admin/group_permissions/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_group_permissions_with_user_groups',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_group_permissions_with_user_groups',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('admin/group_permissions/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$title['headerTitle']="Group Permissions Create";
		$list = $this->crud_model->get_list('user_group_id','user_group_name','user_groups',array(0=>' - Select - '));
		$data['user_groups'] = $list;
		$data['permission_value'] = $this->config->item('permission_value_array');
			
		$this->load->view('templates/header',$title);
		$this->load->view('admin/group_permissions/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$title['headerTitle']="Group Permissions Edit";
		$where=array(
				'permission_id' => $id
		);

		$records=$this->crud_model->get('group_permissions',$where);
		if($records != false){
			//true section
			$data['permission_id']			 = $records[0]['permission_id'];
			$data['controller_name']		 = $records[0]['controller_name'];
			$data['method_name']			 = $records[0]['method_name'];
			$data['user_group_id']			 = $records[0]['user_group_id'];
			$data['permission_value']		 = $records[0]['permission_value'];
				
			$list = $this->crud_model->get_list('user_group_id','user_group_name','user_groups',array(0=>' - Select - '));
			$data['user_groups'] = $list;

			$data['permission_values'] = $this->config->item('permission_value_array');
			$this->load->view('templates/header',$title);
			$this->load->view('admin/group_permissions/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','error');
			redirect('admin/group_permissions');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('user_group_id', 'User group', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('controller_name', 'Controller Name', 'required');
		$this->form_validation->set_rules('method_name', 'Method Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->create();

		}
		else
		{	// true section

			$user_group_id=$this->input->post('user_group_id');
			$controller_name=$this->input->post('controller_name');
			$method_name=$this->input->post('method_name');
			$permission_value=$this->input->post('permission_value');
			$data=array(
			    'user_group_id'       =>$user_group_id,
				'controller_name'     =>$controller_name,
			    'method_name'         =>$method_name,
			    'permission_value'    =>$permission_value
			);

			$rr=$this->crud_model->insert('group_permissions',$data);
			    $insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Group Permissions',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);

			if($rr == false){
				// error
				$title['headerTitle']="Group Permissions Create";
				$this->session->set_flashdata('response','Permission Group cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('admin/group_permissions/create');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('success','Permission added successfully');
				redirect('admin/group_permissions');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('user_group_id', 'User group', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('controller_name', 'Controller Name', 'required|max_length[50]');
		$this->form_validation->set_rules('method_name', 'Method Name', 'required|max_length[50]');
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->edit($this->input->post('permission_id'));
		}
		else
		{// true section

			$permission_id = $this->input->post('permission_id');
			
			$user_group_id= $this->input->post('user_group_id');
			$controller_name=$this->input->post('controller_name');
			$method_name=$this->input->post('method_name');
			$permission_value = $this->input->post('permission_value');
			$where=array(
					   'permission_id'=> $permission_id
			);
			$data=array(
					'user_group_id'      => $user_group_id,
					'controller_name'    => $controller_name,
			        'method_name'        => $method_name,
			        'permission_value'   => $permission_value

			);
			$records=$this->crud_model->update('group_permissions',$data,$where);
			//$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Group Permissions',	
				'masters_id'=>$permission_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);



			$this->session->set_flashdata('success','Permission are Updated');
			
			redirect('admin/group_permissions');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'permission_id'=> $id
		);

		$this->crud_model->delete('group_permissions',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Group Permissions',	
			'masters_id'=>$id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);
		

		$this->session->set_flashdata('success','Permission Deleted');
		redirect('admin/group_permissions');
	}
}