<?php

class Forgot_password extends CI_Controller {

	function forgot_password()
	{
		parent::__construct();
		$this->load->library('tw_email');
		$this->load->library('form_validation');
		$this->load->model('users_model');
	}
	
	function index()
	{
		$this->load->view('templates/header');
		$this->load->view('login/forgot_password');
		$this->load->view('templates/footer');
	}

	function do_send_new_password()
	{
		$this->form_validation->set_rules('user_email_id', 'Email ID', 'required|min_length[5]|max_length[100]|valid_email');
		if($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			
			$this->load->view('templates/header');
			$this->load->view('login/forgot_password');
			$this->load->view('templates/footer');
		}
		else
		{
			//true section
			$this->load->helper('string');
			$user_email_id = $this->input->post('user_email_id');
			$where = array('user_email_id' => $user_email_id);

			$records = $this->crud_model->get('users',$where);

			if($records!=false)
			{// true section
				// email id found
				$random_password=strtoupper(random_string('alnum', 8));
				
				$update = array('user_password'=>md5($random_password));
				
				$this->crud_model->update('users',$update,$where);
				log_message('INFO','New password for '.$user_email_id.' is '.$random_password);
				
				// send mail code
				$from 		= ADMIN_MAIL;
				$fromname 	= 'Password Reset';
				$to 		= $user_email_id;
				$subject 	= 'Your new password for QMS';
				$message 	= '
	<p>Hello,</p>
	<p>Based on your request to reset the password we are sending you the updated password here. Please note down the new password and <a href="'.site_url().'">login here</a></p>
	<p>New Password: '.$random_password.'</p>';

				$this->tw_email->send($from,$fromname,$to,$subject,$message);
				
				$this->session->set_flashdata('response','<div class="alert alert-info">New password sent to your Email ID. Please use your new password for login.</div>');
				redirect('login');
			}
			else
			{// false section
				// no email id found
				$this->session->set_flashdata('response','<div class="alert alert-error">Email ID not available in our database</div>');
				redirect('forgot_password');
			}
		}
	}
}