<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
class Job_update_employeewise extends CI_Controller {

	public function __construct(){
		parent::__construct();// you have missed this line.\
		if($this->session->userdata('user_logged_in') != true){
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}    
	}

	public function listEmployeewise(){
		$this->users_model->permission("Job_update_employeewise", "View");
		$title['headerTitle']="Job Update - Employeewise List";
		$this->data['employee_datas'] = $this->furniture_quotation_model->get_all_job_update_employeewise_list();
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/listEmployeewise',$this->data);
		$this->load->view('templates/footer');
	}

	function create() {
		$this->users_model->permission("Job_update_employeewise", "Add");
		$title['headerTitle']="Job Update - Employeewise";
		$this->form_validation->set_rules('work_done_date', 'Date', 'required');
		//$this->form_validation->set_rules('employee_id[]', 'Employee', 'required');

		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/job_update_employeewise');
			$this->load->view('templates/footer');
		} else {
			$query= $this->db->query("SELECT max(batch_id) as batch_id FROM `job_update_employeewise` ");
			$batch_id= $query->row()->batch_id+1;
			$employee = $this->input->post('employee');
			$employee_id = $this->input->post('employee_id');
			$employee_no = $this->input->post('employee_no');
			$job_no = $this->input->post('job_no');
			$job_id = $this->input->post('job_id');
			$normal_hours = $this->input->post('normal_hours');
			$normal_ot = $this->input->post('normal_ot');
			$work_done_date	=	date("Y-m-d h:m:s", strtotime($this->input->post('work_done_date')));
			for($i=0; $i<count($employee_id); $i++){	
				if($employee_id[$i]!=="" && $job_no[$i]!=="" && $job_id[$i]!==""){
					$accounts_data = array(
						'work_done_date' => $work_done_date,
						'employee_id' => $employee_id[$i],
						'job_number'  => $job_no[$i],
						'job_card_id' => $job_id[$i],
						'normal_hours'=> $normal_hours[$i],
						'normal_ot'	  => $normal_ot[$i],
						'batch_id'	  => $batch_id,
						'user_id' 	  => $this->session->userdata("user_id")
					);
					$this->db->insert('job_update_employeewise', $accounts_data);
				}		
			}
			redirect('jobcard/Job_update_employeewise/listEmployeewise');
		}
	}

	function edit($id,$employee_id) {
		$this->users_model->permission("Job_update_employeewise", "Edit");
		$title['headerTitle']="Job Update - Employeewise";
		$this->form_validation->set_rules('work_done_date', 'Date', 'required');
		//$this->form_validation->set_rules('employee_id[]', 'Employee', 'required');

		if ($this->form_validation->run() == FALSE) {
			$data['empData'] = $this->crud_model->get('employee',array('employee_id' => $employee_id)); 

			$this->db->select('JUE.id,JUE.work_done_date,JUE.job_card_id,JUE.job_number,JUE.normal_hours,JUE.normal_ot,JUE.employee_id,N.client_name,JC.project_name' );
			$this->db->from('job_update_employeewise AS JUE');
			$this->db->join('job_card AS JC','JC.id = JUE.job_card_id','inner');
			$this->db->join('new_client_master AS N','N.client_id = JC.client_id','inner');
			$this->db->where('JUE.`id`', $id);
			$rs = $this->db->get();
			$data['dbData'] =	$rs->result_array();
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/edit_employeewise',$data);
			$this->load->view('templates/footer');
		} else {
			$where=array('id'  => $id);
			$employee = $this->input->post('employee');
			$xxemployee_id = $this->input->post('employee_id');
			$employee_no = $this->input->post('employee_no');
			$job_no = $this->input->post('job_no');
			$job_id = $this->input->post('job_id');
			$normal_hours = $this->input->post('normal_hours');
			$normal_ot = $this->input->post('normal_ot');
			$work_done_date	=	date("Y-m-d h:m:s", strtotime($this->input->post('work_done_date')));
			for($i=0; $i<count($xxemployee_id); $i++){	
				if($xxemployee_id[$i]!=="" && $job_no[$i]!=="" && $job_id[$i]!==""){
					$employee_id	=	$xxemployee_id[$i];
					$accounts_data = array(
						'work_done_date' => $work_done_date,
						'employee_id' => $xxemployee_id[$i],
						'job_number'  => $job_no[$i],
						'job_card_id' => $job_id[$i],
						'normal_hours'=> $normal_hours[$i],
						'normal_ot'	  => $normal_ot[$i],
						'user_id' 	  => $this->session->userdata("user_id")
					);
					$rr=$this->crud_model->update('job_update_employeewise',$accounts_data,$where);
				}		
			}
			redirect('jobcard/Job_update_employeewise/edit/'.$id.'/'.$employee_id);
		}
	}

	public function search_employee() {
		$employee	=	$this->input->post('employee');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$employees = explode(" ", trim($employee));
		for($i=0;$i<count($employees);$i++) {
			$r	= $employees[$i];
			$sql.=" and employee_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `employee` where `employee_status`='active' and `employee_name` like '$employee%'   union (SELECT * FROM `employee` where `employee_status`='active' and `employee_id` not in (SELECT `employee_id` FROM `employee` where `employee_status`='active' and `employee_name` like '$employee%' ) ".$sql." order by employee_name) limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['employee_id'].'" class="employee_button"  tabindex="'.$n++.'" ><input type="hidden" class="employee_id" value="'.$client_contact_datas['employee_id'].'" /><input type="hidden" class="employee_no" value="'.$client_contact_datas['employee_number'].'" /><input type="hidden" class="employee_name" value="'.$client_contact_datas['employee_name'].'" /><input type="hidden" class="designation" value="'.$client_contact_datas['designation'].'" /><input type="hidden" class="employee_photo" value="'.$client_contact_datas['employee_photo'].'" />'.$client_contact_datas['employee_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	public function search_job_no() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		
		$client_contact_data = $this->db->query("SELECT * FROM `view_furniture_job_card` where `job_card_status`='Draft' AND ( `job_card_number` like '%$client%' OR `client_name` like '%$client%' OR `project_name` like '%$client%'  )   ".$sql." order by client_name limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='<tr class="no_result_button" tabindex="-1"><th><b>Name</b></th><th><b>Project</b></th><th><b>Job No</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr tabindex="-1" ><td class="client_button" ><input type="hidden" class="nbcli_id" value="' .$client_contact_datas['client_id'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="project_name" value="'.$client_contact_datas['project_name'].'" /><input type="hidden" class="job_card_number" value="'.$client_contact_datas['job_card_number'].'" /><input type="hidden" class="job_card_id" value="'.$client_contact_datas['job_card_id'].'" /> '.$client_contact_datas['client_name'].'</td><td>'.$client_contact_datas['project_name'].'</td><td>'.$client_contact_datas['job_card_number'].'</td></tr>';
			}
		} else {
			$html.='<tr class="no_result_button" tabindex="-1"><td style="color:red;" colspan="3" > No Results Found </td></tr>';
		}
		print $html;
	}

} // Closing of main class
?>