<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Material_return extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
	}

	public function index() {
		
		
	}

	public function printMR($quotation_id,$type,$print_status=''){
		$rs = $this->db->query("SELECT * FROM `material_return_h` DN INNER JOIN job_card JC ON JC.id=DN.job_id INNER JOIN `new_client_master` NCM ON NCM.`client_id`=JC.`client_id` WHERE DN.`mr_id`='$quotation_id';");
		$records['nbrcdrs'] =$rs->result_array();	
		$records['furniture_itemlist'] = $this->crud_model->get('material_return_b', array('material_return_b.mr_id'=>$quotation_id), null, null, "mr_id", "ASC", null, null, null, null);
		if($records == false) {
			$this->session->set_flashdata('response','error');
			redirect('jobcard/Material_return/material_return_list');
		}
		
		$query = $this->db->get('company_details');  
		$records['company_details'] = $query->row();
		foreach ($query->result() as $row) {
			$company_email_name =  $row->company_name;
		}
		$records['print_status'] = $print_status;
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			$mpdf = new \Mpdf\Mpdf();
			$datas   =   array("records" => $records,"nbrcdrs" => $rs->result_array(),"furniture_items" => $rs2->result_array(),'print_type'=>'pdf_print_type');
			$html = $this->load->view('general/quotations/printpdfdeliverynote', $datas , true);
			$mpdf->WriteHTML($html);
			$mpdf->Output();
		} else if($type=="normal"){
			$records['print_type'] = "normal_print_type";
			$this->load->view('general/quotations/printmaterialreturn', $records);
		
		}
	}
	
	function do_insert_material_retrun($job_card_id) {
		$this->users_model->permission("Material_return", "Add");
		$this->form_validation->set_rules('job_id', 'JOB', 'required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('Manage_jobcard/create_material_return/'.$job_card_id);
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$mrNumber=$this->Job_card_model->mrNumber($this->input->post('division'));
			$mr_code	=	$this->Job_card_model->get_mr_no($mrNumber,$this->input->post('division'));
			$data = array( 
				'mr_number'     => $mrNumber,
				'mr_code'       => $mr_code,
				'mr_date'       => date("Y-m-d"),
				'division_id'   => $this->input->post('division'),
				'job_id'        => $this->input->post('job_id'),
				'loc_id'        => $this->input->post('loc_id'),
				'rfq_number'    => NULL,
				'payment_mode'  => 'Cash',
				'user_id'       => $user_id,
				'status'        => 1
			);
			$this->db->insert('material_return_h', $data);
			$insert_id = $this->db->insert_id();
			
			if($insert_id){
				$p_description_id = $this->input->post('p_description_id');
				$p_description	  = $this->input->post('p_description');
				$p_nbitem	      = $this->input->post('p_nbitem');
				$p_section	      = $this->input->post('p_section');
				$p_qty	          = $this->input->post('p_qty');
				$p_rate	          = $this->input->post('p_rate');
				$p_discount	      = $this->input->post('p_discount');
				$p_vat	          = $this->input->post('p_vat');
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				for($i=0; $i<count($p_description_id); $i++){
					if($p_description_id[$i]!=='') {
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
						
						if(@$p_section[$i] == '') {
							$p_section2 = '';
						} else {
							$p_section2 = $p_section[$i];
						}
						
						if(@$p_vat[$i] == '') {
							$vat_amt = 0;
						} else {
							$vat_amt = $p_vat[$i]/100;
						}
					
					
						$data_array = array(
							'mr_id' 	       => $insert_id,
							'item_details_id'  => $p_description_id[$i],
							'item_description' => $p_description[$i],
							'item_qty' 		   => $p_qty[$i],
							'loc_id'           => $this->input->post('loc_id'),
							'item_rate' 	   => $p_rate[$i],
							'item_disc' 	   => 0,
							'item_amount' 	   => $p_qty[$i]*$p_rate[$i],
							'item_vat_per' 	   => 0,
							'item_vat' 		   => 0,
							'net_amount' 	   => $p_qty[$i]*$p_rate[$i],
							'status'           => 1
						);
						$this->db->insert('material_return_b', $data_array);

						$item_trans_array = array(
							'trans_no' 	  => $mr_code,
							'item_id'  	  => $p_description_id[$i],
							'trans_date'  => date("Y-m-d"),
							'trans_type'  => 3,
							'item_qty' 	  => $p_qty[$i],
							'loc_id' 	  => $this->input->post('loc_id'),
							'item_rate'   => $p_rate[$i],
							'item_amount' => $p_qty[$i]*$p_rate[$i],
							'user_id' 	  => $user_id,
							'created_date'=> date("Y-m-d"),
							'status'      => 1
						);
						$this->db->insert('item_trans', $item_trans_array);
						$po_gross_amt += $p_qty[$i]*$p_rate[$i];
						/*if($p_discount[$i]==='') {
							$po_discount  = $po_discount;
						} else {
							$po_discount  = $po_discount + $p_discount[$i];
						}*/
	 		 		}
				}
				$po_vat_amt   = 0;
				$po_net_amt   = 0;
				$update_data = array(
					'mr_gross_amt'=> $po_gross_amt,
					'mr_vat_amt'  => $po_vat_amt,
					'mr_discount' => 0,
					'mr_net_amt'  => $po_gross_amt
				);
				$this->db->where('mr_id', $insert_id);
				$this->db->update('material_return_h', $update_data);

				$job_allocation_data = array(
					'vch_type'    => 'Material Return',
					'vch_no'      => $mr_code,
					'vch_date'    => date("Y-m-d"),
					'job_id'      => $this->input->post('job_id'),
					'ledger_code' => 'MR0001',
					'ledger_amount' => round($po_gross_amt*-1,3),
					'created_date'=> date('Y-m-d'),
					'user_id' 	  => $this->session->userdata("user_id"),
					'status'	  => 1
				);
				$this->db->insert('job_allocation', $job_allocation_data);

				$log_data=array(
					'trans_no'  	=>  $mr_code,
					'trans_type'	=>  'Material Return',
					'trans_op'  	=>  'Create',
					'trans_user_id' =>  $this->session->userdata('user_id')
	
				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("jobcard/Material_return/material_return_list");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Created Successfully');
				redirect("jobcard/Material_return/material_return_list");
			}
		}		
	}
	

	
	public function edit_material_return($purchase_id) {
		$this->users_model->permission("Material_return", "Edit");
		$title['headerTitle']="Edit Material Return";
		$this->form_validation->set_rules('job_id', 'JOB', 'required');
		$data['row']        = $this->Job_card_model->materialReturnRow($purchase_id);
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			
			$data['details']    = $this->Job_card_model->materialReturnDetails($data['row']->mr_id);
			$data['location_list'] = $this->Job_card_model->loc_list();

			$this->load->view('furniture/quotations/jobcard/edit_material_return',$data);
			$this->load->view('templates/footer');
		} else {
	  		$user_id	=	$this->session->userdata('user_id');
	  	 	if($purchase_id) {
				$this->db->trans_begin();
				$mr_id			= $data['row']->mr_id;
				$mr_code			= $data['row']->mr_code;

				$this->db->where("mr_id",$mr_id);
				$this->db->delete('material_return_b');

				$this->db->where("trans_no",$mr_code);
				$this->db->where("trans_type",3);
				$this->db->delete('item_trans');

				$p_description_id =	$this->input->post('p_description_id');
				$p_description	  =	$this->input->post('p_description');
				$p_nbitem	      =	$this->input->post('p_nbitem');
				$p_section	      =	$this->input->post('p_section');
				$p_qty	          =	$this->input->post('p_qty');
				$p_rate	          =	$this->input->post('p_rate');
				$p_discount	      =	$this->input->post('p_discount');
				$p_vat	          =	$this->input->post('p_vat');
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				for($i=0; $i<count($p_description_id); $i++){
					if($p_description_id[$i]!==''){
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
						
						if(@$p_section[$i] == ''){
							$p_section2 = '';
						} else {
							$p_section2 = $p_section[$i];
						}
						
						if(@$p_vat[$i] == ''){
							$vat_amt = 0;
						} else {
							$vat_amt = $p_vat[$i]/100;
						}				
				
						$data_array = array(
							'mr_id' 	       => $mr_id,
							'item_details_id'  => $p_description_id[$i],
							'item_description' => $p_description[$i],
							'item_qty' 		   => $p_qty[$i],
							'loc_id' 		   => $this->input->post('loc_id'),
							'item_rate' 	   => $p_rate[$i],
							'item_disc' 	   => 0,
							'item_amount' 	   => $p_qty[$i]*$p_rate[$i],
							'item_vat_per' 	   => 0,
							'item_vat' 		   => 0,
							'net_amount' 	   => $p_qty[$i]*$p_rate[$i],
							'status'           => 1
						);
						$this->db->insert('material_return_b', $data_array);

						$item_trans_array = array(
							'trans_no' 	  => $mr_code,
							'item_id'  	  => $p_description_id[$i],
							'trans_date'  => date("Y-m-d"),
							'trans_type'  => 2,
							'item_qty' 	  => -$p_qty[$i],
							'loc_id' 	  => $this->input->post('loc_id'),
							'item_rate'   => $p_rate[$i],
							'item_amount' => $p_qty[$i]*$p_rate[$i],
							'user_id' 	  => $user_id,
							'created_date'  => date("Y-m-d"),
							'status'      => 1
						);
						$this->db->insert('item_trans', $item_trans_array);
						$po_gross_amt += $p_qty[$i]*$p_rate[$i];
		  			}
				}
				$po_vat_amt   = 0;
				$po_net_amt   = 0;
				$update_data = array(
					'mr_gross_amt'      => $po_gross_amt,
					'mr_vat_amt'        => $po_vat_amt,
					'mr_discount'       => 0,
					'mr_net_amt'        => $po_gross_amt
				);
				$this->db->where('mr_id', $mr_id);
				$this->db->update('material_return_h', $update_data);
				
				$this->db->where("vch_no",$mr_code);
				$this->db->where("vch_type",'Material Issue');
				$this->db->delete('job_allocation');

				$job_allocation_data = array(
					'vch_type'    => 'Material Return',
					'vch_no'      => $mi_code,
					'vch_date'    => $mi_date,
					'job_id'      => $this->input->post('job_id'),
					'ledger_code' => 'MR0001',
					'ledger_amount' => round($po_gross_amt*-1,3),
					'created_date'=> date('Y-m-d'),
					'user_id' 	  => $this->session->userdata("user_id"),
					'status'	  => 1
				);
				$this->db->insert('job_allocation', $job_allocation_data);

				$log_data=array(
					'trans_no'  	=>  $data['row']->mr_code,
					'trans_type'	=>  'Material Return',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')
				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'error..!!');
					redirect("jobcard/Material_return/material_return_list");
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Updated Successfully');
					redirect("jobcard/Material_return/material_return_list");
				}
	 		} else {
				$this->session->set_flashdata('response', 'error..!!');
				redirect("jobcard/Material_return/material_return_list");
			}			
		}
	}
	

	public function material_return_list($fromDate	= "NIL",$toDate	= "NIL",$filter_value	= "NIL", $jobNo	= "NIL",$client_id	= "NIL"){
		$this->users_model->permission("Material_return", "View");
		$title['headerTitle']="Material Return";
		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}
		
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		if (@$this->input->post('jobNo')) {
			$jobNo =   $this->input->post("jobNo");
		}elseif ($jobNo != "NIL") {
			$jobNo	=	$jobNo;
		} else {
			$jobNo	= "NIL";
		}
	
		$config["base_url"] = base_url() . "index.php/jobcard/Material_return/material_return_list/".$fromDate."/".$toDate."/".$filter_value."/".$jobNo."/".$client_id;
		$config["total_rows"] = $this->Job_card_model->record_count($fromDate,$toDate,$filter_value,$jobNo,$client_id);
		$config['num_links'] = 15;
		$config["per_page"] = 200;
		$this->pagination->initialize($config);
		if ($this->uri->segment(10)) {
			$page = $this->uri->segment(10)*200-200;
			$i=$page+1;
		} else {
			$page = 0;
			$i=1;
		}
		//pagging end
		$DeletePermission=$this->users_model->check_permission("Materials_issue","Delete");
		$EditPermission=$this->users_model->check_permission("Materials_issue","Edit");
		$list='';
		$headList='';
			foreach ($this->Job_card_model->mrListData($config["per_page"], $page,$fromDate,$toDate,$filter_value,$jobNo,$client_id) as $row) {
				$style='';
				if($row->status==0){
					$style='style="background:#EE4B2B;"';
				}
			    $list.= '<tr '.$style.'>
			   			<td>'.$i++.'</td>
						<td>'.$row->mr_code.'</td>
						<td>'.$row->client_name.'</td>
						<td>'.date('M d,Y',strtotime ($row->mr_date)).'</td>
						<td>'.$row->job_card_number.'</td>
						<td>
							<div class="btn-group">
							<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
							Action <span class="caret"></span>
							</button>
							<ul class="dropdown-menu" role="menu">
							<li><a target="_blank"  href="'.base_url().'index.php/jobcard/Material_return/printMR/' . $row->mr_id . '/normal/print"><i class="fa fa-print"></i> Print</a> </li>';
							if($row->status!=0) {
								$rrr="'".$row->mr_number."','".$row->mr_code."'";
								if($EditPermission){
									$list.= '<li><a class="iframe iframe cboxElement click2" title="View Receipt" href="'.base_url().'index.php/jobcard/Material_return/edit_material_return/' . $row->mr_number . '"><i class="fa fa-edit"></i> Edit</a> </li>';
								}
								if($DeletePermission){
									$list.= '<li><a href="javascript:ConfirmDelete('.$rrr.')" ><i class="fa fa-close"></i> Cancel</a> </li>';
								}
							} 
							$list.= '</ul>
						</div>
					</tr>';
		}

		$datas   =   array("data" => $list,"fromDate" => $fromDate,"toDate" => $toDate,"filter_value" => $filter_value,"jobNo" => $jobNo,"client_id" => $client_id, "links" => $this->pagination->create_links());
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/material_return_list',$datas);
		$this->load->view('templates/footer');
	}

	function create_material_return($job_card_id) {
		$this->users_model->permission("Material_return", "Add");
		$title['headerTitle']="Material Return";
		$page=1;
		$jobcardrecords=$this->Job_card_model->get_job_card_data($job_card_id);

		$data['general_quotation'] 	= 0;
		$data['currency_code'] 		= $jobcardrecords['currency_code'];
		$data['job_card_divisionid']= $jobcardrecords['job_card_divisionid'];
		$data['job_card_number'] 	= $jobcardrecords['job_card_number'];
		$data['job_card_id']  		= $job_card_id;
		$data['quotation_number']  	= $jobcardrecords['quotation_number'];
		$data['client_name']  		= $jobcardrecords['client_name'];
		$data['client_id']  		= $jobcardrecords['client_id'];
		$data['client_telephone1']  = $jobcardrecords['client_telephone1'];
		$data['division_code'] 		= $jobcardrecords['division_code'];
		$quotation_id				= $job_card_id;
		$data['mode']				= 'new';
	
		$data['location_list'] = $this->Job_card_model->loc_list();

		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/jobcard/create_material_return_view',$data);
		$this->load->view('templates/footer');
	}
	
	public function material_return_delete($id,$mr_code){
		$this->users_model->permission("Material_return", "Delete");
		//$this->load->model('proforma_model');
		//$this->proforma_model->delete($id);
		$update_data = array(
			'status'	=> 0,
		);
		$this->db->where('mr_number', $id);
		$this->db->update('material_return_h', $update_data);


		$this->db->where('trans_no', $mr_code);
		$this->db->where('trans_type', 2);
		$this->db->update('item_trans', $update_data);

		$this->db->where('vch_no', $mr_code);
		$this->db->where('vch_type', 'Material Return');
		$this->db->update('item_trans', $update_data);

		$log_data=array(
			'trans_no'  	=>  $mr_code,
			'trans_type'	=>  'Material Return',
			'trans_op'  	=>  'Delete',
			'trans_user_id' =>  $this->session->userdata('user_id')
		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

		$this->session->set_flashdata('response', 'Cancelled...');
		redirect('jobcard/Material_return/material_return_list');
	}
}
?>