<?php
class Covering_letter_template extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$this->users_model->permission("CoveringLetterTemplate", "View");
		$title['headerTitle']="Covering Letter Template";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/covering_letter_template/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('covering_letter_template',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('covering_letter_template',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/covering_letter_template/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->users_model->permission("CoveringLetterTemplate", "Add");
		$title['headerTitle']="Covering Letter Template Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/covering_letter_template/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$this->users_model->permission("CoveringLetterTemplate", "Edit");
		$title['headerTitle']="Covering Letter Template Edit";
		$where=array(
				'cl_template_id' => $id
		);
		$records=$this->crud_model->get('covering_letter_template',$where);
		if($records != false){
			//true section
			$data['cl_template_content']			 = $records[0]['cl_template_content'];
			$data['cl_template_name']			 = $records[0]['cl_template_name'];
			$data['cl_template_id']			 = $records[0]['cl_template_id'];
			$this->load->view('templates/header',$title);
			$this->load->view('masters/covering_letter_template/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/covering_letter_template');
		}

	}
	function do_insert()
	{
		$this->users_model->permission("CoveringLetterTemplate", "Add");
		$title['headerTitle']="Covering Letter Template Create";
		$this->form_validation->set_rules('cl_template_name', 'Covering Letter Template Name', 'required');
		$this->form_validation->set_rules('cl_template_content', 'Covering Letter Template Content', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/covering_letter_template/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$cl_template_name=$this->input->post('cl_template_name');
			$cl_template_content=$this->input->post('cl_template_content');

			$data=array(
			                'cl_template_name' => $cl_template_name,
			                'cl_template_content' => str_replace('<p><br></p>', '', trim($cl_template_content))

			);

			$rr=$this->crud_model->insert('covering_letter_template',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Covering Letter',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','Template cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/covering_letter_template');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','Template added successfully');
				redirect('masters/covering_letter_template');
			}
		}

	}

	function do_update()
	{
		$this->users_model->permission("CoveringLetterTemplate", "Edit");
		$title['headerTitle']="Covering Letter Template Edit";
		$this->form_validation->set_rules('cl_template_name', 'Covering Letter Template Name', 'required');
		$this->form_validation->set_rules('cl_template_content', 'Covering Letter Template Content', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$records=$this->crud_model->get('covering_letter_template');
			if($records != false){
				//true section
				$data['cl_template_content']			 = $records[0]['cl_template_content'];
			    $data['cl_template_name']			     = $records[0]['cl_template_name'];
			    $data['cl_template_id']			         = $records[0]['cl_template_id'];
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/covering_letter_template/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','error');
				redirect('masters/covering_letter_template');
			}
		}
		else
		{// true section

			$cl_template_name   = $this->input->post('cl_template_name');
			$cl_template_content   = $this->input->post('cl_template_content');
			$cl_template_id     = $this->input->post('cl_template_id');

			$where=array(
					       'cl_template_id'   => $cl_template_id
			);
			$data=array(
					       'cl_template_name' => $cl_template_name,
			               'cl_template_content' => str_replace('<p><br></p>', '', trim($cl_template_content)),

			);

			$records=$this->crud_model->update('covering_letter_template',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Covering Letter',	
				'masters_id'=>$cl_template_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('response','Template updated');
			redirect('masters/covering_letter_template');

		}

	}
	function do_delete($id=0)
	{
		$this->users_model->permission("CoveringLetterTemplate", "Delete");
		$where=array(
				'cl_template_id'=> $id
		);

		$this->crud_model->delete('covering_letter_template',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Covering Letter',	
			'masters_id'=>$id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Template deleted');
		redirect('masters/covering_letter_template');
	}
}

