<?php
class Department extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("Department", "View");
		$title['headerTitle']="Department List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/Department/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('department_master',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('department_master',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/department/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Department", "Add");
		$title['headerTitle']="Department Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/department/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("Department", "Edit");
		$title['headerTitle']="Department Edit";
		$where=array(
				'department_id' => $id
		);
		$records=$this->crud_model->get('department_master',$where);
		if($records != false){
			//true section
			$data['department_name']	= $records[0]['department_name'];
			$data['department_id']		= $records[0]['department_id'];
			$data['man_power']			= $records[0]['man_power'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/department/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Department');
		}
	}
	function do_insert() {
		$this->users_model->permission("Department", "Add");
		$title['headerTitle']="Department Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/department/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			$man_power=$this->input->post('man_power');
			
			$data=array('department_name' => $name,'man_power' => $man_power);

			$rr=$this->crud_model->insert('department_master',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Department',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Department Name cannot be inserted',':old:');
				$redirect('masters/Department');
			} else {
				// redirect
				$this->session->set_flashdata('success','Department Name added successfully');
				redirect('masters/Department');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("Department", "Edit");
		$title['headerTitle']="Department Edit";
		$department_id = ascii_to_entities($this->input->post('department_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("department_id"=>$department_id);
					
			$records=$this->crud_model->get('department_master', $where);
			if($records != false){
				//true section
			$data['department_name']	= $records[0]['department_name'];
			$data['department_id']		= $records[0]['department_id'];
			$data['man_power']			= $records[0]['man_power'];
			$data['status']				= $records[0]['status'];

			$data['user_status'] = $this->config->item('user_status_array');

			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/department/edit',$data);
			$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			$man_power=$this->input->post('man_power');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'department_id'  => $department_id
			);
			$data=array(
				'department_name' => $name,
				'man_power' => $man_power,
				'status' => $status
			);

			$records=$this->crud_model->update('department_master',$data,$where);
			 
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Department',	
				'masters_id'=>$department_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Department updated');
			redirect('masters/Department');

		}
	}
	function do_delete($department_id=0) {
		$this->users_model->permission("Department", "Delete");
		$where=array(
			'department_id'  => $department_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('department_master',$data,$where);
		$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Department',	
				'masters_id'=>$department_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('success','Department deleted');
		redirect('masters/Department');
	}
}