<?php
class EmpCategory extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("EmpCategory", "View");
		$title['headerTitle']	= "Employee Category List";
		$config['per_page']		= 25;
		$config['base_url'] 	= site_url('masters/EmpCategory/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('emp_category',array());
		$offset = ($page-1) * $config['per_page'];
		$data['records'] = $this->crud_model->get('emp_category',array(),$config['per_page'],$offset);
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/emp_category/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("EmpCategory", "Add");
		$title['headerTitle']="Employee Category Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/emp_category/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("EmpCategory", "Edit");
		$title['headerTitle']="Employee Category Edit";
		$where=array(
			'emp_category_id' => $id
		);
		$records=$this->crud_model->get('emp_category',$where);
		if($records != false){
			//true section
			$data['emp_category_name']	= $records[0]['emp_category_name'];
			$data['emp_category_id']	= $records[0]['emp_category_id'];
			$data['rate']				= $records[0]['rate'];
			$data['status']				= $records[0]['status'];
			$data['user_status'] 		= $this->config->item('user_status_array');

			$this->load->view('templates/header',$title);
			$this->load->view('masters/emp_category/edit',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/EmpCategory');
		}
	}
	
	function do_insert() {
		$this->users_model->permission("EmpCategory", "Add");
		$title['headerTitle']="Employee Category Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/emp_category/create');
			$this->load->view('templates/footer');
		} else {	// true section
			$name=$this->input->post('name');
			$rate=$this->input->post('rate');
			$data=array(
				'emp_category_name' => $name,
				'rate' => $rate
			);
			$rr=$this->crud_model->insert('emp_category',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Category',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Employee Category cannot be inserted',':old:');
				redirect('masters/EmpCategory');
			} else {
				// redirect
				$this->session->set_flashdata('success','Employee Category added successfully');
				redirect('masters/EmpCategory');
			}
		}
	}

	function do_update() {
		$this->users_model->permission("EmpCategory", "Edit");
		$title['headerTitle']="Employee Category Edit";
		$emp_category_id = ascii_to_entities($this->input->post('emp_category_id'));
		$status = ascii_to_entities($this->input->post('status'));
		$this->form_validation->set_rules('name', 'Name', 'required');
		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("emp_category_id"=>$emp_category_id);
			$records=$this->crud_model->get('emp_category', $where);
			if($records != false){
				//true section
				$data['emp_category_name']	= $records[0]['emp_category_name'];
				$data['emp_category_id']	= $records[0]['emp_category_id'];
				$data['rate']				= $records[0]['rate'];
				$data['status']				= $records[0]['status'];
				$data['user_status'] 		= $this->config->item('user_status_array');

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/emp_category/edit',$data);
				$this->load->view('templates/footer');
			} 
		} else {// true section
			$name=$this->input->post('name');
			$rate=$this->input->post('rate');
			$where=array(
				'emp_category_id'  => $emp_category_id
			);
			$data=array(
				'emp_category_name' => $name,
				'rate' => $rate,
				'status' => $status
			);
			$records=$this->crud_model->update('emp_category',$data,$where);

			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Category',	
				'masters_id'=>$emp_category_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Employee Category updated');
			redirect('masters/EmpCategory');
		}
	}
	function do_delete($department_id=0) {
		$this->users_model->permission("EmpCategory", "Delete");
		$where=array(
			'emp_category_id'  => $emp_category_id
		);
		$data=array('status' => 0);
		$records=$this->crud_model->update('emp_category',$data,$where);

		$this->session->set_flashdata('success','Employee Category deleted');
		redirect('masters/EmpCategory');
	}
}