<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Employee extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
	}

	public function listEmployee(){
		$this->users_model->permission("Employee","View");
		$title['headerTitle']="Employee List";
		$this->data['employee_datas'] = $this->furniture_quotation_model->get_all_employees();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/employee/listEmployee',$this->data);
		$this->load->view('templates/footer');
	}

	public function editEmployee($employee_id,$type=NULl){
		$this->users_model->permission("Employee","Edit");
		$title['headerTitle']="Employee Edit";
		$this->form_validation->set_rules('employee_department_id','Department','required');
		$this->form_validation->set_rules('nationality', 'Nationality', 'required');
		$this->form_validation->set_rules('date_of_joining', 'Date of Joining', 'required');
		$this->form_validation->set_rules('gender','Gender','required');
		$this->form_validation->set_rules('employee_group_id', 'Group', 'required');

		$where=array(
			'employee_id' => $employee_id
		);
		$records=$this->crud_model->get_employee_details($where);
		if($records != false){
			if ($this->form_validation->run() == FALSE){
				$data['country_list'] = $this->crud_model->get_list('id','Country','country_master',array(''=>' - Select - '));
 				$data['department_list'] = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>'- Select Department -'),array('status'=>1),'department_name','asc');
				$data['group_list'] = $this->crud_model->get_list2('employee_group_id','group_name','employee_group',array(''=>'- Select Group -'),array('status'=>1),'group_name','asc');
				$data['pay_head_list'] = $this->crud_model->get('pay_head',array('status' => 1));

				if($records[0]['date_of_birth']=="0000-00-00"){
					$date_of_birth = "";
				}else{
					$date_of_birth = date("d-m-Y", strtotime($records[0]['date_of_birth']));
				}
				if($records[0]['cpr_expiry']=="0000-00-00"){
					$cpr_expiry = "";
				}else{
					$cpr_expiry = date("d-m-Y", strtotime($records[0]['cpr_expiry']));
				}
				if($records[0]['passport_issue_date']=="0000-00-00"){
					$passport_issue_date = "";
				}else{
					$passport_issue_date = date("d-m-Y", strtotime($records[0]['passport_issue_date']));
				}
				if($records[0]['passport_expiry_date']=="0000-00-00"){
					$passport_expiry_date = "";
				}else{
					$passport_expiry_date = date("d-m-Y", strtotime($records[0]['passport_expiry_date']));
				}
				if($records[0]['visa_expiry_date']=="0000-00-00"){
					$visa_expiry_date = "";
				}else{
					$visa_expiry_date = date("d-m-Y", strtotime($records[0]['visa_expiry_date']));
				}
				if($records[0]['contract_start_date']=="0000-00-00"){
					$contract_start_date = "";
				}else{
					$contract_start_date = date("d-m-Y", strtotime($records[0]['contract_start_date']));
				}
				if($records[0]['contract_expiry_date']=="0000-00-00"){
					$contract_expiry_date = "";
				}else{
					$contract_expiry_date = date("d-m-Y", strtotime($records[0]['contract_expiry_date']));
				}
				if($records[0]['driving_licence_expiry']=="0000-00-00"){
					$driving_licence_expiry = "";
				}else{
					$driving_licence_expiry = date("d-m-Y", strtotime($records[0]['driving_licence_expiry']));
				}
				if($records[0]['date_of_joining']=="0000-00-00"){
					$date_of_joining = "";
				}else{
					$date_of_joining = date("d-m-Y", strtotime($records[0]['date_of_joining']));
				}
				if($records[0]['date_of_termination']=="0000-00-00"){
					$date_of_termination = "";
				}else{
					$date_of_termination = date("d-m-Y", strtotime($records[0]['date_of_termination']));
				}
				
				$data['employee_id']			= $records[0]['employee_id'];
				$data['employee_department_id']	= $records[0]['employee_department_id'];
				$data['employee_number']		= $records[0]['employee_number'];
				$data['employee_nick_name']		= $records[0]['employee_nick_name'];
				$data['home_address']			= $records[0]['home_address'];
				$data['nationality']			= $records[0]['nationality'];
				$data['direct_number']			= $records[0]['direct_number'];
				$data['contact_person']			= $records[0]['contact_person'];
				$data['personal_email']			= $records[0]['personal_email'];
				$data['employee_name']			= $records[0]['employee_name'];
				$data['address']				= $records[0]['address'];
				$data['gender']					= $records[0]['gender'];
				$data['date_of_birth']			= $date_of_birth;
				$data['email_id']				= $records[0]['email_id'];
				$data['contact_number']			= $records[0]['contact_number'];
				$data['blood_group']			= $records[0]['blood_group'];
				$data['father_name']			= $records[0]['father_name'];
				$data['designation']			= $records[0]['designation'];
				$data['function']				= $records[0]['function'];
				$data['location']				= $records[0]['location'];
				$data['spouse_name']			= $records[0]['spouse_name'];
				$data['date_of_joining']		= $date_of_joining;
				$data['employee_status']		= $records[0]['employee_status'];
				$data['bank_name']				= $records[0]['bank_name'];
				$data['bank_branch']			= $records[0]['bank_branch'];
				$data['account_no']				= $records[0]['account_no'];
				$data['iban_no']				= $records[0]['iban_no'];
				$data['cpr_number']				= $records[0]['cpr_number'];
				$data['driving_licence_number']	= $records[0]['driving_licence_number'];
				$data['cpr_expiry']				= $cpr_expiry;
				$data['driving_licence_expiry']	= $driving_licence_expiry;
				$data['passport_number']		= $records[0]['passport_number'];
				$data['country_of_issue']		= $records[0]['country_of_issue'];
				$data['passport_issue_date']	= $passport_issue_date;
				$data['passport_expiry_date']	= $passport_expiry_date;
				$data['visa_number']			= $records[0]['visa_number'];
				$data['visa_expiry_date']		= $visa_expiry_date;
				$data['work_permit_number']		= $records[0]['work_permit_number'];
				$data['contract_start_date']	= $contract_start_date;
				$data['contract_expiry_date']	= $contract_expiry_date;
				$data['basic_salary']			= $records[0]['basic_salary'];
				$data['deduction']				= $records[0]['deduction'];
				$data['other_overhead']			= $records[0]['other_overhead'];
				$data['overtime']				= $records[0]['overtime'];
				$data['note_1']					= $records[0]['note_1'];
				$data['note_2']					= $records[0]['note_2'];
				$data['note_3']					= $records[0]['note_3'];
				$data['date_of_termination']	= $date_of_termination;
				$data['termination_reason']		= $records[0]['termination_reason'];
				$data['office_tel']				= $records[0]['office_tel'];
				$data['local_land_line']		= $records[0]['local_land_line'];
				$data['contact_person_no']		= $records[0]['contact_person_no'];
				$data['home_contact_person']	= $records[0]['home_contact_person'];
				$data['home_contact_person_no']	= $records[0]['home_contact_person_no'];
				$data['bank_id']				= $records[0]['bank_name'];
				$data['branch_id']				= $records[0]['bank_branch'];
				$data['employee_photo']			= $records[0]['employee_photo'];
				$data['status'] 				= $type;
				$data['applicable_date']		= $records[0]['applicable_date'];
				$data['employee_group_id']		= $records[0]['employee_group_id'];

				$data['statutory_files'] 		= $this->crud_model->get("statutory_files",$where);
				$data['passport_files']  		= $this->crud_model->get("passport_files",$where);
				$data['contract_files']  		= $this->crud_model->get("contract_files",$where);

				$data['employee_dependent_details'] = $this->crud_model->get("employee_dependent_details",$where);
				$data['employee_asset_details'] = $this->crud_model->get("employee_asset_details",$where);
				if($records[0]['applicable_date']!='00-00-0000' && $records[0]['applicable_date']!=''){
					$data['employee_pay_heads']  	= $this->crud_model->get("employee_pay_heads",array('employee_id' => $employee_id,'applicable_date'=>$records[0]['applicable_date']));
				}else{
					$data['employee_pay_heads']  	= $this->crud_model->get("employee_pay_heads",array('employee_id' => $employee_id));
				}
				
				$this->load->view('templates/header',$title);
				$this->load->view('masters/employee/editEmployee',$data);
				$this->load->view('templates/footer');
			}
		}
	}
	public function createEmployee(){
		$this->users_model->permission("Employee","Add");
		$this->form_validation->set_rules('employee_department_id','Department','required');
		$this->form_validation->set_rules('employee_number', 'Employee Number', 'required');
		$this->form_validation->set_rules('employee_name', 'Employee Name', 'required');
		$this->form_validation->set_rules('nationality', 'Nationality', 'required');
		$this->form_validation->set_rules('date_of_joining', 'Date of Joining', 'required');
		$this->form_validation->set_rules('gender','Gender','required');
		$this->form_validation->set_rules('employee_group_id', 'Group', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			$title['headerTitle']="Employee Create";
			$data['country_list']  = $this->crud_model->get_list('id','Country','country_master',array(''=>' - Select - '));
			$data['department_list'] = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>'- Select Department -'),array('status'=>1),'department_name','asc');
			$data['group_list'] = $this->crud_model->get_list2('employee_group_id','group_name','employee_group',array(''=>'- Select Group -'),array('status'=>1),'group_name','asc');

			$employee_count  = $this->crud_model->get_count('employee');
			$data['employee_number']='E'.($employee_count+10001);
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/employee/createEmployee',$data);
			$this->load->view('templates/footer');
		} else {
			if($this->input->post('date_of_birth')!=""){
				$date_of_birth = date("Y-m-d", strtotime($this->input->post('date_of_birth')));
			}else{
				$date_of_birth = "";
			}
			if($this->input->post('date_of_joining')!=""){
				$date_of_joining = date("Y-m-d", strtotime($this->input->post('date_of_joining')));
			}else{
				$date_of_joining = "";
			}
			if($this->input->post('date_of_termination')!=""){
				$date_of_termination = date("Y-m-d", strtotime($this->input->post('date_of_termination')));
			}else{
				$date_of_termination = "";
			}

			$employee_count  = $this->crud_model->get_count('employee');
			$employee_number='E'.($employee_count+10001);

			$path = FCPATH."images/employee";
			$config['upload_path'] = $path;
			$config['allowed_types'] = 'jpg|jpeg|png';
			$config['max_size'] = '500';
			$config['overwrite'] = FALSE;
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$this->load->library('upload', $config);
			
			if ($_FILES['Image']['name']!=''){
				if (!$this->upload->do_upload('Image')) {
					$uploadImage	='';
				}else{
					$upload_data  =   $this->upload->data();
					$uploadImage = $upload_data['file_name'];
				}
			} else {
				$uploadImage	=@$this->input->post('Image2');
			}
			if($date_of_joining!="0000-00-00"){
				$indemnity_3year=date('Y-m-d', strtotime($date_of_joining. ' + 3 years'));
			}
			$data=array(
				'employee_department_id' => $this->input->post('employee_department_id'),
				'employee_name'     => $this->input->post('employee_name'),
				'employee_nick_name'=> $this->input->post('employee_nick_name'),
				'employee_number'   => $employee_number,
				'home_address'   	=> $this->input->post('home_address'),
				'nationality'   	=> $this->input->post('nationality'),
				'contact_person'   	=> $this->input->post('contact_person'),
				'personal_email'   	=> $this->input->post('personal_email_id'),
				'designation'       => $this->input->post('designation'),
				'function' 			=> $this->input->post('function'),
				'location'    		=> $this->input->post('location'),
				'gender' 			=> $this->input->post('gender'),
				'date_of_birth'     => $date_of_birth,
				'blood_group' 		=> $this->input->post('blood_group'),
				'spouse_name' 		=> $this->input->post('spouse_name'),
				'date_of_joining' 	=> $date_of_joining,
				'employee_status' 	=> $this->input->post('status'),
				'bank_name' 		=> $this->input->post('bank_name'),
				'bank_branch' 		=> $this->input->post('bank_branch'),
				'account_no' 		=> $this->input->post('account_no'),
				'iban_no' 			=> $this->input->post('iban_no'),
				'address'    		=> $this->input->post('address'),
				'contact_number' 	=> $this->input->post('contact_number'),
				'email_id'    		=> $this->input->post('personal_email_id'),
				'date_of_termination' => $date_of_termination,
				'termination_reason'  => $this->input->post('termination_reason'),
				'office_tel'     	  => $this->input->post('office_tel'),
				'local_land_line'     => $this->input->post('local_land_line'),
				'contact_person_no'   => $this->input->post('contact_person_no'),
				'home_contact_person' => $this->input->post('home_contact_person'),
				'home_contact_person_no' => $this->input->post('home_contact_person_no'),
				'employee_group_id'   => $this->input->post('employee_group_id'),
				'employee_photo'      => $uploadImage,
				'indemnity_3year'     => $indemnity_3year,
				'user_id' 			  => $this->session->userdata('user_id')
			);

			$rr=$this->crud_model->insert('employee',$data);
			$insert_id	=	$this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Payroll General Info',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false){
				$this->session->set_flashdata('response','General Info cannot be inserted');
				redirect('masters/Employee/listEmployee');
			}else{
				$this->session->set_flashdata('success','General Info added');
				redirect('masters/Employee/editEmployee/'.$insert_id.'/general_info');
			}
		}
	}
	function upload_it() {
		if($this->input->post('title')!=='' && $_FILES["fileField"]["name"]!=='' ){
			$this->load->helper('form');
			$uniqueID = 'enq'.$this->input->post('enquiry_id_redrct');
			if(!file_exists("uploads/".$uniqueID)) {
				mkdir("uploads/".$uniqueID, 0777, true);
			}
			$config['upload_path'] = 'uploads/'.$uniqueID;
			$config['allowed_types'] = '*';
			$config['overwrite'] = FALSE;
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$this->upload->set_allowed_types('*');
			$this->upload->do_upload("fileField");	
			$upload_data  =   $this->upload->data();
			$uploadImage = $upload_data['file_name'];
			$newdata = array(
				'title'		=> $this->input->post('title'),
				'enquiry_id'=> $this->input->post('enquiry_id_redrct'),
				'user_id'	=> $this->session->userdata('user_id'),
				'file_name' => $uploadImage,
			);
			$add_file = $this->db->insert('enquiry_upload_files', $newdata); 
			if($add_file) {
				$this->session->set_flashdata('success','File Uploaded Successfully...');
			} else {
				$this->session->set_flashdata('response','Something Wrong.Try Again...');
			}
		} else {
			$this->session->set_flashdata('response','Something Wrong.Try Again...');
		}
	    redirect('furniture/Enquiry/editEnquiry/'.$this->input->post('enquiry_id_redrct').'');
	}
	function update_generalinfo($employee_id){
		
		$this->form_validation->set_rules('employee_department_id','Department','required');
		$this->form_validation->set_rules('employee_number', 'Employee Number', 'required');
		$this->form_validation->set_rules('employee_name', 'Employee Name', 'required');
		$this->form_validation->set_rules('nationality', 'Nationality', 'required');
		$this->form_validation->set_rules('employee_group_id', 'Group', 'required');
		//,array('date_of_joining' => date("Y-m-d", strtotime($this->input->post('date_of_joining'))
		
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',validation_errors(),':old:');
			//$this->session->keep_flashdata('response');
			$this->editEmployee($employee_id,'general_info');
		}else{
			$where=array(
				'employee_id'  => $employee_id
			);
			if($this->input->post('date_of_birth')!=""){
				$date_of_birth = date("Y-m-d", strtotime($this->input->post('date_of_birth')));
				if($date_of_birth==="1970-01-01" || $date_of_birth==="01-01-1970"){
					$date_of_birth = "0000-00-00";
				}
			}else{
				$date_of_birth = "0000-00-00";
			}
			if($this->input->post('date_of_joining')!=""){
				$date_of_joining = date("Y-m-d", strtotime($this->input->post('date_of_joining')));
				if($date_of_joining==="1970-01-01" || $date_of_joining==="01-01-1970"){
					$date_of_joining = "0000-00-00";
				}
			}else{
				$date_of_joining = "0000-00-00";
			}
			if($this->input->post('date_of_termination')!=""){
				$date_of_termination = date("Y-m-d", strtotime($this->input->post('date_of_termination')));
				if($date_of_termination==="1970-01-01" || $date_of_termination==="01-01-1970"){
					$date_of_termination = "0000-00-00";
				}
			}else{
				$date_of_termination = "0000-00-00";
			}
			if($date_of_joining!="0000-00-00"){
				$indemnity_3year=date('Y-m-d', strtotime($date_of_joining. ' + 3 years'));
			}
			$path = FCPATH."images/employee";
			$config['upload_path'] = $path;
			$config['allowed_types'] = 'jpg|jpeg|png';
			$config['max_size'] = '500';
			$config['overwrite'] = FALSE;
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$this->load->library('upload', $config);
			
			if ($_FILES['Image']['name']!=''){
				if (!$this->upload->do_upload('Image')) {
					$uploadImage='';
				}else{
					$upload_data= $this->upload->data();
					$uploadImage= $upload_data['file_name'];
				}
			} else {
				$uploadImage=@$this->input->post('Image2');
			}

			$data=array(
				'employee_department_id' => $this->input->post('employee_department_id'),
				'employee_name'     => $this->input->post('employee_name'),
				'employee_nick_name'=> $this->input->post('employee_nick_name'),
				'home_address'   	=> $this->input->post('home_address'),
				'nationality'   	=> $this->input->post('nationality'),
				'direct_number'   	=> $this->input->post('direct_number'),
				'contact_person'   	=> $this->input->post('contact_person'),
				'personal_email'   	=> $this->input->post('personal_email_id'),
				'designation'       => $this->input->post('designation'),
				'function' 			=> $this->input->post('function'),
				'location'    		=> $this->input->post('location'),
				'gender' 			=> $this->input->post('gender'),
				'date_of_birth'     => $date_of_birth,
				'blood_group' 		=> $this->input->post('blood_group'),
				'spouse_name' 		=> $this->input->post('spouse_name'),
				'date_of_joining' 	=> $date_of_joining,
				'employee_status' 	=> $this->input->post('status'),
				'bank_name' 		=> $this->input->post('bank_name'),
				'bank_branch' 		=> $this->input->post('bank_branch'),
				'account_no' 		=> $this->input->post('account_no'),
				'iban_no' 			=> $this->input->post('iban_no'),
				'address'    		=> $this->input->post('address'),
				'contact_number' 	=> $this->input->post('contact_number'),
				'email_id'    		=> $this->input->post('personal_email_id'),
				'date_of_termination'=> $date_of_termination,
				'termination_reason'=> $this->input->post('termination_reason'),
				'office_tel'     	=> $this->input->post('office_tel'),
				'local_land_line'   => $this->input->post('local_land_line'),
				'contact_person_no' => $this->input->post('contact_person_no'),
				'home_contact_person'    => $this->input->post('home_contact_person'),
				'home_contact_person_no' => $this->input->post('home_contact_person_no'),
				'employee_photo'    => $uploadImage,
				'indemnity_3year'   => $indemnity_3year,
				'employee_group_id' => $this->input->post('employee_group_id'),
				'user_id' 			=> $this->session->userdata('user_id')
			);

			$rr=$this->crud_model->update('employee',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Payroll General Info',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			
			$this->session->set_flashdata('success','General Info updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/general_info');
		}
	}

	function update_statuatory($employee_id){
		$this->form_validation->set_rules('cpr_number','CPR Number','required');
		$this->form_validation->set_rules('cpr_expiry','CPR Expiry','required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('statutoryresponse',validation_errors(),':old:');
			//$this->session->keep_flashdata('response');
			$this->editEmployee($employee_id,"add_statuatory");
		}else{
			$where=array('employee_id'  => $employee_id);
			if($this->input->post('cpr_expiry')!=""){
				$cpr_expiry = date("Y-m-d", strtotime($this->input->post('cpr_expiry')));
				if($cpr_expiry==="1970-01-01" || $cpr_expiry==="01-01-1970"){
					$cpr_expiry = "0000-00-00";
				}
			}else{
				$cpr_expiry = "0000-00-00";
			}
			if($this->input->post('driving_licence_expiry')!=""){
				$driving_licence_expiry = date("Y-m-d", strtotime($this->input->post('driving_licence_expiry')));
				if($driving_licence_expiry==="1970-01-01" || $driving_licence_expiry==="01-01-1970"){
					$driving_licence_expiry = "0000-00-00";
				}
			}else{
				$driving_licence_expiry = "0000-00-00";
			}
			
			$data=array(
				'cpr_number'  	        => $this->input->post('cpr_number'),
				'driving_licence_number'=> $this->input->post('driving_licence_number'),
				'cpr_expiry'  	  		=> $cpr_expiry,
				'driving_licence_expiry'=> $driving_licence_expiry
			);

			$rr=$this->crud_model->update('employee',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Statuatory',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($_REQUEST["xcount"]>0  && $this->input->post('title')!=='' && $_FILES["uploadImage1"]["name"]!==''){
				$this->load->helper('form');
				$uniqueID = 'statutories/'.$employee_id;
				if(!file_exists("uploads/".$uniqueID)) {
					mkdir("uploads/".$uniqueID, 0777, true);
				}
				$config['upload_path'] = 'uploads/'.$uniqueID;
				$config['allowed_types'] = '*';
				$config['overwrite'] = FALSE;
				$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');
				$this->upload->do_upload("uploadImage1");	
				$upload_data  =   $this->upload->data();
				$uploadImage = $upload_data['file_name'];
				$newdata = array(
					'employee_id'		=> $employee_id,
					'title'=> $this->input->post('title'),
					'file_name' => $uploadImage,
				);
				$add_file = $this->db->insert('statutory_files', $newdata); 
			}
			
			$this->session->set_flashdata('statutorysuccess','Statuatory Details updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_statuatory');
		}
	}

	function update_passport($employee_id){
		$this->form_validation->set_rules('passport_no','Passport Number','required');
		$this->form_validation->set_rules('country','Country','required');
		$this->form_validation->set_rules('passport_expiry_date','Passport Expiry','required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('passportresponse',validation_errors(),':old:');
			//$this->session->keep_flashdata('response');
			$this->editEmployee($employee_id,"add_passport");
		}else{
			$where=array('employee_id'  => $employee_id);
			if($this->input->post('passport_issue_date')!=""){
				$passport_issue_date = date("Y-m-d", strtotime($this->input->post('passport_issue_date')));
				if($passport_issue_date==="1970-01-01" || $passport_issue_date==="01-01-1970"){
					$passport_issue_date = "0000-00-00";
				}
			}else{
				$passport_issue_date = "0000-00-00";
			}
			if($this->input->post('passport_expiry_date')!=""){
				$passport_expiry_date = date("Y-m-d", strtotime($this->input->post('passport_expiry_date')));
				if($passport_expiry_date==="1970-01-01" || $passport_expiry_date==="01-01-1970"){
					$passport_expiry_date = "0000-00-00";
				}
			}else{
				$passport_expiry_date = "0000-00-00";
			}
			if($this->input->post('visa_expiry_date')!=""){
				$visa_expiry_date = date("Y-m-d", strtotime($this->input->post('visa_expiry_date')));
				if($visa_expiry_date==="1970-01-01" || $visa_expiry_date==="01-01-1970"){
					$visa_expiry_date = "0000-00-00";
				}
			}else{
				$visa_expiry_date = "0000-00-00";
			}
			
			$data=array(
				'passport_number'  	  => $this->input->post('passport_no'),
				'country_of_issue' 	  => $this->input->post('country'),
				'passport_issue_date' => $passport_issue_date,
				'passport_expiry_date'=> $passport_expiry_date,
				'visa_number'  		  => $this->input->post('visa_no'),
				'visa_expiry_date'    => $visa_expiry_date
			);
			
			if($_REQUEST["passport_count"]>0 && $this->input->post('passport_file_name')!=='' && $_FILES["passport_file"]["name"]!==''){
				$this->load->helper('form');
				$uniqueID = 'passport/'.$employee_id;
				if(!file_exists("uploads/".$uniqueID)) {
					mkdir("uploads/".$uniqueID, 0777, true);
				}
				$config['upload_path'] = 'uploads/'.$uniqueID;
				$config['allowed_types'] = '*';
				$config['overwrite'] = FALSE;
				$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');
				$this->upload->do_upload("passport_file");	
				$upload_data  =   $this->upload->data();
				$uploadImage = $upload_data['file_name'];
				$newdata = array(
					'employee_id'=> $employee_id,
					'title'		 => $this->input->post('passport_file_name'),
					'file_name'  => $uploadImage,
				);
				$add_file = $this->db->insert('passport_files', $newdata); 
			}
			
			$rr=$this->crud_model->update('employee',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Passport',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('passportsuccess','Passport and Visa Details updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_passport');
		}

	}

	function update_contract($employee_id){
		//$this->form_validation->set_rules('wpn','Work Permit Number','required');
		$this->form_validation->set_rules('contract_start_date','Contract Start Date','required');
		$this->form_validation->set_rules('contract_expiry_date','Contract Expiry Date','required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('contractresponse',validation_errors(),':old:');
			$this->editEmployee($employee_id,"add_contract");
		}else{
			$where=array('employee_id'  => $employee_id);
			if($this->input->post('contract_start_date')!=""){
				$contract_start_date = date("Y-m-d", strtotime($this->input->post('contract_start_date')));
				if($contract_start_date==="1970-01-01" || $contract_start_date==="01-01-1970"){
					$contract_start_date = "0000-00-00";
				}
			}else{
				$contract_start_date = "0000-00-00";
			}
			if($this->input->post('contract_expiry_date')!=""){
				$contract_expiry_date = date("Y-m-d", strtotime($this->input->post('contract_expiry_date')));
				if($contract_expiry_date==="1970-01-01" || $contract_expiry_date==="01-01-1970"){
					$contract_expiry_date = "0000-00-00";
				}
			}else{
				$contract_expiry_date = "0000-00-00";
			}
			
			$data=array(
				'contract_start_date' => $contract_start_date,
				'contract_expiry_date'=> $contract_expiry_date
			);
			
			if($_REQUEST["contract_count"]>0 && $this->input->post('contract_file_name')!=='' && $_FILES["contract_file"]["name"]!==''){
				$this->load->helper('form');
				$uniqueID = 'contract/'.$employee_id;
				if(!file_exists("uploads/".$uniqueID)) {
					mkdir("uploads/".$uniqueID, 0777, true);
				}
				$config['upload_path'] = 'uploads/'.$uniqueID;
				$config['allowed_types'] = '*';
				$config['overwrite'] = FALSE;
				$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');
				$this->upload->do_upload("contract_file");	
				$upload_data  =   $this->upload->data();
				$uploadImage = $upload_data['file_name'];
				$newdata = array(
					'employee_id'=> $employee_id,
					'title'		 => $this->input->post('contract_file_name'),
					'file_name'  => $uploadImage,
				);
				$add_file = $this->db->insert('contract_files', $newdata); 
			}
			$rr=$this->crud_model->update('employee',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Contract',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('contractsuccess','Updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_contract');
		}
	}

	function update_notes($employee_id){
		$this->form_validation->set_rules('note_1','Note 1','required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('notesresponse',validation_errors(),':old:');
			$this->editEmployee($employee_id,"add_notes");
		}else{
			$where=array('employee_id'  => $employee_id);
			
			$data=array(
				'note_1' => $this->input->post('note_1'),
				'note_2' => $this->input->post('note_2'),
				'note_3' => $this->input->post('note_3')
			);

			$rr=$this->crud_model->update('employee',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Notes',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('notessuccess','Employee Details updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_notes');
		}
	}

	function update_dependent($employee_id){
		$this->form_validation->set_rules('dep_employee_id[]','Employee','required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('dependentresponse',validation_errors(),':old:');
			$this->editEmployee($employee_id,"add_dependent");
		}else{
			$where=array('employee_id'  => $employee_id);
			$this->db->delete('employee_dependent_details', $where);
			$dependent_name	=	$this->input->post('dependent_name');
			$relation	=	$this->input->post('relation');
			$dependent_dob	=	$this->input->post('dependent_dob');
			$dependent_cpr	=	$this->input->post('dependent_cpr');
			$dependent_cpr_expiry	=	$this->input->post('dependent_cpr_expiry');
			$dependent_passport	=	$this->input->post('dependent_passport');
			$dependent_passport_expiry	=	$this->input->post('dependent_passport_expiry');
			$dependent_visa	=	$this->input->post('dependent_visa');
			$dependent_visa_expiry	=	$this->input->post('dependent_visa_expiry');
			for($i=0;$i<count($dependent_name);$i++){
				if($dependent_name[$i]!=""){
					if($dependent_dob[$i]!=""){
						$dependent_dob2 = date("Y-m-d", strtotime($dependent_dob[$i]));
						if($dependent_dob2=="1970-01-01" || $dependent_dob2=="01-01-1970"){
							$dependent_dob2 = "0000-00-00";
						}
					}else{
						$dependent_dob2 = "0000-00-00";
					}
					if($dependent_cpr_expiry[$i]!=""){
						$dependent_cpr_expiry2 = date("Y-m-d", strtotime($dependent_cpr_expiry[$i]));
						if($dependent_cpr_expiry2=="1970-01-01" || $dependent_cpr_expiry2=="01-01-1970"){
							$dependent_cpr_expiry2 = "0000-00-00";
						}
					} else {
						$dependent_cpr_expiry2 = "0000-00-00";
					}
					if($dependent_passport_expiry[$i]!=""){
						$dependent_passport_expiry2 = date("Y-m-d", strtotime($dependent_passport_expiry[$i]));
						if($dependent_passport_expiry2=="1970-01-01" || $dependent_passport_expiry2=="01-01-1970"){
							$dependent_passport_expiry2 = "0000-00-00";
						}
					} else {
						$dependent_passport_expiry2 = "0000-00-00";
					}
					if($dependent_visa_expiry[$i]!=""){
						$dependent_visa_expiry2 = date("Y-m-d", strtotime($dependent_visa_expiry[$i]));
						if($dependent_visa_expiry2=="1970-01-01" || $dependent_visa_expiry2=="01-01-1970"){
							$dependent_visa_expiry2 = "0000-00-00";
						}
					} else {
						$dependent_visa_expiry2 = "0000-00-00";
					}
					$data=array(
						'employee_id' => $employee_id,
						'dependent_name' => $dependent_name[$i],
						'relation' => $relation[$i],
						'dependent_dob' => $dependent_dob2,
						'dependent_cpr' => $dependent_cpr[$i],
						'dependent_cpr_expiry' => $dependent_cpr_expiry2,
						'dependent_passport' => $dependent_passport[$i],
						'dependent_passport_expiry' => $dependent_passport_expiry2,
						'dependent_visa' => $dependent_visa[$i],
						'dependent_visa_expiry' => $dependent_visa_expiry2,
						'created_user' => $this->session->userdata('user_id'),
					);
					$this->db->insert('employee_dependent_details',$data);
				}
			}
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Dependent',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('dependentsuccess','Employee Details updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_dependent');
		}
	}

	function update_asset($employee_id){
		$this->form_validation->set_rules('asset_employee_id','Employee','required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('assetresponse',validation_errors(),':old:');
			$this->editEmployee($employee_id,"add_asset");
		}else{
			$where=array('employee_id'  => $employee_id);
			$this->db->delete('employee_asset_details', $where);
			$asset_name	=	$this->input->post('asset_name');
			$asset_code	=	$this->input->post('asset_code');
			$asset_issue_date	=	$this->input->post('asset_issue_date');
			$asset_return_date	=	$this->input->post('asset_return_date');
			$asset_remarks	=	$this->input->post('asset_remarks');;
			for($i=0;$i<count($asset_name);$i++){
				if($asset_name[$i]!=""){
					if($asset_issue_date[$i]!=""){
						$asset_issue_date2 = date("Y-m-d", strtotime($asset_issue_date[$i]));
						if($asset_issue_date2=="1970-01-01" || $asset_issue_date2=="01-01-1970"){
							$asset_issue_date2 = "0000-00-00";
						}
					}else{
						$asset_issue_date2 = "0000-00-00";
					}
					if($asset_return_date[$i]!=""){
						$asset_return_date2 = date("Y-m-d", strtotime($asset_return_date[$i]));
						if($asset_return_date2=="1970-01-01" || $asset_return_date2=="01-01-1970"){
							$asset_return_date2 = "0000-00-00";
						}
					} else {
						$asset_return_date2 = "0000-00-00";
					}
					
					$data=array(
						'employee_id' => $employee_id,
						'asset_name' => $asset_name[$i],
						'asset_code' => $asset_code[$i],
						'asset_issue_date' => $asset_issue_date2,
						'asset_return_date' => $asset_return_date2,
						'asset_remarks' => $asset_remarks[$i]
					);
					$this->db->insert('employee_asset_details',$data);
				}
			}
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Employee Asset',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',
			);
			$this->crud_model->insert('log_for_masters',$data);
		
			$this->session->set_flashdata('assetsuccess','Employee asset Details updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_asset');
		}
	}
	public function validate_first_day_of_month($date)
	{
		if (date('j', strtotime($date)) !== '1') {
			$this->form_validation->set_message('validate_first_day_of_month', 'The {field} must be the first day of the month.');
			return false;
		}
		return true;
	}
	public function addnewPayHead(){
		$applicable_date=	date("Y-m-d", strtotime($this->input->post('applicable_date')));
		$employee_id=	$this->input->post('employee_id');
		$hid_applicable_date=	date("Y-m-d", strtotime($this->input->post('hid_applicable_date')));
		$rs=$this->crud_model->get('employee_pay_heads',array('employee_id' => $employee_id,'applicable_date' => $hid_applicable_date));
		if($rs!=false){
			foreach($rs as $row){
				$data=array(
					'employee_id' => $employee_id,
					'applicable_date' => $applicable_date,
					'pay_head_id' => $row['pay_head_id'],
					'amount' => $row['amount'],
					'created_id' => $this->session->userdata('user_id'),
				);
				//print_r($data);
				$this->db->insert('employee_pay_heads',$data);
			}
			echo 'yes';
			//$this->session->set_flashdata('salaryresponse','Salary Already Processed',':old:');
			//$this->editEmployee($employee_id,"add_salary");
		} else {
			echo 'No';
		}
	}
	function update_salary_strucure($employee_id){
		$this->form_validation->set_rules('sal_employee_id','Employee','required');
		$this->form_validation->set_rules('applicable_date','Applicable Date','required|callback_validate_first_day_of_month');
		
		
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('salaryresponse',validation_errors(),':old:');
			$this->editEmployee($employee_id,"add_salary");
		}else{
			$array_data = array();
			$applicable_date = date("Y-m-d", strtotime($this->input->post('applicable_date')));
			$rs=$this->crud_model->get('employee_attendance_processed',array('employee_id' => $employee_id,'processed_date >' => $applicable_date));
			if($rs!=false){
				$this->session->set_flashdata('salaryresponse','Salary Already Processed',':old:');
				$this->editEmployee($employee_id,"add_salary");
			} else {
			
			//exit();
			$data = array(
				'applicable_date' => $applicable_date
			);
			$where=array('employee_id'  => $employee_id);
			$rr=$this->crud_model->update('employee',$data,$where);

			$this->db->delete('employee_pay_heads', $where);

			$pay_head_ids = $this->input->post('pay_head');
			$pay_head_amounts = $this->input->post('pay_head_amount');
			for ($i = 0; $i < count($pay_head_ids); $i++) {
				if($pay_head_ids[$i]!=''){
					if($pay_head_amounts[$i]===''){
						$pay_head_amounts[$i] = 0;
					}
					$array_data[] = array(
						'employee_id'=> $employee_id,
						'pay_head_id'=> $pay_head_ids[$i],
						'applicable_date' => $applicable_date,
						'amount' 	 => $pay_head_amounts[$i],
						'created_id' => $this->session->userdata('user_id')
					);
				}
			}
			$this->db->insert_batch('employee_pay_heads', $array_data);
			
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Salary Details',	
				'masters_id'=>$employee_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('salarysuccess','Employee salary Details updated');
			redirect('masters/Employee/editEmployee/'.$employee_id.'/add_salary');
			}
		}
	}
	function statutory_delete_file($employee_id=0,$file_id=0){
		$where=array(
			'file_id'=> $file_id
		);
		
		$records=$this->crud_model->get('statutory_files',$where);
		$statutory_file = $records[0]["file_name"];
		unlink(FCPATH."uploads/statutories/".$employee_id."/".$statutory_file);
		
		$this->crud_model->delete('statutory_files',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Employee Statutory files',	
			'masters_id'=>$employee_id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);
		$this->session->set_flashdata('statutoryresponse','File deleted');
		redirect('masters/Employee/editEmployee/'.$employee_id.'/add_statuatory');
	}

	function passport_delete_file($employee_id=0,$file_id=0){
		$where=array(
			'file_id'=> $file_id
		);
		
		$records=$this->crud_model->get('passport_files',$where);
		$passport_file = $records[0]["file_name"];
		unlink(FCPATH."uploads/passport/".$employee_id."/".$passport_file);
		
		$this->crud_model->delete('passport_files',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Employee Passport files',	
			'masters_id'=>$employee_id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);
		$this->session->set_flashdata('passportresponse','File deleted');
		redirect('masters/Employee/editEmployee/'.$employee_id.'/add_passport');
	}

	function contract_delete_file($employee_id=0,$file_id=0){
		$where=array(
			'file_id'=> $file_id
		);
		
		$records=$this->crud_model->get('contract_files',$where);
		$contract_file = $records[0]["file_name"];
		unlink(FCPATH."uploads/contract/".$employee_id."/".$contract_file);
		
		$this->crud_model->delete('contract_files',$where);
		$date = date("Y-m-d H:i:s");
		$userid = $this->session->userdata('user_id');
		$data= array(						
			'masters_type'=>'Employee Contract files',	
			'masters_id'=>$employee_id,	
			'date'=>$date,	
			'created_id'=> $userid,	
			'masters_op'=>'delete',	
		);
		$this->crud_model->insert('log_for_masters',$data);
		$this->session->set_flashdata('contractresponse','File deleted');
		redirect('masters/Employee/editEmployee/'.$employee_id.'/add_contract');
	}
	
	public function salary_calculator(){
		$basicSalary = 400;
		$payHeadId = 4;
		$others = 5;

		$formula = $this->getFormulaFromDatabase($payHeadId);

		if ($formula) {
			$calculatedValue = $this->calculateValue($basicSalary, $formula, $others);
			echo "The calculated value is: " . $calculatedValue;
		} else {
			echo "No formula ".$payHeadId;
		}
	}
	function getFormulaFromDatabase($payHeadId) {
		$payHeadData = $this->crud_model->get('pay_head',array('status'=>1,'id'=>$payHeadId,'is_formula'=>'1'));
		$formulas = [];
		if($payHeadData!=false){
			foreach ($payHeadData as $payHead) {
				if (!empty($payHead['set_formula'])) {
					$formulas[$payHead['id']] = $payHead['set_formula'];
				}
			}
		}
		return $formulas[$payHeadId] ?? null;
	}

	function calculateValue($basicSalary, $formula, $others) {
		$formula = str_replace('@basic_salary', $basicSalary, $formula);
		$formula = str_replace('#others', $others, $formula);
		eval("\$value = $formula;");
		return $value;
	}

	public function search_employee() {
		$client	=	$this->input->post('employee');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and employee_name LIKE '%$r%' ";
		}
		//$client_contact_data = $this->db->query("SELECT * FROM `employee` where ( employee_status='active' ) AND  ( `employee_name` like '$client%' OR `employee_number` like '$client%' OR `contact_number` like '$client%'  )  union (SELECT * FROM `employee` where employee_status='active' AND `employee_id` not in (SELECT `employee_id` FROM `employee` where employee_status='active' AND ( `employee_name` like '$client%' OR `employee_number` like '$client%' OR `contact_number` like '$client%' ) ) ".$sql." order by employee_name) limit 25 ");
		$client_contact_data = $this->db->query("SELECT * FROM `employee` where ( employee_status='active' ) AND  ( `employee_name` like '%$client%' OR `employee_number` like '%$client%' OR `contact_number` like '%$client%'  )   order by employee_name limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='<tr class="no_result_button" tabindex="-1"><th><b>Name</b></th><th><b>Employee No</b></th><th><b>Local Mobile</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr tabindex="-1" class="employee_button" ><td style="padding:5px 0px 0px 10px !important;"><input type="hidden" class="employee_id" value="' .$client_contact_datas['employee_id'].'" /><input type="hidden" class="employee_name" value="' .$client_contact_datas['employee_name'].'" /> '.$client_contact_datas['employee_name'].'</td><td style="padding:5px 0px 0px 10px !important;" >'.$client_contact_datas['employee_number'].'</td><td style="padding:5px 0px 0px 10px !important;">'.$client_contact_datas['contact_number'].'</td></tr>';
			}
		} else {
			$html.='<tr class="no_result_button" tabindex="-1"><td style="color:red;" colspan="3" > No Results Found </td></tr>';
		}
		print $html;
	}

}

?>