<?php
class kitchen_areas extends CI_Controller {
	function Kitchen_areas()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/kitchen_areas/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('kitchen_areas',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('kitchen_areas',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/kitchen_areas/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->load->view('templates/header');
		$this->load->view('masters/kitchen_areas/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				'kitchen_area_id' => $id
		);
		$records=$this->crud_model->get('kitchen_areas',$where);
		if($records != false){
			//true section
			$data['kitchen_area_name']			 = $records[0]['kitchen_area_name'];
			$data['kitchen_area_id']			 = $records[0]['kitchen_area_id'];
			$this->load->view('templates/header');
			$this->load->view('masters/kitchen_areas/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/kitchen_areas');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('kitchen_area_name', 'Kitchen area Name', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/kitchen_areas/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$kitchen_area_name=$this->input->post('kitchen_area_name');

			$data=array('kitchen_area_name' => $kitchen_area_name

			);

			$rr=$this->crud_model->insert('kitchen_areas',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Area cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/kitchen_areas');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Kitchen Area added successfully</div>');
				redirect('masters/kitchen_areas');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('kitchen_area_name', 'kitchen Area Name', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
				
			$records=$this->crud_model->get('kitchen_areas');
			if($records != false){
				//true section
				$data['kitchen_area_name']			 = $records[0]['kitchen_area_name'];
				$data['kitchen_area_id']			 = $records[0]['kitchen_area_id'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/kitchen_areas/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/kitchen_areas');
			}
				
		}
		else
		{// true section

			$kitchen_area_name   = $this->input->post('kitchen_area_name');
			$kitchen_area_id     = $this->input->post('kitchen_area_id');

			$where=array(
					          'kitchen_area_id'  => $kitchen_area_id
			);
			$data=array(
					          'kitchen_area_name' => $kitchen_area_name

			);
			$records=$this->crud_model->update('kitchen_areas',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Kitchen Area updated</div>');
			redirect('masters/kitchen_areas');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'kitchen_area_id'=> $id
		);

		$this->crud_model->delete('kitchen_areas',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Kitchen Area deleted</div>');
		redirect('masters/kitchen_areas');
	}
}