<?php
class Worktop_brands extends CI_Controller {
	function Worktop_brands()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/worktop_brands/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('worktop_brands',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('worktop_brands',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_brands/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->load->view('templates/header');
		$this->load->view('masters/worktop_brands/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				'worktop_brand_id' => $id
		);
		$records=$this->crud_model->get('worktop_brands',$where);
		if($records != false){
			//true section
			$data['worktop_brand_name']			 = $records[0]['worktop_brand_name'];
			$data['worktop_brand_id']			 = $records[0]['worktop_brand_id'];
			$this->load->view('templates/header');
			$this->load->view('masters/worktop_brands/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/worktop_brands');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('worktop_brand_name', 'Worktop Brand Name', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/worktop_brands/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$worktop_brand_name=$this->input->post('worktop_brand_name');

			$data=array('worktop_brand_name' => $worktop_brand_name

			);

			$rr=$this->crud_model->insert('worktop_brands',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Worktop Brand cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/worktop_brands');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Brand added successfully</div>');
				redirect('masters/worktop_brands');
			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('worktop_brand_name', 'Worktop Brand Name', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$records=$this->crud_model->get('worktop_brands');
			if($records != false){
				//true section
				$data['worktop_brand_name']			 = $records[0]['worktop_brand_name'];
				$data['worktop_brand_id']			 = $records[0]['worktop_brand_id'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/worktop_brands/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/worktop_brands');
			}
		}
		else
		{// true section

			$worktop_brand_name   = $this->input->post('worktop_brand_name');
			$worktop_brand_id     = $this->input->post('worktop_brand_id');

			$where=array(
					       'worktop_brand_id'   => $worktop_brand_id
			);
			$data=array(
					       'worktop_brand_name' => $worktop_brand_name

			);

			$records=$this->crud_model->update('worktop_brands',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Brand updated</div>');
			redirect('masters/worktop_brands');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'worktop_brand_id'=> $id
		);

		$this->crud_model->delete('worktop_brands',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Worktop Brand deleted</div>');
		redirect('masters/worktop_brands');
	}
}
