<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Payroll_processing extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
		$this->load->model('Hr_model');
	}

	public function list(){
		$this->users_model->permission("Attendance","View");
		$title['headerTitle']="Attendance List";
		$data['fromDate'] = date('d-m-Y',strtotime(date('Y-m-01')));
		$data['toDate'] = date('d-m-Y',strtotime(date('Y-m-t')));
		$data['employee_datas'] = $this->Hr_model->get_all_attendance();
		
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/attendance/listAttendance',$data);
		$this->load->view('templates/footer');
	}

	public function create(){
		$this->users_model->permission("Payroll_processing","View");
		$title['headerTitle']="Payroll Processing";
		if($this->input->post('fromDate')!='') {
			$fromDate = $this->input->post('fromDate');
		} else {
			$fromDate = date('d-m-Y',strtotime(date('Y-m-01')));
		}
		if($this->input->post('toDate')!='') {
			$toDate = $this->input->post('toDate');
		} else {
			$toDate = date('d-m-Y',strtotime(date('Y-m-t')));
		}
		$data['fromDate'] = $fromDate;
		$data['toDate'] = $toDate;
		$data['payroll_processing_datas'] = $this->Hr_model->get_payroll_processing();
		$data['employee_attendance_processed'] = $this->Hr_model->employee_attendance_processed();
		$data['available_payrolls'] = $this->Hr_model->available_payroll();
		$payUnitData = [];
		$payHeadData = [];
		//print_r($data['employee_attendance_processed']);
		$allPayHeads = $this->crud_model->get("pay_head", array('status' => 1));
		if($data['payroll_processing_datas']!=false) {
			foreach($data['payroll_processing_datas'] as $value) { 
				$payUnitData[$value['pay_hash_unit']][$value['employee_id']] = $value['pay_value']; 
			}
		}
		$data['payUnitData'] = $payUnitData;
		if ($data['available_payrolls'] != false) {
			foreach ($data['available_payrolls'] as $key => $value) {
				$existsInProcessedTable = false;
				if ($data['employee_attendance_processed'] != false) {
					foreach ($data['employee_attendance_processed'] as $value2) {
						if ($fromDate <= $value2['processed_date'] && $toDate >= $value2['processed_date'] && $value['employee_id'] == $value2['employee_id']) {
							$existsInProcessedTable = true;
							break;
						}
					}
				}
				if (!$existsInProcessedTable) {
					$payHeadData[$value['set_variable']][$value['employee_id']] = $value['amount'];
				} else {
					unset($data['available_payrolls'][$key]);
				}
			}
		}
		$payHeadZero = [];
		foreach ($allPayHeads as $payHead2) {
			$payHeadZero[$payHead2['set_variable']] = 0;
		}

		$data['payHeadData'] = $payHeadData;
		$data['payHeadZero'] = $payHeadZero;
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/payroll_processing/create',$data);
		$this->load->view('templates/footer');
	}
	public function view_payroll(){
		$this->users_model->permission("Payroll_processing","View");
		$title['headerTitle']="Payroll Processing";
		if($this->input->post('fromDate')!='') {
			$fromDate = $this->input->post('fromDate');
		} else {
			$fromDate = date('d-m-Y',strtotime(date('Y-m-01')));
		}
		if($this->input->post('toDate')!='') {
			$toDate = $this->input->post('toDate');
		} else {
			$toDate = date('d-m-Y',strtotime(date('Y-m-t')));
		}
		$data['fromDate'] = $fromDate;
		$data['toDate'] = $toDate;
		$data['payroll_processing_datas'] = $this->Hr_model->get_payroll_processing();
		$data['available_payrolls'] = $this->Hr_model->available_payroll();
		$payUnitData = [];
		$payHeadData = [];
		$allPayHeads = $this->crud_model->get("pay_head", array('status' => 1));
		if($data['payroll_processing_datas']!=false) {
			foreach($data['payroll_processing_datas'] as $value) { 
				$payUnitData[$value['pay_hash_unit']][$value['employee_id']] = $value['pay_value'];
				/* foreach ($allPayHeads as $payHead) {
					$payHeadData[$payHead['set_variable']][$value['employee_id']] = 0;
				}  */
			}
		}
		$data['payUnitData'] = $payUnitData;
		if($data['available_payrolls']!=false) {
			foreach($data['available_payrolls'] as $value) {
				$payHeadData[$value['set_variable']][$value['employee_id']] = $value['amount'];
			}
		}
		$payHeadZero = [];
		foreach ($allPayHeads as $payHead2) {
			$payHeadZero[$payHead2['set_variable']] = 0;
		}

		$data['payHeadData'] = $payHeadData;
		$data['payHeadZero'] = $payHeadZero;
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/payroll_processing/view_payroll',$data);
		$this->load->view('templates/footer');
	}

	public function generatePayroll() {
		$this->users_model->permission("Payroll_processing","Create");
		if($this->input->post('fromDate')!='' && $this->input->post('toDate')!='') {
			$fromDate= $this->input->post('fromDate');
			$toDate  = $this->input->post('toDate');
			$this->db->trans_begin();
			$payroll_processing_datas = $this->Hr_model->get_payroll_processing();
			$employee_attendance_processed = $this->Hr_model->employee_attendance_processed();
			$available_payrolls = $this->Hr_model->available_payroll();
			$payUnitData = [];
			$payHeadData = [];
			$allPayHeads = $this->crud_model->get("pay_head", array('status' => 1));
			if($payroll_processing_datas!=false) {
				foreach($payroll_processing_datas as $value) { 
					$payUnitData[$value['pay_hash_unit']][$value['employee_id']] = $value['pay_value']; 
				}
			}
			if ($available_payrolls != false) {
				foreach ($available_payrolls as $key => $value) {
					$existsInProcessedTable = false;
					if ($employee_attendance_processed != false) {
						foreach ($employee_attendance_processed as $value2) {
							/* if ($fromDate <= $value2['processed_date'] && $toDate >= $value2['processed_date'] && $value['employee_id'] == $value2['employee_id']) {
								$existsInProcessedTable = true;
								break;
							} */
							if (date('Y', strtotime($fromDate)) == $value2['processing_year'] && date('m', strtotime($fromDate)) == $value2['processing_month'] && $value['employee_id'] == $value2['employee_id']) {
								$existsInProcessedTable = true;
								break;
							}
						}
					}
			
					if (!$existsInProcessedTable) {
						$payHeadData[$value['set_variable']][$value['employee_id']] = $value['amount'];
					} else {
						unset($available_payrolls[$key]);
					}
				}
			}
			$payHeadZero = [];
			foreach ($allPayHeads as $payHead2) {
				$payHeadZero[$payHead2['set_variable']] = 0;
			}

			$total_paying_amount=0;
			$currentEmployee  = '';
			$currentEmployeeID= '';
			$processed_count  = $this->Hr_model->get_count_with_group_by('employee_attendance_processed',array(),'processed_no');
			$processed_no	  = $processed_count+1;
			$processed_date   = date('Y-m-d');
			$dataInsert		  = array();
			$dataInsert2	  = array();
			$datapayroll_payables=array();

			if($available_payrolls != false) {
				foreach($available_payrolls as $available_payroll) { 
					if($available_payroll['is_payable']==0){
						$pay_unit = $available_payroll['pay_unit'];
						$set_variable=$available_payroll['set_variable'];
						$amount=$available_payroll['amount'];
						$formula=$available_payroll['set_formula'];
						$employee_id=$available_payroll['employee_id'];
						if (isset($payUnitData[$pay_unit][$employee_id])) {
							$pay_value = $payUnitData[$pay_unit][$employee_id];
						} else {
							$pay_value = 0; 
						}
						
						$updated_formula = str_replace($pay_unit, $pay_value, $formula);
						foreach($payHeadData as $set_variable => $employeeData){
							if(isset($employeeData[$employee_id])) {
								$pay_amount = $employeeData[$employee_id];
							} else {
								$pay_amount = 0;
							}
							$updated_formula = str_replace($set_variable, $pay_amount, $updated_formula);
						}
						foreach($payHeadZero as $key => $value_zero) {
							$updated_formula = str_replace($key, $value_zero, $updated_formula);
						}
						if($available_payroll['is_formula']==1) {
						eval("\$amount = $updated_formula;");
						$amount=number_format($amount, 3, '.', '');
						} else {
							$amount = $available_payroll['amount'];
						}
						$total_paying_amount+=$amount;
						if($amount!=0) {
							$dataInsert[]=array(
								'processed_no' 	=> $processed_no,
								'processing_year'=> date('Y', strtotime($fromDate)),
								'processing_month'=> date('m', strtotime($fromDate)),
								'processed_date'=> $processed_date,
								'pay_head_id'   => $available_payroll['pay_head_id'],
								'employee_id'   => $available_payroll['employee_id'],
								'amount' 		=> $amount,
								'created_user'	=> $this->session->userdata('user_id'),
							);
						}
					}
				}
				$this->db->insert_batch('employee_attendance_processed',$dataInsert);
			
				$added_payroll_data=	$this->db->query("SELECT eap.employee_id,eap.pay_head_id,eap.amount,ph.set_variable,ph.is_payable FROM `employee_attendance_processed` eap inner join pay_head ph on ph.id=eap.pay_head_id WHERE eap.processing_year=".date('Y', strtotime($fromDate))." and eap.processing_month=".date('m', strtotime($fromDate))." and eap.status=1 and ph.is_payable=0 order by eap.employee_id desc, eap.pay_head_id asc");
				$added_payroll_datas=$added_payroll_data->result_array();
				foreach($available_payrolls as $available_payroll2) { 
					if($available_payroll2['is_payable']==1){
						$pay_unit = $available_payroll2['pay_unit'];
						$set_variable=$available_payroll2['set_variable'];
						$amount=$available_payroll2['amount'];
						$formula=$available_payroll2['set_formula'];
						$employee_id=$available_payroll2['employee_id'];
						if (isset($payUnitData[$pay_unit][$employee_id])) {
							$pay_value = $payUnitData[$pay_unit][$employee_id];
						} else {
							$pay_value = 0; 
						}
						$updated_formula = str_replace($pay_unit, $pay_value, $formula);
						
						if($added_payroll_data->num_rows() > 0) {
							foreach($added_payroll_datas as $key=>$added_payroll) {
								if($added_payroll['employee_id']==$employee_id && $added_payroll['is_payable']==0) {
									$pay_amount = $added_payroll['amount'];
									$set_variable=$added_payroll['set_variable'];
									$updated_formula = str_replace($set_variable, $pay_amount, $updated_formula);
								}
							}
						}
						foreach($payHeadZero as $key => $value_zero) {
							$updated_formula = str_replace($key, $value_zero, $updated_formula);
						}
						if($available_payroll2['is_formula']==1) {
							eval("\$amount2 = $updated_formula;");
							$amount2=number_format($amount2, 3, '.', '');
						} else {
							$amount2 = $available_payroll2['amount'];
						}
						$total_paying_amount+=$amount2;
						if($amount2!=0) {
							$dataInsert2[]=array(
								'processed_no' 	=> $processed_no,
								'processing_year'=> date('Y', strtotime($fromDate)),
								'processing_month'=> date('m', strtotime($fromDate)),
								'processed_date'=> $processed_date,
								'pay_head_id'   => $available_payroll2['pay_head_id'],
								'employee_id'   => $available_payroll2['employee_id'],
								'amount' 		=> $amount2,
								'created_user'	=> $this->session->userdata('user_id'),
							);
							if($available_payroll2['is_statutory']==0) {
								$datapayroll_payables[]=array(
									'pp_year'		=> date('Y', strtotime($fromDate)),
									'pp_month'		=> date('m', strtotime($fromDate)),
									'pay_head_id'   => $available_payroll['pay_head_id'],
									'employee_id'   => $available_payroll['employee_id'],
									'amount' 		=> $amount2
								);
							}
						} 
					}
				}
				if(!empty($dataInsert2)) {
					$this->db->insert_batch('employee_attendance_processed',$dataInsert2);
				}
				if(!empty($datapayroll_payables)) {
					$this->db->insert_batch('employee_payroll_payables',$datapayroll_payables);
				}
			} 

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Payroll cannot be done, try again.');
				redirect('transactions/Payroll_processing/create');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success','Payroll added successfully');
				redirect('transactions/Payroll_processing/create');
		 	}
		} else {
			$this->session->set_flashdata('response','Payroll cannot be done without date');
			redirect('transactions/Payroll_processing/create');
		}
	}
	
	public function salary_calculator(){
		$basicSalary = 400;
		$payHeadId = 4;
		$others = 5;

		$formula = $this->getFormulaFromDatabase($payHeadId);

		if ($formula) {
			$calculatedValue = $this->calculateValue($basicSalary, $formula, $others);
			echo "The calculated value is: " . $calculatedValue;
		} else {
			echo "No formula ".$payHeadId;
		}
	}
	function getFormulaFromDatabase($payHeadId) {
		$payHeadData = $this->crud_model->get('pay_head',array('status'=>1,'id'=>$payHeadId,'is_formula'=>'1'));
		$formulas = [];
		if($payHeadData!=false){
			foreach ($payHeadData as $payHead) {
				if (!empty($payHead['set_formula'])) {
					$formulas[$payHead['id']] = $payHead['set_formula'];
				}
			}
		}
		return $formulas[$payHeadId] ?? null;
	}

	function calculateValue($basicSalary, $formula, $others) {
		$formula = str_replace('@basic_salary', $basicSalary, $formula);
		$formula = str_replace('#others', $others, $formula);
		eval("\$value = $formula;");
		return $value;
	}

	public function add_employee() {
		for($i=3; $i<=250; $i++) {
			$employee_name = 'Employee ' . $i;
			$employee_number = 'E' . str_pad($i, 5, '0', STR_PAD_LEFT); 
			$nationality = 99;
			$gender = (rand(0, 1) == 1) ? 'male' : 'female'; 
			$employee_status = 'active';
			$applicable_date = '2022-08-01';
			$employee_group_id = rand(1, 4);
			$data = array(
				'employee_id' => $i,
				'employee_name' => $employee_name,
				'employee_nick_name' => $employee_name,
				'employee_number' => $employee_number,
				'nationality' => $nationality,
				'gender' => $gender,
				'employee_status' => $employee_status,
				'applicable_date' => $applicable_date,
				'employee_group_id' => $employee_group_id,
				'user_id' => $this->session->userdata('user_id')
			);
			$this->db->insert('employee', $data);
			//$employee_id=$this->db->insert_id() . "<br>";
		}
	}

	public function add_employee_pay_head() {
		$basic_salary_amounts = array(150, 250, 500, 1000); 
		$allowance_amounts = array(30, 50, 80); 
	
		for($i=3; $i<=250; $i++) {
			$employee_id = $i;
			
			$basic_salary_amount = $basic_salary_amounts[array_rand($basic_salary_amounts)]; 
			$this->insert_employee_pay_head($employee_id, 1, $basic_salary_amount);
	
			foreach (range(2, 4) as $pay_head_id) {
				$allowance_amount = $allowance_amounts[array_rand($allowance_amounts)]; 
				$this->insert_employee_pay_head($employee_id, $pay_head_id, $allowance_amount);
			}
	
			$random_pay_head_ids = range(5, 10); 
			shuffle($random_pay_head_ids);
	
			foreach ($random_pay_head_ids as $pay_head_id) {
				$this->insert_employee_pay_head($employee_id, $pay_head_id);
			}
		}
	}

	public function insert_employee_pay_head($employee_id, $pay_head_id, $amount = null) {
		$data = array(
			'employee_id' => $employee_id,
			'pay_head_id' => $pay_head_id,
			'amount' => $amount, 
			'applicable_date' => '2024-01-01',
			'created_id' => $this->session->userdata('user_id')
		);
		//$this->db->insert('employee_pay_heads', $data);
	}

	public function insert_employee_attendance() {
		$start_date = new DateTime('2024-12-01');
		$end_date = new DateTime('2024-12-31');
		$interval = new DateInterval('P1D'); // 1 day interval
		$period = new DatePeriod($start_date, $interval, $end_date);
	
		$off_days = []; // Array to store off days
		foreach ($period as $date) {
			if ($date->format('N') === '5') { // Check if the day is Friday (N=5)
				$off_days[] = $date->format('Y-m-d'); // Add the Friday to off days
			}
		}
	
		$employee_ids = range(1, 250); // Array of employee IDs from 3 to 250
		$pay_unit_ids = range(1, 3); // Array of pay unit IDs from 1 to 3
		$pay_values = range(0, 4); // Array of pay values from 0 to 4
	
		 // Replace with your method to generate attendance number
		
		foreach ($period as $date) {
			$attendance_date = $date->format('Y-m-d');
			
	
			 if (!in_array($attendance_date, $off_days)) { 
				$attendance_no = $this->generate_attendance_no();
				foreach ($employee_ids as $employee_id) {
					// Randomly select pay_unit_id and pay_value
					$pay_unit_id = $pay_unit_ids[array_rand($pay_unit_ids)];
					$pay_value = $pay_values[array_rand($pay_values)];
	
					if ($pay_value > 0 and ( $pay_unit_id === 2 OR $pay_unit_id === 3 OR $pay_unit_id === 4)) {
						$pay_value = rand(1, 4); // If pay_value is not zero, randomly select a value from 1 to 4
					} else {
						$pay_value = 1;
					}
	
					$this->attendance($attendance_no, $attendance_date, $employee_id, $pay_unit_id, $pay_value);
				}
			} 
		} 
	}
	function generate_attendance_no() {
		// Get the maximum attendance number from the table
		$max_attendance_no_query = $this->db->query('SELECT MAX(attendance_no) AS max_attendance_no FROM employee_attendance');
		$max_attendance_no_row = $max_attendance_no_query->row();
		$max_attendance_no = $max_attendance_no_row->max_attendance_no;
	
		if ($max_attendance_no === null) {
			$next_attendance_no = 1; // If no attendance numbers exist, start from 1
		} else {
			$next_attendance_no = $max_attendance_no + 1; // Increment the maximum attendance number by 1
		}
	
		return $next_attendance_no;
	}

	public function attendance($attendance_no, $attendance_date, $employee_id, $pay_unit_id, $pay_value) {
        $data = array(
            'attendance_no' => $attendance_no,
            'attendance_date' => $attendance_date,
            'employee_id' => $employee_id,
            'pay_unit_id' => $pay_unit_id,
            'pay_value' => $pay_value,
			'comments' 	 	 => NULL,
			'created_date' 	 => date("Y-m-d h:m:s"),
			'created_id' 	 => $this->session->userdata('user_id')
        );
        //$this->db->insert('employee_attendance', $data);
    }
}

?>