<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Convert fb date to mysql data
 */
if ( ! function_exists('convert_fbdate_mysqldate'))
{
	function convert_fbdate_mysqldate($fbdate = '')
	{	
		$ar_date = explode("/",$fbdate);
		$date = $ar_date[2] . '-' . $ar_date[1] . '-' . $ar_date[0];
		return $date;
	}
}
/**
 * check if user logged in, if not redirect him to login page
 */
if ( ! function_exists('user_must_loggedin'))
{
	function user_must_loggedin()
	{
		$CI =& get_instance();
		$CI->load->model('logics/users_logic');
		if($CI->users_logic->verify_user_session() != true)
		{
			$CI->session->set_flashdata('response','<div class="error">Login required</div>');
			redirect('home');
			exit;
		}
	}
}

/**
 * get post time
 */
if ( ! function_exists('get_post_time'))
{
	function get_post_time($post_time)//post_dttime in mysql format Y-m-s H:i:s
	{
		$CI =& get_instance();
		$current_time 		= time();
		
		$post_time_stamp 	= strtotime($post_time);
		$current_time_stamp = $current_time;
		
		$seconds = $current_time_stamp - $post_time_stamp;
		
		$days = floor($seconds / (60 * 60 * 24));
		$remainder = $seconds % (60 * 60 * 24);
		$hours = floor($remainder / (60 * 60));
		$remainder = $remainder % (60 * 60);
		$minutes = floor($remainder / 60);
		$seconds = $remainder % 60;
		
		//return "$days days, $hours hours, $minutes mins and $seconds seconds";
		
		if($days > 0)
			return date($CI->config->item('datetime_format_app'), $post_time_stamp);
		elseif($hours > 0)
			return "few hours ago";		
		elseif($minutes > 0)
			return 'few minutes ago';
		elseif($seconds > 20)
			return 'few seconds ago';
		else
			return "just now";
	}
}

/**
 * get profile image
 */
if ( ! function_exists('profile_image'))
{
	function profile_image($profile_id = 0)
	{
		$CI =& get_instance();
		if($profile_id == 0)
		{
			$profile_id = $CI->session->userdata('profile_id');
		}
		
		$CI->load->model('logics/photos_logic');
		$profile_image = $CI->photos_logic->get_default_profile_image($profile_id);
		
		
		return "<img src='" . base_url() . "images/profiles/" . $profile_image['image_name'] . "' alt='Profile Image'  />";
		
	}
}

/**
 * get thumb image
 */
if ( ! function_exists('thumbnail_image'))
{
	function thumbnail_image($profile_id = 0)
	{
		$CI =& get_instance();
		if($profile_id == 0)
		{
			$profile_id = $CI->session->userdata('profile_id');
		}
		
		$CI->load->model('logics/photos_logic');
		$CI->load->library('image_lib');
		$profile_image = $CI->photos_logic->get_default_profile_image($profile_id);
		//print_r($profile_image);exit;
		$fullview_image_path = $CI->config->item('base_path').'images/profiles/'.$profile_image['image_name'];
		$thumb_image_path = $CI->config->item('base_path').'images/thumbs/'.$profile_image['image_name'];
		if(!file_exists($thumb_image_path))
		{
			// create thumb image
			//echo $fullview_image_path;exit;
			$cf['image_library'] = 'gd2';
			$cf['source_image'] = $fullview_image_path;
			$cf['new_image'] = $CI->config->item('base_path').'images/thumbs/'.$profile_image['image_name'];
			$cf['maintain_ratio'] = TRUE;
			$cf['width'] = 40;
			$cf['height'] = 40;
			$CI->image_lib->initialize($cf);
			if(!$CI->image_lib->resize())
			{
				echo "error<br />".$CI->image_lib->display_errors();exit;
			}
			
		}
		
		return "<img src='" . base_url() . "images/thumbs/" . $profile_image['image_name'] . "' alt='' />";
	}
}

/**
 * get album image
 */
if ( ! function_exists('album_image'))
{
	function album_image($photo_id=0)
	{
		$CI =& get_instance();
		
		$CI->load->model('logics/photos_logic');
		$image = $CI->photos_logic->get_image($photo_id);
		
		return "<img src='" . base_url() . "images/thumbs/" . $image['image_name'] . "' height='100' width='100' alt='Image'  />";
		
	}
}

/**
 * load thumb image
 */
if ( ! function_exists('load_thumbnail_image'))
{
	function load_thumbnail_image($image_name = '',$width='60')
	{
		$CI =& get_instance();
		$CI->load->library('image_lib');
		
		$fullview_image_path = $CI->config->item('base_path').'images/profiles/'.$image_name;
		if(!file_exists($fullview_image_path))
		{
			$fullview_image_path = $CI->config->item('base_path').'images/fullview/default.jpg';
		}
		$thumb_image_path = $CI->config->item('base_path').'images/thumbs/'.$image_name;
		if(!file_exists($thumb_image_path))
		{
			// create thumb image
			//echo $fullview_image_path;exit;
			$cf['image_library'] = 'gd2';
			$cf['source_image'] = $fullview_image_path;
			$cf['new_image'] = $CI->config->item('base_path').'images/thumbs/'.$image_name;
			$cf['maintain_ratio'] = TRUE;
			$cf['width'] = 60;
			$cf['height'] = 60;
			$CI->image_lib->initialize($cf);
			if(!$CI->image_lib->resize())
			{
				echo "error<br />".$CI->image_lib->display_errors();exit;
			}
			
		}
		
		return "<img src='" . base_url() . "images/thumbs/" . $image_name . "' alt='' width='".$width."' />";
	}
}



/**
 * Resize and Crop images (album images)
 */
if ( ! function_exists('resize_crop_image'))
{
	function resize_crop_image($source_image = '',$destination_image = '',$w=100,$h=100)
	{
		$CI =& get_instance();
		$CI->load->library('image_lib');
		
		$path = $CI->config->item('base_path');
    $source_image = $source_image;//'port.jpg';
    $new_w = $w;
    $new_h = $h;
    
    // get image size of img
    $x = getimagesize($path.$source_image);
    // image width
    $sw = $x[0];
    // image height
    $sh = $x[1];
    //print_r($x);exit;
    
    if($sw > $sh) // Horizontal Rectangle?
    {
      $newwidth = ($sw/$sh)*$new_w;
      $newheight=$new_h;   
      $x_pos = ($sw - $sh) / 2;
      $x_pos = ceil($x_pos);
      $y_pos=0;
    }
    
    else if($sh > $sw) // Vertical Rectangle?
    {
      $newheight = ($sh/$sw)*$new_h;
      $newwidth=$new_w;
      $y_pos = ($sh - $sw) / 2;
      $y_pos = ceil($y_pos);
      $x_pos=0;
    }
    else //Already Square
    {
      $newheight=$new_h;
      $newwidth=$new_w;
    }
    
    //echo $x_pos.','.$y_pos.":".$newheight.','.$newwidth;
    
    
    $CI->load->library('image_lib');
    $config['image_library'] = 'gd2';
    $config['source_image'] = $path.$source_image;
    $config['new_image'] = $path.$destination_image;
    $config['create_thumb'] = FALSE;
    $config['maintain_ratio'] = TRUE;
    $config['width'] = $newwidth;
    $config['height'] = $newheight;
    
    $CI->image_lib->initialize($config);
    if(!$CI->image_lib->resize())
    {
      //echo $CI->image_lib->display_errors();
    }
    
    //$config2['image_library'] = 'imagemagick';
    //$config2['library_path'] = '/usr/X11R6/bin/';
    $config2['source_image'] = $path.$destination_image;
    //$config2['new_image'] = $path.$destination_image;
    $config2['x_axis'] = 0;
    $config2['y_axis'] = 0;
    $config2['height'] = $h;
    $config2['width'] = $w;
    $config2['maintain_ratio'] = false;
    //print_r($config2);exit;
    
    $CI->image_lib->initialize($config2);
    if(!$CI->image_lib->crop())
    {
      //echo $CI->image_lib->display_errors();
    }
  }
}




/**
 * Resize and Generate all other required images
 */
if ( ! function_exists('resize_generate_image'))
{
  function resize_generate_image($image_path = '',$image_name = '', $is_profile=false,$w=100,$h=100)
  {
    $CI =& get_instance();
		$CI->load->library('image_lib');
		
		// resize image in fullview
    $cf1['image_library'] = 'gd2';
    $cf1['source_image'] = $CI->config->item('base_path').$image_path.$image_name;
    $cf1['maintain_ratio'] = TRUE;
    $cf1['width'] = 688;
    $cf1['height'] = 516;
    
    $CI->image_lib->initialize($cf1);
    $CI->image_lib->resize();
    
    // resize and crop for thumb
    resize_crop_image($image_path.$image_name,'images/thumbs/'.$image_name,$w,$h);
    
    // is_profile image? create one
    if($is_profile==true)
    {
      resize_crop_image($image_path.$image_name,'images/profiles/'.$image_name,$w,$h);
    }
    
  }
}

/**
 * Convert number into english words 
 */

if ( ! function_exists('convert_number_to_words'))
{
	function convert_number_to_words($number) {
		//Credits to author of http://www.karlrixon.co.uk/writing/convert-numbers-to-words-with-php/
		$hyphen      = '-';
		$conjunction = ' and ';
		$separator   = ', ';
		$negative    = 'negative ';
		$decimal     = ' point ';
		$dictionary  = array(
				0                   => 'zero',
				1                   => 'one',
				2                   => 'two',
				3                   => 'three',
				4                   => 'four',
				5                   => 'five',
				6                   => 'six',
				7                   => 'seven',
				8                   => 'eight',
				9                   => 'nine',
				10                  => 'ten',
				11                  => 'eleven',
				12                  => 'twelve',
				13                  => 'thirteen',
				14                  => 'fourteen',
				15                  => 'fifteen',
				16                  => 'sixteen',
				17                  => 'seventeen',
				18                  => 'eighteen',
				19                  => 'nineteen',
				20                  => 'twenty',
				30                  => 'thirty',
				40                  => 'fourty',
				50                  => 'fifty',
				60                  => 'sixty',
				70                  => 'seventy',
				80                  => 'eighty',
				90                  => 'ninety',
				100                 => 'hundred',
				1000                => 'thousand',
				1000000             => 'million',
				1000000000          => 'billion',
				1000000000000       => 'trillion',
				1000000000000000    => 'quadrillion',
				1000000000000000000 => 'quintillion'
		);
	
		if (!is_numeric($number)) {
			return false;
		}
	
		if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
			// overflow
			trigger_error(
			'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
			E_USER_WARNING
			);
			return false;
		}
	
		if ($number < 0) {
			return $negative . convert_number_to_words(abs($number));
		}
	
		$string = $fraction = null;
	
		if (strpos($number, '.') !== false) {
			list($number, $fraction) = explode('.', $number);
		}
	
		switch (true) {
			case $number < 21:
				$string = $dictionary[$number];
				break;
			case $number < 100:
				$tens   = ((int) ($number / 10)) * 10;
				$units  = $number % 10;
				$string = $dictionary[$tens];
				if ($units) {
					$string .= $hyphen . $dictionary[$units];
				}
				break;
			case $number < 1000:
				$hundreds  = $number / 100;
				$remainder = $number % 100;
				$string = $dictionary[$hundreds] . ' ' . $dictionary[100];
				if ($remainder) {
					$string .= $conjunction . convert_number_to_words($remainder);
				}
				break;
			default:
				$baseUnit = pow(1000, floor(log($number, 1000)));
				$numBaseUnits = (int) ($number / $baseUnit);
				$remainder = $number % $baseUnit;
				$string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
				if ($remainder) {
					$string .= $remainder < 100 ? $conjunction : $separator;
					$string .= convert_number_to_words($remainder);
				}
				break;
		}
	
		if (null !== $fraction && is_numeric($fraction)) {
			$string .= $decimal;
			$words = array();
			foreach (str_split((string) $fraction) as $number) {
				$words[] = $dictionary[$number];
			}
			$string .= implode(' ', $words);
		}
	
		return $string;
	}

}