<?php
class Crud_Model extends CI_Model {

	function __construct()             
	{
		// Call the Model constructor
		parent::__construct();
	}

	// select records count (for pagination)
	function get_count($table_name = '', $where=array()){
		$rs = $this->db->get_where($table_name,$where);
		return $rs->num_rows();
	}

	// select records
	function get($table_name = '', $where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null,$or_like=null,$group_by=null){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		if($or_like) {
			$this->db->or_like($or_like);
		}
		if($group_by) {
			$this->db->group_by($group_by); 
		}
		$rs = $this->db->get_where($table_name, $where);
		//echo $this->db->last_query();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function location_list() {
		$user_id   =   $this->session->userdata('user_id');
		$init_list=array();
		$this->db->select('location_master.`loc_id`,location_master.`loc_name`');
		$this->db->from('location_master');
		$this->db->join('location_permission','location_master.loc_id = location_permission.loc_id','inner');
		$this->db->where('location_permission.permission_value','Allow');
		$this->db->where('location_permission.user_id',$user_id);
		$rs = $this->db->get();
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			if($rs->num_rows() > 1){
				$init_list=array(''=>' - Select Location - ');
			}
			foreach($records as $record){
				$init_list[$record['loc_id']] = $record['loc_name'];
			}
			return $init_list;
		} else {
			$this->db->select('location_master.`loc_id`,location_master.`loc_name`');
			$this->db->from('location_master');
			$rs2 = $this->db->get();
			if($rs2->num_rows()>0){
				$records = $rs2->result_array();
				if($rs2->num_rows() > 1){
					$init_list=array(''=>' - Select Location - ');
				}
				foreach($records as $record){
					$init_list[$record['loc_id']] = $record['loc_name'];
				}
				return $init_list;
			} else {
				return array();
			}
		}
	}

	// get list of records for drop down
	function get_list3($id_field_name,$id_field_name2,$id_field_name3,$id_field_name4,$value_field_name,$table_name,$init_list=array(),$where=array(), $or_where=null,$order_by_field=null,$order_by_order=null){
		$this->db->select($id_field_name);
		$this->db->select($id_field_name2);
		$this->db->select($id_field_name3);
		$this->db->select($id_field_name4);
		$this->db->select($value_field_name);
		$this->db->where($where);
		if($or_where) {
			$this->db->or_where($or_where);
		}
		 
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		$rs = $this->db->get($table_name);	
		
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			foreach($records as $record){
				$init_list[$record[$id_field_name].':nb:'.$record[$id_field_name2].':nb:'.$record[$id_field_name3].':nb:'.$record[$id_field_name4]] = $record[$value_field_name];
			}
			return $init_list;
		}
		else{
			return array();
		}
	}

	function get_list2($id_field_name,$value_field_name,$table_name,$init_list=array(),$where=array(),$order_by_field=null,$order_by_order=null,$group_by=null){
		$this->db->select($id_field_name);
		$this->db->select($value_field_name);
		$this->db->where($where);
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($group_by) {
			$this->db->group_by($group_by); 
		}
		
		$rs = $this->db->get($table_name);
		
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			foreach($records as $record){
				$init_list[$record[$id_field_name]] = $record[$value_field_name];
			}
			return $init_list;
		}
		else{
			return array();
		}
	}

	function get_list4($id_field_name,$value_field_name,$table_name,$init_list=array(),$where=array(),$or_where=null,$order_by_field=null,$order_by_order=null,$group_by=null){
		$this->db->select($id_field_name);
		$this->db->select($value_field_name);
		$this->db->where($where);
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		if($or_where) {
			$this->db->or_where($or_where);
		}
		if($group_by) {
			$this->db->group_by($group_by); 
		}
		
		$rs = $this->db->get($table_name);
		
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			foreach($records as $record){
				$init_list[$record[$id_field_name]] = $record[$value_field_name];
			}
			return $init_list;
		}
		else{
			return array();
		}
	}

	function get_list($id_field_name,$value_field_name,$table_name,$init_list=array(),$where=array()){
		$this->db->select($id_field_name);
		$this->db->select($value_field_name);
		$this->db->where($where);
		$rs = $this->db->get($table_name);
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			foreach($records as $record){
				$init_list[$record[$id_field_name]] = $record[$value_field_name];
			}
			return $init_list;
		}
		else{
			return array();
		}
	}

	// create new record
	function insert($table_name = '', $data=array()){
		$this->db->insert($table_name,$data);
		return $this->db->insert_id();
	}

	// update existing record
	function update($table_name = '', $data=array(),$where=array()){
		return $this->db->update($table_name,$data,$where);
	}

	// delete existing record
	function delete($table_name = '', $where=array()){
		$this->db->delete($table_name,$where);
	}


	function get_view_furniture_quotations_client_project_users($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}

		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('*,furniture_quotation.status as status,furniture_quotation.id as id');
		$this->db->where($where);
		$this->db->from('furniture_quotation');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_quotation.client_id','left');
		$this->db->join('users','users.user_id = furniture_quotation.salesman_id','left');
		$this->db->join('furniture_exstock_paymentterm','furniture_exstock_paymentterm.payment_id = furniture_quotation.exstock_paymenttermid','left');
		$this->db->join('furniture_byorder_paymentterm','furniture_byorder_paymentterm.payment_id = furniture_quotation.byorder_paymenttermid','left');
		$this->db->join('company_division','company_division.division_id = furniture_quotation.quotation_divisionid','left');
		$this->db->join('client_contact','client_contact.Contact_Id = furniture_quotation.contact_Id','left');
		$this->db->join('job_card','job_card.id = furniture_quotation.job_card_id','left');
		 

		$rs = $this->db->get();
		//$this->db->last_query();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
		
		
	}

	public function getIstaxable($quotation_id){
		$this->db->select('new_client_master.tax_perce');
		$this->db->where('id',$quotation_id);
		$this->db->from('furniture_quotation');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_quotation.client_id','left');
		$rs = $this->db->get();
	 
		if($rs->num_rows() > 0){
			return $rs->row()->tax_perce;
		}
		else{
			return false;
		}

	}

	function get_view_job_card($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}

		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('view_furniture_job_card.*,new_client_master.*,users.*,company_division.*,furniture_quotation.quotation_number');
		$this->db->where($where);
		$this->db->from('view_furniture_job_card');
		$this->db->join('new_client_master','new_client_master.client_id = view_furniture_job_card.client_id','left');
		$this->db->join('users','users.user_id = view_furniture_job_card.salesman_id','left');
		$this->db->join('furniture_quotation','furniture_quotation.id = view_furniture_job_card.quotation_id','left');
		//$this->db->join('furniture_exstock_paymentterm','furniture_exstock_paymentterm.payment_id = view_furniture_job_card.exstock_paymenttermid','left');
		//$this->db->join('furniture_byorder_paymentterm','furniture_byorder_paymentterm.payment_id = view_furniture_job_card.byorder_paymenttermid','left');
		$this->db->join('company_division','company_division.division_id = view_furniture_job_card.job_card_divisionid','left');

		$rs = $this->db->get();
		$this->db->last_query();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}	
	}

	function invoice($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){



		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}

		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('*');
		$this->db->where($where);
		$this->db->from('furniture_invoice');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_invoice.client_id','left');
		$this->db->join('company_division','company_division.division_id = furniture_invoice.quotation_divisionid','inner');
		$this->db->join('furniture_quotation','furniture_quotation.id = furniture_invoice.quotation_id','left');
		$this->db->join('users','users.user_id = furniture_invoice.created_id','left');
		$rs = $this->db->get();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
		
		
	}

	function proforma($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){



		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}

		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('*');
		$this->db->where($where);
		$this->db->from('proforma');
		$this->db->join('new_client_master','new_client_master.client_id = proforma.client_id','left');
		$this->db->join('company_division','company_division.division_id = proforma.quotation_divisionid','inner');
		$this->db->join('furniture_quotation','furniture_quotation.id = proforma.quotation_id','left');
		$this->db->join('users','users.user_id = proforma.created_id','left');
		$rs = $this->db->get();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
		
		
	}
	
	function get_view_furniture_quotations_client_project_users_count($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}

		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('*');
		$this->db->where($where);
		$this->db->from('furniture_quotation');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_quotation.client_id','left');
		$this->db->join('users','users.user_id = furniture_quotation.salesman_id','left');
		$this->db->join('furniture_exstock_paymentterm','furniture_exstock_paymentterm.payment_id = furniture_quotation.exstock_paymenttermid','left');
		$this->db->join('furniture_byorder_paymentterm','furniture_byorder_paymentterm.payment_id = furniture_quotation.byorder_paymenttermid','left');
		$this->db->join('company_division','company_division.division_id = furniture_quotation.quotation_divisionid','left');

		$rs = $this->db->get();

		return $rs->num_rows();


	}

	function get_view_furniture_items_with_brand($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('*');
		$this->db->where($where);
		
		$this->db->from('furniture_items');
		$this->db->join('furniture_brands','furniture_brands.brand_id = furniture_items.furniture_brand','left');
		$this->db->join('items','items.id = furniture_items.item_id','left');
		$this->db->join('item_specifications','item_specifications.item_id = items.id','left');
		
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	function get_view_invoice_items_with_brand($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null, $group_by=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		
		if($group_by) {
			$this->db->group_by($group_by); 
		}
	
		$this->db->select('*');
		$this->db->where($where);
		
		$this->db->from('furniture_invoice_details');
		//$this->db->join('furniture_brands','furniture_brands.brand_id = furniture_items.furniture_brand','left');
		
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function get_view_proforma_items_with_brand($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null, $group_by=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		
		if($group_by) {
			$this->db->group_by($group_by); 
		}
	
		$this->db->select('*');
		$this->db->where($where);
		
		$this->db->from('proforma_details');
		//$this->db->join('furniture_brands','furniture_brands.brand_id = furniture_items.furniture_brand','left');
		
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	
	function get_view_furniture_items_with_brand_count($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){
	
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('*');
		$this->db->where($where);
		
		$this->db->from('furniture_items');
		$this->db->join('furniture_brands','furniture_brands.brand_id = furniture_items.furniture_brand','left');
		
		$rs = $this->db->get();
		
		return $rs->num_rows();
	}

	public function discount_limit(){
		$user_group_id=$this->session->userdata('user_group_id');
		$query = $this->db->query("SELECT * FROM `user_groups` WHERE `user_group_id`='$user_group_id'");
		print $query->row()->discount_limit;
	}

	 
	public function profit_based_discount_limit($profit_percentage=0){
		$user_group_id=$this->session->userdata('user_group_id');
		if($profit_percentage!=0){
			$sql=" and `profit_percentage`>=".$profit_percentage;
		} else {
			$sql="";
		}
		$query = $this->db->query("SELECT * FROM `discount_b_profit` WHERE `user_group_id`='$user_group_id' ".$sql);
		if($query->row()!=false){
			return $query->result_array();
		} else {
			return 0;
		}
		//return $discount_percentage;
	}

	public function user_wise_discount_limit(){
		$user_id   =   $this->session->userdata('user_id');
		$query = $this->db->query("SELECT * FROM `users` WHERE `user_status`='Enabled' and user_id='$user_id'");
		
		print $query->row()->discount_limit;
	}

	public function user_wise_section_discount_limit(){
		$user_id   =   $this->session->userdata('user_id');
		$query = $this->db->query("SELECT * FROM `users` WHERE `user_status`='Enabled' and user_id='$user_id'");		
		return $query->row();
	}

	public function is_chassi_number(){
		$user_division   =   $this->session->userdata('user_division');
		$query = $this->db->query("SELECT `status` FROM `config_settings` WHERE division_id='$user_division' and `config_name`= 'is_chassi_number'");		
		return $query->row()->status;
	}

	function convert_number($number) {

		if (($number < 0) || ($number > 999999999)) {

			throw new Exception("Number is out of range");

		}
		$Gn = floor($number / 1000000);

		/* Millions (giga) */
		$number -= $Gn * 1000000;

		$kn = floor($number / 1000);

		/* Thousands (kilo) */

		$number -= $kn * 1000;

		$Hn = floor($number / 100);

		/* Hundreds (hecto) */

		$number -= $Hn * 100;

		$Dn = floor($number / 10);

		/* Tens (deca) */

		$n = $number % 10;

		/* Ones */



		$res = "";



		if ($Gn) {

			$res .= $this->convert_number($Gn) .  "Million";

		}



		if ($kn) {

			$res .= (empty($res) ? "" : " ") .$this->convert_number($kn) . " Thousand";

		}



		if ($Hn) {

			$res .= (empty($res) ? "" : " ") .$this->convert_number($Hn) . " Hundred";

		}

		$ones = array("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", "Nineteen");

		$tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eigthy", "Ninety");

		if ($Dn || $n) {

			if (!empty($res)) {

				$res .= " and ";

			}
			if ($Dn < 2) {

				$res .= $ones[$Dn * 10 + $n];

			} else {

				$res .= $tens[$Dn];



				if ($n) {

					$res .= "-" . $ones[$n];

				}

			}

		}
		if (empty($res)) {

			$res = "zero";

		}
		return $res;

	}

	public function userList(){
		$is_salesman   =   $this->session->userdata('is_salesman');
		$logged_user_id   =   $this->session->userdata('user_id');
		if ($is_salesman == 1 AND $this->session->userdata('user_group_id') != 1) {
			$sql    = "  and `user_id`='$logged_user_id' ";
		} else {
			$sql    =   "  ";
		}	
        $query= $this->db->query("SELECT * FROM `users` where `user_status`='Enabled' ".$sql);
		return $query->result();
    }
	function get_employee_details($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('*');
		
		$this->db->from('employee');
		$this->db->join('department_master','department_master.department_id = employee.employee_department_id','inner');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$this->db->where($where);
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getDivision(){

		$this->db->select('*');
		$this->db->from('company_division');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getuserDivision(){

		$this->db->select('user_division');
		$this->db->from('users');
		$this->db->where('user_id',$this->session->userdata('user_id'));
		$division_id =  $this->db->get()->row()->user_division;
		if(!empty($division_id)){
			// $this->db->select('*');
			// $this->db->where_in('division_id', $division_id);
			// $this->db->where('status',1);
			// $this->db->from('company_division');
			// $rs = $this->db->get();
			$rs = $this->db->query("SELECT * from company_division where division_id in ($division_id) AND status = 1 ");
			if($rs->num_rows() > 0){
				return $rs->result_array();
			}
			else{
				return false;
			}
		}
	}
	public function get_job_no($division_id=0){
		if($division_id!= 0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' and status='1'");
			$division_code=$query->row()->division_code;
			$query1= $this->db->query("SELECT max(job_card_number)  as job_no FROM `job_card` where divisionid='$division_id'");
			 
			if($query1->num_rows() > 0  &&  !empty($query1->row()->job_no) )
			{
				$job_no = $query1->row()->job_no;
				$sLen = strlen($job_no);
				$jbno = substr($job_no,4);
				$number = 1 * preg_replace("([^0-9])", "", $jbno);
				$number = $number + 1;
				$new_jobno ='JB'.date("y").$division_code.$number; 
				$string    = 'JB'.date("y").$division_code;
				$sLenNew = strlen($new_jobno);
				if ($sLenNew < $sLen) {
					$Zero = str_repeat('0', ($sLen - $sLenNew));
					$new_job_no = $string . $Zero . $number;
				}
			}
			else{
				$no = '00001';
				$new_job_no ='JB'.date("y").$division_code.sprintf("%'.05d",$no);
			}
			return $new_job_no;	
		}  
		
	}
	public function getInvoiceTempNum($division_id=0){
		if($division_id!= 0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' and status='1'");
			$division_code=$query->row()->division_code;
			$query1= $this->db->query("SELECT max(invoice_number)  as inv_no FROM `furniture_invoice` where quotation_divisionid='$division_id'");
			if($query1->num_rows() > 0  &&  !empty($query1->row()->inv_no) )
			{
				$inv_no = $query1->row()->inv_no;
				$sLen = strlen($inv_no);
				$jbno = substr($inv_no,4);
				$number = 1 * preg_replace("([^0-9])", "", $jbno);
				$number = $number + 1;
				$new_invno ='IN'.date("y").$division_code.$number; 
				$string    = 'IN'.date("y").$division_code;
				$sLenNew = strlen($new_invno);
				if ($sLenNew < $sLen) {
					$Zero = str_repeat('0', ($sLen - $sLenNew));
					$new_inv_no = $string . $Zero . $number;
				}
			}
			else{
				$no = '00001';
				$new_inv_no ='IN'.date("y").$division_code.sprintf("%'.05d",$no);
			}
			return $new_inv_no;	
		}  
		
	}

	public function get_companyConfig(){
		$this->db->select('*');
		$this->db->from('company_details');
		$rs = $this->db->get();
		if($rs->num_rows() > 0 )
		{
			return $rs->row();
		}
		else{
			return false;
		}

	}

	public function getVehicleDiscountLimit($furniture_quotation_id){
		$this->db->select('RG.labour_disc,RG.parts_disc');
		$this->db->from('reg_no_table AS RG');
		$this->db->join('furniture_quotation AS FQ','FQ.reg_no = RG.reg_no','left');
		$this->db->where('FQ.id' ,$furniture_quotation_id);
		$rs = $this->db->get();
	//	echo $this->db->last_query();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getVehicle_section_DiscountLimit($id){
		$this->db->select('RG.labour_disc,RG.parts_disc');
		$this->db->from('reg_no_table AS RG');
		$this->db->join('job_card AS JC','JC.reg_no = RG.reg_no','left');
		$this->db->where('JC.id' ,$id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getlastInvoicenum($inv_no){
		$this->db->select('invoice_number');
		$this->db->from('furniture_invoice');
		$this->db->where('invoice_id',$inv_no);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->invoice_number;
		}
		else{
			return false;
		}
	}

	public function getCustomerldgcode($client_id){
		$this->db->select('client_code');
		$this->db->from('new_client_master');
		$this->db->where('client_id',$client_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->client_code;
		}
		else{
			return false;
		}
	}
	public function get_model($make_id){
		$this->db->select('*');
		$this->db->from('model');
		$this->db->where('make_id',$make_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
}