<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class StockReport extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('Report_model');
	}		
	public function index() {
		$this->users_model->permission("StockReport", "View");
		$data['report_type'] = "confirmed qoute";	
		$division_list = $this->crud_model->get_list('division_id','division_name','company_division');
		$data['division_list'] = $division_list;
		$data['submitted_division_id'] = NULL;
		$data['records']= false;
		$data['invoice_records'] = false;
		$data['receipt_records'] = false;
		$data['credit_note_records'] = false;
		$data['purchase_invoice_records'] = false;
		$data['payment_records'] = false;
		$data['debit_note_records'] = false;
		$data['general_receipt_records'] = false;
		$data['general_payment_records'] = false;
		$data['journal_records'] = false;
		$this->load->view('templates/header');
		$this->load->view('reports/stock_report',$data);
		$this->load->view('templates/footer');		
	}
	public function list() {
		if($this->input->post('item_id') != '') {
			$this->db->where('item_trans.status', 1);
			$this->db->where('item_trans.item_id', $this->input->post('item_id'));
			if($this->input->post('filter_by')!=='nb'){
				$this->db->where('item_trans.trans_type', $this->input->post('filter_by'));
			}
			
			$this->db->select("item_trans.*, items.item_name, items.item_code, items.unit, CASE item_trans.trans_type WHEN 0 THEN 'Opening' WHEN 1 THEN 'Purchase' WHEN 2 THEN 'Issue' WHEN 3 THEN 'Return' WHEN 4 THEN 'Adjustment' ELSE 'Unknown' END AS trans_type_translation");
			$this->db->from('item_trans');
			$this->db->join('items', 'items.id = item_trans.item_id','inner');
			if($this->input->post('report_date_from') != '' or $this->input->post('report_date_to') != '' ) {
				$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
				$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

				if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
					$this->db->where('DATE(trans_date) >=', $date_fmt);
					$this->db->where('DATE(trans_date) <=', $date_to);
				}
				else if($this->input->post('report_date_from') != '') {
					$this->db->where('DATE(trans_date) >=', $date_fmt);
				}
				else if($this->input->post('report_date_to')!=''){
					$this->db->where('DATE(trans_date) <=', $date_to);
				}
			}
			if($this->input->post('division') and $this->input->post('division')!="select" ) {
				//$this->db->where('furniture_invoice.quotation_divisionid', $this->input->post('division'));
			}
			$this->db->order_by("trans_date","DESC");
			$rs = $this->db->get();
			//echo $this->db->last_query();
			$data['invoice_records'] = $rs->result_array();

			$division_list = $this->crud_model->get_list('division_id','division_name','company_division');
			$data['division_list'] = $division_list;
			$data['submitted_division_id'] = $this->input->post('division');
			$this->load->view('templates/header');
			$this->load->view('reports/stock_report',$data);
			$this->load->view('templates/footer');
			
		}else{
			$this->index();
		}
	}

	public function search_item() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql=" and item_name LIKE '%$client%' ";
		$client_contact_data = $this->db->query("SELECT * FROM `items` where `item_name` like '%$client%'   order by item_name limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['id'].'" class="item_button" tabindex="-1" ><input type="hidden" class="item_name" value="'.$client_contact_datas['item_name'].'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($client_contact_datas['description']).'" /><input type="hidden" class="item_unit" value="'.$client_contact_datas['unit'].'" />'.$client_contact_datas['item_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		/* echo date('Y-m-d',$given_date);
		 echo date('Y-m-d',$today_date);
		exit ; */
		if($given_date <= $today_date){
			//true
			return true;
		}
		else{
			//false
			$this->form_validation->set_message('date_check', 'Date cannot be future date');
			return FALSE;
		}

	}	
	public function itemSummary(){
		$this->users_model->permission("ItemSummary", "View");
		$data['itemsummary'] = $this->Report_model->getItemSummary();
		$data['items'] = $this->Report_model->getItemList();
		$this->load->view('templates/header');
		$this->load->view('reports/item_summary_report',$data);
		$this->load->view('templates/footer');

	}	
}
?>