<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Supplier_master extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('text');
		$this->config->load('arrays');
	}	
	
	
	public function index($page=1) {
		$this->users_model->permission("Supplier_master", "View");
		$title['headerTitle']="Vendor List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('Supplier_master/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('supplier_master',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('supplier_master',
		array(),
		$config['per_page'],
		$offset,
		'supplier_id',
		'desc'
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header',$title);
		$this->load->view('reports/list_supplier_master',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Supplier_master", "Add");
		$title['headerTitle']="Vendor Create";

		$date=date("Y-m-d");
		$vat_applicable=$this->furniture_quotation_model->vat_applicable($date);
		$list = $this->crud_model->get_list2('id','Country','country_master',array(),array('status'=>1));

		$datas   =   array("vat_applicable" => $vat_applicable,"country_master_list" => $list);

		$this->load->view('templates/header',$title);
		$this->load->view('reports/create_supplier_master',$datas);
		$this->load->view('templates/footer');
	}
	function do_insert() {
		$this->users_model->permission("Supplier_master", "Add");
		$this->form_validation->set_rules('client_name', 'Vendor', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('client_telephone1', 'Mobile', 'required|numeric|max_length[20]');
		$this->form_validation->set_rules('contact_person', 'Contact Person', 'required|max_length[100]');
		
		$client_id  		=   $this->input->post('client_id');
		$client_name  		=   trim($this->input->post('client_name'));
		$client_address  	=   trim($this->input->post('client_address'));
		$client_telephone1  =   $this->input->post('client_telephone1');
		$client_telephone2  =   $this->input->post('client_telephone2');
		$client_fax  		=   $this->input->post('client_fax');
		$client_email  		=   $this->input->post('client_email');
		$contact_person  	=   $this->input->post('contact_person');
		$tax_name  			=   $this->input->post('tax_name');
		$tax_no  			=   $this->input->post('tax_no');
		$country_id    = $this->input->post('country_id');
		if(@$this->input->post('is_credit')==1){
			$is_credit = $this->input->post('is_credit');
		} else {
			$is_credit = 0;
		}
		
		$credit_limit = $this->input->post('credit_limit');
		$credit_days  = $this->input->post('credit_days');
		$tax_perce    = $this->input->post('tax_perce');
		$opening_balance    = $this->input->post('opening_balance');
		$cr_no  		   = $this->input->post('cr_no');
		
		if ($this->form_validation->run() == FALSE) {
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->create();
		} else {
			$this->db->trans_begin();
			$data=array(
				'supplier_name' 	=>	$client_name,
				'address' 			=>	$client_address,
				'mobile_no' 		=>	$client_telephone1,
				'contact_person' 	=> 	$contact_person,
				'supplier_telephone2' =>	$client_telephone2,
				'supplier_fax' 		=> 	$client_fax,
				'supplier_email' 	=> 	$client_email,
				'tax_name' 			=> 	$tax_name,
				'tax_no' 			=> 	$tax_no,
				'is_credit' 		=> 	$is_credit,
				'credit_limit' 		=> 	$credit_limit,
				'credit_days' 		=> 	$credit_days,
				'country_id' 		=> 	$country_id,
				'tax_perce' 		=> 	$tax_perce,
				'cr_no' 			=> $cr_no,
			);

			$records=$this->crud_model->insert('supplier_master',$data);

			$insert_id = $this->db->insert_id();

			$up_data=array(
				'supplier_code'  =>  'SP'.sprintf("%'.04d",$insert_id),
			);
			$this->db->where('supplier_id', $insert_id);
			$this->db->update('supplier_master', $up_data);

			$bank_account_number 	   = $this->input->post('bank_account_number');
			$bank_account_holder_name  = $this->input->post('bank_account_holder_name');
			$bank_iban    = $this->input->post('bank_iban');
			$bank_swift    = $this->input->post('bank_swift');
			$bank_name = $this->input->post('bank_name');
			$bank_branch  = $this->input->post('bank_branch');

			$data=array(
				'ledger_name' 		=>	$client_name,
				'ledger_code' 		=>	'SP'.sprintf("%'.04d",$insert_id),
				'acoount_group_id'  =>	18,
				'tax_percentage' 	=>	$tax_perce,
				'taxability' 		=> 	'Taxable',
				'opening_balance' 	=> 	$opening_balance,
				'bank_account_number' => 	$bank_account_number,
				'bank_account_holder_name' 			=> 	$bank_account_holder_name,
				'bank_iban' 			=> 	$bank_iban,
				'bank_swift' 		=> 	$bank_swift,
				'bank_name' 		=> 	$bank_name,
				'country_id' 		=> 	$country_id,
				'bank_branch' 		=> 	$bank_branch
			);

			$records=$this->crud_model->insert('ledgers',$data);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Vendor',	
				'masters_id'=>'SP'.sprintf("%'.04d",$insert_id),	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','Sorry! Something went wrong .');
				redirect('Supplier_master');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success','Vendor Details Added');
				redirect('Supplier_master');
			 }
		}
	}
	public function search_client($client_name='NIL',$telephone='NIL',$page=1) {
		$like=array();
		$or_like=array();

		if (@$this->input->post('client_name')) {
			$client_name =   $this->input->post("client_name");
		}elseif ($client_name != "NIL") {
			$client_name	=	$client_name;
		} else {
			$client_name	= "NIL";
		}
		if (@$this->input->post('telephone')) {
			$telephone =   $this->input->post("telephone");
		}elseif ($telephone != "NIL") {
			$telephone	=	$telephone;
		} else {
			$telephone	= "NIL";
		}

		if($client_name != "NIL") {
			$like=array('supplier_name'=> $client_name);
		}
		if($telephone != "NIL") {
			$or_like = array('mobile_no'=>$telephone);
		}

		$title['headerTitle']="Vendor List";
		$data['records'] = $this->crud_model->get('supplier_master', null,null, null, 'supplier_id','desc',  $like,null, $or_like);
		$data['pagination'] = NULL;

		$this->load->view('templates/header',$title);
		$this->load->view('reports/list_supplier_master',$data);
		$this->load->view('templates/footer');
	}
	function update_Invoice($client_id){
		$where=array(
				'client_id' => $client_id
		);
		$records=$this->crud_model->get('new_client_master',$where);
		if($records != false){
			$client_name = $records[0]['client_name'];
			$where=array(
				'client_id'  => $client_id
			);
			$data=array(
				'client' 		=>	$client_name,
			);
			$records=$this->crud_model->update('furniture_invoice',$data,$where);
			$this->session->set_flashdata('success','Vendor Details Updated');
			redirect('client_reports');
		} else {
			$this->session->set_flashdata('response','Try Later');
			redirect('client_reports');
		}
	}
	
	function edit($client_id) {
		$this->users_model->permission("Supplier_master", "Edit");
		$title['headerTitle']="Vendor Edit";
		$where=array(
				'supplier_id' => $client_id
		);
		$records=$this->crud_model->get('supplier_master',$where);
		if($records != false){
			//true section
			$data['client_id']		 	 = $records[0]['supplier_id'];
			$data['client_name']		 = $records[0]['supplier_name'];
			$data['client_address']		 = $records[0]['address'];
			$data['client_telephone1']	 = $records[0]['mobile_no'];
			$data['contact_person']		 = $records[0]['contact_person'];
			$data['status']		 		 = $records[0]['status'];
			$data['client_telephone2']	 = $records[0]['supplier_telephone2'];
			$data['client_fax']			 = $records[0]['supplier_fax'];
			$data['client_email']		 = $records[0]['supplier_email'];
			$data['tax_name']			 = $records[0]['tax_name'];
			$data['tax_no']		 		 = $records[0]['tax_no'];
			$data['tax_perce']		 	 = $records[0]['tax_perce'];
			$data['is_credit']		     = $records[0]['is_credit'];
			$data['credit_limit']		 = $records[0]['credit_limit'];
			$data['credit_days']		 = $records[0]['credit_days'];
			$data['supplier_code']		 = $records[0]['supplier_code'];
			$data['country_id']	   		 = $records[0]['country_id'];
			$data['cr_no']	  		  = $records[0]['cr_no'];

			$where2=array(
				'ledger_code' => $records[0]['supplier_code']
			);
			$legder_records=$this->crud_model->get('ledgers',$where2);
			if($legder_records != false){
				$data['bank_account_number']	  = $legder_records[0]['bank_account_number'];
				$data['bank_account_holder_name'] = $legder_records[0]['bank_account_holder_name'];
				$data['bank_iban']		 	      = $legder_records[0]['bank_iban'];
				$data['bank_swift']		 	      = $legder_records[0]['bank_swift'];
				$data['bank_name']		 	 	  = $legder_records[0]['bank_name'];
				$data['bank_branch']		 	  = $legder_records[0]['bank_branch'];
				$data['opening_balance']		  = $legder_records[0]['opening_balance'];
			} else {
				$data['bank_account_number']	  = NULL;
				$data['bank_account_holder_name'] = NULL;
				$data['bank_iban']		 	      = NULL;
				$data['bank_swift']		 	      = NULL;
				$data['bank_name']		 	      = NULL;
				$data['bank_branch']		 	  = NULL;
				$data['opening_balance']		  = NULL;
			}		

			$data['user_status'] = $this->config->item('user_status_array');

			$date=date("Y-m-d");
			$data['vat_applicable']=$this->furniture_quotation_model->vat_applicable($date);
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
				
			$where3=array(
				'supplier_code' => $records[0]['supplier_code'],
				'trn_type' 		=> 'Opening',
			);
			$data['supplier_bill_allocations_records']=$this->crud_model->get('supplier_bill_allocations',$where3);

			$cd_query = $this->db->get('company_division');
			if ($cd_query->num_rows() > 1) {
				$list = $this->crud_model->get_list('division_id','division_name','company_division',array());
				$data['division_list'] = $list;
				$data['division_count'] = true;
			} else {
				$data['division_id'] = $cd_query->row()->division_id;
				$data['division_count'] = false;
			}

			$list3 = $this->crud_model->get_list2('id','Country','country_master',array(),array('status'=>1));
			$data['country_master_list'] = $list3;

			$this->load->view('templates/header',$title);
			$this->load->view('reports/edit_supplier_master',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','Error');
			redirect('Supplier_master');
		}
	}
	
	function do_update() {
		$this->users_model->permission("Supplier_master","Edit");
		$title['headerTitle']="Vendor Edit";
		
		$client_id  		=   $this->input->post('client_id');
		$where		=   array("supplier_id"=>$client_id);
		$records	=	$this->crud_model->get('supplier_master', $where);

		if($records != false){
			if($records[0]['supplier_name'] != $this->input->post('client_name')){
				$this->form_validation->set_rules('client_name', 'Vendor', 'trim|required|max_length[100]|is_unique[supplier_master.supplier_name]');
			} else {
				$this->form_validation->set_rules('client_name', 'Vendor', 'trim|required|max_length[100]');
			}
			$this->form_validation->set_rules('client_telephone1', 'Mobile', 'required|numeric|max_length[20]');
			$this->form_validation->set_rules('contact_person', 'Contact Person', 'required|max_length[100]');
			
			
			$client_name  		=   trim($this->input->post('client_name'));
			$client_address  	=   trim($this->input->post('client_address'));
			$client_telephone1  =   $this->input->post('client_telephone1');
			$client_telephone2  =   $this->input->post('client_telephone2');
			$client_fax  		=   $this->input->post('client_fax');
			$client_email  		=   $this->input->post('client_email');
			$contact_person  	=   $this->input->post('contact_person');
			$tax_name  			=   $this->input->post('tax_name');
			$tax_no  			=   $this->input->post('tax_no');
			$country_id  		=   $this->input->post('country_id');
			if(@$this->input->post('is_credit')==1){
				$is_credit  		=   $this->input->post('is_credit');
			} else {
				$is_credit  		=0;
			}
			
			$credit_limit  	=   $this->input->post('credit_limit');
			$credit_days  			=   $this->input->post('credit_days');
			$tax_perce  			=   $this->input->post('tax_perce');
			$cr_no   = $this->input->post('cr_no');
			$status = ascii_to_entities($this->input->post('status'));

			if ($this->form_validation->run() == FALSE) {
				
				$data['client_id']		 	 = $records[0]['supplier_id'];
				$data['client_name']		 = $records[0]['supplier_name'];
				$data['client_address']		 = $records[0]['address'];
				$data['client_telephone1']	 = $records[0]['mobile_no'];
				$data['contact_person']		 = $records[0]['contact_person'];
				$data['status']		 		 = $records[0]['status'];
				$data['client_telephone2']	 = $records[0]['supplier_telephone2'];
				$data['client_fax']			 = $records[0]['supplier_fax'];
				$data['client_email']		 = $records[0]['supplier_email'];
				$data['tax_name']			 = $records[0]['tax_name'];
				$data['tax_no']		 		 = $records[0]['tax_no'];
				$data['tax_perce']		 	 = $records[0]['tax_perce'];
				$data['is_credit']		     = $records[0]['is_credit'];
				$data['credit_limit']		 = $records[0]['credit_limit'];
				$data['credit_days']		 = $records[0]['credit_days'];
				$data['supplier_code']		 = $records[0]['supplier_code'];
				$data['country_id']	   		 = $records[0]['country_id'];
				$data['cr_no']	  		  = $records[0]['cr_no'];
	
				$where2=array(
					'ledger_code' => $records[0]['supplier_code']
				);
				$legder_records=$this->crud_model->get('ledgers',$where2);
				if($legder_records != false){
					$data['bank_account_number']	  = $legder_records[0]['bank_account_number'];
					$data['bank_account_holder_name'] = $legder_records[0]['bank_account_holder_name'];
					$data['bank_iban']		 	      = $legder_records[0]['bank_iban'];
					$data['bank_swift']		 	      = $legder_records[0]['bank_swift'];
					$data['bank_name']		 	 	  = $legder_records[0]['bank_name'];
					$data['bank_branch']		 	  = $legder_records[0]['bank_branch'];
					$data['opening_balance']		  = $legder_records[0]['opening_balance'];
				} else {
					$data['bank_account_number']	  = NULL;
					$data['bank_account_holder_name'] = NULL;
					$data['bank_iban']		 	      = NULL;
					$data['bank_swift']		 	      = NULL;
					$data['bank_name']		 	      = NULL;
					$data['bank_branch']		 	  = NULL;
					$data['opening_balance']		  = NULL;
				}		
	
				$data['user_status'] = $this->config->item('user_status_array');
	
				$date=date("Y-m-d");
				$data['vat_applicable']=$this->furniture_quotation_model->vat_applicable($date);
				$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
				
				$where3=array(
					'supplier_code' => $records[0]['supplier_code'],
					'trn_type' 		=> 'Opening',
				);
				$data['supplier_bill_allocations_records']=$this->crud_model->get('supplier_bill_allocations',$where3);

				$cd_query = $this->db->get('company_division');
				if ($cd_query->num_rows() > 1) {
					$list = $this->crud_model->get_list('division_id','division_name','company_division',array());
					$data['division_list'] = $list;
					$data['division_count'] = true;
				} else {
					$data['division_id'] = $cd_query->row()->division_id;
					$data['division_count'] = false;
				}
				
				$list3 = $this->crud_model->get_list2('id','Country','country_master',array(),array('status'=>1));
				$data['country_master_list'] = $list3;

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('reports/edit_supplier_master',$data);
				$this->load->view('templates/footer');
			} else {

				$this->db->trans_begin();

				$where=array(
					'supplier_id'  => $client_id
				);
				$data=array(
					'supplier_name'  =>	$client_name,
					'address' 		 =>	$client_address,
					'mobile_no' 	 =>	$client_telephone1,
					'contact_person' => $contact_person,
					'supplier_telephone2' =>	$client_telephone2,
					'supplier_fax' 		=> 	$client_fax,
					'supplier_email' 	=> 	$client_email,
					'tax_name' 			=> 	$tax_name,
					'tax_no' 			=> 	$tax_no,
					'is_credit' 		=> 	$is_credit,
					'credit_limit' 		=> 	$credit_limit,
					'credit_days' 		=> 	$credit_days,
					'tax_perce' 		=> 	$tax_perce,
					'country_id' 		=> 	$country_id,
					'status' 		 	=> $status,
					'cr_no' 			=> 	$cr_no,
				);

				$records=$this->crud_model->update('supplier_master',$data,$where);
				$insid  = $this->input->post('client_code');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vendor',	
					'masters_id'=>$insid,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);

				$bank_account_number 	   = $this->input->post('bank_account_number');
				$bank_account_holder_name  = $this->input->post('bank_account_holder_name');
				$bank_iban    = $this->input->post('bank_iban');
				$bank_swift    = $this->input->post('bank_swift');
				$bank_name = $this->input->post('bank_name');
				$bank_branch  = $this->input->post('bank_branch');
				$client_code  = $this->input->post('client_code');
				$opening_balance  = $this->input->post('opening_balance');

				$led_data=array(
					'ledger_code'  		=> $client_code,
					'ledger_name' 		=>	$client_name,
					'tax_percentage' 	=>	$tax_perce,
					'acoount_group_id'  =>	18,
					'taxability' 		=> 	'Taxable',
					'bank_account_number' => 	$bank_account_number,
					'bank_account_holder_name' 			=> 	$bank_account_holder_name,
					'bank_iban' 			=> 	$bank_iban,
					'bank_swift' 		=> 	$bank_swift,
					'bank_name' 		=> 	$bank_name,
					'country_id' 		=> 	$country_id,
					'bank_branch' 		=> 	$bank_branch
				);

				$this->db->where('ledger_code', $client_code);
				$query = $this->db->get('ledgers');
				if ($query->num_rows() > 0) {
					$where2=array(
						'ledger_code'  => $client_code
					);
					$this->crud_model->update('ledgers',$led_data,$where2);
				} else {
					$this->crud_model->insert('ledgers',$led_data);
				}

				$cus_bill_id	  = $this->input->post('cus_bill_id');

				$bill_no	  = $this->input->post('bill_no');
				$bill_date	  = $this->input->post('bill_date');
				$bill_amount  = $this->input->post('bill_amount');
				$os_amount	  = $this->input->post('os_amount');
				$bill_type	  = $this->input->post('bill_type');
				$division_id  = $this->input->post('division_id');
				$opening_total = 0;
		
				$where3=array(
					'supplier_code' =>  $client_code,
					'trn_type' 		=> 'Opening',
				);

				$this->crud_model->delete('supplier_bill_allocations',$where3);

				for($i=0; $i<count($bill_no); $i++){
					if($bill_no[$i]!=='' and $bill_date[$i]!=='' and $bill_amount[$i]!=='' and $os_amount[$i]!=='' and $bill_type[$i]!==''){
						$opening_total = $opening_total+($os_amount[$i]*-1);
						if($cus_bill_id[$i]!==''){
							$cus_b_id=	$cus_bill_id[$i];
						} else {
							$cus_b_id=	NULL;
						}
						$data_array = array(
							'id' 			=> $cus_b_id,
							'supplier_code' => $client_code,
							'bill_id' 		=> 'OP'.$bill_no[$i],
							'trn_no' 		=> 'OP'.$bill_no[$i],
							'bill_date'		=> date("Y-m-d", strtotime($bill_date[$i])),
							'bill_amt' 		=> $bill_amount[$i]*-1,
							'bill_os_amount'=> $os_amount[$i]*-1,
							'bill_type' 	=> $bill_type[$i],
							'trn_type' 	  	=> 'Opening',
							'division_id' 	=> $division_id[$i],
							'status'        => 1
						);
						$this->db->insert('supplier_bill_allocations', $data_array);
	 		 		}
				}

				$op_data=array(
					'opening_balance' 	=> 	$opening_total
				);
				$this->crud_model->update('ledgers',$op_data,$where2);
				
				$where4=array(
					'ledger_code'=>  $client_code,
					'vch_no' 	=>  0,
					'vch_type'  => 'Opening',
				);
				$this->crud_model->delete('accounts',$where4);
				
				if($opening_total!=0 && $opening_total!=''){
					$books_beginning_date  = $this->furniture_quotation_model->books_beginning_date_config();
					$accounts_data = array(
						'vch_type' 	  => 'OPENING',
						'vch_no'  	  => 0,
						'vch_date'    => $books_beginning_date,
						'vch_ref'     => '',
						'ledger_code' => $client_code,
						'rev_ledger_code' => NULL,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'=> (float)$opening_total,
						'ledger_narration'=> 'Opening Balance',
						'vch_narration'=> 'Opening Balance',
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}
				
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response','Sorry! Something went wrong .');
					redirect('Supplier_master/edit/'.$client_id);
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success','Vendor Details Updated');
					redirect('Supplier_master/edit/'.$client_id);
				}
			}
		} else {
			$this->session->set_flashdata('response','Error');
			redirect('Supplier_master');
		}

	}
}
?>