<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Materials_issue extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
	}

	public function index() {
		
		
	}
	
	public function printMI($quotation_id,$type,$print_status=''){
		$rs = $this->db->query("SELECT * FROM `material_issue_h` DN INNER JOIN job_card JC ON JC.id=DN.job_id INNER JOIN `new_client_master` NCM ON NCM.`client_id`=JC.`client_id` WHERE DN.`mi_id`='$quotation_id';");
		$records['nbrcdrs'] =$rs->result_array();	
		
		$records['furniture_itemlist'] = $this->crud_model->get('material_issue_b', array('material_issue_b.mi_id'=>$quotation_id), null, null, "mi_id", "ASC", null, null, null, null);
		
		if($records == false) {
			$this->session->set_flashdata('response','error');
			redirect("jobcard/Materials_issue/material_issue_list");
		}
		
		$query = $this->db->get('company_details');  
		$records['company_details'] = $query->row();
		$records['print_status'] = $print_status;
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			//$this->load->helper(array('dompdf', 'file'));
			//$html = $this->load->view('general/quotations/printview4', $records, true);
			//pdf_create($html, 'Invoice_No_'.$records['division_code'].'-'.$records['invoice_number']);
			$mpdf = new \Mpdf\Mpdf();
			$datas   =   array("records" => $records,"nbrcdrs" => $rs->result_array(),"furniture_items" => $rs2->result_array(),'print_type'=>'pdf_print_type');
			$html = $this->load->view('general/quotations/printpdfdeliverynote', $datas , true);
			$mpdf->WriteHTML($html);
			$mpdf->Output();
		} else if($type=="normal"){
			$records['print_type'] = "normal_print_type";
			$this->load->view('general/quotations/printmaterialissue', $records);
		
		}
		 //if you want to write it to disk and/or send it as an attachment  
	}

	
	
	public function edit_material_issue($purchase_id) {
		$this->users_model->permission("Material_issue", "Edit");
		$title['headerTitle']="Edit Material Issue";
		//$this->form_validation->set_rules('p_description_id[]', 'Item', 'required');
		$this->form_validation->set_rules('job_id', 'JOB', 'required');
		if ($this->form_validation->run() == FALSE){
			$data['row']        = $this->Job_card_model->materialIssueRow($purchase_id);
			$data['details']    = $this->Job_card_model->materialIssueDetails($data['row']->mi_id);
			
			$data['location_list'] = $this->Job_card_model->loc_list();

			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/edit_material_issue',$data);
			$this->load->view('templates/footer');
		} else {
	  		$user_id	=	$this->session->userdata('user_id');
		  	if($purchase_id) {
				$this->db->trans_begin();
				$data['row']        = $this->Job_card_model->materialIssueRow($purchase_id);
				$mi_id=$data['row']->mi_id;

				$mi_code=$data['row']->mi_code;

				$this->db->where("mi_id",$mi_id);
				$this->db->delete('material_issue_b');

				$this->db->where("trans_no",$mi_code);
				$this->db->where("trans_type",2);
				$this->db->delete('item_trans');

				$p_description_id	  =	$this->input->post('p_description_id');
				$p_description	    =	$this->input->post('p_description');
				$p_nbitem	          =	$this->input->post('p_nbitem');
				$p_section	        =	$this->input->post('p_section');
				$p_qty	            =	$this->input->post('p_qty');
				$p_rate	            =	$this->input->post('p_rate');
				$p_discount	        =	$this->input->post('p_discount');
				$p_vat	        	=	$this->input->post('p_vat');
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;
				$uom   				= $this->input->post('uom');
				$uom_id   			= $this->input->post('uom_id');
				for($i=0; $i<count($p_description_id); $i++) {
					if($p_description_id[$i]!=='') {
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
					
						if(@$p_section[$i] == ''){
							$p_section2 = '';
						} else {
							$p_section2 = $p_section[$i];
						}
						
						if(@$p_vat[$i] == ''){
							$vat_amt = 0;
						} else {
							$vat_amt = $p_vat[$i]/100;
						}
					
					
						$data_array = array(
							'mi_id' 	       => $mi_id,
							'item_details_id'  => $p_description_id[$i],
							'item_description' => $p_description[$i],
							'item_qty' 		   => $p_qty[$i],
							'uom' 		      => $uom[$i],
							'uom_id' 		  => $uom_id[$i],
							'loc_id' 		   => $this->input->post('loc_id'),
							'item_rate' 	   => $p_rate[$i],
							'item_disc' 	   => 0,
							'item_amount' 	   => $p_qty[$i]*$p_rate[$i],
							'item_vat_per' 	   => 0,
							'item_vat' 		   => 0,
							'net_amount' 	   => $p_qty[$i]*$p_rate[$i],
							'status'           => 1
						);
						$this->db->insert('material_issue_b', $data_array);

						$item_trans_array = array(
							'trans_no' 	  => $mi_code,
							'item_id'  	  => $p_description_id[$i],
							'trans_date'  => date("Y-m-d"),
							'trans_type'  => 2,
							'item_qty' 	  => -$p_qty[$i],
							
							'loc_id' 	  => $this->input->post('loc_id'),
							'item_rate'   => $p_rate[$i],
							'item_amount' => $p_qty[$i]*$p_rate[$i],
							'user_id' 	  => $user_id,
							'created_date'  => date("Y-m-d"),
							'status'      => 1
						);
						$this->db->insert('item_trans', $item_trans_array);

						$po_gross_amt += $p_qty[$i]*$p_rate[$i];
			 	 	}
				}
				$po_vat_amt   = 0;
				$po_net_amt   = 0;
				$update_data = array(
					'mi_gross_amt'      => $po_gross_amt,
					'mi_vat_amt'        => $po_vat_amt,
					'mi_discount'       => 0,
					'mi_net_amt'        => $po_gross_amt
				);
				$this->db->where('mi_id', $mi_id);
				$this->db->update('material_issue_h', $update_data);

				$this->db->where("vch_no",$mi_code);
				$this->db->where("vch_type",'Material Issue');
				$this->db->delete('job_allocation');

				$job_allocation_data = array(
					'vch_type'    => 'Material Issue',
					'vch_no'      => $mi_code,
					'vch_date'    => date("Y-m-d"),
					'job_id'      => $this->input->post('job_id'),
					'ledger_code' => 'MI0001',
					'ledger_amount' => round($po_gross_amt,3),
					'created_date'=> date('Y-m-d'),
					'user_id' 	  => $this->session->userdata("user_id"),
					'status'	  => 1
				);
				$this->db->insert('job_allocation', $job_allocation_data);

				$log_data=array(
					'trans_no'  	=>  $data['row']->mi_code,
					'trans_type'	=>  'Material Issue',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')
	
				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'error..!!');
					redirect("jobcard/Materials_issue/material_issue_list");
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Updated Successfully');
				  redirect("jobcard/Materials_issue/material_issue_list");
				}
		  	} else {
				$this->session->set_flashdata('response', 'error..!!');
				redirect("jobcard/Materials_issue/material_issue_list");
			}
		}
	}

	function do_insert_material_issue($job_card_id) {
		$this->users_model->permission("Material_issue", "Add");
		//$this->form_validation->set_rules('p_description_id[]', 'Item', 'required');
		$this->form_validation->set_rules('job_id', 'JOB', 'required');
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('jobcard/Materials_issue/create_material_issue/'.$job_card_id);
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$miNumber=$this->Job_card_model->miNumber($this->input->post('division'));
			$mi_code=$this->Job_card_model->get_mi_no($miNumber,$this->input->post('division'));
			$data = array( 
				'mi_number'   => $miNumber,
				'mi_code'     => $mi_code,
				'mi_date'     => date("Y-m-d"),
				'division_id' => $this->input->post('division'),
				'job_id' => $this->input->post('job_id'),
				'loc_id'      => $this->input->post('loc_id'),
				'rfq_number'  => NULL,
				'payment_mode'=> 'Cash',
				'user_id'     => $user_id,
				'status'      => 1
			);
			
			$this->db->insert('material_issue_h', $data);
			$insert_id = $this->db->insert_id();
			if($insert_id){
				$p_description_id	= $this->input->post('p_description_id');
				$p_description	    = $this->input->post('p_description');
				$p_nbitem	        = $this->input->post('p_nbitem');
				$p_section	        = $this->input->post('p_section');
				$p_qty	            = $this->input->post('p_qty');
				$p_rate	            = $this->input->post('p_rate');
				$p_discount	        = $this->input->post('p_discount');
				$p_vat	        	= $this->input->post('p_vat');
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;
				$uom   				= $this->input->post('uom');
				$uom_id   			= $this->input->post('uom_id');
				for($i=0; $i<count($p_description_id); $i++){
					if($p_description_id[$i]!==''){
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
					
						if(@$p_section[$i] == ''){
							$p_section2 = '';
						} else {
							$p_section2 = $p_section[$i];
						}
						
						if(@$p_vat[$i] == ''){
							$vat_amt = 0;
						} else {
							$vat_amt = $p_vat[$i]/100;
						}
					
					
						$data_array = array(
							'mi_id' 	      => $insert_id,
							'item_details_id' => $p_description_id[$i],
							'item_description'=> $p_description[$i],
							'item_qty' 		  => $p_qty[$i],
							'uom' 		      => $uom[$i],
							'uom_id' 		  => $uom_id[$i],
							'loc_id' 		  => $this->input->post('loc_id'),
							'item_rate' 	  => $p_rate[$i],
							'item_disc' 	  => 0,
							'item_amount' 	  => $p_qty[$i]*$p_rate[$i],
							'item_vat_per' 	  => 0,
							'item_vat' 		  => 0,
							'net_amount' 	  => $p_qty[$i]*$p_rate[$i],
							'status'          => 1
						);
						$this->db->insert('material_issue_b', $data_array);

						$item_trans_array = array(
							'trans_no' 	  => $mi_code,
							'item_id'  	  => $p_description_id[$i],
							'trans_date'  => date("Y-m-d"),
							'trans_type'  => 2,
							'item_qty' 	  => -$p_qty[$i],
							'loc_id' 	  => $this->input->post('loc_id'),
							'item_rate'   => $p_rate[$i],
							'item_amount' => $p_qty[$i]*$p_rate[$i],
							'user_id' 	  => $user_id,
							'created_date'  => date("Y-m-d"),
							'status'      => 1
						);
						$this->db->insert('item_trans', $item_trans_array);

						$po_gross_amt += $p_qty[$i]*$p_rate[$i];
						/*if($p_discount[$i]==='') {
							$po_discount  = $po_discount;
						} else {
							$po_discount  = $po_discount + $p_discount[$i];
						}*/
	 		 		}
				}		
				$po_vat_amt   = 0;
				$po_net_amt   = 0;
				$update_data = array(
					'mi_gross_amt'      => $po_gross_amt,
					'mi_vat_amt'        => $po_vat_amt,
					'mi_discount'       => 0,
					'mi_net_amt'        => $po_gross_amt
				);
				$this->db->where('mi_id', $insert_id);
				$this->db->update('material_issue_h', $update_data);

				$job_allocation_data = array(
					'vch_type'    => 'Material Issue',
					'vch_no'      => $mi_code,
					'vch_date'    => date("Y-m-d"),
					'job_id'      => $this->input->post('job_id'),
					'ledger_code' => 'MI0001',
					'ledger_amount' => round($po_gross_amt,3),
					'created_date'=> date('Y-m-d'),
					'user_id' 	  => $this->session->userdata("user_id"),
					'status'	  => 1
				);
				$this->db->insert('job_allocation', $job_allocation_data);		
			}
			$log_data=array(
				'trans_no'  	=> $mi_code,
				'trans_type'	=> 'Material Issue',
				'trans_op'  	=> 'Create',
				'trans_user_id' => $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("jobcard/Materials_issue/material_issue_list");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Material issued Successfully');
			//	redirect("jobcard/Materials_issue/edit_material_issue/".$insert_id);
				redirect("jobcard/Materials_issue/edit_material_issue/".$miNumber);
			}
		}
	}

	public function material_issue_list($fromDate	= "NIL",$toDate	= "NIL",$filter_value	= "NIL", $jobNo	= "NIL",$client_id	= "NIL"){
		$this->users_model->permission("Material_issue", "View");
		$title['headerTitle']="Material Issue";
		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}
		
		if (@$this->input->post('client_id')) {
			$client_id =   $this->input->post("client_id");
		}elseif ($client_id != "NIL") {
			$client_id	=	$client_id;
		} else {
			$client_id	= "NIL";
		}
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		if (@$this->input->post('jobNo')) {
			$jobNo =   $this->input->post("jobNo");
		}elseif ($jobNo != "NIL") {
			$jobNo	=	$jobNo;
		} else {
			$jobNo	= "NIL";
		}

		$config["base_url"] = base_url() . "index.php/jobcard/Materials_issue/material_issue_list/".$fromDate."/".$toDate."/".$filter_value."/".$jobNo."/".$client_id;
		$config["total_rows"] = $this->Job_card_model->mi_record_count($fromDate,$toDate,$filter_value,$jobNo,$client_id);
		$config['num_links'] = 15;
		$config["per_page"] = 200;
		$this->pagination->initialize($config);
		if ($this->uri->segment(8)) {
			$page = $this->uri->segment(8)*200-200;
			$i=$page+1;
		} else {
			$page = 0;
			$i=1;
		}
		//pagging end
		$list='';
		$headList='';
		$DeletePermission=$this->users_model->check_permission("Material_issue","Delete");
		$EditPermission=$this->users_model->check_permission("Material_issue","Edit");
		$cus=$this->input->post("supplier_name");
		foreach ($this->Job_card_model->miListData($config["per_page"], $page,$fromDate,$toDate,$filter_value,$jobNo,$client_id) as $row) {
			$style='';
			if($row->status==0){
				$style='style="background:#EE4B2B;"';
			}
			// <td class="title">'.$row->payment_mode.'</td>
			$list.= '<tr  class="silver-invoice" '.$style.'>
						<td>'.$i++.'</td>
						<td>'.$row->mi_code.'</td>
						<td>'.$row->client_name.'</td>
						<td>'.date('M d,Y',strtotime ($row->mi_date)).'</td>
						<td>'.$row->job_card_number.'</td>
						<td> 
						<div class="btn-group">
							<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
							Action <span class="caret"></span>
							</button>
							<ul class="dropdown-menu" role="menu">
							<li><a target="_blank"  href="'.base_url().'index.php/jobcard/Materials_issue/printMI/' . $row->mi_id . '/normal/print"><i class="fa fa-print"></i> Print</a> </li>';
							if($row->status!=0) {
								$rrr="'".$row->mi_number."','".$row->mi_code."'";
								if($EditPermission){
									$list.= '<li><a class="iframe iframe cboxElement click2" title="View Receipt" href="'.base_url().'index.php/jobcard/Materials_issue/edit_material_issue/' . $row->mi_number . '"><i class="fa fa-edit"></i> Edit</a> </li>';
								}
								if($DeletePermission){
									$list.= '<li><a href="javascript:ConfirmDelete('.$rrr.')" ><i class="fa fa-close"></i> Cancel</a> </li>';
								}
							} 
							$list.= '</ul>
						</div> </td>
					</tr>';
		}
		
		$datas   =   array("data" => $list,"fromDate" => $fromDate,"toDate" => $toDate,"filter_value" => $filter_value,"jobNo" => $jobNo,"client_id" => $client_id, "links" => $this->pagination->create_links());	
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/material_issue_list',$datas);
		$this->load->view('templates/footer');
	}



	function create_material_issue($job_card_id)	{
		$this->users_model->permission("Material_issue", "Add");
		$page=1;
		$jobcardrecords=$this->Job_card_model->get_job_card_data($job_card_id);

		$data['general_quotation'] 	= 0;
		$data['currency_code'] 		= $jobcardrecords['currency_code'];
		$data['job_card_divisionid']= $jobcardrecords['job_card_divisionid'];
		$data['job_card_number'] 	= $jobcardrecords['job_card_number'];
		$data['job_card_id']  		= $job_card_id;
		$data['quotation_number']  	= $jobcardrecords['quotation_number'];
		$data['client_name']  		= $jobcardrecords['client_name'];
		$data['client_id']  		= $jobcardrecords['client_id'];
		$data['client_telephone1']  = $jobcardrecords['client_telephone1'];
		$data['division_code'] 		= $jobcardrecords['division_code'];
		$quotation_id				= $job_card_id;
		$data['mode']				= 'new';

		$data['location_list'] = $this->Job_card_model->loc_list();

		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/jobcard/create_material_issue_view',$data);
		$this->load->view('templates/footer');
	}

	public function search_items_by_location() {
		$item	=	$this->input->post('item');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$loc_id	=	$this->input->post('loc_id');
	
		$query3 = $this->db->query("SELECT * FROM `items`  WHERE `item_name` like '%$item%' limit 10");
		$itemList_date	=	$query3->result_array();
		$itemList='';
		
		$query4 = $this->db->query("SELECT * FROM `unit_master`  WHERE `status` = 1");
		$unit_list = $query4->result_array();
		$UnitmasterArray = array_column($unit_list , 'unit_name' , 'unit_id' );

		foreach($itemList_date as $itemList_datas){
			$item_rate=0;
			$id=$itemList_datas['id'];
			$query5 = $this->db->query("SELECT item_rate FROM `item_trans` WHERE `loc_id` = '$loc_id' and `item_id` = '$id' and `trans_type`=1 ORDER BY `item_trans_id` DESC LIMIT 1");
			if($query5->num_rows() > 0){
				$item_rate = $query5->row()->item_rate;
			}
			if($item_rate==0){
				$query6 = $this->db->query("SELECT item_rate FROM `item_trans` WHERE `loc_id` != '$loc_id' and `item_id` = '$id' and `trans_type`=1 ORDER BY `item_trans_id` DESC LIMIT 1");
				if($query6->num_rows() > 0){
					$item_rate = $query6->row()->item_rate;
				}
			}
			if($item_rate==0){
				$item_rate =$itemList_datas['cost_price'];
			}

			if(isset($itemList_datas['uom_id']) && isset($UnitmasterArray[$itemList_datas['uom_id']])){
				$unit_bom_name = $UnitmasterArray[$itemList_datas['uom_id']];
			}
			else{
				$unit_bom_name  = '';
			}
			
			 if($itemList_datas['conversion'] <= 1 )
			 {	
				$data_uom = $itemList_datas['unit'];
				$data_uom_id = $itemList_datas['unit_id'];

			 }
			 else{
				$data_uom = $unit_bom_name;
				$data_uom_id = $itemList_datas['uom_id'];
			 }
			$html.='<li class="search_item_list p_description_button"  data-uom="'.$data_uom .'" data-uom-id="'.$data_uom_id.'" data-rate="'.$itemList_datas['selling_price'].'"  data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" data-item_cost="'.$item_rate.'" data-item_details_id="'.$itemList_datas['id'].'" item_tax_rate="5">'.$itemList_datas['item_name'].'</li>';
		}
		if(count($itemList_date)==0){
			$html.='<li>No data found</li>';
		}
		print $html;
	}	

	public function material_issue_delete($id,$mi_code){
		$this->users_model->permission("Material_issue", "Delete");
		$update_data = array(
			'status'      => 0,
		);
		$this->db->where('mi_number', $id);
		$this->db->update('material_issue_h', $update_data);

		$this->db->where('trans_no', $mi_code);
		$this->db->where('trans_type', 2);
		$this->db->update('item_trans', $update_data);

		// $this->db->where('vch_no', $mi_code);
		// $this->db->where('vch_type', 'Material Issue');
		// $this->db->update('item_trans', $update_data);

		$log_data=array(
			'trans_no'  	=>  $mi_code,
			'trans_type'	=>  'Material Issue',
			'trans_op'  	=>  'Delete',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

		$this->session->set_flashdata('response', 'Cancelled...');
		redirect('jobcard/Materials_issue/material_issue_list');
	}
}
?>