<?php
class Vehicle_jobcard extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
		$this->load->model('crud_model');
	}
	public function index($status=''){
		$this->users_model->permission("Job_card", "View");
		$title['headerTitle']="Vehicle Job Card";
    	$data['vjobcardcount'] = $this->Vehicle->getVjobcardcountarea();
 		$data['vjobcard'] = $this->Vehicle->getVjobcard($status);
		//$vehicle_desc = array('v_desc' => ' ', 'jb_id' => ' ');
		// if(!empty($data['vjobcard'])){
		// 	foreach($data['vjobcardcount'] as $rec){
		// 		$jobcarddesc = $this->Vehicle->getVjobcarddesc($rec['id']);
		// 		if($jobcarddesc != false && !empty($jobcarddesc)){
		// 			$vehicle_desc['v_desc'] = $jobcarddesc->furniture_model;
		// 			$vehicle_desc['jb_id']  = $rec['id'];
		// 		}
		// 		else{
		// 			$vehicle_desc['v_desc'] = '';
		// 			$vehicle_desc['jb_id']  = '';
		// 		}
		// 		$data['vehicle_desc'][] = $vehicle_desc;
		// 	}
		// }	
		$data['vehicle_desc']= $this->Vehicle->getVjobcarddesc( );
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['registration']  = $this->Vehicle->getRegistration();			
			
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function create_jobcard(){
		if(get_cookie('division_val_id')!=false){ 			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$division_id = $this->session->userdata('user_division');
		if(!empty($data['h_division_id'])){
			$data['h_division_id'] = $data['h_division_id'];
		}
		else{
			$data['h_division_id'] = $division_id ;
		}		
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Create Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$data['make']    = $this->Vehicle->getMake();
		$data['staff']   = $this->Vehicle->getServiceStaff();
		$data['advisor'] = $this->Vehicle->getAdvisorStaff();
		$data['jb_num']  =  $this->crud_model->get_job_no($division_id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$data['v_category'] = $this->Vehicle->getv_category();
 		$this->load->view('furniture/quotations/jobcard/create_jobcard',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("Job_card", "Add");
		$division_id = $this->session->userdata('user_division');
		$reg_no_id = $this->input->post('reg_no');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$data['v_category'] = $this->Vehicle->getv_category();
		$is_chassi = $this->crud_model->is_chassi_number();
		$data['jb_num']  =  $this->crud_model->get_job_no($division_id);
		$cookie_division_val = array(
			'name'   => 'division_val_id',
			'value'  => $this->input->post('division_id'),
			'expire' => 60*60*24*60
		);
		$this->input->set_cookie($cookie_division_val);		
		if(get_cookie('division_val_id')!=false){ 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}		 
		$config = array(		 
			array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
				array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                 )
			),
			array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
	   		),
			// array(
			// 'field' => 'contact_name',
			// 'label' => 'Contact Name',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Enter %s.'
			// )
	   		// ),array(
			// 'field' => 'contact_num',
			// 'label' => 'Contact Number',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Enter %s.'
			// )
	   		//),
			array(
			'field' => 'km_in',
			'label' => 'Kilometer IN',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'job_card_number',
			'label' => 'Job Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select a division to add %s.'
			)
	   		),array(
			'field' => 'job_date',
			'label' => 'Date',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		),array(
			'field' => 'fuel_level',
			'label' => 'Fuel Level',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		), 
		);	
		if($this->input->post('reg_val') == 1 || empty($this->input->post('reg_val'))){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			);
			// $config[] = array(
			// 		'field' => 'chassi_number',
			// 		'label' => 'Chassi Number',
			// 		'rules' => 'trim|required',
			// 		'errors' => array(
			// 			'required'      => 'Please Enter %s.',
			// 		)
			// 	);
			
		}
		if($this->input->post('reg_val') == 0 || empty($this->input->post('reg_val'))  ){
			if($reg_no_id != '')
			{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					'errors' => array(
						'is_unique'      => '%s  is Already Exists..'
					)
				);
			}
			else{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			}
			if(isset($is_chassi) && $is_chassi == 0){
				if(!empty($this->input->post('chassi_number'))){
					$config[] = array(
						'field' => 'chassi_number',
						'label' => 'Chassi Number',
						'rules' => 'trim|callback_is_unique[chassi_number]',	
					); 
				}
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)	
				); 		
			}		
		}
		if($data['company_config']->is_advisor == 1){
			$config[] = array(
				'field' => 'advisor',
				'label' => 'Advisor',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Add %s.',
				)
			);
		}

		//'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
        $this->form_validation->set_rules($config);
		$model_id = $this->input->post('model');
		$Client_Id = $this->input->post('client_id');
		$contact_name = $this->input->post('contact_name');
	

		if ($this->form_validation->run() == FALSE){

			if(!empty(get_cookie('division_val_id'))){
				$data['h_division_id'] = get_cookie('division_val_id');
			}
			else{
				$data['h_division_id'] = $division_id ;
			}
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['fuel_level']     =  set_value('fuel_level');
			$data['model']    =  $this->Vehicle->getJBCModel($model_id);			
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   =  set_value('client');
			//$data['h_division_id']  = get_cookie('division_val_id'); 
			//$data['contact_name']   =  set_value('contact_name');
			//$data['contact_num']    =  set_value('contact_num');
			$data['km_in']            =  set_value('km_in');
			$data['next_km']          =  set_value('next_km');
			$data['job_card_number']  =  set_value('job_card_number');
			$data['job_date']   =  set_value('job_date');
		 
			$data['car_year']   =  set_value('car_year');
			$data['car_color']  =  set_value('car_color');
			$data['contact_num_2']  =  set_value('contact_num_2');
			$data['contact']  =  set_value('contact');
			$data['contact_name']  =  set_value('contact_name');
			$data['contact_id']    =  set_value('contact_id');
			$data['contact_num']   =  set_value('contact_num');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$data['reg_val'] 	  = $this->input->post('reg_val');
			$title['headerTitle'] ="Vehicle Job Card";
			$this->load->view('templates/header',$title);
			$data['make']     = $this->Vehicle->getMake();
			$data['staff']    = $this->Vehicle->getServiceStaff();
			$data['advisor']  = $this->Vehicle->getAdvisorStaff();
			$data['selected_contact'] = $this->Vehicle->get_ContactDetails($Client_Id,$contact_name);
			$this->load->view('furniture/quotations/jobcard/create_Vjobcard',$data);
			$this->load->view('templates/footer');
		}
		else{
			$division_id = $this->input->post('division_id');
			$job_card_number  = $this->crud_model->get_job_no($division_id);
			$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
			$contact_name = $this->input->post('contact_name');
			$con_num = $this->input->post('contact_num');
			$client_id = $this->input->post('client_id');
			$contact_id = $this->input->post('contact_id');
			// if(!empty($contact_name) && !empty($con_num ) ){
			// 	$cnt_cntact = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id' AND Contact_Name LIke '%$contact_name%' AND Contact_Tel = $con_num ");
			// 	if($cnt_cntact->num_rows() > 0){
			// 		$contact_id = $cnt_cntact->row()->Contact_Id;
			// 	}else{
			// 		$contact_id = $this->input->post('contact_id');
			// 	}
			// }
			// else{
			// 	$contact_id = $this->input->post('contact_id');
			// }
				if($this->input->post('reg_val') == 0  || $this->input->post('reg_val') == "" ){
					$data = array(
						'reg_no'	 =>	$this->input->post('reg_no'),
						'make_id' => $this->input->post('make'),
						'model_id' => $this->input->post('model'),
						'client_id' => $this->input->post('client_id'),
						'client_mobile_no' =>  $this->input->post('contact_num_2'),				 
						'car_year' => $this->input->post('car_year'),
						'car_color' => $this->input->post('car_color'),
						'chassi_number' => $this->input->post('chassi_number'),
					);
					$this->crud_model->insert('reg_no_table',$data);
 				}

			$data = array(
				'job_card_number' => $job_card_number,
				'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
				'client_id' => $this->input->post('client_id'),
				'divisionid' => $division_id,
				'created_user_id' => $this->session->userdata('user_id'),
				'reg_no' =>  $this->input->post('reg_no'),
				'make' =>  $this->input->post('make'),
				'model' =>  $this->input->post('model'),
				'chassi_number' =>  $this->input->post('chassi_number'),
				'car_year' =>  $this->input->post('car_year'),
				'car_color' =>  $this->input->post('car_color'),
				'contact_id' => $contact_id,
				'contact_name' => $contact_name,
				'contact_num' =>  $this->input->post('contact_num'),
				'km_in' =>  $this->input->post('km_in'),
				'next_km' =>  $this->input->post('next_km'),
				'fuel_level' =>  $this->input->post('fuel_level'),
				'is_insurance' =>  $is_insurance,
				'salesman_id' =>  $this->input->post('advisor'),
				'job_card_status' =>  'Draft',
				'job_card_total' =>  $this->input->post('job_card_total'),
				'job_card_vat_perc' =>  10,
				'job_card_vat_amount' =>  $this->input->post('jbcdvat_amount'),
				'job_card_amount_with_vat' =>  $this->input->post('job_card_amount_with_vat'),
				'vtype_id'   =>  $this->input->post('v_type'),
				'contact_person2' => $this->input->post('contact_num_2'),
			);
			$res = $this->crud_model->insert('job_card',$data);
			$insert_id = $this->db->insert_id();
			if($res != ''){
				$item_id = $this->input->post('item_id');
				$furniture_model = $this->input->post('item');
				$furniture_description =$this->input->post('desc');
				$vat_perce =($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$vat_amount =$this->input->post('item_vat_amount');
				$item_discount =$this->input->post('item_discount');
				$net_amount =$this->input->post('item_net_amount');
				$section_id =$this->input->post('section_id');
				$technician_id =$this->input->post('technician_id');
				$furniture_quantity =$this->input->post('item_qty');
				$furniture_unitprice =$this->input->post('item_rate');
				$furniture_amount =$this->input->post('item_amount');
				$item_uom =$this->input->post('item_uom');
				$item_uom_id =$this->input->post('item_uom_id');
				$sl = 1;
				if(!empty($item_id)){	
					for($i = 0; $i < count($item_id);$i++ ){
						$data  = array(
							'job_card_id' => $insert_id,
							'sl_no' => $sl++,
							'item_id' => $item_id[$i],
							'furniture_model' =>$furniture_model[$i],
							'furniture_description' =>$furniture_description[$i],
							'furniture_unitprice' =>$furniture_unitprice[$i],
							'furniture_quantity' =>$furniture_quantity[$i],
							'furniture_amount' =>$furniture_amount[$i],
							'uom'	    =>$item_uom[$i],
							'uom_id'    =>$item_uom_id[$i],
							'vat_perce' =>$vat_perce[$i],
							'vat_amount' =>$vat_amount[$i],
							'item_discount' =>$item_discount[$i],
							'net_amount' =>$net_amount[$i],
							'jb_type' =>1,
							'section_id' =>$section_id[$i],
							'technician_id' =>$technician_id[$i],
						);
						$this->Vehicle->insertjobcarddetail($data);
					}
				}
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				if($this->input->post('reg_val') != 0 ){
					$where_reg = array(
 						'v_type'    => $this->input->post('v_type'),
						 'reg_no LIKE'  => '%'.$this->input->post('reg_no').'%',
					);
					$data_reg = array(
						'client_mobile_no' =>  $this->input->post('contact_num_2'),				 
					);
					$this->crud_model->update('reg_no_table',$data_reg,$where_reg);
				}
				$data= array(						
					'masters_type'=>'Vehicle Job Card',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Job Card Created');
					
			}
			else{
					$this->session->set_flashdata('response', 'Something WentWrong');					 
					redirect('jobcard/Vehicle_jobcard/create_jobcard');					 
				}
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$insert_id.'');
		}
	}


	// Callback function for is_unique validation
public function is_unique($str) {
    $this->db->where('chassi_number', $str);
    $query = $this->db->get('reg_no_table');
    if ($query->num_rows() > 0) {
		$row_detail =  $query->row();
        $this->form_validation->set_message('is_unique', '%s already exists for Vehicle Reg : '.$row_detail->reg_no.'.');
        return FALSE;
    } else {
        return TRUE;
    }
}


	public function add_contact( ) {   ///////changed due to customer request 08/10//2024 not using
		//if($Contact_Id!='' && $Client_Id!=''){
			$Client_Id  	   = $this->input->post('client_id');
			$client_Contact_Name  	   = $this->input->post('client_Contact_Name');
			$client_Contact_Tel  	   = $this->input->post('client_Contact_Tel');
			$client_Contact_designation= $this->input->post('client_Contact_designation');
			$client_Contact_Email  	   = $this->input->post('client_Contact_Email');
			$client_Contact_Address    = $this->input->post('client_Contact_Address');
			$msg = array('message' => '', 'html' => '');
			if($client_Contact_Name!==''){
				if($client_Contact_Tel!==''){
					$data=array(
						'Client_Id'   => $Client_Id,
						'Contact_Name'   => $client_Contact_Name,
						'Contact_Tel' 	 =>	$client_Contact_Tel,
						'designation' 	 =>	$client_Contact_designation,
						'Contact_Email'  =>	$client_Contact_Email,
						'Contact_Address'=>	$client_Contact_Address,
						'Creation_date' =>  date("Y-m-d H:i:s"),
					);
					$records=$this->crud_model->insert('client_contact',$data);

					//$get_contact = $this->Vehicle->get_ContactDetails_only($Client_Id); 
					//if($records=== true){
							$get_contact = $this->Vehicle->get_ContactDetails_only_new($Client_Id); 
							$html= '';
							if(!empty($get_contact)){
								$contact_id    = $get_contact->Contact_Id;
								$contact_name  = $get_contact->Contact_Name;
								$Contact_num   = $get_contact->Contact_Tel;

								// $html  = "<option value=''>Select Contact Person</option>";
								// foreach($get_contact AS $rec){
								// 	$html .= "<option data-cnt-id='".$rec['Contact_Id']."' value='".$rec['Contact_Name']." - ".$rec['Contact_Id']."'>".$rec['Contact_Name']."</option>";
								// }
								$html =  array('1',$contact_id,$contact_name,$Contact_num);

							}
							else{
								//$html .= "<option value=''>No Data Found</option>";
								$html =  array('0','');
							}
				//	}
					$msg['html'] = $html;
					$msg['message'] = 'success';					 				
 
				} else {
					$msg['message'] = 'error';					 	
 
				}
			} else {
				$msg['message']  = 'error';
				
			}
			echo json_encode($msg); 
	}


	public function editVjobcard($id = ''){
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();	
		$data['customer'] = $this->Vehicle->getCustomer();	
		$data['staff']    = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['technician']  = $this->Vehicle->getServiceStaff();
		$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($id);
		$data['model']    = $this->Vehicle->getregisterModel($data['vjobcard']->make);
		$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($id);
		$Client_Id = $data['vjobcard']->client_id;
		$division_id =  $this->Vehicle->getVjobcard_division($id);
		$data['material_details'] = $this->Vehicle->getPurchaseMaterial_job($id,$division_id);
		$data['material_issue']   = $this->Vehicle->getMaterialIssue_job($id,$division_id);
		$data['ContactDetails']   = $this->Vehicle->get_ContactDetails_only($Client_Id);
		$data['jobtype_spare']	  = $this->Vehicle->Chkjobtype_spare($id);
		$data['jobtype_labour']	  = $this->Vehicle->Chkjobtype_labour($id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$data['Unitmasterdata']   = $this->Vehicle->getUnitmasterdata();
		$data['vehicle_discount_limit']  = $this->crud_model->getVehicle_section_DiscountLimit($id);
		$data['select_discount_person']  = $this->Vehicle->getLabourDiscountAdvisor();
		$data['v_category'] = $this->Vehicle->getv_category();
		$this->load->view('furniture/quotations/jobcard/edit_Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		 
		$this->users_model->permission("Job_card", "Edit");
		$job_card_id = $this->input->post('job_card_id');
		$reg_no_id   = $this->input->post('reg_no_id');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$config = array(		 
			// array(
            //         'field' => 'make',
            //         'label' => 'Make',
            //         'rules' => 'rtrim|required',
            //         'errors' => array(
            //             'required'      => 'Please Select %s.'
            //         )
            // ),
			// array(
            //         'field' => 'model',
            //         'label' => 'Model',
            //         'rules' => 'trim|required',
            //         'errors' => array(
            //             'required'      => 'Please Select %s.'
            //         )
			// ),
		  array(
			'field' => 'client',
			'label' => 'Customer Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),
			// array(
			// 'field' => 'contact_name',
			// 'label' => 'Contact Name',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Enter %s.'
			// )
	   		// ),array(
			// 'field' => 'contact_num',
			// 'label' => 'Contact Number',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Enter %s.'
			// )
	   		// ),
			array(
			'field' => 'km_in',
			'label' => 'Kilometer IN',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'job_card_number',
			'label' => 'Job Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select a division to add %s.'
			)
	   		),array(
			'field' => 'job_date',
			'label' => 'Date',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		),//array(
			// 'field' => 'advisor',
			// 'label' => 'Advisor',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please select %s.'
			// )
	   		// ),array(
			// 'field' => 'item[]',
			// 'label' => 'Labour Charges',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Add %s For Create Job Card.'
			// )
	   		// ),
		);	
	
		if($this->input->post('reg_val') == 2 || empty($this->input->post('reg_val'))){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			);	
		}
		if($this->input->post('reg_val') == 0  ){
			if($reg_no_id != '')
			{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'This Registration Number',
					'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					'errors' => array(
						'is_unique'      => '%s  is Already Exists..'
					)
				);
			}
			else{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			}
			$config[] = array(
				'field' => 'chassi_number',
				'label' => 'Chassi Number',
				'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
				'errors' => array(
					'is_unique'      => '%s already exists.'
				)
			); 
				
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){			
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['fuel_level']   =  set_value('fuel_level');
			$data['model']    =  set_value('model');			
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   =  set_value('client');
			$data['contact_name']  =  set_value('contact_name');
			$data['km_in']  =  set_value('km_in');
			$data['job_card_number']  =  set_value('job_card_number');
			$data['job_date']   =  set_value('job_date');
			$data['advisor']    =  set_value('advisor');
			$data['contact_num_2']  =  set_value('contact_num_2');
			$data['contact']  =  set_value('contact');
			$data['contact_name']  =  set_value('contact_name');
			$data['contact_id']  =  set_value('contact_id');
			$data['contact_num']  =  set_value('contact_num');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');			
			$title['headerTitle']="Update Vehicle Job Card";
			$this->load->view('templates/header',$title);
			$data['make']  = $this->Vehicle->getMake();	
			$data['customer']  = $this->Vehicle->getCustomer();	
			$data['staff']  = $this->Vehicle->getServiceStaff();
			$data['advisor']  = $this->Vehicle->getAdvisorStaff();
			$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($job_card_id);
			$data['model']  = $this->Vehicle->getregisterModel($data['vjobcard']->model);
			$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($job_card_id);
			$Client_Id = $data['vjobcard']->client_id;
			$data['ContactDetails'] = $this->Vehicle->get_ContactDetails_only($Client_Id );
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$job_card_id.'');
		}
		else{
			$where2 = array('job_card_id' => $job_card_id);
			$this->crud_model->delete('job_card_details',$where2);
			$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
			if($this->input->post('reg_val') == 0 ){
				$data = array(
					'reg_no'	 =>	$this->input->post('reg_no'),
					'make_id' => $this->input->post('make'),
					'model_id' => $this->input->post('model'),
					'client_id' => $this->input->post('client_id'),	
					'client_mobile_no' =>  $this->input->post('contact_num_2'),				 
					'car_year' => $this->input->post('car_year'),
					'car_color' => $this->input->post('car_color'),
					'chassi_number' => $this->input->post('chassi_number'),
				);
			 $this->Vehicle->insertregistration($data);
			}
				/****sp amount****/
				$sp_qnty  = $this->input->post('m_item_qty');
				$sp_rate  = $this->input->post('m_item_rate');
				$sp_vat   = $this->input->post('m_item_vat');								
				$sp_disc   = $this->input->post('m_item_discount[]');								
				$sp_total_amount = $sp_net_amount = 0;
				if(!empty($sp_qnty)){
					for($sp = 0 ; $sp < count($sp_qnty); $sp++){
						$sp_vat_p   = floatval($sp_vat[$sp]);
						$sp_amount   = floatval($sp_qnty[$sp]) * floatval($sp_rate[$sp]) -  $sp_disc[$sp];
						$sp_vat_amnt = (floatval($sp_amount) * floatval($sp_vat_p)) / 100;
						$sp_net_amount += $sp_amount + $sp_vat_amnt;
					}
				}
				/****lb amount****/
				$lb_net_amount = 0;
				$lb_vat_perce     = ($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$lb_item_discount = $this->input->post('item_discount');
				$lb_item_qty      = $this->input->post('item_qty');
				$lb_item_rate     = $this->input->post('item_rate');
				if(!empty($lb_item_qty)){
					for($lb = 0 ; $lb < count($lb_item_qty) ; $lb++){
						$lb_amount     = (floatval($lb_item_qty[$lb]) * floatval($lb_item_rate[$lb])) - floatval($lb_item_discount[$lb]);
						$lb_vat_amnt   = (floatval($lb_amount) * floatval($lb_vat_perce[$lb]) ) / 100;
						$lb_net_amount += $lb_amount + $lb_vat_amnt;
						
					}
				}				
				$job_card_amount_with_vat = $sp_net_amount + $lb_net_amount;
				$lb_cost_tot = $sp_cost_tot = 0;
				if(!empty($this->input->post('item_cost'))){
					for($sp = 0 ; $sp < count($this->input->post('item_cost')) ; $sp++){
						$sp_cost = $this->input->post('item_cost');
						$sp_cost_tot += (floatval($sp_cost[$sp]) * floatval($sp_qnty[$sp]));
					}
				}
				if(!empty($this->input->post('lb_item_cost'))){
					for($lb = 0 ; $lb < count($this->input->post('lb_item_cost')) ; $lb++){
						$lb_cost = $this->input->post('lb_item_cost');
						$lb_cost_tot += (floatval($lb_cost[$lb]) * floatval($lb_item_qty[$lb]));
					}
				}
				$grand_cost = $sp_cost_tot + $lb_cost_tot;
				$data = array(
					
					'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
					//'client_id' => $this->input->post('client_id'),
					'created_user_id' => $this->session->userdata('user_id'),
					//'reg_no' =>  $this->input->post('reg_no'),
					//'make' =>  $this->input->post('make'),
					//'model' =>  $this->input->post('model'),
					//'car_year' =>  $this->input->post('car_year'),
					//'car_color' =>  $this->input->post('car_color'),
					'contact_id' => $this->input->post('contact_id'),
					'contact_name' =>  $this->input->post('contact_name'),
					'contact_num' =>  $this->input->post('contact_num'),
					'km_in' =>  $this->input->post('km_in'),
					'next_km' =>  $this->input->post('next_km'),
					'fuel_level' =>  $this->input->post('fuel_level'),
					'is_insurance' =>  $is_insurance,
					'salesman_id' =>  $this->input->post('advisor'),
					'job_card_status' =>  'Draft',
					'job_card_total' =>  $job_card_amount_with_vat,
					'job_card_vat_perc' =>  10,
					'job_card_vat_amount' =>  $job_card_amount_with_vat,
					'job_card_amount_with_vat' =>  $job_card_amount_with_vat,
					'vtype_id'   =>  $this->input->post('v_type_id'),
					'contact_person2' => $this->input->post('contact_num_2'),
					'grand_cost'    => $grand_cost
				);
			    $where = array('id' => $job_card_id);

			    $this->crud_model->update('job_card',$data,$where);		
				if($this->input->post('reg_val') != 0 ){
				
					$where_reg = array(
 						'v_type'    => $this->input->post('v_type_id'),
						'reg_no LIKE'  => '%'.$this->input->post('reg_no').'%',
					);
					$data_reg = array(
						'client_mobile_no' =>$this->input->post('contact_num_2'),			 
					);
					$this->crud_model->update('reg_no_table',$data_reg,$where_reg);
					//echo $this->db->last_query();
					//exit();
				} 				
			if( $this->input->post('jb_type') == 1)
			{			 
				$item_id = $this->input->post('item_id');
				$furniture_model = $this->input->post('item');
				$furniture_description =$this->input->post('desc');
				$vat_perce =($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$vat_amount =$this->input->post('item_vat_amount');
				$item_discount =$this->input->post('item_discount');
				$item_disc_perc =$this->input->post('item_discount_prcnt_lb');
				$net_amount =$this->input->post('item_net_amount');
				$section_id =$this->input->post('section_id');
				$technician_id =$this->input->post('technician_id');
				$furniture_quantity =$this->input->post('item_qty');
				$furniture_unitprice =$this->input->post('item_rate');
				$furniture_amount =$this->input->post('item_amount');
				$job_card_details_id = $this->input->post('job_card_details_id');
				$item_uom =$this->input->post('item_uom');
				$item_uom_id =$this->input->post('item_uom_id');
				$item_cost =$this->input->post('lb_item_cost');
				$sl = 1;
				if(!empty($item_id)){	
					for($i = 0; $i < count($item_id);$i++ ){				
						$dataValues  = array(
							'job_card_id' => $job_card_id,
							'sl_no' => $sl++,
							'job_card_details_id'=>$job_card_details_id[$i],
							'item_id' => $item_id[$i],
							'furniture_model' =>$furniture_model[$i],
							'furniture_description' =>$furniture_description[$i],
							'Item_cost' =>$item_cost[$i],
							'furniture_unitprice' =>$furniture_unitprice[$i],
							'furniture_quantity' =>$furniture_quantity[$i],
							'furniture_amount' =>$furniture_amount[$i],
							'uom'	    =>$item_uom[$i],
							'uom_id'    =>$item_uom_id[$i],
							'vat_perce' =>$vat_perce[$i],
							'vat_amount' =>$vat_amount[$i],
							'item_disc_perc' =>$item_disc_perc[$i],
							'item_discount' =>$item_discount[$i],
							'net_amount' => $net_amount[$i],
							'jb_type' => $this->input->post('jb_type'),
							'section_id' => $section_id[$i],
							'technician_id' => $technician_id[$i],
							'body_id' =>   '',
							'part_type' =>  ''
						);
						//var_dump($dataValues);
						$this->Vehicle->UpdateJobdetails($dataValues);
					}
				}	
			}		 
			if($this->input->post('m_jb_type') == 2){				  
				$item_id = $this->input->post('m_item_id');
				$furniture_model = $this->input->post('m_item');
				$furniture_description =  $this->input->post('furniture_description');
				$vat_perce =($this->input->post('m_item_vat') !='' ?  $this->input->post('m_item_vat') : 10);
				$vat_amount =$this->input->post('m_item_vat_amount');
				$item_discount =$this->input->post('m_item_discount');
				$item_disc_perc =$this->input->post('m_item_discount_perc');
				$net_amount =$this->input->post('m_item_net_amount');
				$furniture_quantity =$this->input->post('m_item_qty');
				$furniture_unitprice =$this->input->post('m_item_rate');
				$furniture_amount =$this->input->post('m_item_amount');
				$job_card_details_id = $this->input->post('m_job_card_details_id');
				$body_id =  $this->input->post('body_id');
				$part_type  =  $this->input->post('part_type');
				$item_uom =$this->input->post('sp_uom');
				$item_uom_id =$this->input->post('sp_uom_id');				
				$item_cost =$this->input->post('item_cost');				
				$sl = 1;
				if(!empty($item_id)){	
					for($i = 0; $i < count($item_id);$i++ ){
						$m_section_id = $this->input->post('m_section_id')[$i];
						//if(!empty($this->input->post('m_section_id')[$i])){
							$section = explode('-', $m_section_id);
							$section_id = $section[1];
							$technician_id = $section[0];
							$dataValues  = array(
								'job_card_id' => $job_card_id,
								'sl_no' => $sl++,
								'job_card_details_id'=>$job_card_details_id[$i],
								'item_id' => $item_id[$i],
								'furniture_model' =>$furniture_model[$i],
								'furniture_description' =>$furniture_description[$i],
								'Item_cost' =>$item_cost[$i],
								'furniture_unitprice' =>$furniture_unitprice[$i],
								'furniture_quantity' =>$furniture_quantity[$i],
								'furniture_amount' =>$furniture_amount[$i],
								'vat_perce' =>$vat_perce[$i],
								'uom'	    =>$item_uom[$i],
							    'uom_id'    =>$item_uom_id[$i],
								'vat_amount' =>$vat_amount[$i],
								'item_disc_perc' =>$item_disc_perc[$i],
								'item_discount' =>$item_discount[$i],
								'net_amount' => $net_amount[$i],
								'jb_type' => $this->input->post('m_jb_type'),
								'section_id' => $section_id,
								'technician_id' => $technician_id,
								'body_id' =>   $this->input->post('body_id')[$i],
								'part_type' =>   $this->input->post('part_type')[$i]
							);	
 							$this->Vehicle->UpdateJobdetails($dataValues);
					  //  }
					}
				}
			}	
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'	=> 'Vehicle Job Card',	
					'masters_id'	=> $job_card_id,	
					'date'			=>	$date,	
					'created_id'	=> $userid,	
					'masters_op'	=> 'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Job Card Updated');
		    	redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$job_card_id.'');
		}	
	}
	public function insurance($id = ''){
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){
		 
			$config = array(		 
			array(
				'field' => 'client',
				'label' => 'Insurer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'lpono',
				'label' => 'LPO Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'lpo_date',
				'label' => 'LPO Date',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Add %s.'
				)
				),array(
				'field' => 'claim_no',
				'label' => 'Claim Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'claim_amount',
				'label' => 'Claim Amount',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				)
			);	
	
		    $this->form_validation->set_rules($config);
			if ($this->form_validation->run() == FALSE){
				$data['customer']  = $this->Vehicle->getnewCustomer();
				$data['lpono']		 = $records[0]['lpono'];
				$data['insurer_id']		 = $records[0]['insurer_id'];
				$data['lpo_date']		 = $records[0]['lpo_date'];
				$data['claim_no']		 = $records[0]['claim_no'];
				$data['claim_amount']		 = $records[0]['claim_amount']; 
				$data['id'] = $id;
				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/is_insurance',$data);
				$this->load->view('templates/footer'); 
			}
			else{

				$data = array(
					
					'lpono' => $this->input->post('lpono'),
					'insurer_id' => $this->input->post('insurer_id'),
					'lpo_date' => date('y-m-d', strtotime($this->input->post('lpo_date'))),
					'created_user_id' => $this->session->userdata('user_id'),
					'claim_no' =>  $this->input->post('claim_no'),
					'claim_amount' =>  $this->input->post('claim_amount'),
				);
				$where = array('id' => $id);
				$this->crud_model->update('job_card',$data,$where);	
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					redirect("jobcard/Vehicle_jobcard");
				}
				else {
					$this->db->trans_commit();
				    $this->session->set_flashdata('success', 'Insurer Detailes Updated');
			    	redirect('jobcard/Vehicle_jobcard/insurance/'.$id.'');
				}

			}
	    }
	}

	public function customerComplaints($id = '') {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 

		if($records != false){			 
			$config = array(		 
				array(
						'field' => 'customer_complaints',
						'label' => 'Customer Complaints Detail',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required'      => 'Please Add  %s.'
						)
				),);
				$this->form_validation->set_rules($config);
			
			if ($this->form_validation->run() == FALSE){ 
				$data['customer_complaints']   =  set_value('customer_complaints');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$data['customer_complaints']		 = $records[0]['customer_complaints'];
				$data['service_advisor_meassages']	 = $records[0]['service_advisor_meassages'];
				$data['id'] = $id;

				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/customer_complaints',$data);
				$this->load->view('templates/footer'); 
			} else{
				
					$user_id	=	$this->session->userdata('user_id');
					$data = array(
						'customer_complaints' => htmlentities($this->input->post('customer_complaints')),
						'service_advisor_meassages' =>  htmlentities($this->input->post('service_advisor_meassages'))
					);
					$this->db->trans_begin();
					$where = array('id' => $id);
			     	$this->crud_model->update('job_card',$data,$where);	
										
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						redirect("jobcard/Vehicle_jobcard");
					} else {
						$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Customer Complaints Added Successfully');
					redirect('jobcard/Vehicle_jobcard/customerComplaints/'.$id.'');
				}
			}
		}
       	
	}
	public function inventoryDetails($id = '') {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){
			$config = array(
				array(
					'field' => 'inventory_detail_img',
					'label' => 'Customer Inventory Detail',
					'rules' => 'callback_validate_inventory_detail_img',
					'errors' => array(
						'validate_inventory_detail_img' => 'Please select at least one inventory detail image.'
					)
				),
			);
				$this->form_validation->set_rules($config);			 
				//$this->form_validation->set_rules('inventory_detail', 'Customer inventory_detail', 'required');		
			if ($this->form_validation->run() == FALSE){ 
				$data['inventory_detail']   =  set_value('inventory_detail');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$data['inventory_detail']		 = $records[0]['inventory_detail'];
				$data['inventory_detail_master'] = $this->Vehicle->v_InventoryChecklist();
				$data['id'] = $id;

				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/v_inventory_detail',$data);
				$this->load->view('templates/footer'); 
			} 
			else{
				
				$user_id	=	$this->session->userdata('user_id');
				if ($this->input->post('inventory_detail_img')) {
					$inventory_details = $this->input->post('inventory_detail_img');

					if (is_array($inventory_details)) {
						$selected_values = implode(',', $inventory_details);
					} else {
						$selected_values = $inventory_details;
					} 
					$selected_values = rtrim($selected_values, ','); 
				}
				$data = array(
					'inventory_detail' => $selected_values,
				);						
				$this->db->trans_begin();
				$where = array('id' => $id);
				$this->crud_model->update('job_card',$data,$where);	
									
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/inventoryDetails/'.$id.'');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Inventory Details Added Successfully');
					redirect('jobcard/Vehicle_jobcard/inventoryDetails/'.$id.'');
				}	
			}
		}
       	
	}

	public function validate_inventory_detail_img($str) {
		if (isset($_POST['inventory_detail_img']) && count($_POST['inventory_detail_img']) > 0) {
			foreach ($_POST['inventory_detail_img'] as $value) {
				if ($value != '') {
					return true; 
				}
			}
			return false; 
		} else {
			return false;
		}
	}

	public function do_draft($id = '',$division_id = ''){
	 
		$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
	    //$id  = $this->input->post('id');
		//$division_id = $this->input->post('division');
		$query_data= $this->db->query("SELECT * FROM `furniture_quotation` WHERE `job_card_id`='$id' AND `quotation_status` != 'Closed' limit 1");
		if ($query_data->num_rows()==0){
			$user_id	=	$this->session->userdata('user_id');
			$dbdata = $this->Vehicle->jobCardRow($id);
			// $division=$dbdata->division_id;
			$SQL = "SELECT MAX(quotation_number)+1 as `new_quotation_number` FROM furniture_quotation WHERE `quotation_divisionid`='$division_id';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			if($data[0]['new_quotation_number'] != NULL and $data[0]['new_quotation_number'] != ""){
				$quotation_number= $data[0]['new_quotation_number'];
			} else{
				$quotation_number = 10001;
			}
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' and status='1'");
			$division_code=$query->row()->division_code;
			//$division_dbdata = $this->EnquiryModel->company_division($division);
			$qtnmr=$division_code.'-'.$quotation_number;

			if($dbdata->tax_perce==0){
				$vat_percentage=0;
			} else {
				$date=date("Y-m-d");
				$query2= $this->db->query("SELECT * FROM `vat_applicable` WHERE `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where `applicable_date`<'$date') order by `vat_percentage` DESC");
				$vat_percentage=$query2->row()->vat_percentage;
			}
			
			$data = array(
				'quotation_number' 			=> $quotation_number,
				'quotation_number_full' 	=> $qtnmr.'-0',
				'quotation_revisionnumber' 	=> 0,
				'quotation_date'   			=> date("Y-m-d"),
				'quotation_divisionid'    	=> $division_id,
				'client_id'    				=> $dbdata->client_id,
				'contact_id'    			=> $dbdata->contact_id,
				'quotation_vat_percentage'  => $vat_percentage,
				'quotation_vat_amount'  	=> 0,
				'quotation_amount_with_vat'  => 0,
				'quotation_status'    		=> 'Open',
				'job_card_id'    			=> $id,
				'quotation_type'    		=> 3,
				'reg_no'    				=> $dbdata->reg_no,
				'make_id'    				=> $dbdata->make,
				'model_id'    				=> $dbdata->model,
				'contact_person'    		=> $dbdata->contact_name,
				'contact_p_tel'    			=> $dbdata->contact_num,
				'salesman_id'  				=> $dbdata->salesman_id,
				'status'  					=> 3
			);
			 
			$this->crud_model->insert('furniture_quotation', $data);
			$insert_id = $this->db->insert_id();	
 			if(!empty($insert_id) ){
				$where_jb = array(
					'job_card_id' => $dbdata->id,
				);
				$job_data = $this->Vehicle->getQutatioJBDetail($dbdata->id);
				if($job_data != false){

					$grandtotal = $famountTotal = $vatTotal = $itemdiscount = $famounttotal = $quotation_vat_amount= 0 ;
					foreach($job_data as $rec){
						if($rec['jb_type']  == 1){
							$furniture_area = 'Labour';
						}else{
							$furniture_area = 'Spare Parts';
						}
						
						$quotation_vat_amount     += $rec['vat_amount'];
						$itemdiscount +=  $rec['item_discount'];
						$dataValues  = array(
							'quotation_id'    => $insert_id,
							'furniture_area'  => $furniture_area,
							 'ex_furniture_area' => $rec['jb_type'],
							'item_id' 		  => $rec['item_id'], 
							'furniture_model' =>  $rec['furniture_model'], 
							'furniture_description' => $rec['furniture_description'],  
							'furniture_quantity'=> $rec['furniture_quantity'],  
							'furniture_unitprice' =>  $rec['furniture_unitprice'], 
							'furniture_amount' => $rec['furniture_amount'], 
							'uom' =>  $rec['uom'],
							'vat_perce' => $rec['vat_perce'],
							'vat_amount' =>  $rec['vat_amount'],
							'item_discount' =>  $rec['item_discount'],
							'net_amount' =>  $rec['net_amount'],
						);
						$grandtotal   += $rec['net_amount'] ;
						$famounttotal += $rec['furniture_amount'];
						$vatTotal     += $rec['vat_amount'];
 						$this->crud_model->insert('furniture_items', $dataValues);
						
					}
					$where_quot = array(
						'id' => $insert_id,
						'job_card_id' => $dbdata->id
					);
					$quot_data = array(
						'quotation_total' => $famounttotal,
						'quotation_vat_amount' => $vatTotal,
						'quotation_amount_with_vat' => $grandtotal
					);
					$this->crud_model->update('furniture_quotation', $quot_data,$where_quot );
				}
			}	
			$list='';
			$i=0;

			$job_data = array(
					'quotation_id' => $insert_id ,
					'qtn_no' => $qtnmr
			);
			$where_1 = array('id' => $id);
			$this->crud_model->update('job_card',$job_data,$where_1);

			$log_data=array(
				'trans_no'  =>  $qtnmr.'-0',
				'trans_type'  =>  'Quotation',
				'trans_op'  =>  'Create',
				'trans_user_id'  =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			$log_for_quotationg_data=array(
				'trans_id'  	=>  $insert_id,
				'trans_type'  	=>  'Quotation',
				'trans_action'  =>  'Create',
				'flow_id'  		=>  3,
				'group_by'  	=>  1,
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_quotation=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);			
			/* $u_data = array(
				'quotation_number' => $qtnmr,
				'status' => 2
			);
			$this->db->where('id', $Enquiry_Id);
			$this->db->update('enquiry', $u_data); */
 			if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    redirect("jobcard/Vehicle_jobcard/index");
                }
			else {
                    $this->db->trans_commit();
                    $this->session->set_flashdata('success', 'Quotation Created Successfully');
                   // $path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$insert_id;
                    $path	=	base_url()."index.php/furniture/Furnitures/index/".$insert_id;
					redirect($path);
             }
			
		} else {
			$this->db->trans_rollback();
			// $this->session->set_flashdata('response', 'Quotation Already created!!! <a target="_blank"  href="'.site_url('furniture/furniture_quotation_client_project/index/'.$query_data->row()->id.'').'" class="btn btn-success view_quotation"><span >Qtn# : '.$query_data->row()->quotation_number.' </span></a>');
			 $this->session->set_flashdata('response', 'Quotation Already created!!! <a target="_blank"  href="'.site_url('furniture/Furnitures/index/'.$query_data->row()->id.'').'" class="btn btn-success view_quotation"><span >Qtn# : '.$query_data->row()->quotation_number.' </span></a>');
			// //$path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$query_data->row()->id;
			// $path	=	base_url()."index.php/furniture/Enquiry/listEnquiry";
			// redirect($path);
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');
		}		
	}

	public function document_attachments($job_no,$division_id) {
		$this->users_model->permission("Job_card", "Edit");
		$dbdata = $this->Vehicle->dataRowdocument($job_no,$division_id);		
		//$this->form_validation->set_rules('job_no', 'Job No', 'required');
		$this->form_validation->set_rules('title', 'Title', 'required');
		$title['headerTitle']="Document Attachments";
		$config = array(		 
			array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please enter document %s.'
                    )
            ),);
			$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){ 
			$data['title']   =  set_value('title');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			//$inventory_item=$this->JobCardModel->inventory_item();
			$vir_files =$this->Vehicle->vir_files($job_no,$division_id);
			$datas   =   array("dbdata" => $dbdata,"vir_files"=>$vir_files);
			$datas['job_no'] = $job_no;
			$datas['division_id'] = $division_id;
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/document_attachments',$datas);
			$this->load->view('templates/footer'); 
		} else{
			
			/*$this->db->where('job_no', $job_no);
			$this->db->where('division_id', $division_id);
			$this->db->delete('vir_files');*/					
			$this->load->library('upload');
			$files = $_FILES;
			$file_upload = $this->input->post('image');
			$file_upload2 = $this->input->post('image2');
			$config['upload_path'] = './images/job_documents/';
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$config['allowed_types'] = '*';
			$config['max_size']= '0';
			$config['overwrite'] = TRUE;
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			
	
			if ($this->upload->do_upload('image')) {
				$ext = end(explode(".", $_FILES["image"]['name']));
				$datanew = array(
					'job_no' 	 => $job_no,
					'division_id'=> $division_id,
					'title'=> $this->input->post('title'),
					'file_name'  => $config['file_name'].'.'.$ext
				);
				$added = $this->db->insert('vir_files',$datanew);
			} else {
				$this->session->set_flashdata('response', $this->upload->display_errors());
				redirect("jobcard/Vehicle_jobcard/document_attachments/".$job_no."/".$division_id);
			}
			
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("jobcard/Vehicle_jobcard");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Attachment Added Successfully');
				redirect("jobcard/Vehicle_jobcard/document_attachments/".$job_no."/".$division_id);
			}
		}		   
	}

	public function delete_documents($job_no,$division_id,$id){
		if($job_no!='' && $division_id!='' && $id!='' ){
			$this->db->where('vir_files_id', $id);
			$this->db->delete('vir_files');
			$this->session->set_flashdata('success', 'File Deleted Successfully');
			redirect("jobcard/Vehicle_jobcard/document_attachments/".$job_no."/".$division_id);
		} else {
			redirect("jobcard/Vehicle_jobcard");
		}
	}

	public function view_files($job_no,$division_id) {
	    	$data['job_images'] =$this->Vehicle->get_job_images($job_no);
			$data['job_no'] = $job_no;
			$data['division_id'] = $division_id;
			$title['headerTitle']="View Images";
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/view_images',$data);
			$this->load->view('templates/footer'); 
	}

	public function check_job_crd_confirmation(){
		$job_id = $this->input->post('jb_id');
		$check_po_exist = $this->Vehicle->checkPOdata($job_id);
		if($check_po_exist !== NULL){
			$msg = $check_po_exist;
		}
		else{
			$msg = "confirm";
		}
		echo json_encode($msg);
	}
	public function checkPurcahseDataPulled(){
		$job_id = $this->input->post('job_id');
		$check_pur_datapulled = $this->Vehicle->get_check_pulled_pur_data($job_id); 
		echo json_encode($check_pur_datapulled );
	}

	public function checkMaterialIssueDataPulled(){
		$job_id = $this->input->post('job_id');
		$check_material_datapulled = $this->Vehicle->get_check_pulled_material_data($job_id);
		echo json_encode($check_material_datapulled);
	}
	public function checkRateDiff(){
		$job_id = $this->input->post('job_id');
		$check_rate_Job = $this->Vehicle->get_check_rate_Job($job_id);
		$check_rate_quo = $this->Vehicle->get_check_rate_quo($job_id);
		$rata_Array =  array('job_rate' =>  $check_rate_Job, 'qout_rate' => $check_rate_quo );
		echo json_encode($rata_Array);
	}

	public function updateJObcardStatus(){
		$job_id = $this->input->post('job_id');
		$data = array ( 'job_card_status'=> 'Completed');
		$update_jobcard_staus  = $this->Vehicle->UpdateJObcardStatus($job_id,$data);
		echo json_encode($update_jobcard_staus);
	}

	public function getTechnician(){
		$tech_id = $this->input->post('tech_id');
		$staff = $this->Vehicle->getServiceStaff();
		$html = '';
		if(!empty($staff))
		foreach ($staff as $res) {
			     
				if( $res['type'] == 2){
					$selected = $tech_id == $res['staff_id'] ? 'selected="selected"' : '' ;
				$html .= '<option  '.$selected.'   value="'.$res['staff_id'].'-'.$res['section_id'].'">' . $res['staff_name'] . '</option>';
			}
	    }
		echo $html;
	}

	public function send_disc_request(){
		$getresponse = $this->Vehicle->sendDicsRequest();
		echo json_encode($getresponse);
	}

	public function job_history($reg_no = ''){
		$title['headerTitle']="Job History";
		$data['records'] = $this->Vehicle->getJobhistory($reg_no);
		$inv_detail = [];
		if(!empty($data['records'])){
			foreach( $data['records'] as $rec){
				 $inv_detail[] = $this->Vehicle->getInvoiceDetails($rec['invoice_id']);
			}
			$data['inv_detail'] = $inv_detail;
		}
		else{
			$data['inv_detail'] = NULL;
		}
		$data['reg_no'] = $reg_no;
		$this->load->view('templates/header',$title);
		$this->load->view('reports/job_history',$data);
		$this->load->view('templates/footer'); 
	}

	public function printJobcard($job_id,$type=''){
		
		//$this->load->helper(array('dompdf', 'file'));
		 // page info here, db calls, etc.     
		 
		$records = $this->Vehicle->get_vehicle_job_details($job_id);
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Complete JobCard..</div>');
				redirect("jobcard/Vehicle_jobcard");
		}	
		$job_card_id = $records->id;
		$division_id = $records->divisionid;
		
 		$datas['logo']  = $this->Vehicle->getcompany_division($division_id);
		$datas['records'] = $records;
		$datas['company_details']  = $this->Vehicle->getcompany_details();
		$datas['customer']  = $this->Vehicle->getCustomer();
		$datas['make']  = $this->Vehicle->getMake();	
		$datas['model']    = $this->Vehicle->getregisterModel($datas['records']->make);
		// if($job_card_id!=0){
		// 	$this->db->select('job_card_number');
		// 	$this->db->from('job_card');
		// 	$this->db->where('id', $job_card_id);
		// 	$this->db->limit(1);
		// 	$query2 = $this->db->get();
		// 	$records['job_card_number'] = $query2->row()->job_card_number;
		// } else {
		// 	$records['job_card_number'] = "";
		// }

		// $records['logos_url'] = array();
		// $logos_id = explode(",",$records['quotation_logos']);
		// foreach($logos_id as $key=>$logo_id) {
		// 	$where = array('logo_id' => $logo_id);
		// 	$logo = $this->crud_model->get('logos',$where);
		// 	if($logo== true){
		// 		array_push($records['logos_url'], "images/logos/".$logo[0]['logo_filename']);
		// 	}else if($records['logo_filename']){
		// 		array_push($records['logos_url'], "images/company_division/".$records['logo_filename']);
		// 	}
		// }
		
		// $query = $this->db->get('company_details');  
		// $records['company_details'] = $query->row();
		// foreach ($query->result() as $row)
		// {
		// 	$company_email_name =  $row->company_name;
		// }
		//var_dump($records);exit;
		//$this->load->view('general/quotations/printview4', $records);
		 
		//if($type=="pdf"){
			$datas['image'] = "without_image";
			$datas['print_type'] = "pdf_print_type";
			$datas['controller'] = $this;

			$mpdf = new \Mpdf\Mpdf([
				'default_font_size' => 10,
			]);
		//	$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			$header = $this->load->view('general/jobcard/jobcard_pdf_header', $datas , true);
			$html = $this->load->view('general/jobcard/jobcard_printview', $datas , true);
			$footer = $this->load->view('general/jobcard/jobcard_pdf_footer', $datas , true);
			
			$mpdf->SetHTMLHeader($header);
			$mpdf->AddPage('P','','','','',15,15,95,20,5,3);
			// Write the HTML content
			$mpdf->WriteHTML($html);

			// Get the total number of pages
			$totalPages = $mpdf->page;

			// Set the footer only on the last page
			if ($totalPages > 0) {
				//$mpdf->AddPage('P','','','','',15,15,82,20,10,0); // Add a new page
				$mpdf->SetHTMLFooter($footer);
				$mpdf->WriteHTML(''); // Write an empty HTML to apply the footer
			}
		//	 echo 'JobCard - '.ucfirst(strtolower($client_name)).' - '.$records->job_card_number;
			$download_path='pdfexport/Quotation/';
			$filename= 'JobCard_'.$records->job_card_number;
			$mpdf->Output($filename, 'I');



			/*$mpdf->SetHTMLFooter($footer);
			$base_url=base_url();
			
			// if($records['invoice_status']==='1'){
			// 	$mpdf->SetWatermarkText('Cancelled');
			// 	$mpdf->showWatermarkText = true;
			// }
			
			$mpdf->WriteHTML($html);
			$download_path='pdfexport/Quotation/';
			$filename='22.pdf';
			//$mpdf->Output($download_path.$filename, 'F');
			$mpdf->Output($filename, 'I');*/
		
		//}else if($type=="normal"){
	//	$records['print_type'] = "normal_print_type";
		//$this->load->view('general/quotations/normal_jobcard_print', $records);
	//	}
		/*else if($type=="email"){
		
		$this->db->select('*');
		$this->db->from('emails'); 
		$query_email = $this->db->get();
		$records_email=$query_email->result_array();
		
		$records['print_type'] = "email_print_type";
		$this->load->helper(array('dompdf', 'file'));
		$html = $this->load->view('general/quotations/printview4', $records, true);
		pdf_create($html, 'Invoice_No_'.$invoice_id,$stream=FALSE);
				
				
				
				$from 		= $records['salesman_email_id'];
				$fromname 	= $company_email_name;
				$to 		= $records['client_email'];
				$cc 		= @$records_email[0]['invoice_cc'];
				$subject 	= 'Invoice';
				$message 	= 'Please find attached invoice';
				$this->load->library('invoice_email');
				$send = $this->invoice_email->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$invoice_id);
				if($send){
					$this->session->set_flashdata('response','<div class="alert alert-success">Email Send Successfully</div>');
				}else{
					$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
				}
				redirect('invoices');
		}*/
		 //$html = $this->load->view('general/quotations/printview1', $records, true);
		 //pdf_create($html, 'Quotation_No_'.$quotation_id);		
		 //if you want to write it to disk and/or send it as an attachment  
	}
	public function cancel_jobcard($job_id = ''){
		
		$this->users_model->permission("Job_card", "Edit");
		$this->db->trans_begin();
		if($job_id != ''){
			
			$where = array (
				'id' => $job_id
			);
			$where_update_data = array(		
				'job_card_status'   =>  'Cancelled',	
				'cancelled_user_id' => 	$this->session->userdata('user_id'),		
			);		
			$this->crud_model->update('job_card',$where_update_data,$where);
			if ($this->db->trans_status() === FALSE) {
				$status = 'Draft';
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('jobcard/Vehicle_jobcard/index/'.$status.'');

			} else {
				$this->db->trans_commit();
				$status = 'Cancelled';
				$this->session->set_flashdata('success', 'Job Card Cancelled Successfully');
				redirect('jobcard/Vehicle_jobcard/index/'.$status.'');
			}
		}

	}
	
}