<?php
class Currency extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
	}
	function index($page=1)	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/currency/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('currency',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('currency',array(),$config['per_page'],$offset);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/currency/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->load->view('templates/header');
		$this->load->view('masters/currency/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$where=array(
				'currency_id' => $id
		);
		$records=$this->crud_model->get('currency',$where);
		if($records != false){
			//true section
			$data['currency_name']			 = $records[0]['currency_name'];
			$data['currency_code']			 = $records[0]['currency_code'];
			$data['currency_id']			 = $records[0]['currency_id'];
			$data['exchange_rate']			 = $records[0]['exchange_rate'];
			$this->load->view('templates/header');
			$this->load->view('masters/currency/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/company_division');
		}
	}
	function do_insert() {
	
		$currency_code = ascii_to_entities($this->input->post('currency_code'));
		$file_error = "";
		$filename = "";
		//$this->form_validation->set_rules('division_name', 'Company Division Name', 'required|max_length[100]');
		$this->form_validation->set_rules('currency_name', 'Currency Name', 'required|max_length[100]');
		$this->form_validation->set_rules('currency_code', 'Currency Code', 'required|max_length[10]');
		$this->form_validation->set_rules('exchange_rate', 'Exhange Rate', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/currency/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$exchange_rate=$this->input->post('exchange_rate');
			$currency_code=$this->input->post('currency_code');
			$currency_name=$this->input->post('currency_name');
			//$currency_code =  $currency_code;
			
			$data=array('exchange_rate' => $exchange_rate,
						'currency_name' => $currency_name,
						'currency_code' => $currency_code

			);

			$rr=$this->crud_model->insert('currency',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Currency cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/currency');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Currency added successfully</div>');
				redirect('masters/currency');

			}
		}

	}

	function do_update($currency_id) {
		
		$currency_code = ascii_to_entities($this->input->post('currency_code'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('currency_name', 'Currency Name', 'required|max_length[100]');
		$this->form_validation->set_rules('currency_code', 'Currency Code', 'required|max_length[10]');
		$this->form_validation->set_rules('exchange_rate', 'Exhange Rate', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("currency_id"=>$currency_id);
					
			$records=$this->crud_model->get('currency', $where);
			if($records != false){
				//true section
				$data['currency_name']			 = $records[0]['currency_name'];
			$data['currency_code']			 = $records[0]['currency_code'];
			$data['currency_id']			 = $records[0]['currency_id'];
			$data['exchange_rate']			 = $records[0]['exchange_rate'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/currency/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$exchange_rate=$this->input->post('exchange_rate');
			$currency_code=$this->input->post('currency_code');
			$currency_name=$this->input->post('currency_name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'currency_id'  => $currency_id
			);
			$data=array('exchange_rate' => $exchange_rate,
						'currency_name' => $currency_name,
						'currency_code' => $currency_code

			);

			$records=$this->crud_model->update('currency',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Currency updated</div>');
			redirect('masters/currency');

		}
	}
	function do_delete($id=0) {

		$where=array(
			'quotation_divisionid'=> $id
		);
		
		$records=$this->crud_model->get('view_furniture_quotations_client_project_users', $where);
		
		if(!$records) {
			$where=array(
				'division_id'=> $id
			);
			$this->crud_model->delete('company_division',$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Company division deleted</div>');
			redirect('masters/company_division');
		} else {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry. You cannot delete a division that is used in the existing quotations.</div>');
			redirect('masters/company_division');
		}
	}
}