<?php
class Ledger extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$this->users_model->permission("Ledger","View");
		$title['headerTitle']="Ledger List";
		$this->data['records'] = $this->furniture_quotation_model->get_all_ledgers();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/ledger/list',$this->data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->users_model->permission("Ledger","Add");
		$title['headerTitle']="Ledger Create";
		$data['ledger_code'] = $this->furniture_quotation_model->get_ledger_code();
		$date=date("Y-m-d");
		$data['vat_applicable']   = $this->furniture_quotation_model->taxability($date);

		$this->load->view('templates/header',$title);
		$this->load->view('masters/ledger/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$this->users_model->permission("Ledger","Edit");
		$title['headerTitle']="Ledger Edit";
		
		$SQL="select L.*,A.acc_group_name from ledgers L inner join account_group A on A.acc_group_id=L.acoount_group_id WHERE L.`ledger_id`='$id' ";
		$result = $this->db->query($SQL);
		$records= $result->result_array();
		
		
		if($records != false){
			//true section
			$data['ledger_name']	 = $records[0]['ledger_name'];
			$data['ledger_code']	 = $records[0]['ledger_code'];
			$data['ledger_id']		 = $records[0]['ledger_id'];
			$data['acc_group_name']		= $records[0]['acc_group_name'];
			$data['acoount_group_id']	= $records[0]['acoount_group_id'];
			$data['tax_percentage']	= $records[0]['tax_percentage'];
			$data['taxability']		= $records[0]['taxability'];
			$data['bank_account_number']	= $records[0]['bank_account_number'];
			$data['bank_account_holder_name']	= $records[0]['bank_account_holder_name'];
			$data['bank_iban']		= $records[0]['bank_iban'];
			$data['bank_swift']		= $records[0]['bank_swift'];
			$data['bank_name']		= $records[0]['bank_name'];
			$data['bank_branch']	= $records[0]['bank_branch'];
			$data['opening_balance']= $records[0]['opening_balance'];
			$data['is_edit']		= $records[0]['is_edit'];

			$date=date("Y-m-d");
			$data['vat_applicable']   = $this->furniture_quotation_model->taxability($date);

			$this->load->view('templates/header',$title);
			$this->load->view('masters/ledger/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Ledger');
		}

	}
	function do_insert()
	{
		$this->users_model->permission("Ledger","Add");
		$title['headerTitle']="Ledger Create";
		$this->form_validation->set_rules('ledger_code', 'Ledger Code', 'required');
		$this->form_validation->set_rules('ledger_name', 'Ledger Name', 'trim|required|is_unique[ledgers.ledger_name]');
		$this->form_validation->set_rules('acc_group_parent', 'Under ( Group )', 'required');
		$this->form_validation->set_rules('taxability', 'Taxability', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			
			$data['ledger_code'] = $this->furniture_quotation_model->get_ledger_code();
			
			$date=date("Y-m-d");
			$data['vat_applicable']   = $this->furniture_quotation_model->taxability($date);
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/ledger/create',$data);
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$ledger_code	 = $this->furniture_quotation_model->get_ledger_code();
			$ledger_name	 = trim($this->input->post('ledger_name'));
			$acc_group_parent= trim($this->input->post('acc_group_parent'));
			$allt	 		 = $this->input->post('taxability');
			$bank_account_number 	   = trim($this->input->post('bank_account_number'));
			$bank_account_holder_name  = trim($this->input->post('bank_account_holder_name'));
			$bank_iban    	 = trim($this->input->post('bank_iban'));
			$bank_swift      = trim($this->input->post('bank_swift'));
			$bank_name 		 = trim($this->input->post('bank_name'));
			$bank_branch  	 = trim($this->input->post('bank_branch'));
			$opening_balance = trim($this->input->post('opening_balance'));
			
			$array_of_words =	explode('-',$allt);

			$tax_percentage	=	$array_of_words[0];
			$taxability	=	$array_of_words[1];

			$data=array(
				'ledger_name' 		=> $ledger_name,
				'ledger_code' 		=> $ledger_code,
				'acoount_group_id'  => $acc_group_parent,
				'tax_percentage' 	=> $tax_percentage,
				'taxability' 	   	=> $taxability,
				'bank_account_number'=> 	$bank_account_number,
				'bank_account_holder_name' => 	$bank_account_holder_name,
				'bank_iban' 		=> 	$bank_iban,
				'bank_swift' 		=> 	$bank_swift,
				'bank_name' 		=> 	$bank_name,
				'bank_branch' 		=> 	$bank_branch,
				'opening_balance' 	=> 	$opening_balance,
				'is_edit' 			=> 	1
			);

			$rr=$this->crud_model->insert('ledgers',$data);
			if($opening_balance!=0 && $opening_balance!=''){
				$books_beginning_date  = $this->furniture_quotation_model->books_beginning_date_config();
				$accounts_data = array(
					'vch_type' 	  => 'OPENING',
					'vch_no'  	  => 0,
					'vch_date'    => $books_beginning_date,
					'vch_ref'     => '',
					'ledger_code' => $ledger_code,
					'rev_ledger_code' => NULL,
					'cc_code' 	  => 1,
					'div_code' 	  => 1,
					'ledger_amount'=> (float)$opening_balance,
					'ledger_narration'=> 'Opening Balance',
					'vch_narration'=> 'Opening Balance',
					'user_id' 	  => $this->session->userdata("user_id"),
					'status'      => 1
				);
				$this->db->insert('accounts', $accounts_data);
			}
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Accounts Ledger',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			if($rr == false){
				// error

				$this->session->set_flashdata('response','Ledgers cannot be inserted',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/list');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('success','ledger added successfully');
				redirect('masters/Ledger');
			}
		}

	}

	function do_update()
	{
		$this->users_model->permission("Ledger","Edit");
		$title['headerTitle']="Ledger Edit";
		$ledger_id	 = $this->input->post('ledger_id');
		$SQL="select L.*,A.acc_group_name from ledgers L inner join account_group A on A.acc_group_id=L.acoount_group_id WHERE L.`ledger_id`='$ledger_id' ";
		$result = $this->db->query($SQL);
		$records= $result->result_array();
		
		$this->form_validation->set_rules('ledger_id', 'Ledger Code', 'required');
		$this->form_validation->set_rules('ledger_code', 'Ledger Code', 'required');
		if(trim($records[0]['ledger_name']) != trim($this->input->post('ledger_name'))){
			$this->form_validation->set_rules('ledger_name', 'Ledger Name', 'required|is_unique[ledgers.ledger_name]');
		} else {
			$this->form_validation->set_rules('ledger_name', 'Ledger Name', 'required');
		}
		
		$this->form_validation->set_rules('acc_group_parent', 'Under ( Group )', 'required');
		$this->form_validation->set_rules('taxability', 'Taxability', 'required');

		if ($this->form_validation->run() == FALSE) {
			// false section
			if($records != false) {
				//true section
				$data['ledger_name']	 = $records[0]['ledger_name'];
				$data['ledger_code']	 = $records[0]['ledger_code'];
				$data['ledger_id']		 = $records[0]['ledger_id'];
				$data['acc_group_name']	 = $records[0]['acc_group_name'];
				$data['acoount_group_id']= $records[0]['acoount_group_id'];
				$data['tax_percentage']	 = $records[0]['tax_percentage'];
				$data['taxability']		 = $records[0]['taxability'];
				$data['bank_account_number']	= $records[0]['bank_account_number'];
				$data['bank_account_holder_name']	= $records[0]['bank_account_holder_name'];
				$data['bank_iban']		= $records[0]['bank_iban'];
				$data['bank_swift']		= $records[0]['bank_swift'];
				$data['bank_name']		= $records[0]['bank_name'];
				$data['bank_branch']	= $records[0]['bank_branch'];
				$data['opening_balance']= $records[0]['opening_balance'];
				$data['is_edit']		= $records[0]['is_edit'];

				$date=date("Y-m-d");
				$data['vat_applicable']   = $this->furniture_quotation_model->taxability($date);
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/ledger/edit',$data);
				$this->load->view('templates/footer');
					
			} else {
				//false section
				$this->session->set_flashdata('response','error'.$records);
				redirect('masters/Ledger');
			}
		} else {
			// true section

			$ledger_code	 = $this->furniture_quotation_model->get_ledger_code();
			$ledger_name	 = trim($this->input->post('ledger_name'));
			
			$acc_group_parent= trim($this->input->post('acc_group_parent'));
			$allt	 = trim($this->input->post('taxability'));
			$bank_account_number 	   = trim($this->input->post('bank_account_number'));
			$bank_account_holder_name  = trim($this->input->post('bank_account_holder_name'));
			$bank_iban    	 = trim($this->input->post('bank_iban'));
			$bank_swift      = trim($this->input->post('bank_swift'));
			$bank_name 		 = trim($this->input->post('bank_name'));
			$bank_branch  	 = trim($this->input->post('bank_branch'));
			$opening_balance = $this->input->post('opening_balance');
			
			$array_of_words =	explode('-',$allt);

			$tax_percentage	=	$array_of_words[0];
			$taxability	=	$array_of_words[1];

			$data=array(
				'ledger_name' => $ledger_name,
				'acoount_group_id' => $acc_group_parent,
				'tax_percentage' 	   => $tax_percentage,
				'taxability' 	   => $taxability,
				'bank_account_number' => 	$bank_account_number,
				'bank_account_holder_name' 	=> 	$bank_account_holder_name,
				'bank_iban' 		=> 	$bank_iban,
				'bank_swift' 		=> 	$bank_swift,
				'bank_name' 		=> 	$bank_name,
				'bank_branch' 		=> 	$bank_branch,
				'opening_balance' 	=> 	$opening_balance
			);

			$where=array(
				'ledger_id'   => $ledger_id
			);

			$records=$this->crud_model->update('ledgers',$data,$where);
			
			$ledger_code = $this->input->post('ledger_code');

			$where4=array(
				'ledger_code'=>  $ledger_code,
				'vch_no' 	=>  0,
				'vch_type'  => 'Opening',
			);
			$this->crud_model->delete('accounts',$where4);
			
			if($opening_balance!=0 && $opening_balance!=''){
				$books_beginning_date  = $this->furniture_quotation_model->books_beginning_date_config();
				$accounts_data = array(
					'vch_type' 	  => 'OPENING',
					'vch_no'  	  => 0,
					'vch_date'    => $books_beginning_date,
					'vch_ref'     => '',
					'ledger_code' => $ledger_code,
					'rev_ledger_code' => NULL,
					'cc_code' 	  => 1,
					'div_code' 	  => 1,
					'ledger_amount'=> (float)$opening_balance,
					'ledger_narration'=> 'Opening Balance',
					'vch_narration'=> 'Opening Balance',
					'user_id' 	  => $this->session->userdata("user_id"),
					'status'      => 1
				);
				$this->db->insert('accounts', $accounts_data);
			}
			 
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Accounts Ledger',	
				'masters_id'=>$ledger_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('success','Ledger Updated');
			redirect('masters/Ledger');
		}
	}
	function do_delete($id=0) {
		$this->users_model->permission("Ledger","Delete");
		$where=array(
			'terms_id'=> $id
		);

		$this->crud_model->delete('terms_and_conditions',$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Accounts Ledger',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);
		$this->session->set_flashdata('response','Terms and Conditions Deleted');
		redirect('masters/terms_and_conditions');
	}

	public function search_account_group() {
		$acc_group_name	=	$this->input->post('acc_group_name');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		
		$client_contact_data = $this->db->query("SELECT A.acc_group_id,A.acc_group_name,A.acc_group_parent,B.acc_group_name as parent_group,(CASE WHEN A.acc_group_primary = 1 THEN 'Asset' WHEN A.acc_group_primary = 2 THEN 'Liability' WHEN A.acc_group_primary = 3 THEN 'Income' WHEN A.acc_group_primary = 4 THEN 'Expense' ELSE 'NIL' END) AS primary_group FROM `account_group` as A left join `account_group` B on A.acc_group_parent=B.acc_group_id where A.`acc_group_id`!='17' and A.`acc_group_id`!='18' and  (A.`acc_group_name` like '%$acc_group_name%' ) order by A.acc_group_name asc limit 30 ");

		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr tabIndex="-1"><td value="' .$client_contact_datas['acc_group_id'].'" class="client_button" ><input  type="hidden" class="acc_group_id" value="'.$client_contact_datas['acc_group_id'].'" /><input type="hidden" class="acc_group_name" value="'.$client_contact_datas['acc_group_name'].'" /><input  type="hidden" class="acc_group_parent" value="'.$client_contact_datas['acc_group_parent'].'" />'.$client_contact_datas['acc_group_name'].'</td><td  >'.$client_contact_datas['parent_group'].'</td><td >'.$client_contact_datas['primary_group'].'</td></tr>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

}